/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.OutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.OutputValidator;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145PrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145PublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.DSTU4145Parameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.general.DSAOutputSigner;
import org.bouncycastle.crypto.general.DSAOutputValidator;
import org.bouncycastle.crypto.general.DSAOutputVerifier;
import org.bouncycastle.crypto.general.DSTU4145KeyPairGenerator;
import org.bouncycastle.crypto.general.DSTU4145Signer;
import org.bouncycastle.crypto.general.EcKeyGenerationParameters;
import org.bouncycastle.crypto.general.EcKeyPairGenerator;
import org.bouncycastle.crypto.general.GOST3411Digest;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.general.GuardedSignatureOperatorFactory;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcNamedDomainParameters;
import org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DSTU4145 {
    private static byte[] DEFAULT_SBOX = new byte[]{10, 9, 13, 6, 14, 11, 4, 5, 15, 1, 3, 12, 7, 0, 8, 2, 8, 0, 12, 4, 9, 6, 7, 11, 2, 3, 1, 15, 5, 14, 10, 13, 15, 6, 5, 8, 14, 11, 10, 4, 12, 0, 3, 7, 2, 9, 1, 13, 3, 8, 13, 9, 6, 11, 15, 0, 2, 5, 12, 10, 4, 14, 1, 7, 15, 8, 14, 9, 7, 2, 0, 13, 12, 6, 1, 5, 11, 4, 3, 10, 2, 8, 9, 7, 5, 15, 0, 11, 12, 1, 13, 14, 10, 3, 6, 4, 3, 8, 11, 5, 6, 4, 14, 10, 2, 12, 1, 7, 9, 15, 13, 0, 1, 2, 3, 14, 6, 13, 11, 8, 15, 10, 12, 5, 7, 9, 0, 4};
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("DSTU4145", (Enum)Variations.DSTU4145);
    public static final SignatureParameters DSTU4145 = new SignatureParameters();

    private DSTU4145() {
    }

    private static DSA getDsaVerifier(AsymmetricDSTU4145PublicKey key) {
        DSTU4145Signer dstu4145Signer = new DSTU4145Signer();
        AsymmetricDSTU4145PublicKey k = key;
        EcPublicKeyParameters publicKeyParameters = new EcPublicKeyParameters(k.getW(), org.bouncycastle.crypto.general.DSTU4145.getDomainParams(k.getParameters().getDomainParameters()));
        dstu4145Signer.init(false, publicKeyParameters);
        return dstu4145Signer;
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters curveParams) {
        if (curveParams instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)curveParams);
        }
        return new EcDomainParameters(curveParams);
    }

    private static EcPrivateKeyParameters getLwKey(final AsymmetricDSTU4145PrivateKey privKey) {
        return AccessController.doPrivileged(new PrivilegedAction<EcPrivateKeyParameters>(){

            @Override
            public EcPrivateKeyParameters run() {
                return new EcPrivateKeyParameters(privKey.getS(), org.bouncycastle.crypto.general.DSTU4145.getDomainParams(privKey.getParameters().getDomainParameters()));
            }
        });
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair kp) {
        SelfTestExecutor.validate((Algorithm)ALGORITHM, kp, new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair kp) {
                byte[] data = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                DSTU4145Signer signer = new DSTU4145Signer();
                signer.init(true, new ParametersWithRandom(kp.getPrivate(), Utils.testRandom));
                BigInteger[] rv = signer.generateSignature(data);
                signer.init(false, kp.getPublic());
                signer.verifySignature(data, rv[0], rv[1]);
                return signer.verifySignature(data, rv[0], rv[1]);
            }
        });
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class LittleEndianSignatureOperatorFactory
    extends GuardedSignatureOperatorFactory<SignatureParameters> {
        @Override
        public OutputSignerUsingSecureRandom<SignatureParameters> doCreateSigner(AsymmetricPrivateKey key, SignatureParameters parameters) {
            DSTU4145Signer dstu4145Signer = new DSTU4145Signer();
            Digest digest = parameters.digestAlgorithm == SecureHash.Algorithm.GOST3411 ? new GOST3411Digest(DEFAULT_SBOX) : Register.createDigest(parameters.getDigestAlgorithm());
            AsymmetricDSTU4145PrivateKey k = (AsymmetricDSTU4145PrivateKey)key;
            final EcPrivateKeyParameters privateKeyParameters = org.bouncycastle.crypto.general.DSTU4145.getLwKey(k);
            return new DSAOutputSigner<SignatureParameters>(dstu4145Signer, digest, parameters, new DSAOutputSigner.Initializer(){

                @Override
                public void initialize(DSA signer, SecureRandom random) {
                    signer.init(true, new ParametersWithRandom(privateKeyParameters, random));
                }
            }, true);
        }

        @Override
        public OutputVerifier<SignatureParameters> doCreateVerifier(AsymmetricPublicKey key, SignatureParameters parameters) {
            Digest digest = parameters.digestAlgorithm == SecureHash.Algorithm.GOST3411 ? new GOST3411Digest(DEFAULT_SBOX) : Register.createDigest(parameters.getDigestAlgorithm());
            DSA dstu4145Signer = org.bouncycastle.crypto.general.DSTU4145.getDsaVerifier((AsymmetricDSTU4145PublicKey)key);
            return new DSAOutputVerifier<SignatureParameters>(dstu4145Signer, digest, parameters, true);
        }

        @Override
        protected OutputValidator<SignatureParameters> doCreateValidator(AsymmetricPublicKey key, SignatureParameters parameters, byte[] signature) throws InvalidSignatureException {
            Digest digest = parameters.digestAlgorithm == SecureHash.Algorithm.GOST3411 ? new GOST3411Digest(DEFAULT_SBOX) : Register.createDigest(parameters.getDigestAlgorithm());
            DSA dstu4145Signer = org.bouncycastle.crypto.general.DSTU4145.getDsaVerifier((AsymmetricDSTU4145PublicKey)key);
            return new DSAOutputValidator<SignatureParameters>(dstu4145Signer, digest, parameters, signature, true);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class SignatureOperatorFactory
    extends GuardedSignatureOperatorFactory<SignatureParameters> {
        @Override
        public OutputSignerUsingSecureRandom<SignatureParameters> doCreateSigner(AsymmetricPrivateKey key, SignatureParameters parameters) {
            DSTU4145Signer dstu4145Signer = new DSTU4145Signer();
            Digest digest = parameters.digestAlgorithm == SecureHash.Algorithm.GOST3411 ? new GOST3411Digest(DEFAULT_SBOX) : Register.createDigest(parameters.getDigestAlgorithm());
            AsymmetricDSTU4145PrivateKey k = (AsymmetricDSTU4145PrivateKey)key;
            final EcPrivateKeyParameters privateKeyParameters = new EcPrivateKeyParameters(k.getS(), org.bouncycastle.crypto.general.DSTU4145.getDomainParams(k.getParameters().getDomainParameters()));
            return new DSAOutputSigner<SignatureParameters>(dstu4145Signer, digest, parameters, new DSAOutputSigner.Initializer(){

                @Override
                public void initialize(DSA signer, SecureRandom random) {
                    signer.init(true, new ParametersWithRandom(privateKeyParameters, random));
                }
            });
        }

        @Override
        public OutputVerifier<SignatureParameters> doCreateVerifier(AsymmetricPublicKey key, SignatureParameters parameters) {
            Digest digest = parameters.digestAlgorithm == SecureHash.Algorithm.GOST3411 ? new GOST3411Digest(DEFAULT_SBOX) : Register.createDigest(parameters.getDigestAlgorithm());
            DSA dstu4145Signer = org.bouncycastle.crypto.general.DSTU4145.getDsaVerifier((AsymmetricDSTU4145PublicKey)key);
            return new DSAOutputVerifier<SignatureParameters>(dstu4145Signer, digest, parameters);
        }

        @Override
        protected OutputValidator<SignatureParameters> doCreateValidator(AsymmetricPublicKey key, SignatureParameters parameters, byte[] signature) throws InvalidSignatureException {
            Digest digest = parameters.digestAlgorithm == SecureHash.Algorithm.GOST3411 ? new GOST3411Digest(DEFAULT_SBOX) : Register.createDigest(parameters.getDigestAlgorithm());
            DSA dstu4145Signer = org.bouncycastle.crypto.general.DSTU4145.getDsaVerifier((AsymmetricDSTU4145PublicKey)key);
            return new DSAOutputValidator<SignatureParameters>(dstu4145Signer, digest, parameters, signature);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class SignatureParameters
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        SignatureParameters() {
            this(SecureHash.Algorithm.GOST3411);
        }

        private SignatureParameters(DigestAlgorithm digestAlgorithm) {
            super(ALGORITHM);
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public SignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new SignatureParameters(digestAlgorithm);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricDSTU4145PublicKey, AsymmetricDSTU4145PrivateKey> {
        private final EcKeyPairGenerator engine = new DSTU4145KeyPairGenerator();
        private final DSTU4145Parameters parameters;
        private final EcKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom random) {
            super(keyGenParameters);
            this.parameters = keyGenParameters.getDomainParameters();
            this.param = new EcKeyGenerationParameters(org.bouncycastle.crypto.general.DSTU4145.getDomainParams(this.parameters.getDomainParameters()), random);
            this.engine.init(this.param);
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricDSTU4145PublicKey, AsymmetricDSTU4145PrivateKey> doGenerateKeyPair() {
            AsymmetricCipherKeyPair kp = this.engine.generateKeyPair();
            org.bouncycastle.crypto.general.DSTU4145.validateKeyPair(kp);
            EcPublicKeyParameters pubKey = (EcPublicKeyParameters)kp.getPublic();
            EcPrivateKeyParameters prvKey = (EcPrivateKeyParameters)kp.getPrivate();
            Object algorithm = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            return new AsymmetricKeyPair<AsymmetricDSTU4145PublicKey, AsymmetricDSTU4145PrivateKey>(new AsymmetricDSTU4145PublicKey((Algorithm)algorithm, this.parameters, pubKey.getQ()), new AsymmetricDSTU4145PrivateKey((Algorithm)algorithm, this.parameters, prvKey.getD()));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyGenParameters
    extends GeneralParameters {
        private final DSTU4145Parameters domainParameters;

        public KeyGenParameters(DSTU4145Parameters domainParameters) {
            super(ALGORITHM);
            this.domainParameters = domainParameters;
        }

        public DSTU4145Parameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum Variations {
        DSTU4145;

    }
}

