/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.logging.Logger;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.OperatorUsingSecureRandom;
import org.bouncycastle.crypto.OutputEncryptor;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.fips.BlockCipherUtils;
import org.bouncycastle.crypto.fips.CipherKeyGenerator;
import org.bouncycastle.crypto.fips.DesEdeEngine;
import org.bouncycastle.crypto.fips.DesEdeKeyGenerator;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsInputDecryptor;
import org.bouncycastle.crypto.fips.FipsKeyUnwrapper;
import org.bouncycastle.crypto.fips.FipsKeyWrapOperatorFactory;
import org.bouncycastle.crypto.fips.FipsKeyWrapper;
import org.bouncycastle.crypto.fips.FipsMACOperatorFactory;
import org.bouncycastle.crypto.fips.FipsOutputDecryptor;
import org.bouncycastle.crypto.fips.FipsOutputEncryptor;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSymmetricKeyGenerator;
import org.bouncycastle.crypto.fips.FipsSymmetricOperatorFactory;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.Mode;
import org.bouncycastle.crypto.fips.Padding;
import org.bouncycastle.crypto.fips.PrivilegedUtils;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.MultiBlockCipher;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.io.CipherInputStream;
import org.bouncycastle.crypto.internal.io.CipherOutputStreamImpl;
import org.bouncycastle.crypto.internal.macs.CMac;
import org.bouncycastle.crypto.internal.params.DesEdeParameters;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class FipsTripleDES {
    private static final Logger LOG = Logger.getLogger(FipsTripleDES.class.getName());
    public static final FipsAlgorithm ALGORITHM = new FipsAlgorithm("TripleDES");
    static final FipsEngineProvider<MultiBlockCipher> ENGINE_PROVIDER;
    public static final Parameters ECB;
    public static final Parameters ECBwithPKCS7;
    public static final Parameters ECBwithISO10126_2;
    public static final Parameters ECBwithX923;
    public static final Parameters ECBwithISO7816_4;
    public static final Parameters ECBwithTBC;
    public static final ParametersWithIV CBC;
    public static final ParametersWithIV CBCwithPKCS7;
    public static final ParametersWithIV CBCwithISO10126_2;
    public static final ParametersWithIV CBCwithX923;
    public static final ParametersWithIV CBCwithISO7816_4;
    public static final ParametersWithIV CBCwithTBC;
    public static final ParametersWithIV CBCwithCS1;
    public static final ParametersWithIV CBCwithCS2;
    public static final ParametersWithIV CBCwithCS3;
    public static final ParametersWithIV CFB8;
    public static final ParametersWithIV CFB64;
    public static final ParametersWithIV OFB;
    public static final ParametersWithIV CTR;
    public static final WrapParameters TKW;
    public static final AuthParameters CMAC;

    private FipsTripleDES() {
    }

    static FipsEngineProvider<Mac> getMacProvider(FipsAlgorithm algorithm) {
        FipsEngineProvider<Mac> macProvider;
        switch ((Mode)algorithm.basicVariation()) {
            case CMAC: {
                macProvider = new FipsEngineProvider<Mac>(){

                    @Override
                    public Mac createEngine() {
                        return new CMac((BlockCipher)ENGINE_PROVIDER.createEngine());
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to FipsTripleDES MAC Provider: " + algorithm);
            }
        }
        return macProvider;
    }

    static Mac makeMAC(AuthParameters authParameters) {
        CMac mac;
        switch ((Mode)authParameters.getAlgorithm().basicVariation()) {
            case CMAC: {
                mac = new CMac((BlockCipher)ENGINE_PROVIDER.createEngine(), authParameters.macLenInBits);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to FipsTripleDES.OperatorFactory.createMACCalculator: " + authParameters.getAlgorithm());
            }
        }
        return mac;
    }

    private static void validateKeySize(Algorithm algorithm, int keySize) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            if (keySize != 168 && keySize != 192) {
                throw new IllegalKeyException("Key must be of length 192 bits: " + algorithm.getName());
            }
        } else if (keySize != 112 && keySize != 168 && keySize != 128 && keySize != 192) {
            throw new IllegalKeyException("Key must be of length 128 or 192 bits: " + algorithm.getName());
        }
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey key, org.bouncycastle.crypto.Parameters parameters, boolean forReading) {
        Algorithm algorithm;
        ValidatedSymmetricKey vKey = PrivilegedUtils.getValidatedKey(key);
        int keyLength = vKey.getKeySizeInBits();
        if (!forReading || keyLength != 128) {
            FipsTripleDES.validateKeySize(key.getAlgorithm(), keyLength);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && !forReading && !DesEdeParameters.isReal3Key(vKey.getKeyBytes())) {
                throw new IllegalKeyException("Key not real 3-Key DESEDE key");
            }
        }
        if (!Properties.isOverrideSet("org.bouncycastle.tripledes.allow_weak") && !forReading) {
            if (DesEdeParameters.isActuallyDesKey(vKey.getKeyBytes())) {
                throw new IllegalKeyException("Attempt to use repeated DES key: " + key.getAlgorithm().getName());
            }
            if (DesEdeParameters.isWeakKey(vKey.getKeyBytes(), 0, vKey.getKeyBytes().length)) {
                throw new IllegalKeyException("Attempt to use weak key: " + key.getAlgorithm().getName());
            }
        }
        if (!(algorithm = key.getAlgorithm()).equals(ALGORITHM) && !algorithm.equals(parameters.getAlgorithm())) {
            throw new IllegalKeyException("FIPS Key not for specified algorithm");
        }
        return vKey;
    }

    private static void cmacStartUpTest(EngineProvider provider) {
        SelfTestExecutor.validate(ALGORITHM, provider, new BasicKatTest<EngineProvider>(){

            @Override
            public boolean hasTestPassed(EngineProvider provider) throws Exception {
                byte[] input16 = Hex.decode("6bc1bee22e409f96e93d7e117393172a");
                byte[] output_k128_m16 = Hex.decode("c0b9bbee139722ab");
                CMac mac = new CMac(provider.createEngine(), 64);
                KeyParameterImpl key = new KeyParameterImpl(Hex.decode("0102020404070708080b0b0d0d0e0e101013131515161619"));
                mac.init(key);
                mac.update(input16, 0, input16.length);
                byte[] out = new byte[8];
                mac.doFinal(out, 0);
                return Arrays.areEqual(out, output_k128_m16);
            }
        });
    }

    static {
        ECB = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB));
        ECBwithPKCS7 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.PKCS7));
        ECBwithISO10126_2 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO10126_2));
        ECBwithX923 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.X923));
        ECBwithISO7816_4 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO7816_4));
        ECBwithTBC = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.TBC));
        CBC = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC));
        CBCwithPKCS7 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.PKCS7));
        CBCwithISO10126_2 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO10126_2));
        CBCwithX923 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.X923));
        CBCwithISO7816_4 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO7816_4));
        CBCwithTBC = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.TBC));
        CBCwithCS1 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS1));
        CBCwithCS2 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS2));
        CBCwithCS3 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS3));
        CFB8 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CFB8));
        CFB64 = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CFB64));
        OFB = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.OFB64));
        CTR = new ParametersWithIV(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CTR));
        TKW = new WrapParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.WRAP));
        CMAC = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CMAC));
        EngineProvider provider = new EngineProvider();
        provider.createEngine();
        FipsTripleDES.cmacStartUpTest(provider);
        ENGINE_PROVIDER = provider;
        FipsRegister.registerEngineProvider(ALGORITHM, provider);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class EngineProvider
    extends FipsEngineProvider<MultiBlockCipher> {
        private static byte[] input = Hex.decode("4e6f772069732074");
        private static byte[] output = Hex.decode("f7cfbe5e6c38b35a");
        private static final byte[] keyBytes = Hex.decode("0102020404070708080b0b0d0d0e0e101013131515161619");

        private EngineProvider() {
        }

        @Override
        public MultiBlockCipher createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new DesEdeEngine(), new VariantKatTest<DesEdeEngine>(){

                @Override
                public void evaluate(DesEdeEngine tripleDesEngine) {
                    byte[] tmp = new byte[input.length];
                    KeyParameterImpl key = new KeyParameterImpl(keyBytes);
                    tripleDesEngine.init(true, key);
                    tripleDesEngine.processBlock(input, 0, tmp, 0);
                    if (!Arrays.areEqual(output, tmp)) {
                        this.fail("Failed self test on encryption");
                    }
                    tripleDesEngine.init(false, key);
                    tripleDesEngine.processBlock(tmp, 0, tmp, 0);
                    if (!Arrays.areEqual(input, tmp)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyWrapOperatorFactory
    extends FipsKeyWrapOperatorFactory<WrapParameters, SymmetricKey> {
        private Wrapper createWrapper(FipsAlgorithm algorithm, boolean useInverse) {
            SP80038FWrapEngine cipher;
            switch ((Mode)algorithm.basicVariation()) {
                case WRAP: {
                    cipher = new SP80038FWrapEngine((BlockCipher)ENGINE_PROVIDER.createEngine(), useInverse);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown algorithm passed to FipsDESEDE.KeyWrapOperatorFactory: " + algorithm.getName());
                }
            }
            return cipher;
        }

        @Override
        public FipsKeyWrapper<WrapParameters> createKeyWrapper(SymmetricKey key, final WrapParameters parameters) {
            ValidatedSymmetricKey sKey = FipsTripleDES.validateKey(key, parameters, false);
            final Wrapper wrapper = this.createWrapper(parameters.getAlgorithm(), parameters.useInverse);
            wrapper.init(true, new KeyParameterImpl(sKey.getKeyBytes()));
            return new FipsKeyWrapper<WrapParameters>(){

                @Override
                public WrapParameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] wrap(byte[] in, int inOff, int inLen) throws PlainInputProcessingException {
                    if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                        if (!Properties.isOverrideSet("org.bouncycastle.tripledes.allow_wrap")) {
                            throw new FipsUnapprovedOperationError("Triple-DES encryption key-wrapping disallowed");
                        }
                        LOG.warning("Triple-DES encryption key-wrapping detected: no longer an approved operation but override set");
                    }
                    try {
                        return wrapper.wrap(in, inOff, inLen);
                    }
                    catch (Exception e) {
                        throw new PlainInputProcessingException("Unable to wrap key: " + e.getMessage(), e);
                    }
                }
            };
        }

        @Override
        public FipsKeyUnwrapper<WrapParameters> createKeyUnwrapper(SymmetricKey key, final WrapParameters parameters) {
            ValidatedSymmetricKey sKey = FipsTripleDES.validateKey(key, parameters, true);
            final Wrapper wrapper = this.createWrapper(parameters.getAlgorithm(), parameters.useInverse);
            wrapper.init(false, new KeyParameterImpl(sKey.getKeyBytes()));
            return new FipsKeyUnwrapper<WrapParameters>(){

                @Override
                public WrapParameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidWrappingException {
                    try {
                        return wrapper.unwrap(in, inOff, inLen);
                    }
                    catch (InvalidCipherTextException e) {
                        throw new InvalidWrappingException("Unable to unwrap key: " + e.getMessage(), e);
                    }
                }
            };
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class MACOperatorFactory
    extends FipsMACOperatorFactory<AuthParameters> {
        @Override
        protected int calculateMACSize(AuthParameters parameters) {
            return FipsTripleDES.makeMAC(parameters).getMacSize();
        }

        @Override
        protected Mac createMAC(SymmetricKey key, AuthParameters parameters) {
            Mac mac = FipsTripleDES.makeMAC(parameters);
            ValidatedSymmetricKey sKey = FipsTripleDES.validateKey(key, parameters, false);
            if (parameters.getIV() != null) {
                mac.init(Utils.getParametersWithIV(sKey, parameters.getIV()));
            } else {
                mac.init(Utils.getKeyParameter(sKey));
            }
            return mac;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class OperatorFactory
    extends FipsSymmetricOperatorFactory<Parameters> {
        @Override
        public FipsOutputEncryptor<Parameters> createOutputEncryptor(SymmetricKey key, Parameters parameters) {
            ValidatedSymmetricKey sKey = FipsTripleDES.validateKey(key, parameters, false);
            return new OutEncryptor(sKey, parameters, null);
        }

        @Override
        public FipsOutputDecryptor<Parameters> createOutputDecryptor(SymmetricKey key, final Parameters parameters) {
            ValidatedSymmetricKey sKey = FipsTripleDES.validateKey(key, parameters, true);
            final BufferedBlockCipher cipher = BlockCipherUtils.createStandardCipher(false, sKey, ENGINE_PROVIDER, parameters, null);
            return new FipsOutputDecryptor<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public int getMaxOutputSize(int inputLen) {
                    return cipher.getOutputSize(inputLen);
                }

                @Override
                public int getUpdateOutputSize(int inputLen) {
                    return cipher.getUpdateOutputSize(inputLen);
                }

                @Override
                public CipherOutputStream getDecryptingStream(OutputStream out) {
                    if (cipher.getUnderlyingCipher() instanceof StreamCipher) {
                        return CipherOutputStreamImpl.getInstance(out, (StreamCipher)((Object)cipher.getUnderlyingCipher()));
                    }
                    return CipherOutputStreamImpl.getInstance(out, cipher);
                }
            };
        }

        @Override
        public FipsInputDecryptor<Parameters> createInputDecryptor(SymmetricKey key, final Parameters parameters) {
            ValidatedSymmetricKey sKey = FipsTripleDES.validateKey(key, parameters, true);
            final BufferedBlockCipher cipher = BlockCipherUtils.createStandardCipher(false, sKey, ENGINE_PROVIDER, parameters, null);
            return new FipsInputDecryptor<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public InputStream getDecryptingStream(InputStream in) {
                    if (cipher.getUnderlyingCipher() instanceof StreamCipher) {
                        return new CipherInputStream(in, (StreamCipher)((Object)cipher.getUnderlyingCipher()));
                    }
                    return new CipherInputStream(in, cipher);
                }
            };
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        private class OutEncryptor
        extends FipsOutputEncryptor<Parameters>
        implements OperatorUsingSecureRandom<OutputEncryptor<Parameters>> {
            private final Parameters parameters;
            private final ValidatedSymmetricKey key;
            private final BufferedBlockCipher cipher;

            public OutEncryptor(ValidatedSymmetricKey key, Parameters parameters, SecureRandom random) {
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    if (!Properties.isOverrideSet("org.bouncycastle.tripledes.allow_enc")) {
                        throw new FipsUnapprovedOperationError("Triple-DES encryption disallowed");
                    }
                    LOG.warning("Triple-DES encryption detected: no longer an approved operation but override set");
                }
                this.key = key;
                this.parameters = parameters;
                this.cipher = BlockCipherUtils.createStandardCipher(true, key, ENGINE_PROVIDER, parameters, random);
            }

            @Override
            public CipherOutputStream getEncryptingStream(OutputStream out) {
                if (this.cipher.getUnderlyingCipher() instanceof StreamCipher) {
                    return CipherOutputStreamImpl.getInstance(out, (StreamCipher)((Object)this.cipher.getUnderlyingCipher()));
                }
                return CipherOutputStreamImpl.getInstance(out, this.cipher);
            }

            @Override
            public OutputEncryptor<Parameters> withSecureRandom(SecureRandom random) {
                return new OutEncryptor(this.key, this.parameters, random);
            }

            @Override
            public Parameters getParameters() {
                return this.parameters;
            }

            @Override
            public int getMaxOutputSize(int inputLen) {
                return this.cipher.getOutputSize(inputLen);
            }

            @Override
            public int getUpdateOutputSize(int inputLen) {
                return this.cipher.getUpdateOutputSize(inputLen);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyGenerator
    extends FipsSymmetricKeyGenerator {
        private final FipsAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(int keySizeInBits, SecureRandom random) {
            this(ALGORITHM, keySizeInBits, random);
        }

        public KeyGenerator(FipsParameters parameterSet, int keySizeInBits, SecureRandom random) {
            this(parameterSet.getAlgorithm(), keySizeInBits, random);
        }

        private KeyGenerator(FipsAlgorithm algorithm, int keySizeInBits, SecureRandom random) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                Utils.validateKeyGenRandom(random, 112, algorithm);
                if (keySizeInBits != 168 && keySizeInBits != 192) {
                    throw new IllegalArgumentException("Attempt to create key with unapproved key size [" + keySizeInBits + "]: " + algorithm.getName());
                }
            } else if (keySizeInBits != 112 && keySizeInBits != 168 && keySizeInBits != 128 && keySizeInBits != 192) {
                throw new IllegalArgumentException("Attempt to create key with invalid key size [" + keySizeInBits + "]: " + algorithm.getName());
            }
            this.algorithm = algorithm;
            this.keySizeInBits = keySizeInBits;
            this.random = random;
        }

        @Override
        public SymmetricKey generateKey() {
            DesEdeKeyGenerator cipherKeyGenerator = new DesEdeKeyGenerator(this.algorithm);
            ((CipherKeyGenerator)cipherKeyGenerator).init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, ((CipherKeyGenerator)cipherKeyGenerator).generateKey());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class WrapParameters
    extends FipsParameters {
        private final boolean useInverse;

        WrapParameters(FipsAlgorithm algorithm) {
            this(algorithm, false);
        }

        private WrapParameters(FipsAlgorithm algorithm, boolean useInverse) {
            super(algorithm);
            this.useInverse = useInverse;
        }

        public boolean isUsingInverseFunction() {
            return this.useInverse;
        }

        public WrapParameters withUsingInverseFunction(boolean useInverse) {
            return new WrapParameters(this.getAlgorithm(), useInverse);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class AuthParameters
    extends FipsParameters
    implements AuthenticationParametersWithIV {
        private final byte[] iv;
        private final int macLenInBits;

        AuthParameters(FipsAlgorithm algorithm) {
            this(algorithm, null, Utils.getDefaultMacSize(algorithm, 64));
        }

        private AuthParameters(FipsAlgorithm algorithm, byte[] iv, int macLenInBits) {
            super(algorithm);
            this.iv = iv;
            this.macLenInBits = macLenInBits;
        }

        @Override
        public int getMACSizeInBits() {
            return this.macLenInBits;
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }

        @Override
        public AuthParameters withIV(byte[] iv) {
            return new AuthParameters(this.getAlgorithm(), Arrays.clone(iv), this.macLenInBits);
        }

        @Override
        public AuthParameters withIV(SecureRandom random) {
            return new AuthParameters(this.getAlgorithm(), this.getAlgorithm().createDefaultIvIfNecessary(8, random), this.macLenInBits);
        }

        public AuthParameters withIV(SecureRandom random, int ivLen) {
            return new AuthParameters(this.getAlgorithm(), this.getAlgorithm().createIvIfNecessary(ivLen, random), this.macLenInBits);
        }

        @Override
        public AuthParameters withMACSize(int macSizeInBits) {
            return new AuthParameters(this.getAlgorithm(), Arrays.clone(this.iv), macSizeInBits);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class ParametersWithIV
    extends Parameters
    implements org.bouncycastle.crypto.ParametersWithIV {
        private final byte[] iv;

        ParametersWithIV(FipsAlgorithm algorithm) {
            this(algorithm, null);
        }

        private ParametersWithIV(FipsAlgorithm algorithm, byte[] iv) {
            super(algorithm);
            ((Mode)algorithm.basicVariation()).checkIv(iv, 8);
            this.iv = iv;
        }

        public ParametersWithIV withIV(byte[] iv) {
            return new ParametersWithIV(this.getAlgorithm(), Arrays.clone(iv));
        }

        public ParametersWithIV withIV(SecureRandom random) {
            return new ParametersWithIV(this.getAlgorithm(), ((Mode)this.getAlgorithm().basicVariation()).createDefaultIvIfNecessary(8, random));
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Parameters
    extends FipsParameters {
        Parameters(FipsAlgorithm algorithm) {
            super(algorithm);
        }
    }
}

