/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsOperationError;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.util.Properties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FipsEntropyConfig {
    private static final int W = 512;
    private static int C;
    private static int AdptC;
    private static float H;
    private static int retry;

    public static float getH() {
        return H;
    }

    public static int getStuckC() {
        return C;
    }

    public static int getAdaptiveProportionateC() {
        return AdptC;
    }

    public static int getAdaptiveProportionateW() {
        return 512;
    }

    public static int getMaxRetries() {
        return retry;
    }

    static {
        String ret;
        String factors = Properties.getPropertyValue("org.bouncycastle.entropy.factors");
        if (factors != null) {
            String[] splitFactors = factors.split(",");
            if (splitFactors.length != 3) {
                FipsStatus.moveToErrorStatus(new FipsOperationError("entropy factors needs to be <int>,<int>,<float>"));
            }
            try {
                C = Integer.parseInt(splitFactors[0].trim());
                AdptC = Integer.parseInt(splitFactors[1].trim());
                H = Float.parseFloat(splitFactors[2].trim());
            }
            catch (Exception e) {
                FipsStatus.moveToErrorStatus(new FipsOperationError("exception parsing entropy factors: " + e.getMessage(), e));
            }
        } else {
            C = 4;
            AdptC = 13;
            H = 8.0f;
        }
        if ((ret = Properties.getPropertyValue("org.bouncycastle.entropy.retry")) != null) {
            try {
                retry = Integer.parseInt(ret);
            }
            catch (Exception e) {
                FipsStatus.moveToErrorStatus(new FipsOperationError("exception parsing entropy retry: " + e.getMessage(), e));
            }
        } else {
            retry = 5;
        }
    }
}

