/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.logging.Logger;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import org.bouncycastle.crypto.asymmetric.DSAValidationParameters;
import org.bouncycastle.crypto.fips.DSAOutputSigner;
import org.bouncycastle.crypto.fips.DSAOutputValidator;
import org.bouncycastle.crypto.fips.DSAOutputVerifier;
import org.bouncycastle.crypto.fips.DsaKeyPairGenerator;
import org.bouncycastle.crypto.fips.DsaParametersGenerator;
import org.bouncycastle.crypto.fips.DsaSigner;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsOutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.fips.FipsOutputValidator;
import org.bouncycastle.crypto.fips.FipsOutputVerifier;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsSignatureOperatorFactory;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.NullDigest;
import org.bouncycastle.crypto.fips.PrivilegedUtils;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.EngineProvider;
import org.bouncycastle.crypto.internal.ExtendedDigest;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.crypto.internal.PrimeCertaintyCalculator;
import org.bouncycastle.crypto.internal.params.DsaKeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.DsaParameterGenerationParameters;
import org.bouncycastle.crypto.internal.params.DsaParameters;
import org.bouncycastle.crypto.internal.params.DsaPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaValidationParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.math.internal.Primes;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.TestRandomBigInteger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class FipsDSA {
    private static final Logger LOG = Logger.getLogger(FipsDSA.class.getName());
    public static final FipsAlgorithm ALGORITHM = new FipsAlgorithm("DSA", null);
    public static final Parameters DSA = new Parameters();
    private static final EngineProvider<DsaSigner> ENGINE_PROVIDER;

    private FipsDSA() {
    }

    private static DsaParameters getDomainParams(DSADomainParameters dsaParams) {
        return new DsaParameters(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
    }

    private static DsaPrivateKeyParameters getLwKey(final AsymmetricDSAPrivateKey privKey) {
        return AccessController.doPrivileged(new PrivilegedAction<DsaPrivateKeyParameters>(){

            @Override
            public DsaPrivateKeyParameters run() {
                return new DsaPrivateKeyParameters(privKey.getX(), FipsDSA.getDomainParams(privKey.getDomainParameters()));
            }
        });
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair kp) {
        SelfTestExecutor.validate(ALGORITHM, kp, new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair kp) {
                byte[] data = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                DsaSigner signer = new DsaSigner();
                signer.init(true, new ParametersWithRandom(kp.getPrivate(), Utils.testRandom));
                BigInteger[] rv = signer.generateSignature(data);
                signer.init(false, kp.getPublic());
                return signer.verifySignature(data, rv[0], rv[1]);
            }
        });
    }

    static {
        DsaProvider provider = new DsaProvider();
        provider.createEngine();
        ENGINE_PROVIDER = provider;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DsaProvider
    extends FipsEngineProvider<DsaSigner> {
        private static BigInteger r = new BigInteger("4400138d05f9639caf54a583caaf25d2b76d0c3ead752ce17dbc85fe", 16);
        private static BigInteger s = new BigInteger("46b366898ee97c044df7fd8616410b91978e0eb99a581d7b71e82e89", 16);

        private DsaProvider() {
        }

        @Override
        public DsaSigner createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new DsaSigner(), new VariantKatTest<DsaSigner>(){

                @Override
                void evaluate(DsaSigner signer) throws Exception {
                    BigInteger q = new BigInteger("90EAF4D1AF0708B1B612FF35E0A2997EB9E9D263C9CE659528945C0D", 16);
                    BigInteger p = new BigInteger("C196BA05AC29E1F9C3C72D56DFFC6154A033F1477AC88EC37F09BE6C5BB95F51C296DD20D1A28A067CCC4D4316A4BD1DCA55ED1066D438C35AEBAABF57E7DAE428782A95ECA1C143DB701FD48533A3C18F0FE23557EA7AE619ECACC7E0B51652A8776D02A425567DED36EABD90CA33A1E8D988F0BBB92D02D1D20290113BB562CE1FC856EEB7CDD92D33EEA6F410859B179E7E789A8F75F645FAE2E136D252BFFAFF89528945C1ABE705A38DBC2D364AADE99BE0D0AAD82E5320121496DC65B3930E38047294FF877831A16D5228418DE8AB275D7D75651CEFED65F78AFC3EA7FE4D79B35F62A0402A1117599ADAC7B269A59F353CF450E6982D3B1702D9CA83", 16);
                    BigInteger g = new BigInteger("A59A749A11242C58C894E9E5A91804E8FA0AC64B56288F8D47D51B1EDC4D65444FECA0111D78F35FC9FDD4CB1F1B79A3BA9CBEE83A3F811012503C8117F98E5048B089E387AF6949BF8784EBD9EF45876F2E6A5A495BE64B6E770409494B7FEE1DBB1E4B2BC2A53D4F893D418B7159592E4FFFDF6969E91D770DAEBD0B5CB14C00AD68EC7DC1E5745EA55C706C4A1C5C88964E34D09DEB753AD418C1AD0F4FDFD049A955E5D78491C0B7A2F1575A008CCD727AB376DB6E695515B05BD412F5B8C2F4C77EE10DA48ABD53F5DD498927EE7B692BBBCDA2FB23A516C5B4533D73980B2A3B60E384ED200AE21B40D273651AD6060C13D97FD69AA13C5611A51B9085", 16);
                    DsaKeyPairGenerator kpGen = new DsaKeyPairGenerator();
                    kpGen.init(new DsaKeyGenerationParameters((SecureRandom)new TestRandomBigInteger("947813B589EDBA642411AD79205E43CE9B859327A4F84CF4B02628DB058A7B22771EA185", 16), new DsaParameters(p, q, g)));
                    AsymmetricCipherKeyPair kp = kpGen.generateKeyPair();
                    signer.init(true, new ParametersWithRandom(kp.getPrivate(), new TestRandomBigInteger(224, Hex.decode("735959CC4463B8B440E407EECA8A473BF6A6D1FE657546F67D401F0500000000"))));
                    byte[] msg = Hex.decode("23097D223405D8228642A477BDA255B32AADBCE4BDA0B3F7E36C9DA7");
                    BigInteger[] sig = signer.generateSignature(msg);
                    if (!sig[0].equals(r) || !sig[1].equals(s)) {
                        this.fail("KAT signature incorrect");
                    }
                    signer.init(false, kp.getPublic());
                    if (!signer.verifySignature(msg, sig[0], sig[1])) {
                        this.fail("KAT signature not verified");
                    }
                }
            });
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class OperatorFactory
    extends FipsSignatureOperatorFactory<Parameters> {
        @Override
        public FipsOutputSignerUsingSecureRandom<Parameters> createSigner(AsymmetricPrivateKey key, Parameters parameters) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("DSA is no longer an approved algorithm for signature generation");
            }
            Utils.checkDigestAlgorithm(LOG, parameters.getDigestAlgorithm(), "org.bouncycastle.dsa.allow_sha1_sig");
            DsaSigner dsaSigner = (DsaSigner)ENGINE_PROVIDER.createEngine();
            Digest digest = parameters.digestAlgorithm != null ? FipsSHS.createDigest(parameters.digestAlgorithm) : new NullDigest();
            AsymmetricDSAPrivateKey k = (AsymmetricDSAPrivateKey)key;
            final DsaPrivateKeyParameters privateKeyParameters = FipsDSA.getLwKey(k);
            int effSizeInBits = privateKeyParameters.getParameters().getP().bitLength();
            return new DSAOutputSigner<Parameters>(dsaSigner, digest, parameters, new DSAOutputSigner.Initializer(){

                @Override
                public void initialize(DSA signer, SecureRandom random) {
                    signer.init(true, new ParametersWithRandom(privateKeyParameters, random));
                }
            });
        }

        @Override
        public FipsOutputVerifier<Parameters> createVerifier(AsymmetricPublicKey key, Parameters parameters) {
            DsaSigner dsaSigner = (DsaSigner)ENGINE_PROVIDER.createEngine();
            Digest digest = parameters.digestAlgorithm != null ? FipsSHS.createDigest(parameters.digestAlgorithm) : new NullDigest();
            AsymmetricDSAPublicKey k = (AsymmetricDSAPublicKey)key;
            DsaPublicKeyParameters publicKeyParameters = new DsaPublicKeyParameters(k.getY(), FipsDSA.getDomainParams(k.getDomainParameters()));
            int effSizeInBits = publicKeyParameters.getParameters().getP().bitLength();
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && effSizeInBits != 1024 && effSizeInBits != 2048 && effSizeInBits != 3072) {
                throw new FipsUnapprovedOperationError("Attempt to create verifier with unapproved keysize [" + effSizeInBits + "]", ALGORITHM);
            }
            dsaSigner.init(false, publicKeyParameters);
            return new DSAOutputVerifier<Parameters>(dsaSigner, digest, parameters);
        }

        @Override
        public FipsOutputValidator<Parameters> createValidator(AsymmetricPublicKey key, Parameters parameters, byte[] signature) throws InvalidSignatureException {
            DsaSigner dsaSigner = (DsaSigner)ENGINE_PROVIDER.createEngine();
            Digest digest = parameters.digestAlgorithm != null ? FipsSHS.createDigest(parameters.digestAlgorithm) : new NullDigest();
            AsymmetricDSAPublicKey k = (AsymmetricDSAPublicKey)key;
            DsaPublicKeyParameters publicKeyParameters = new DsaPublicKeyParameters(k.getY(), FipsDSA.getDomainParams(k.getDomainParameters()));
            int effSizeInBits = publicKeyParameters.getParameters().getP().bitLength();
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && effSizeInBits != 1024 && effSizeInBits != 2048 && effSizeInBits != 3072) {
                throw new FipsUnapprovedOperationError("Attempt to create verifier with unapproved keysize [" + effSizeInBits + "]", ALGORITHM);
            }
            dsaSigner.init(false, publicKeyParameters);
            return new DSAOutputValidator<Parameters>(dsaSigner, digest, parameters, signature);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyPairGenerator
    extends FipsAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey> {
        private final DsaKeyPairGenerator engine = new DsaKeyPairGenerator();
        private final DSADomainParameters domainParameters;
        private final DsaKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom random) {
            super(keyGenParameters);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("DSA is no longer an approved algorithm for keypair generation");
            }
            this.domainParameters = keyGenParameters.getDomainParameters();
            this.param = new DsaKeyGenerationParameters(random, FipsDSA.getDomainParams(this.domainParameters));
            this.engine.init(this.param);
        }

        @Override
        public AsymmetricKeyPair<AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey> generateKeyPair() {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("DSA is no longer an approved algorithm for keypair generation");
            }
            AsymmetricCipherKeyPair kp = this.engine.generateKeyPair();
            DsaPublicKeyParameters pubKey = (DsaPublicKeyParameters)kp.getPublic();
            DsaPrivateKeyParameters prvKey = (DsaPrivateKeyParameters)kp.getPrivate();
            FipsAlgorithm algorithm = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            FipsDSA.validateKeyPair(kp);
            return new AsymmetricKeyPair<AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey>(new AsymmetricDSAPublicKey(algorithm, this.domainParameters, pubKey.getY()), new AsymmetricDSAPrivateKey(algorithm, this.domainParameters, prvKey.getX()));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class DomainParametersValidator {
        private final Version version;
        private final FipsDigestAlgorithm digestAlgorithm;
        private final SecureRandom random;

        public DomainParametersValidator(FipsDigestAlgorithm digestAlgorithm, SecureRandom random) {
            this(Version.FIPS_PUB_186_4, digestAlgorithm, random);
        }

        public DomainParametersValidator(Version version, FipsDigestAlgorithm digestAlgorithm, SecureRandom random) {
            if (Version.FIPS_PUB_186_2 == version && digestAlgorithm != FipsSHS.Algorithm.SHA1) {
                throw new IllegalArgumentException("186-2 can only validate with SHA-1");
            }
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                Utils.validateRandom(random, "FIPS SecureRandom required for DSA parameter validation in approved mode.");
            }
            this.version = version;
            this.digestAlgorithm = digestAlgorithm;
            this.random = random;
        }

        private static int getMinimumIterations(int L) {
            return L <= 1024 ? 40 : 48 + 8 * ((L - 1) / 1024);
        }

        public boolean isValidPAndQ(BigInteger p, BigInteger q, byte[] seed, int counter) {
            ExtendedDigest hash = FipsSHS.createDigest(this.digestAlgorithm);
            if (Version.FIPS_PUB_186_2 == this.version) {
                int i;
                if (p.bitLength() != 1024 || q.bitLength() != 160 || counter > 4095) {
                    return false;
                }
                if (seed.length < 20) {
                    return false;
                }
                BigInteger computed_q = this.digest(hash, seed).xor(this.digest(hash, this.seedPlus1(seed)));
                if (!q.equals(computed_q = computed_q.setBit(0).setBit(159)) || !this.isProbablePrime(q, DomainParametersValidator.getMinimumIterations(1024))) {
                    return false;
                }
                BigInteger extra = BigInteger.ONE.shiftLeft(64);
                byte[] offset = Arrays.clone(seed);
                this.inc(offset);
                boolean computedPIsPrime = false;
                BigInteger computed_p = null;
                for (i = 0; i <= counter; ++i) {
                    BigInteger W = BigInteger.ZERO;
                    for (int j = 0; j <= 5; ++j) {
                        this.inc(offset);
                        W = W.add(this.digest(hash, offset).shiftLeft(160 * j));
                    }
                    this.inc(offset);
                    W = W.add(this.digest(hash, offset).mod(extra).shiftLeft(960));
                    BigInteger X = W.setBit(1023);
                    BigInteger c = X.mod(q.shiftLeft(1));
                    computed_p = X.subtract(c.subtract(BigInteger.ONE));
                    if (computed_p.bitLength() != 1024 || !this.isProbablePrime(computed_p, DomainParametersValidator.getMinimumIterations(1024))) continue;
                    computedPIsPrime = true;
                    break;
                }
                if (i != counter || !p.equals(computed_p) || !computedPIsPrime) {
                    return false;
                }
            } else {
                int i;
                int L = p.bitLength();
                int N = q.bitLength();
                if (!(L == 1024 && N == 160 || L == 2048 && N == 224 || L == 2048 && N == 256 || L == 3072 && N == 256)) {
                    return false;
                }
                if (counter > 4 * L - 1) {
                    return false;
                }
                if (seed.length * 8 < N) {
                    return false;
                }
                BigInteger twoPowNminus1 = BigInteger.ONE.shiftLeft(N - 1);
                BigInteger U = this.digest(hash, seed).mod(twoPowNminus1);
                BigInteger computed_q = U.setBit(0).setBit(N - 1);
                if (!q.equals(computed_q) || !this.isProbablePrime(q, DomainParametersValidator.getMinimumIterations(L))) {
                    return false;
                }
                int outlen = hash.getDigestSize() * 8;
                int n = (L + outlen - 1) / outlen - 1;
                int b = L - n * outlen;
                BigInteger extra = BigInteger.ONE.shiftLeft(b);
                byte[] offset = Arrays.clone(seed);
                boolean computedPIsPrime = false;
                BigInteger computed_p = null;
                for (i = 0; i <= counter; ++i) {
                    BigInteger W = BigInteger.ZERO;
                    for (int j = 0; j < n; ++j) {
                        this.inc(offset);
                        W = W.add(this.digest(hash, offset).shiftLeft(outlen * j));
                    }
                    this.inc(offset);
                    W = W.add(this.digest(hash, offset).mod(extra).shiftLeft(outlen * n));
                    BigInteger X = W.setBit(L - 1);
                    BigInteger c = X.mod(q.shiftLeft(1));
                    computed_p = X.subtract(c.subtract(BigInteger.ONE));
                    if (computed_p.bitLength() != L || !this.isProbablePrime(computed_p, DomainParametersValidator.getMinimumIterations(L))) continue;
                    computedPIsPrime = true;
                    break;
                }
                if (i != counter || !p.equals(computed_p) || !computedPIsPrime) {
                    return false;
                }
            }
            return true;
        }

        public boolean isPartiallyValidG(BigInteger p, BigInteger q, BigInteger g) {
            if (BigInteger.valueOf(2L).compareTo(g) > 0 || p.subtract(BigInteger.ONE).compareTo(g) < 0) {
                return false;
            }
            return g.modPow(q, p).equals(BigInteger.ONE);
        }

        public boolean isValidG(BigInteger p, BigInteger q, byte[] seed, int index, BigInteger g) {
            ExtendedDigest hash = FipsSHS.createDigest(this.digestAlgorithm);
            if (index >>> 8 != 0) {
                return false;
            }
            if (BigInteger.valueOf(2L).compareTo(g) > 0 || p.subtract(BigInteger.ONE).compareTo(g) < 0) {
                return false;
            }
            if (!g.modPow(q, p).equals(BigInteger.ONE)) {
                return false;
            }
            BigInteger e = p.subtract(BigInteger.ONE).divide(q);
            int count = 0;
            byte[] counter = new byte[3];
            counter[0] = (byte)index;
            byte[] U = Arrays.concatenate(seed, Hex.decode("6767656E"), counter);
            BigInteger computed_g = null;
            while (++count < 65536) {
                this.inc(U);
                computed_g = this.digest(hash, U).modPow(e, p);
                if (computed_g.compareTo(BigInteger.ONE) <= 0) continue;
            }
            return g.equals(computed_g);
        }

        private BigInteger digest(Digest hash, byte[] input) {
            byte[] res = new byte[hash.getDigestSize()];
            hash.update(input, 0, input.length);
            hash.doFinal(res, 0);
            return new BigInteger(1, res);
        }

        private byte[] seedPlus1(byte[] seed) {
            return this.inc(Arrays.clone(seed));
        }

        private byte[] inc(byte[] value) {
            int i = value.length - 1;
            while (i >= 0) {
                int n = i--;
                value[n] = (byte)(value[n] + 1);
                if (value[n] == 0) continue;
            }
            return value;
        }

        private boolean isProbablePrime(BigInteger x, int iterations) {
            return !Primes.hasAnySmallFactors(x) && Primes.isMRProbablePrime(x, this.random, iterations);
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static enum Version {
            FIPS_PUB_186_2,
            FIPS_PUB_186_4;

        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class DomainParametersGenerator {
        private final SecureRandom random;
        private final DomainGenParameters parameters;
        private final FipsDigestAlgorithm digestAlgorithm;

        public DomainParametersGenerator(DomainGenParameters parameters, SecureRandom random) {
            this(FipsSHS.Algorithm.SHA256, parameters, random);
        }

        public DomainParametersGenerator(FipsDigestAlgorithm digestAlgorithm, DomainGenParameters parameters, SecureRandom random) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                int effSizeInBits = parameters.L;
                if (effSizeInBits != 2048 && effSizeInBits != 3072) {
                    throw new FipsUnapprovedOperationError("Attempt to create parameters with unapproved key size [" + effSizeInBits + "]", ALGORITHM);
                }
                Utils.validateRandom(random, Utils.getAsymmetricSecurityStrength(effSizeInBits), ALGORITHM, "Attempt to create parameters with unapproved RNG");
            }
            this.digestAlgorithm = digestAlgorithm;
            this.parameters = parameters;
            this.random = random;
        }

        public DSADomainParameters generateDomainParameters() {
            if (this.parameters.p != null) {
                if (this.parameters.seed != null && this.parameters.usageIndex >= 0) {
                    BigInteger g = DsaParametersGenerator.calculateGenerator_FIPS186_3_Verifiable(FipsSHS.createDigest(this.digestAlgorithm), this.parameters.p, this.parameters.q, this.parameters.seed, this.parameters.usageIndex);
                    return new DSADomainParameters(this.parameters.p, this.parameters.q, g, new DSAValidationParameters(this.parameters.seed, -1, this.parameters.usageIndex));
                }
                BigInteger g = DsaParametersGenerator.calculateGenerator_FIPS186_3_Unverifiable(this.parameters.p, this.parameters.q, this.random);
                return new DSADomainParameters(this.parameters.p, this.parameters.q, g, null);
            }
            DsaParametersGenerator pGen = new DsaParametersGenerator(FipsSHS.createDigest(this.digestAlgorithm));
            DsaParameterGenerationParameters params = new DsaParameterGenerationParameters(this.parameters.L, this.parameters.N, this.parameters.certainty, this.random, this.parameters.usageIndex);
            pGen.init(params);
            DsaParameters p = pGen.generateParameters();
            DsaValidationParameters validationParameters = p.getValidationParameters();
            return new DSADomainParameters(p.getP(), p.getQ(), p.getG(), new DSAValidationParameters(validationParameters.getSeed(), validationParameters.getCounter(), validationParameters.getUsageIndex()));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class DomainGenParameters
    extends FipsParameters {
        private final int L;
        private final int N;
        private final int certainty;
        private final BigInteger p;
        private final BigInteger q;
        private final byte[] seed;
        private final int usageIndex;

        public DomainGenParameters(int strength) {
            this(strength, strength > 1024 ? 256 : 160, PrimeCertaintyCalculator.getDefaultCertainty(strength));
        }

        public DomainGenParameters(int strength, int certainty) {
            this(strength, strength > 1024 ? 256 : 160, certainty);
        }

        public DomainGenParameters(int L, int N, int certainty) {
            this(L, N, certainty, null, null, null, -1);
        }

        public DomainGenParameters(int L, int N, int certainty, int usageIndex) {
            this(L, N, certainty, null, null, null, usageIndex);
        }

        public DomainGenParameters(BigInteger p, BigInteger q) {
            this(p.bitLength(), q.bitLength(), 0, p, q, null, -1);
        }

        public DomainGenParameters(BigInteger p, BigInteger q, byte[] seed, int usageIndex) {
            this(p.bitLength(), q.bitLength(), 0, p, q, Arrays.clone(seed), usageIndex);
        }

        DomainGenParameters(int L, int N, int certainty, BigInteger p, BigInteger q, byte[] seed, int usageIndex) {
            super(ALGORITHM);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && p == null && certainty < PrimeCertaintyCalculator.getDefaultCertainty(L)) {
                throw new FipsUnapprovedOperationError("Prime generation certainty " + certainty + " inadequate for parameters of " + L + " bits", this.getAlgorithm());
            }
            if (usageIndex > 255) {
                throw new IllegalArgumentException("Usage index must be in range 0 to 255 (or -1 to ignore)");
            }
            this.L = L;
            this.N = N;
            this.certainty = certainty;
            this.p = p;
            this.q = q;
            this.seed = seed;
            this.usageIndex = usageIndex;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Parameters
    extends FipsParameters {
        private final FipsDigestAlgorithm digestAlgorithm;

        Parameters() {
            super(ALGORITHM);
            this.digestAlgorithm = FipsSHS.Algorithm.SHA1;
        }

        private Parameters(FipsDigestAlgorithm digestAlgorithm) {
            super(ALGORITHM);
            if (digestAlgorithm == null && CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                PrivilegedUtils.checkPermission(Permissions.TlsNullDigestEnabled);
            }
            this.digestAlgorithm = digestAlgorithm;
        }

        public FipsDigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public Parameters withDigestAlgorithm(FipsDigestAlgorithm digestAlgorithm) {
            return new Parameters(digestAlgorithm);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyGenParameters
    extends FipsParameters {
        private final DSADomainParameters domainParameters;

        public KeyGenParameters(DSADomainParameters domainParameters) {
            super(ALGORITHM);
            this.domainParameters = domainParameters;
        }

        public DSADomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }
}

