/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.pqc.lms;

import java.util.Arrays;
import java.util.List;
import org.bouncycastle.crypto.ExhaustedPrivateKeyException;
import org.bouncycastle.crypto.internal.pqc.lms.HSSKeyGenerationParameters;
import org.bouncycastle.crypto.internal.pqc.lms.HSSPrivateKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.HSSPublicKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.HSSSignature;
import org.bouncycastle.crypto.internal.pqc.lms.LMOtsParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMOtsPrivateKey;
import org.bouncycastle.crypto.internal.pqc.lms.LMS;
import org.bouncycastle.crypto.internal.pqc.lms.LMSContext;
import org.bouncycastle.crypto.internal.pqc.lms.LMSPrivateKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSPublicKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSSignature;
import org.bouncycastle.crypto.internal.pqc.lms.LMSSignedPubKey;
import org.bouncycastle.crypto.internal.pqc.lms.LMSigParameters;

class HSS {
    HSS() {
    }

    public static HSSPrivateKeyParameters generateHSSKeyPair(HSSKeyGenerationParameters parameters) {
        LMSPrivateKeyParameters[] keys = new LMSPrivateKeyParameters[parameters.getDepth()];
        LMSSignature[] sig = new LMSSignature[parameters.getDepth() - 1];
        byte[] rootSeed = new byte[parameters.getLmsParameters()[0].getLMSigParam().getM()];
        parameters.getRandom().nextBytes(rootSeed);
        byte[] I = new byte[16];
        parameters.getRandom().nextBytes(I);
        byte[] zero = new byte[]{};
        long hssKeyMaxIndex = 1L;
        for (int t = 0; t < keys.length; ++t) {
            keys[t] = t == 0 ? new LMSPrivateKeyParameters(parameters.getLmsParameters()[t].getLMSigParam(), parameters.getLmsParameters()[t].getLMOTSParam(), 0, I, 1 << parameters.getLmsParameters()[t].getLMSigParam().getH(), rootSeed) : new PlaceholderLMSPrivateKey(parameters.getLmsParameters()[t].getLMSigParam(), parameters.getLmsParameters()[t].getLMOTSParam(), -1, zero, 1 << parameters.getLmsParameters()[t].getLMSigParam().getH(), zero);
            hssKeyMaxIndex *= 1L << parameters.getLmsParameters()[t].getLMSigParam().getH();
        }
        if (hssKeyMaxIndex == 0L) {
            hssKeyMaxIndex = Long.MAX_VALUE;
        }
        return new HSSPrivateKeyParameters(parameters.getDepth(), Arrays.asList(keys), Arrays.asList(sig), 0L, hssKeyMaxIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementIndex(HSSPrivateKeyParameters keyPair) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = keyPair;
        synchronized (hSSPrivateKeyParameters) {
            HSS.rangeTestKeys(keyPair);
            keyPair.incIndex();
            keyPair.getKeys().get(keyPair.getL() - 1).incIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rangeTestKeys(HSSPrivateKeyParameters keyPair) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = keyPair;
        synchronized (hSSPrivateKeyParameters) {
            int L;
            if (keyPair.getIndex() >= keyPair.getIndexLimit()) {
                throw new ExhaustedPrivateKeyException("hss private key" + (keyPair.isShard() ? " shard" : "") + " is exhausted");
            }
            int d = L = keyPair.getL();
            List<LMSPrivateKeyParameters> prv = keyPair.getKeys();
            while (prv.get(d - 1).getIndex() == (long)(1 << prv.get(d - 1).getSigParameters().getH())) {
                if (--d != 0) continue;
                throw new ExhaustedPrivateKeyException("hss private key" + (keyPair.isShard() ? " shard" : "") + " is exhausted the maximum limit for this HSS private key");
            }
            while (d < L) {
                keyPair.replaceConsumedKey(d);
                ++d;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HSSSignature generateSignature(HSSPrivateKeyParameters keyPair, byte[] message) {
        LMSSignedPubKey[] signed_pub_key;
        LMSPrivateKeyParameters nextKey;
        int L = keyPair.getL();
        HSSPrivateKeyParameters hSSPrivateKeyParameters = keyPair;
        synchronized (hSSPrivateKeyParameters) {
            HSS.rangeTestKeys(keyPair);
            List<LMSPrivateKeyParameters> keys = keyPair.getKeys();
            List<LMSSignature> sig = keyPair.getSig();
            nextKey = keyPair.getKeys().get(L - 1);
            signed_pub_key = new LMSSignedPubKey[L - 1];
            for (int i = 0; i < L - 1; ++i) {
                signed_pub_key[i] = new LMSSignedPubKey(sig.get(i), keys.get(i + 1).getPublicKey());
            }
            keyPair.incIndex();
        }
        LMSContext context = nextKey.generateLMSContext().withSignedPublicKeys(signed_pub_key);
        context.update(message, 0, message.length);
        return HSS.generateSignature(L, context);
    }

    public static HSSSignature generateSignature(int L, LMSContext context) {
        return new HSSSignature(L - 1, context.getSignedPubKeys(), LMS.generateSign(context));
    }

    public static boolean verifySignature(HSSPublicKeyParameters publicKey, HSSSignature signature, byte[] message) {
        int Nspk = signature.getlMinus1();
        if (Nspk + 1 != publicKey.getL()) {
            return false;
        }
        LMSSignature[] sigList = new LMSSignature[Nspk + 1];
        LMSPublicKeyParameters[] pubList = new LMSPublicKeyParameters[Nspk];
        for (int i = 0; i < Nspk; ++i) {
            sigList[i] = signature.getSignedPubKey()[i].getSignature();
            pubList[i] = signature.getSignedPubKey()[i].getPublicKey();
        }
        sigList[Nspk] = signature.getSignature();
        LMSPublicKeyParameters key = publicKey.getLMSPublicKey();
        for (int i = 0; i < Nspk; ++i) {
            LMSSignature sig = sigList[i];
            byte[] msg = pubList[i].toByteArray();
            if (!LMS.verifySignature(key, sig, msg)) {
                return false;
            }
            try {
                key = pubList[i];
                continue;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
        return LMS.verifySignature(key, sigList[Nspk], message);
    }

    static class PlaceholderLMSPrivateKey
    extends LMSPrivateKeyParameters {
        public PlaceholderLMSPrivateKey(LMSigParameters lmsParameter, LMOtsParameters otsParameters, int q, byte[] I, int maxQ, byte[] masterSecret) {
            super(lmsParameter, otsParameters, q, I, maxQ, masterSecret);
        }

        @Override
        LMOtsPrivateKey getNextOtsPrivateKey() {
            throw new RuntimeException("placeholder only");
        }

        @Override
        public LMSPublicKeyParameters getPublicKey() {
            throw new RuntimeException("placeholder only");
        }
    }
}

