/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.bouncycastle.crypto.NativeServices;
import org.bouncycastle.crypto.fips.NativeFeatures;
import org.bouncycastle.crypto.fips.NativeLibIdentity;
import org.bouncycastle.crypto.fips.NativeLoader;
import org.bouncycastle.crypto.fips.VariantSelector;

class FipsNativeServices
implements NativeServices {
    public static final String RSA = "RSA";
    private static Set<String> nativeFeatures = null;

    FipsNativeServices() {
    }

    @Override
    public String getStatusMessage() {
        if (NativeLoader.isNativeLibsAvailableForSystem()) {
            if (NativeLoader.isNativeInstalled()) {
                return "READY";
            }
            return NativeLoader.getNativeStatusMessage();
        }
        return "UNSUPPORTED";
    }

    @Override
    public Set<String> getFeatureSet() {
        return FipsNativeServices.getNativeFeatureSet();
    }

    public String getFeatureString() {
        return String.join((CharSequence)" ", this.getFeatureSet());
    }

    @Override
    public String getVariant() {
        return NativeLoader.getSelectedVariant();
    }

    @Override
    public String[][] getVariantSelectionMatrix() {
        try {
            return VariantSelector.getFeatureMatrix();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return new String[0][];
        }
    }

    @Override
    public boolean hasService(String feature) {
        if (nativeFeatures == null) {
            nativeFeatures = FipsNativeServices.getNativeFeatureSet();
        }
        return nativeFeatures.contains(feature);
    }

    @Override
    public String getBuildDate() {
        return NativeLibIdentity.getNativeBuiltTimeStamp();
    }

    @Override
    public String getLibraryIdent() {
        String lib = NativeLibIdentity.getLibraryIdent();
        if (lib == null) {
            return "java";
        }
        return lib;
    }

    @Override
    public boolean isEnabled() {
        return NativeLoader.isNativeEnabled();
    }

    @Override
    public boolean isInstalled() {
        return NativeLoader.isNativeInstalled();
    }

    @Override
    public boolean isSupported() {
        return NativeLoader.isNativeLibsAvailableForSystem();
    }

    static synchronized Set<String> getNativeFeatureSet() {
        TreeSet<String> set = new TreeSet<String>();
        if (NativeFeatures.hasHardwareRSA()) {
            set.add(RSA);
        }
        if (NativeFeatures.hasHardwareSeed()) {
            set.add("NRBG");
        }
        if (NativeFeatures.hasHardwareRand()) {
            set.add("DRBG");
        }
        if (NativeFeatures.hasAESHardwareSupport()) {
            set.add("AES/ECB");
        }
        if (NativeFeatures.hasGCMHardwareSupport()) {
            set.add("AES/GCM");
        }
        if (NativeFeatures.hasCBCHardwareSupport()) {
            set.add("AES/CBC");
        }
        if (NativeFeatures.hasCFBHardwareSupport()) {
            set.add("AES/CFB");
        }
        if (NativeFeatures.hasCTRHardwareSupport()) {
            set.add("AES/CTR");
        }
        if (NativeFeatures.hasHardwareSHA()) {
            set.add("SHA2");
        }
        if (set.isEmpty()) {
            set.add("NONE");
        }
        return Collections.unmodifiableSet(set);
    }
}

