/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

final class Ed25519PublicKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 32;
    private final byte[] data = new byte[32];
    private final Ed25519 ed25519 = new Ed25519(){

        @Override
        protected Digest createDigest() {
            return FipsSHS.createDigest(FipsSHS.Algorithm.SHA512);
        }
    };

    public Ed25519PublicKeyParameters(byte[] buf) {
        this(Ed25519PublicKeyParameters.validate(buf), 0);
    }

    public Ed25519PublicKeyParameters(byte[] buf, int off) {
        super(false);
        System.arraycopy(buf, off, this.data, 0, 32);
    }

    public Ed25519PublicKeyParameters(InputStream input) throws IOException {
        super(false);
        if (32 != Streams.readFully(input, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed25519 public key");
        }
    }

    public void encode(byte[] buf, int off) {
        System.arraycopy(this.data, 0, buf, off, 32);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    public boolean verify(int algorithm, byte[] ctx, byte[] msg, int msgOff, int msgLen, byte[] sig, int sigOff) {
        switch (algorithm) {
            case 0: {
                if (null != ctx) {
                    throw new IllegalArgumentException("ctx");
                }
                return this.ed25519.verify(sig, sigOff, this.data, 0, msg, msgOff, msgLen);
            }
            case 1: {
                return this.ed25519.verify(sig, sigOff, this.data, 0, ctx, msg, msgOff, msgLen);
            }
            case 2: {
                if (64 != msgLen) {
                    throw new IllegalArgumentException("msgLen");
                }
                return this.ed25519.verifyPrehash(sig, sigOff, this.data, 0, ctx, msg, msgOff);
            }
        }
        throw new IllegalArgumentException("algorithm");
    }

    private static byte[] validate(byte[] buf) {
        if (buf.length != 32) {
            throw new IllegalArgumentException("'buf' must have length 32");
        }
        return buf;
    }
}

