/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.DesBase;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.DefaultMultiBlockCipher;
import org.bouncycastle.crypto.internal.OutputLengthException;
import org.bouncycastle.crypto.internal.params.KeyParameter;

class DesEdeEngine
extends DefaultMultiBlockCipher {
    private static final int MAX_BLOCK_COUNT = 65536;
    protected static final int BLOCK_SIZE = 8;
    private WorkingBuffer workingBuf = null;
    private boolean forEncryption;
    private int blockCount;
    private final DesBase desBase = new DesBase();

    @Override
    public void init(boolean encrypting, CipherParameters params) {
        int[] workingKey3;
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to DESede init - " + params.getClass().getName());
        }
        byte[] keyMaster = ((KeyParameter)params).getKey();
        if (keyMaster.length != 24 && keyMaster.length != 16) {
            throw new IllegalArgumentException("key size must be 16 or 24 bytes.");
        }
        this.forEncryption = encrypting;
        byte[] key1 = new byte[8];
        System.arraycopy(keyMaster, 0, key1, 0, key1.length);
        int[] workingKey1 = this.desBase.generateWorkingKey(encrypting, key1);
        byte[] key2 = new byte[8];
        System.arraycopy(keyMaster, 8, key2, 0, key2.length);
        int[] workingKey2 = this.desBase.generateWorkingKey(!encrypting, key2);
        if (keyMaster.length == 24) {
            byte[] key3 = new byte[8];
            System.arraycopy(keyMaster, 16, key3, 0, key3.length);
            workingKey3 = this.desBase.generateWorkingKey(encrypting, key3);
        } else {
            workingKey3 = workingKey1;
        }
        this.workingBuf = new WorkingBuffer(workingKey1, workingKey2, workingKey3);
        this.blockCount = 0;
    }

    @Override
    public String getAlgorithmName() {
        return "DESede";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.workingBuf == null) {
            throw new IllegalStateException("DESede engine not initialised");
        }
        if (inOff + 8 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 8 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        byte[] temp = new byte[8];
        if (this.forEncryption) {
            if (this.blockCount >= 65536) {
                throw new IllegalStateException("attempt to process more than 65536 blocks with 2-Key TripleDES");
            }
            this.desBase.desFunc(this.workingBuf.workingKey1, in, inOff, temp, 0);
            this.desBase.desFunc(this.workingBuf.workingKey2, temp, 0, temp, 0);
            this.desBase.desFunc(this.workingBuf.workingKey3, temp, 0, out, outOff);
        } else {
            this.desBase.desFunc(this.workingBuf.workingKey3, in, inOff, temp, 0);
            this.desBase.desFunc(this.workingBuf.workingKey2, temp, 0, temp, 0);
            this.desBase.desFunc(this.workingBuf.workingKey1, temp, 0, out, outOff);
        }
        ++this.blockCount;
        return 8;
    }

    @Override
    public void reset() {
    }

    private static final class WorkingBuffer {
        private final int[] workingKey1;
        private final int[] workingKey2;
        private final int[] workingKey3;

        WorkingBuffer(int[] workingKey1, int[] workingKey2, int[] workingKey3) {
            this.workingKey1 = workingKey1;
            this.workingKey2 = workingKey2;
            this.workingKey3 = workingKey3;
        }

        protected void finalize() throws Throwable {
            try {
                if (this.workingKey1 == this.workingKey3) {
                    for (int i = 0; i != this.workingKey1.length; ++i) {
                        this.workingKey1[i] = 0;
                        this.workingKey2[i] = 0;
                    }
                } else {
                    for (int i = 0; i != this.workingKey1.length; ++i) {
                        this.workingKey1[i] = 0;
                        this.workingKey2[i] = 0;
                        this.workingKey3[i] = 0;
                    }
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

