/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.TestTrigger;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.MultiBlockCipher;
import org.bouncycastle.crypto.internal.SkippingStreamCipher;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.crypto.util.dispose.NativeDisposer;
import org.bouncycastle.crypto.util.dispose.NativeReference;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

class AESNativeCTR
implements StreamCipher,
SkippingStreamCipher,
MultiBlockCipher {
    private static byte[] key = Hex.decode("000102030405060708090a0b0c0d0e0f");
    private static byte[] enc = Hex.decode("c6a13b37878f5b826f4f8162a1c8d8797346139595c0b41e497bbde365f42d0a");
    private static TestTrigger trigger = new TestTrigger();
    private CTRRefWrapper referenceWrapper = null;

    private AESNativeCTR() {
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.processBytes(this.referenceWrapper.getReference(), in, inOff, this.getBlockSize(), out, outOff);
    }

    @Override
    public int getMultiBlockSize() {
        return AESNativeCTR.getMultiBlockSize(this.referenceWrapper.getReference());
    }

    @Override
    public int processBlocks(byte[] in, int inOff, int blockCount, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        int extent = this.getBlockSize() * blockCount;
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.processBytes(this.referenceWrapper.getReference(), in, inOff, extent, out, outOff);
    }

    @Override
    public long skip(long numberOfBytes) {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.skip(this.referenceWrapper.getReference(), numberOfBytes);
    }

    @Override
    public long seekTo(long position) {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.seekTo(this.referenceWrapper.getReference(), position);
    }

    @Override
    public long getPosition() {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.getPosition(this.referenceWrapper.getReference());
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof ParametersWithIV) {
            int maxCounterSize;
            ParametersWithIV ivParam = (ParametersWithIV)params;
            byte[] iv = ivParam.getIV();
            int blockSize = this.getBlockSize();
            int n = maxCounterSize = 8 > blockSize / 2 ? blockSize / 2 : 8;
            if (blockSize - iv.length > maxCounterSize) {
                throw new IllegalArgumentException("CTR mode requires IV of at least: " + (blockSize - maxCounterSize) + " bytes.");
            }
            if (this.referenceWrapper == null) {
                this.referenceWrapper = new CTRRefWrapper(AESNativeCTR.makeNative());
            }
            if (ivParam.getParameters() == null) {
                AESNativeCTR.init(this.referenceWrapper.getReference(), null, iv);
            } else {
                byte[] key = ((KeyParameter)ivParam.getParameters()).getKey();
                switch (key.length) {
                    case 16: 
                    case 24: 
                    case 32: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid key length, key must be 16,24 or 32 bytes");
                    }
                }
                AESNativeCTR.init(this.referenceWrapper.getReference(), key, iv);
            }
        } else {
            throw new IllegalArgumentException("CTR mode requires ParametersWithIV");
        }
        this.reset();
    }

    static native long makeNative();

    @Override
    public String getAlgorithmName() {
        return "AES/CTR";
    }

    @Override
    public byte returnByte(byte in) {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.returnByte(this.referenceWrapper.getReference(), in);
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCTR.processBytes(this.referenceWrapper.getReference(), in, inOff, len, out, outOff);
    }

    @Override
    public void reset() {
        if (this.referenceWrapper == null) {
            return;
        }
        AESNativeCTR.reset(this.referenceWrapper.getReference());
    }

    private static native long getPosition(long var0);

    private static native int getMultiBlockSize(long var0);

    private static native long skip(long var0, long var2);

    private static native long seekTo(long var0, long var2);

    static native void init(long var0, byte[] var2, byte[] var3);

    private static native byte returnByte(long var0, byte var2);

    private static native int processBytes(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native void reset(long var0);

    static native void dispose(long var0);

    static AESNativeCTR newInstance() {
        AESNativeCTR engine = new AESNativeCTR();
        if (trigger.triggerTest()) {
            return SelfTestExecutor.validate(FipsAES.CTR.getAlgorithm(), engine, new BasicKatTest<AESNativeCTR>(){

                @Override
                public boolean hasTestPassed(AESNativeCTR ctrCipher) throws Exception {
                    byte[] data = new byte[32];
                    byte[] buf = new byte[32];
                    byte[] iv = new byte[16];
                    ctrCipher.init(true, new ParametersWithIV(new KeyParameterImpl(key), iv));
                    ctrCipher.processBlocks(data, 0, 2, buf, 0);
                    if (!Arrays.areEqual(enc, buf)) {
                        return false;
                    }
                    ctrCipher.init(false, new ParametersWithIV(new KeyParameterImpl(key), iv));
                    ctrCipher.processBlocks(enc, 0, 2, buf, 0);
                    return Arrays.areEqual(data, buf);
                }
            });
        }
        return engine;
    }

    private static class CTRRefWrapper
    extends NativeReference {
        public CTRRefWrapper(long reference) {
            super(reference);
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    private static class Disposer
    extends NativeDisposer {
        Disposer(long ref) {
            super(ref);
        }

        @Override
        protected void dispose(long reference) {
            AESNativeCTR.dispose(reference);
        }
    }
}

