/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.asymmetric.CustomNamedCurves;
import org.bouncycastle.crypto.asymmetric.ECImplicitDomainParameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class ECDomainParameters {
    private final ECCurve curve;
    private final byte[] seed;
    private final ECPoint G;
    private final BigInteger n;
    private final BigInteger h;
    private volatile BigInteger hInv = null;

    public ECDomainParameters(ECCurve curve, ECPoint G, BigInteger n) {
        this(curve, G, n, BigInteger.ONE, null);
    }

    public ECDomainParameters(ECCurve curve, ECPoint G, BigInteger n, BigInteger h) {
        this(curve, G, n, h, null);
    }

    public ECDomainParameters(ECCurve curve, ECPoint G, BigInteger n, BigInteger h, byte[] seed) {
        if (curve == null) {
            throw new NullPointerException("curve");
        }
        if (n == null) {
            throw new NullPointerException("n");
        }
        this.curve = curve;
        this.G = KeyUtils.validated(curve, G);
        this.n = n;
        this.h = h;
        this.seed = Arrays.clone(seed);
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECPoint getG() {
        return this.G;
    }

    public BigInteger getN() {
        return this.n;
    }

    public BigInteger getH() {
        return this.h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getInverseH() {
        if (this.hInv == null) {
            if (this.h == null) {
                throw new IllegalStateException("no H provided for these parameters");
            }
            ECDomainParameters eCDomainParameters = this;
            synchronized (eCDomainParameters) {
                if (this.hInv == null) {
                    this.hInv = BigIntegers.modOddInverseVar(this.n, this.h);
                }
            }
        }
        return this.hInv;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.seed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ECDomainParameters)) {
            return false;
        }
        ECDomainParameters that = (ECDomainParameters)o;
        if (!this.G.equals(that.G)) {
            return false;
        }
        if (!this.curve.equals(that.curve)) {
            return false;
        }
        if (!this.h.equals(that.h)) {
            return false;
        }
        return this.n.equals(that.n);
    }

    public int hashCode() {
        int result = this.curve.hashCode();
        result = 31 * result + this.G.hashCode();
        result = 31 * result + this.n.hashCode();
        result = 31 * result + this.h.hashCode();
        return result;
    }

    static ECDomainParameters decodeCurveParameters(AlgorithmIdentifier algId) {
        if (!algId.getAlgorithm().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            throw new IllegalArgumentException("Unknown algorithm type: " + algId.getAlgorithm());
        }
        X962Parameters params = X962Parameters.getInstance(algId.getParameters());
        if (params.isNamedCurve()) {
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)params.getParameters();
            X9ECParameters x9 = CustomNamedCurves.getByOID(oid);
            if (x9 == null) {
                x9 = ECNamedCurveTable.getByOID(oid);
            }
            return new NamedECDomainParameters(oid, x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
        }
        if (!params.isImplicitlyCA()) {
            X9ECParameters x9 = X9ECParameters.getInstance(params.getParameters());
            return new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
        }
        return new ECImplicitDomainParameters((ECDomainParameters)CryptoServicesRegistrar.getProperty(CryptoServicesRegistrar.Property.EC_IMPLICITLY_CA));
    }
}

