/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.asymmetric.DHDomainParametersID;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class DHDomainParametersIndex {
    private static final DHDomainParameters ffdhe2048 = new DHDomainParameters(BigIntegers.fromUnsignedByteArray(Hex.decode("FFFFFFFFFFFFFFFFADF85458A2BB4A9AAFDC5620273D3CF1\nD8B9C583CE2D3695A9E13641146433FBCC939DCE249B3EF9\n7D2FE363630C75D8F681B202AEC4617AD3DF1ED5D5FD6561\n2433F51F5F066ED0856365553DED1AF3B557135E7F57C935\n984F0C70E0E68B77E2A689DAF3EFE8721DF158A136ADE735\n30ACCA4F483A797ABC0AB182B324FB61D108A94BB2C8E3FB\nB96ADAB760D7F4681D4F42A3DE394DF4AE56EDE76372BB19\n0B07A7C8EE0A6D709E02FCE1CDF7E2ECC03404CD28342F61\n9172FE9CE98583FF8E4F1232EEF28183C3FE3B1B4C6FAD73\n3BB5FCBC2EC22005C58EF1837D1683B2C6F34A26C1B2EFFA\n886B423861285C97FFFFFFFFFFFFFFFF")), BigIntegers.fromUnsignedByteArray(Hex.decode("7FFFFFFFFFFFFFFFD6FC2A2C515DA54D57EE2B10139E9E78\nEC5CE2C1E7169B4AD4F09B208A3219FDE649CEE7124D9F7C\nBE97F1B1B1863AEC7B40D901576230BD69EF8F6AEAFEB2B0\n9219FA8FAF83376842B1B2AA9EF68D79DAAB89AF3FABE49A\nCC278638707345BBF15344ED79F7F4390EF8AC509B56F39A\n98566527A41D3CBD5E0558C159927DB0E88454A5D96471FD\nDCB56D5BB06BFA340EA7A151EF1CA6FA572B76F3B1B95D8C\n8583D3E4770536B84F017E70E6FBF176601A0266941A17B0\nC8B97F4E74C2C1FFC7278919777940C1E1FF1D8DA637D6B9\n9DDAFE5E17611002E2C778C1BE8B41D96379A51360D977FD\n4435A11C30942E4BFFFFFFFFFFFFFFFF")), BigIntegers.TWO, 224);
    private static final DHDomainParameters ffdhe3072 = new DHDomainParameters(BigIntegers.fromUnsignedByteArray(Hex.decode("FFFFFFFFFFFFFFFFADF85458A2BB4A9AAFDC5620273D3CF1\nD8B9C583CE2D3695A9E13641146433FBCC939DCE249B3EF9\n7D2FE363630C75D8F681B202AEC4617AD3DF1ED5D5FD6561\n2433F51F5F066ED0856365553DED1AF3B557135E7F57C935\n984F0C70E0E68B77E2A689DAF3EFE8721DF158A136ADE735\n30ACCA4F483A797ABC0AB182B324FB61D108A94BB2C8E3FB\nB96ADAB760D7F4681D4F42A3DE394DF4AE56EDE76372BB19\n0B07A7C8EE0A6D709E02FCE1CDF7E2ECC03404CD28342F61\n9172FE9CE98583FF8E4F1232EEF28183C3FE3B1B4C6FAD73\n3BB5FCBC2EC22005C58EF1837D1683B2C6F34A26C1B2EFFA\n886B4238611FCFDCDE355B3B6519035BBC34F4DEF99C0238\n61B46FC9D6E6C9077AD91D2691F7F7EE598CB0FAC186D91C\nAEFE130985139270B4130C93BC437944F4FD4452E2D74DD3\n64F2E21E71F54BFF5CAE82AB9C9DF69EE86D2BC522363A0D\nABC521979B0DEADA1DBF9A42D5C4484E0ABCD06BFA53DDEF\n3C1B20EE3FD59D7C25E41D2B66C62E37FFFFFFFFFFFFFFFF")), BigIntegers.fromUnsignedByteArray(Hex.decode("7FFFFFFFFFFFFFFFD6FC2A2C515DA54D57EE2B10139E9E78\nEC5CE2C1E7169B4AD4F09B208A3219FDE649CEE7124D9F7C\nBE97F1B1B1863AEC7B40D901576230BD69EF8F6AEAFEB2B0\n9219FA8FAF83376842B1B2AA9EF68D79DAAB89AF3FABE49A\nCC278638707345BBF15344ED79F7F4390EF8AC509B56F39A\n98566527A41D3CBD5E0558C159927DB0E88454A5D96471FD\nDCB56D5BB06BFA340EA7A151EF1CA6FA572B76F3B1B95D8C\n8583D3E4770536B84F017E70E6FBF176601A0266941A17B0\nC8B97F4E74C2C1FFC7278919777940C1E1FF1D8DA637D6B9\n9DDAFE5E17611002E2C778C1BE8B41D96379A51360D977FD\n4435A11C308FE7EE6F1AAD9DB28C81ADDE1A7A6F7CCE011C\n30DA37E4EB736483BD6C8E9348FBFBF72CC6587D60C36C8E\n577F0984C289C9385A098649DE21BCA27A7EA229716BA6E9\nB279710F38FAA5FFAE574155CE4EFB4F743695E2911B1D06\nD5E290CBCD86F56D0EDFCD216AE22427055E6835FD29EEF7\n9E0D90771FEACEBE12F20E95B363171BFFFFFFFFFFFFFFFF")), BigIntegers.TWO, 256);
    private static final DHDomainParameters ffdhe4096 = new DHDomainParameters(BigIntegers.fromUnsignedByteArray(Hex.decode("FFFFFFFFFFFFFFFFADF85458A2BB4A9AAFDC5620273D3CF1\nD8B9C583CE2D3695A9E13641146433FBCC939DCE249B3EF9\n7D2FE363630C75D8F681B202AEC4617AD3DF1ED5D5FD6561\n2433F51F5F066ED0856365553DED1AF3B557135E7F57C935\n984F0C70E0E68B77E2A689DAF3EFE8721DF158A136ADE735\n30ACCA4F483A797ABC0AB182B324FB61D108A94BB2C8E3FB\nB96ADAB760D7F4681D4F42A3DE394DF4AE56EDE76372BB19\n0B07A7C8EE0A6D709E02FCE1CDF7E2ECC03404CD28342F61\n9172FE9CE98583FF8E4F1232EEF28183C3FE3B1B4C6FAD73\n3BB5FCBC2EC22005C58EF1837D1683B2C6F34A26C1B2EFFA\n886B4238611FCFDCDE355B3B6519035BBC34F4DEF99C0238\n61B46FC9D6E6C9077AD91D2691F7F7EE598CB0FAC186D91C\nAEFE130985139270B4130C93BC437944F4FD4452E2D74DD3\n64F2E21E71F54BFF5CAE82AB9C9DF69EE86D2BC522363A0D\nABC521979B0DEADA1DBF9A42D5C4484E0ABCD06BFA53DDEF\n3C1B20EE3FD59D7C25E41D2B669E1EF16E6F52C3164DF4FB\n7930E9E4E58857B6AC7D5F42D69F6D187763CF1D55034004\n87F55BA57E31CC7A7135C886EFB4318AED6A1E012D9E6832\nA907600A918130C46DC778F971AD0038092999A333CB8B7A\n1A1DB93D7140003C2A4ECEA9F98D0ACC0A8291CDCEC97DCF\n8EC9B55A7F88A46B4DB5A851F44182E1C68A007E5E655F6A\nFFFFFFFFFFFFFFFF")), BigIntegers.fromUnsignedByteArray(Hex.decode("7FFFFFFFFFFFFFFFD6FC2A2C515DA54D57EE2B10139E9E78\nEC5CE2C1E7169B4AD4F09B208A3219FDE649CEE7124D9F7C\nBE97F1B1B1863AEC7B40D901576230BD69EF8F6AEAFEB2B0\n9219FA8FAF83376842B1B2AA9EF68D79DAAB89AF3FABE49A\nCC278638707345BBF15344ED79F7F4390EF8AC509B56F39A\n98566527A41D3CBD5E0558C159927DB0E88454A5D96471FD\nDCB56D5BB06BFA340EA7A151EF1CA6FA572B76F3B1B95D8C\n8583D3E4770536B84F017E70E6FBF176601A0266941A17B0\nC8B97F4E74C2C1FFC7278919777940C1E1FF1D8DA637D6B9\n9DDAFE5E17611002E2C778C1BE8B41D96379A51360D977FD\n4435A11C308FE7EE6F1AAD9DB28C81ADDE1A7A6F7CCE011C\n30DA37E4EB736483BD6C8E9348FBFBF72CC6587D60C36C8E\n577F0984C289C9385A098649DE21BCA27A7EA229716BA6E9\nB279710F38FAA5FFAE574155CE4EFB4F743695E2911B1D06\nD5E290CBCD86F56D0EDFCD216AE22427055E6835FD29EEF7\n9E0D90771FEACEBE12F20E95B34F0F78B737A9618B26FA7D\nBC9874F272C42BDB563EAFA16B4FB68C3BB1E78EAA81A002\n43FAADD2BF18E63D389AE44377DA18C576B50F0096CF3419\n5483B00548C0986236E3BC7CB8D6801C0494CCD199E5C5BD\n0D0EDC9EB8A0001E15276754FCC68566054148E6E764BEE7\nC764DAAD3FC45235A6DAD428FA20C170E345003F2F32AFB5\n7FFFFFFFFFFFFFFF")), BigIntegers.TWO, 304);
    private static final DHDomainParameters ffdhe6144 = new DHDomainParameters(BigIntegers.fromUnsignedByteArray(Hex.decode("FFFFFFFFFFFFFFFFADF85458A2BB4A9AAFDC5620273D3CF1\nD8B9C583CE2D3695A9E13641146433FBCC939DCE249B3EF9\n7D2FE363630C75D8F681B202AEC4617AD3DF1ED5D5FD6561\n2433F51F5F066ED0856365553DED1AF3B557135E7F57C935\n984F0C70E0E68B77E2A689DAF3EFE8721DF158A136ADE735\n30ACCA4F483A797ABC0AB182B324FB61D108A94BB2C8E3FB\nB96ADAB760D7F4681D4F42A3DE394DF4AE56EDE76372BB19\n0B07A7C8EE0A6D709E02FCE1CDF7E2ECC03404CD28342F61\n9172FE9CE98583FF8E4F1232EEF28183C3FE3B1B4C6FAD73\n3BB5FCBC2EC22005C58EF1837D1683B2C6F34A26C1B2EFFA\n886B4238611FCFDCDE355B3B6519035BBC34F4DEF99C0238\n61B46FC9D6E6C9077AD91D2691F7F7EE598CB0FAC186D91C\nAEFE130985139270B4130C93BC437944F4FD4452E2D74DD3\n64F2E21E71F54BFF5CAE82AB9C9DF69EE86D2BC522363A0D\nABC521979B0DEADA1DBF9A42D5C4484E0ABCD06BFA53DDEF\n3C1B20EE3FD59D7C25E41D2B669E1EF16E6F52C3164DF4FB\n7930E9E4E58857B6AC7D5F42D69F6D187763CF1D55034004\n87F55BA57E31CC7A7135C886EFB4318AED6A1E012D9E6832\nA907600A918130C46DC778F971AD0038092999A333CB8B7A\n1A1DB93D7140003C2A4ECEA9F98D0ACC0A8291CDCEC97DCF\n8EC9B55A7F88A46B4DB5A851F44182E1C68A007E5E0DD902\n0BFD64B645036C7A4E677D2C38532A3A23BA4442CAF53EA6\n3BB454329B7624C8917BDD64B1C0FD4CB38E8C334C701C3A\nCDAD0657FCCFEC719B1F5C3E4E46041F388147FB4CFDB477\nA52471F7A9A96910B855322EDB6340D8A00EF092350511E3\n0ABEC1FFF9E3A26E7FB29F8C183023C3587E38DA0077D9B4\n763E4E4B94B2BBC194C6651E77CAF992EEAAC0232A281BF6\nB3A739C1226116820AE8DB5847A67CBEF9C9091B462D538C\nD72B03746AE77F5E62292C311562A846505DC82DB854338A\nE49F5235C95B91178CCF2DD5CACEF403EC9D1810C6272B04\n5B3B71F9DC6B80D63FDD4A8E9ADB1E6962A69526D43161C1\nA41D570D7938DAD4A40E329CD0E40E65FFFFFFFFFFFFFFFF")), BigIntegers.fromUnsignedByteArray(Hex.decode("7FFFFFFFFFFFFFFFD6FC2A2C515DA54D57EE2B10139E9E78\nEC5CE2C1E7169B4AD4F09B208A3219FDE649CEE7124D9F7C\nBE97F1B1B1863AEC7B40D901576230BD69EF8F6AEAFEB2B0\n9219FA8FAF83376842B1B2AA9EF68D79DAAB89AF3FABE49A\nCC278638707345BBF15344ED79F7F4390EF8AC509B56F39A\n98566527A41D3CBD5E0558C159927DB0E88454A5D96471FD\nDCB56D5BB06BFA340EA7A151EF1CA6FA572B76F3B1B95D8C\n8583D3E4770536B84F017E70E6FBF176601A0266941A17B0\nC8B97F4E74C2C1FFC7278919777940C1E1FF1D8DA637D6B9\n9DDAFE5E17611002E2C778C1BE8B41D96379A51360D977FD\n4435A11C308FE7EE6F1AAD9DB28C81ADDE1A7A6F7CCE011C\n30DA37E4EB736483BD6C8E9348FBFBF72CC6587D60C36C8E\n577F0984C289C9385A098649DE21BCA27A7EA229716BA6E9\nB279710F38FAA5FFAE574155CE4EFB4F743695E2911B1D06\nD5E290CBCD86F56D0EDFCD216AE22427055E6835FD29EEF7\n9E0D90771FEACEBE12F20E95B34F0F78B737A9618B26FA7D\nBC9874F272C42BDB563EAFA16B4FB68C3BB1E78EAA81A002\n43FAADD2BF18E63D389AE44377DA18C576B50F0096CF3419\n5483B00548C0986236E3BC7CB8D6801C0494CCD199E5C5BD\n0D0EDC9EB8A0001E15276754FCC68566054148E6E764BEE7\nC764DAAD3FC45235A6DAD428FA20C170E345003F2F06EC81\n05FEB25B2281B63D2733BE961C29951D11DD2221657A9F53\n1DDA2A194DBB126448BDEEB258E07EA659C74619A6380E1D\n66D6832BFE67F638CD8FAE1F2723020F9C40A3FDA67EDA3B\nD29238FBD4D4B4885C2A99176DB1A06C500778491A8288F1\n855F60FFFCF1D1373FD94FC60C1811E1AC3F1C6D003BECDA\n3B1F2725CA595DE0CA63328F3BE57CC97755601195140DFB\n59D39CE091308B4105746DAC23D33E5F7CE4848DA316A9C6\n6B9581BA3573BFAF311496188AB15423282EE416DC2A19C5\n724FA91AE4ADC88BC66796EAE5677A01F64E8C0863139582\n2D9DB8FCEE35C06B1FEEA5474D6D8F34B1534A936A18B0E0\nD20EAB86BC9C6D6A5207194E68720732FFFFFFFFFFFFFFFF")), BigIntegers.TWO, 352);
    private static final DHDomainParameters ffdhe8192 = new DHDomainParameters(BigIntegers.fromUnsignedByteArray(Hex.decode("FFFFFFFFFFFFFFFFADF85458A2BB4A9AAFDC5620273D3CF1\nD8B9C583CE2D3695A9E13641146433FBCC939DCE249B3EF9\n7D2FE363630C75D8F681B202AEC4617AD3DF1ED5D5FD6561\n2433F51F5F066ED0856365553DED1AF3B557135E7F57C935\n984F0C70E0E68B77E2A689DAF3EFE8721DF158A136ADE735\n30ACCA4F483A797ABC0AB182B324FB61D108A94BB2C8E3FB\nB96ADAB760D7F4681D4F42A3DE394DF4AE56EDE76372BB19\n0B07A7C8EE0A6D709E02FCE1CDF7E2ECC03404CD28342F61\n9172FE9CE98583FF8E4F1232EEF28183C3FE3B1B4C6FAD73\n3BB5FCBC2EC22005C58EF1837D1683B2C6F34A26C1B2EFFA\n886B4238611FCFDCDE355B3B6519035BBC34F4DEF99C0238\n61B46FC9D6E6C9077AD91D2691F7F7EE598CB0FAC186D91C\nAEFE130985139270B4130C93BC437944F4FD4452E2D74DD3\n64F2E21E71F54BFF5CAE82AB9C9DF69EE86D2BC522363A0D\nABC521979B0DEADA1DBF9A42D5C4484E0ABCD06BFA53DDEF\n3C1B20EE3FD59D7C25E41D2B669E1EF16E6F52C3164DF4FB\n7930E9E4E58857B6AC7D5F42D69F6D187763CF1D55034004\n87F55BA57E31CC7A7135C886EFB4318AED6A1E012D9E6832\nA907600A918130C46DC778F971AD0038092999A333CB8B7A\n1A1DB93D7140003C2A4ECEA9F98D0ACC0A8291CDCEC97DCF\n8EC9B55A7F88A46B4DB5A851F44182E1C68A007E5E0DD902\n0BFD64B645036C7A4E677D2C38532A3A23BA4442CAF53EA6\n3BB454329B7624C8917BDD64B1C0FD4CB38E8C334C701C3A\nCDAD0657FCCFEC719B1F5C3E4E46041F388147FB4CFDB477\nA52471F7A9A96910B855322EDB6340D8A00EF092350511E3\n0ABEC1FFF9E3A26E7FB29F8C183023C3587E38DA0077D9B4\n763E4E4B94B2BBC194C6651E77CAF992EEAAC0232A281BF6\nB3A739C1226116820AE8DB5847A67CBEF9C9091B462D538C\nD72B03746AE77F5E62292C311562A846505DC82DB854338A\nE49F5235C95B91178CCF2DD5CACEF403EC9D1810C6272B04\n5B3B71F9DC6B80D63FDD4A8E9ADB1E6962A69526D43161C1\nA41D570D7938DAD4A40E329CCFF46AAA36AD004CF600C838\n1E425A31D951AE64FDB23FCEC9509D43687FEB69EDD1CC5E\n0B8CC3BDF64B10EF86B63142A3AB8829555B2F747C932665\nCB2C0F1CC01BD70229388839D2AF05E454504AC78B758282\n2846C0BA35C35F5C59160CC046FD8251541FC68C9C86B022\nBB7099876A460E7451A8A93109703FEE1C217E6C3826E52C\n51AA691E0E423CFC99E9E31650C1217B624816CDAD9A95F9\nD5B8019488D9C0A0A1FE3075A577E23183F81D4A3F2FA457\n1EFC8CE0BA8A4FE8B6855DFE72B0A66EDED2FBABFBE58A30\nFAFABE1C5D71A87E2F741EF8C1FE86FEA6BBFDE530677F0D\n97D11D49F7A8443D0822E506A9F4614E011E2A94838FF88C\nD68C8BB7C5C6424CFFFFFFFFFFFFFFFF")), BigIntegers.fromUnsignedByteArray(Hex.decode("7FFFFFFFFFFFFFFFD6FC2A2C515DA54D57EE2B10139E9E78\nEC5CE2C1E7169B4AD4F09B208A3219FDE649CEE7124D9F7C\nBE97F1B1B1863AEC7B40D901576230BD69EF8F6AEAFEB2B0\n9219FA8FAF83376842B1B2AA9EF68D79DAAB89AF3FABE49A\nCC278638707345BBF15344ED79F7F4390EF8AC509B56F39A\n98566527A41D3CBD5E0558C159927DB0E88454A5D96471FD\nDCB56D5BB06BFA340EA7A151EF1CA6FA572B76F3B1B95D8C\n8583D3E4770536B84F017E70E6FBF176601A0266941A17B0\nC8B97F4E74C2C1FFC7278919777940C1E1FF1D8DA637D6B9\n9DDAFE5E17611002E2C778C1BE8B41D96379A51360D977FD\n4435A11C308FE7EE6F1AAD9DB28C81ADDE1A7A6F7CCE011C\n30DA37E4EB736483BD6C8E9348FBFBF72CC6587D60C36C8E\n577F0984C289C9385A098649DE21BCA27A7EA229716BA6E9\nB279710F38FAA5FFAE574155CE4EFB4F743695E2911B1D06\nD5E290CBCD86F56D0EDFCD216AE22427055E6835FD29EEF7\n9E0D90771FEACEBE12F20E95B34F0F78B737A9618B26FA7D\nBC9874F272C42BDB563EAFA16B4FB68C3BB1E78EAA81A002\n43FAADD2BF18E63D389AE44377DA18C576B50F0096CF3419\n5483B00548C0986236E3BC7CB8D6801C0494CCD199E5C5BD\n0D0EDC9EB8A0001E15276754FCC68566054148E6E764BEE7\nC764DAAD3FC45235A6DAD428FA20C170E345003F2F06EC81\n05FEB25B2281B63D2733BE961C29951D11DD2221657A9F53\n1DDA2A194DBB126448BDEEB258E07EA659C74619A6380E1D\n66D6832BFE67F638CD8FAE1F2723020F9C40A3FDA67EDA3B\nD29238FBD4D4B4885C2A99176DB1A06C500778491A8288F1\n855F60FFFCF1D1373FD94FC60C1811E1AC3F1C6D003BECDA\n3B1F2725CA595DE0CA63328F3BE57CC97755601195140DFB\n59D39CE091308B4105746DAC23D33E5F7CE4848DA316A9C6\n6B9581BA3573BFAF311496188AB15423282EE416DC2A19C5\n724FA91AE4ADC88BC66796EAE5677A01F64E8C0863139582\n2D9DB8FCEE35C06B1FEEA5474D6D8F34B1534A936A18B0E0\nD20EAB86BC9C6D6A5207194E67FA35551B5680267B00641C\n0F212D18ECA8D7327ED91FE764A84EA1B43FF5B4F6E8E62F\n05C661DEFB258877C35B18A151D5C414AAAD97BA3E499332\nE596078E600DEB81149C441CE95782F22A282563C5BAC141\n1423605D1AE1AFAE2C8B0660237EC128AA0FE3464E435811\n5DB84CC3B523073A28D4549884B81FF70E10BF361C137296\n28D5348F07211E7E4CF4F18B286090BDB1240B66D6CD4AFC\nEADC00CA446CE05050FF183AD2BBF118C1FC0EA51F97D22B\n8F7E46705D4527F45B42AEFF395853376F697DD5FDF2C518\n7D7D5F0E2EB8D43F17BA0F7C60FF437F535DFEF29833BF86\nCBE88EA4FBD4221E8411728354FA30A7008F154A41C7FC46\n6B4645DBE2E321267FFFFFFFFFFFFFFF")), BigIntegers.TWO, 400);
    private static final BigInteger modp2048p = BigIntegers.fromUnsignedByteArray(Hex.decode("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD1\n29024E088A67CC74020BBEA63B139B22514A08798E3404DD\nEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245\nE485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7ED\nEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3D\nC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F\n83655D23DCA3AD961C62F356208552BB9ED529077096966D\n670C354E4ABC9804F1746C08CA18217C32905E462E36CE3B\nE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9\nDE2BCBF6955817183995497CEA956AE515D2261898FA0510\n15728E5A8AACAA68FFFFFFFFFFFFFFFF"));
    private static final DHDomainParameters modp2048 = new DHDomainParameters(modp2048p, modp2048p.subtract(BigInteger.ONE).shiftRight(1), BigIntegers.TWO, 224);
    private static final BigInteger modp3072p = BigIntegers.fromUnsignedByteArray(Hex.decode("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD1\n29024E088A67CC74020BBEA63B139B22514A08798E3404DD\nEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245\nE485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7ED\nEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3D\nC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F\n83655D23DCA3AD961C62F356208552BB9ED529077096966D\n670C354E4ABC9804F1746C08CA18217C32905E462E36CE3B\nE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9\nDE2BCBF6955817183995497CEA956AE515D2261898FA0510\n15728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64\nECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7\nABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6B\nF12FFA06D98A0864D87602733EC86A64521F2B18177B200C\nBBE117577A615D6C770988C0BAD946E208E24FA074E5AB31\n43DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF"));
    private static final DHDomainParameters modp3072 = new DHDomainParameters(modp3072p, modp3072p.subtract(BigInteger.ONE).shiftRight(1), BigIntegers.TWO, 256);
    public static final BigInteger modp4096p = BigIntegers.fromUnsignedByteArray(Hex.decode("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD1\n29024E088A67CC74020BBEA63B139B22514A08798E3404DD\nEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245\nE485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7ED\nEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3D\nC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F\n83655D23DCA3AD961C62F356208552BB9ED529077096966D\n670C354E4ABC9804F1746C08CA18217C32905E462E36CE3B\nE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9\nDE2BCBF6955817183995497CEA956AE515D2261898FA0510\n15728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64\nECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7\nABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6B\nF12FFA06D98A0864D87602733EC86A64521F2B18177B200C\nBBE117577A615D6C770988C0BAD946E208E24FA074E5AB31\n43DB5BFCE0FD108E4B82D120A92108011A723C12A787E6D7\n88719A10BDBA5B2699C327186AF4E23C1A946834B6150BDA\n2583E9CA2AD44CE8DBBBC2DB04DE8EF92E8EFC141FBECAA6\n287C59474E6BC05D99B2964FA090C3A2233BA186515BE7ED\n1F612970CEE2D7AFB81BDD762170481CD0069127D5B05AA9\n93B4EA988D8FDDC186FFB7DC90A6C08F4DF435C934063199\nFFFFFFFFFFFFFFFF"));
    private static final DHDomainParameters modp4096 = new DHDomainParameters(modp4096p, modp4096p.subtract(BigInteger.ONE).shiftRight(1), BigIntegers.TWO, 304);
    public static final BigInteger modp6144p = BigIntegers.fromUnsignedByteArray(Hex.decode("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E08\n8A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B\n302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9\nA637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE6\n49286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8\nFD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D\n670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C\n180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF695581718\n3995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D\n04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7D\nB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D226\n1AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200C\nBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFC\nE0FD108E4B82D120A92108011A723C12A787E6D788719A10BDBA5B26\n99C327186AF4E23C1A946834B6150BDA2583E9CA2AD44CE8DBBBC2DB\n04DE8EF92E8EFC141FBECAA6287C59474E6BC05D99B2964FA090C3A2\n233BA186515BE7ED1F612970CEE2D7AFB81BDD762170481CD0069127\nD5B05AA993B4EA988D8FDDC186FFB7DC90A6C08F4DF435C934028492\n36C3FAB4D27C7026C1D4DCB2602646DEC9751E763DBA37BDF8FF9406\nAD9E530EE5DB382F413001AEB06A53ED9027D831179727B0865A8918\nDA3EDBEBCF9B14ED44CE6CBACED4BB1BDB7F1447E6CC254B33205151\n2BD7AF426FB8F401378CD2BF5983CA01C64B92ECF032EA15D1721D03\nF482D7CE6E74FEF6D55E702F46980C82B5A84031900B1C9E59E7C97F\nBEC7E8F323A97A7E36CC88BE0F1D45B7FF585AC54BD407B22B4154AA\nCC8F6D7EBF48E1D814CC5ED20F8037E0A79715EEF29BE32806A1D58B\nB7C5DA76F550AA3D8A1FBFF0EB19CCB1A313D55CDA56C9EC2EF29632\n387FE8D76E3C0468043E8F663F4860EE12BF2D5B0B7474D6E694F91E\n6DCC4024FFFFFFFFFFFFFFFF"));
    private static final DHDomainParameters modp6144 = new DHDomainParameters(modp6144p, modp6144p.subtract(BigInteger.ONE).shiftRight(1), BigIntegers.TWO, 352);
    private static final BigInteger modp8192p = BigIntegers.fromUnsignedByteArray(Hex.decode("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD1\n29024E088A67CC74020BBEA63B139B22514A08798E3404DD\nEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245\nE485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7ED\nEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3D\nC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F\n83655D23DCA3AD961C62F356208552BB9ED529077096966D\n670C354E4ABC9804F1746C08CA18217C32905E462E36CE3B\nE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9\nDE2BCBF6955817183995497CEA956AE515D2261898FA0510\n15728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64\nECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7\nABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6B\nF12FFA06D98A0864D87602733EC86A64521F2B18177B200C\nBBE117577A615D6C770988C0BAD946E208E24FA074E5AB31\n43DB5BFCE0FD108E4B82D120A92108011A723C12A787E6D7\n88719A10BDBA5B2699C327186AF4E23C1A946834B6150BDA\n2583E9CA2AD44CE8DBBBC2DB04DE8EF92E8EFC141FBECAA6\n287C59474E6BC05D99B2964FA090C3A2233BA186515BE7ED\n1F612970CEE2D7AFB81BDD762170481CD0069127D5B05AA9\n93B4EA988D8FDDC186FFB7DC90A6C08F4DF435C934028492\n36C3FAB4D27C7026C1D4DCB2602646DEC9751E763DBA37BD\nF8FF9406AD9E530EE5DB382F413001AEB06A53ED9027D831\n179727B0865A8918DA3EDBEBCF9B14ED44CE6CBACED4BB1B\nDB7F1447E6CC254B332051512BD7AF426FB8F401378CD2BF\n5983CA01C64B92ECF032EA15D1721D03F482D7CE6E74FEF6\nD55E702F46980C82B5A84031900B1C9E59E7C97FBEC7E8F3\n23A97A7E36CC88BE0F1D45B7FF585AC54BD407B22B4154AA\nCC8F6D7EBF48E1D814CC5ED20F8037E0A79715EEF29BE328\n06A1D58BB7C5DA76F550AA3D8A1FBFF0EB19CCB1A313D55C\nDA56C9EC2EF29632387FE8D76E3C0468043E8F663F4860EE\n12BF2D5B0B7474D6E694F91E6DBE115974A3926F12FEE5E4\n38777CB6A932DF8CD8BEC4D073B931BA3BC832B68D9DD300\n741FA7BF8AFC47ED2576F6936BA424663AAB639C5AE4F568\n3423B4742BF1C978238F16CBE39D652DE3FDB8BEFC848AD9\n22222E04A4037C0713EB57A81A23F0C73473FC646CEA306B\n4BCBC8862F8385DDFA9D4B7FA2C087E879683303ED5BDD3A\n062B3CF5B3A278A66D2A13F83F44F82DDF310EE074AB6A36\n4597E899A0255DC164F31CC50846851DF9AB48195DED7EA1\nB1D510BD7EE74D73FAF36BC31ECFA268359046F4EB879F92\n4009438B481C6CD7889A002ED5EE382BC9190DA6FC026E47\n9558E4475677E9AA9E3050E2765694DFC81F56E880B96E71\n60C980DD98EDD3DFFFFFFFFFFFFFFFFF"));
    private static final DHDomainParameters modp8192 = new DHDomainParameters(modp8192p, modp8192p.subtract(BigInteger.ONE).shiftRight(1), BigIntegers.TWO, 400);
    private static final Map<String, DHDomainParameters> params = new HashMap<String, DHDomainParameters>();

    public static DHDomainParameters lookupDomainParameters(DHDomainParametersID paramID) {
        return params.get(Strings.toLowerCase(paramID.getName()));
    }

    static {
        params.put("ffdhe2048", ffdhe2048);
        params.put("ffdhe3072", ffdhe3072);
        params.put("ffdhe4096", ffdhe4096);
        params.put("ffdhe6144", ffdhe6144);
        params.put("ffdhe8192", ffdhe8192);
        params.put("modp2048", modp2048);
        params.put("modp3072", modp3072);
        params.put("modp4096", modp4096);
        params.put("modp6144", modp6144);
        params.put("modp8192", modp8192);
    }
}

