/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;

public class Properties {
    public static boolean isOverrideSet(String propertyName) {
        try {
            return Properties.isSetTrue(Properties.getPropertyValue(propertyName));
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public static boolean isOverrideSetTo(String propertyName, boolean isTrue) {
        try {
            String propertyValue = Properties.getPropertyValue(propertyName);
            if (isTrue) {
                return Properties.isSetTrue(propertyValue);
            }
            return Properties.isSetFalse(propertyValue);
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public static int asInteger(String propertyName, int defaultValue) {
        String p = Properties.getPropertyValue(propertyName);
        if (p != null) {
            return Integer.parseInt(p);
        }
        return defaultValue;
    }

    public static String getPropertyValue(final String propertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String v = Security.getProperty(propertyName);
                if (v != null) {
                    return v;
                }
                return System.getProperty(propertyName);
            }
        });
    }

    public static String getPropertyValue(final String propertyName, final String alternative) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String v = Security.getProperty(propertyName);
                if (v != null) {
                    return v;
                }
                v = System.getProperty(propertyName);
                if (v != null) {
                    return v;
                }
                return alternative;
            }
        });
    }

    private static boolean isSetFalse(String p) {
        if (p == null || p.length() != 5) {
            return false;
        }
        return !(p.charAt(0) != 'f' && p.charAt(0) != 'F' || p.charAt(1) != 'a' && p.charAt(1) != 'A' || p.charAt(2) != 'l' && p.charAt(2) != 'L' || p.charAt(3) != 's' && p.charAt(3) != 'S' || p.charAt(4) != 'e' && p.charAt(4) != 'E');
    }

    private static boolean isSetTrue(String p) {
        if (p == null || p.length() != 4) {
            return false;
        }
        return !(p.charAt(0) != 't' && p.charAt(0) != 'T' || p.charAt(1) != 'r' && p.charAt(1) != 'R' || p.charAt(2) != 'u' && p.charAt(2) != 'U' || p.charAt(3) != 'e' && p.charAt(3) != 'E');
    }
}

