/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPrivateKey;
import org.bouncycastle.jcajce.provider.DHUtils;
import org.bouncycastle.jcajce.provider.KeyUtil;

class ProvDHPrivateKey
implements Destroyable,
DHPrivateKey {
    static final long serialVersionUID = 311058815616901812L;
    private transient AsymmetricDHPrivateKey baseKey;

    ProvDHPrivateKey(Algorithm algorithm, DHPrivateKey key) {
        this.baseKey = new AsymmetricDHPrivateKey(algorithm, DHUtils.extractParams(key.getParams()), key.getX());
    }

    ProvDHPrivateKey(Algorithm algorithm, DHPrivateKeySpec keySpec) {
        this.baseKey = new AsymmetricDHPrivateKey(algorithm, DHUtils.extractParams(keySpec), keySpec.getX());
    }

    ProvDHPrivateKey(AsymmetricDHPrivateKey key) {
        this.baseKey = key;
    }

    @Override
    public String getAlgorithm() {
        KeyUtil.checkDestroyed(this);
        return "DH";
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    @Override
    public DHParameterSpec getParams() {
        return DHUtils.convertParams(this.baseKey.getDomainParameters());
    }

    @Override
    public BigInteger getX() {
        return this.baseKey.getX();
    }

    AsymmetricDHPrivateKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("DH");
        }
        try {
            return KeyUtil.privateKeyToString("DH", this.baseKey.getX(), this.baseKey.getDomainParameters());
        }
        catch (Exception e) {
            return KeyUtil.restrictedToString("DH");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvDHPrivateKey)) {
            return false;
        }
        ProvDHPrivateKey other = (ProvDHPrivateKey)o;
        return this.baseKey.equals(other.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Algorithm alg = (Algorithm)in.readObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricDHPrivateKey(alg, enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        out.defaultWriteObject();
        out.writeObject(this.baseKey.getAlgorithm());
        out.writeObject(this.getEncoded());
    }
}

