/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.crypto.AEADOperatorFactory;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.OutputAEADDecryptor;
import org.bouncycastle.crypto.OutputAEADEncryptor;
import org.bouncycastle.crypto.OutputCipher;
import org.bouncycastle.crypto.OutputDecryptor;
import org.bouncycastle.crypto.OutputEncryptor;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricOperatorFactory;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsAEADOperatorFactory;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsSymmetricOperatorFactory;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.internal.asn1.cms.GCMParameters;
import org.bouncycastle.jcajce.PBKDF1Key;
import org.bouncycastle.jcajce.PBKDF2Key;
import org.bouncycastle.jcajce.PBKDFKey;
import org.bouncycastle.jcajce.PKCS12Key;
import org.bouncycastle.jcajce.provider.BaseWrapCipher;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.ClassUtil;
import org.bouncycastle.jcajce.provider.PBEScheme;
import org.bouncycastle.jcajce.provider.PBKDFPBEKey;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF1;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF2;
import org.bouncycastle.jcajce.provider.ProvPKCS12;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.WrappedByteArrayOutputStream;

class BaseCipher
extends CipherSpi {
    private static final Logger LOG = Logger.getLogger(BaseCipher.class.getName());
    private static final int BUF_SIZE = 1024;
    private final BouncyCastleFipsProvider fipsProvider;
    private final FipsSymmetricOperatorFactory fipsFactory;
    private final SymmetricOperatorFactory generalFactory;
    private final FipsAEADOperatorFactory fipsAeadFactory;
    private final AEADOperatorFactory generalAeadFactory;
    private final int blockSizeInBits;
    private final int keySizeInBits;
    private final DigestAlgorithm prf;
    private final Class[] fipsAvailableSpecs;
    private final Class[] generalAvailableSpecs;
    private final ParametersCreatorProvider<FipsParameters> fipsParametersProvider;
    private final ParametersCreatorProvider<Parameters> generalParametersProvider;
    private final Algorithm[] algorithms;
    private final Map<Algorithm, Parameters> baseParametersMap;
    private final PBEScheme scheme;
    private Set<Algorithm> activeAlgorithmSet = new HashSet<Algorithm>();
    private PBEParameterSpec pbeSpec = null;
    private String pbeAlgorithm = null;
    private AlgorithmParameters engineParams = null;
    private String modeName = null;
    private OutputCipher<Parameters> cipher;
    private OutputEncryptor<Parameters> encryptor;
    private OutputDecryptor<Parameters> decryptor;
    private UpdateOutputStream aadStream;
    private UpdateOutputStream processingStream;
    private WrappedByteArrayOutputStream resultStream = new WrappedByteArrayOutputStream();
    private byte[] associatedData = null;

    private BaseCipher(BouncyCastleFipsProvider fipsProvider, int blockSizeInBits, int keySizeInBits, DigestAlgorithm prf, PBEScheme scheme, FipsSymmetricOperatorFactory fipsFactory, SymmetricOperatorFactory generalFactory, FipsAEADOperatorFactory fipsAeadFactory, AEADOperatorFactory generalAeadFactory, Class[] availableSpecs, ParametersCreatorProvider fipsParametersCreatorProvider, ParametersCreatorProvider generalParametersCreatorProvider, Map<Algorithm, Parameters> baseParametersMap, Algorithm ... algorithms) {
        this.fipsProvider = fipsProvider;
        this.keySizeInBits = keySizeInBits;
        this.prf = prf;
        this.scheme = scheme;
        this.fipsFactory = fipsFactory;
        this.generalFactory = generalFactory;
        this.fipsAeadFactory = fipsAeadFactory;
        this.generalAeadFactory = generalAeadFactory;
        this.blockSizeInBits = blockSizeInBits;
        this.fipsAvailableSpecs = availableSpecs;
        this.generalAvailableSpecs = availableSpecs;
        this.fipsParametersProvider = fipsParametersCreatorProvider;
        this.generalParametersProvider = generalParametersCreatorProvider;
        this.baseParametersMap = baseParametersMap;
        this.algorithms = algorithms;
        this.activeAlgorithmSet.addAll(java.util.Arrays.asList(algorithms));
    }

    @Override
    protected int engineGetBlockSize() {
        return (this.blockSizeInBits + 7) / 8;
    }

    @Override
    protected byte[] engineGetIV() {
        Parameters params = this.cipher.getParameters();
        if (params instanceof ParametersWithIV) {
            return ((ParametersWithIV)params).getIV();
        }
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.cipher.getMaxOutputSize(inputLen);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.cipher != null) {
            ParametersWithIV ivParams;
            Parameters params = this.cipher.getParameters();
            String name = Utils.getBaseName(params.getAlgorithm());
            if (params instanceof AuthenticationParametersWithIV) {
                try {
                    AuthenticationParametersWithIV authParams = (AuthenticationParametersWithIV)params;
                    this.engineParams = AlgorithmParameters.getInstance(name, this.fipsProvider);
                    this.engineParams.init(new GCMParameters(authParams.getIV(), authParams.getMACSizeInBits() / 8).getEncoded());
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.toString(), e);
                }
            }
            if (params instanceof ParametersWithIV && (ivParams = (ParametersWithIV)params).getIV() != null) {
                try {
                    this.engineParams = AlgorithmParameters.getInstance(name, this.fipsProvider);
                    this.engineParams.init(new DEROctetString(ivParams.getIV()).getEncoded());
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.toString(), e);
                }
            }
            if (this.pbeSpec != null) {
                try {
                    this.engineParams = AlgorithmParameters.getInstance(this.pbeAlgorithm, this.fipsProvider);
                    this.engineParams.init(this.pbeSpec);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        String modeMatch1;
        String modeMatch2;
        this.modeName = Strings.toUpperCase(mode);
        if (this.modeName.equals("CTS")) {
            this.modeName = "CBC/CS3";
        }
        if (this.modeName.equals("SIC")) {
            modeMatch2 = "/CTR";
            modeMatch1 = "/CTR/";
        } else if (this.modeName.equals("CFB") || this.modeName.equals("OFB")) {
            modeMatch2 = "/" + this.modeName + Integer.toString(this.blockSizeInBits);
            modeMatch1 = "/" + this.modeName + Integer.toString(this.blockSizeInBits) + "/";
        } else {
            modeMatch2 = "/" + this.modeName;
            modeMatch1 = "/" + this.modeName + "/";
        }
        HashSet<Algorithm> currentAlgs = new HashSet<Algorithm>(this.activeAlgorithmSet);
        this.activeAlgorithmSet.clear();
        for (Algorithm alg : currentAlgs) {
            if (!alg.getName().endsWith(modeMatch2) && !alg.getName().contains(modeMatch1)) continue;
            this.activeAlgorithmSet.add(alg);
        }
        if (this.activeAlgorithmSet.isEmpty()) {
            throw new NoSuchAlgorithmException(this.modeName + " not found");
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        String paddingName = Strings.toUpperCase(padding);
        HashSet<Algorithm> currentAlgs = new HashSet<Algorithm>(this.activeAlgorithmSet);
        this.activeAlgorithmSet.clear();
        if (paddingName.equals("NOPADDING")) {
            for (Algorithm alg : currentAlgs) {
                if (alg.getName().indexOf(47) != alg.getName().lastIndexOf(47)) continue;
                this.activeAlgorithmSet.add(alg);
            }
            if (this.activeAlgorithmSet.isEmpty() && currentAlgs.size() == 1) {
                for (Algorithm alg : currentAlgs) {
                    if (!alg.getName().endsWith("CS3")) continue;
                    this.activeAlgorithmSet.add(alg);
                }
            }
        } else if (paddingName.equals("PKCS5PADDING") || paddingName.equals("PKCS7PADDING")) {
            for (Algorithm alg : currentAlgs) {
                if (!alg.getName().endsWith("PKCS7")) continue;
                this.activeAlgorithmSet.add(alg);
            }
        } else if (paddingName.equals("ISO10126PADDING") || paddingName.equals("ISO10126-2PADDING")) {
            for (Algorithm alg : currentAlgs) {
                if (!alg.getName().endsWith("ISO10126-2")) continue;
                this.activeAlgorithmSet.add(alg);
            }
        } else if (paddingName.equals("X9.23PADDING") || paddingName.equals("X923PADDING")) {
            for (Algorithm alg : currentAlgs) {
                if (!alg.getName().endsWith("X9.23")) continue;
                this.activeAlgorithmSet.add(alg);
            }
        } else if (paddingName.equals("ISO7816-4PADDING") || paddingName.equals("ISO9797-1PADDING")) {
            for (Algorithm alg : currentAlgs) {
                if (!alg.getName().endsWith("ISO7816-4")) continue;
                this.activeAlgorithmSet.add(alg);
            }
        } else if (paddingName.equals("TBCPADDING")) {
            for (Algorithm alg : currentAlgs) {
                if (!alg.getName().endsWith("TBC")) continue;
                this.activeAlgorithmSet.add(alg);
            }
        } else if (paddingName.equals("CTSPADDING") || paddingName.equals("CS3PADDING")) {
            for (Algorithm alg : currentAlgs) {
                if (!alg.getName().endsWith("CS3")) continue;
                this.activeAlgorithmSet.add(alg);
            }
        } else if (paddingName.equals("CS1PADDING")) {
            for (Algorithm alg : currentAlgs) {
                if (!alg.getName().endsWith("CS1")) continue;
                this.activeAlgorithmSet.add(alg);
            }
        } else if (paddingName.equals("CS2PADDING")) {
            for (Algorithm alg : currentAlgs) {
                if (!alg.getName().endsWith("CS2")) continue;
                this.activeAlgorithmSet.add(alg);
            }
        } else {
            throw new NoSuchPaddingException("Padding " + padding + " unknown");
        }
        if (this.activeAlgorithmSet.isEmpty()) {
            throw new NoSuchPaddingException(paddingName + " not found");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.doEngineInit(opmode, key, params, random, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doEngineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random, boolean originatesInModule) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object parameters;
        boolean forEncryption;
        AEADOperatorFactory aeadOperatorFactory;
        SymmetricOperatorFactory operatorFactory;
        ParametersCreator parametersCreator;
        Algorithm alg;
        this.pbeAlgorithm = null;
        this.engineParams = null;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key for algorithm " + key.getAlgorithm() + " not suitable for symmetric enryption.");
        }
        if (random == null) {
            random = this.fipsProvider.getDefaultSecureRandom();
        }
        if ((alg = this.getAlgorithm()) instanceof FipsAlgorithm) {
            if (opmode == 1 && params != null && alg.equals(FipsAES.GCM.getAlgorithm())) {
                if (!originatesInModule) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Passed in GCM nonce detected" + this.getNonceAsHexString(params));
                    }
                } else if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("GCM nonce detected" + this.getNonceAsHexString(params));
                }
            }
            parametersCreator = this.fipsParametersProvider.get((FipsParameters)this.baseParametersMap.get(alg));
            operatorFactory = this.fipsFactory;
            aeadOperatorFactory = this.fipsAeadFactory;
        } else {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Cipher cannot be used in approved mode");
            }
            parametersCreator = this.generalParametersProvider.get(this.baseParametersMap.get(alg));
            operatorFactory = this.generalFactory;
            aeadOperatorFactory = this.generalAeadFactory;
        }
        switch (opmode) {
            case 1: 
            case 3: {
                forEncryption = true;
                break;
            }
            case 2: 
            case 4: {
                forEncryption = false;
                break;
            }
            default: {
                throw new InvalidParameterException("unknown opmode " + opmode + " passed");
            }
        }
        if (key instanceof PBEKey && !(key instanceof PBKDFPBEKey) || this.scheme != null || params instanceof PBEParameterSpec) {
            SecretKey pbeKey;
            PBEParameterSpec spec;
            if (params instanceof PBEParameterSpec) {
                this.pbeSpec = spec = (PBEParameterSpec)params;
            } else if (key instanceof PBEKey) {
                pbeKey = (PBEKey)key;
                this.pbeSpec = spec = new PBEParameterSpec(pbeKey.getSalt(), pbeKey.getIterationCount());
            } else {
                if (key instanceof PBEKey) throw new InvalidAlgorithmParameterException("No algorithm parameters provided when required");
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            try {
                pbeKey = (SecretKey)key;
            }
            catch (Exception e) {
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            if (this.keySizeInBits == 0) {
                throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: cannot use PBE with variable key size");
            }
            if (key instanceof PBKDF2Key || this.scheme == PBEScheme.PBKDF2) {
                this.pbeAlgorithm = "PBKDF2";
                key = new SecretKeySpec(ProvPBEPBKDF2.getSecretKey(pbeKey, spec, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits), alg.getName());
                try {
                    if (alg.requiresAlgorithmParameters()) {
                        if (params == null) {
                            throw new InvalidKeyException("No algorithm parameters provided when required");
                        }
                        parameters = parametersCreator.createParameters(forEncryption, params, random);
                    }
                    parameters = parametersCreator.createParameters(forEncryption, null, random);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + e.getMessage(), e);
                }
            } else if (key instanceof PBKDF1Key || this.scheme == PBEScheme.PBKDF1) {
                this.pbeAlgorithm = "PBKDF1";
                if (alg.requiresAlgorithmParameters()) {
                    byte[][] kAndIv = ProvPBEPBKDF1.getSecretKeyAndIV(pbeKey, spec, this.prf, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits, this.blockSizeInBits);
                    key = new SecretKeySpec(kAndIv[0], alg.getName());
                    try {
                        parameters = parametersCreator.createParameters(forEncryption, params != null && !(params instanceof PBEParameterSpec) ? params : new IvParameterSpec(kAndIv[1]), random);
                    }
                    catch (IllegalArgumentException e) {
                        throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + e.getMessage(), e);
                    }
                } else {
                    key = new SecretKeySpec(ProvPBEPBKDF1.getSecretKey(pbeKey, spec, this.prf, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits), alg.getName());
                    try {
                        parameters = parametersCreator.createParameters(forEncryption, null, random);
                    }
                    catch (IllegalArgumentException e) {
                        throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + e.getMessage(), e);
                    }
                }
            } else {
                if (!(key instanceof PKCS12Key) && this.scheme != PBEScheme.PKCS12) throw new InvalidKeyException("Unable to use passed in key for PBE");
                this.pbeAlgorithm = "PBKDF-PKCS12";
                if (alg.requiresAlgorithmParameters()) {
                    byte[][] kAndIv = ProvPKCS12.getSecretKeyAndIV(pbeKey, this.prf, spec, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits, this.blockSizeInBits);
                    key = new SecretKeySpec(kAndIv[0], alg.getName());
                    try {
                        parameters = parametersCreator.createParameters(forEncryption, params != null && !(params instanceof PBEParameterSpec) ? params : new IvParameterSpec(kAndIv[1]), random);
                    }
                    catch (IllegalArgumentException e) {
                        throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + e.getMessage(), e);
                    }
                } else {
                    key = new SecretKeySpec(ProvPKCS12.getSecretKey(pbeKey, spec, PasswordBasedDeriver.KeyType.CIPHER, this.keySizeInBits), alg.getName());
                    try {
                        parameters = parametersCreator.createParameters(forEncryption, null, random);
                    }
                    catch (IllegalArgumentException e) {
                        throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + e.getMessage(), e);
                    }
                }
            }
        } else {
            if (key instanceof PBKDFKey) {
                throw new InvalidKeyException("PBE key requires a PBEParameterSpec");
            }
            if (!forEncryption && alg.requiresAlgorithmParameters() && params == null) {
                throw new InvalidAlgorithmParameterException("No algorithm parameters provided when required");
            }
            try {
                parameters = parametersCreator.createParameters(forEncryption, params, random);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + e.getMessage(), e);
            }
        }
        try {
            SymmetricKey symmetricKey = Utils.convertKey(alg, key);
            if (this.keySizeInBits != 0 && Utils.keyNotLength(symmetricKey, this.keySizeInBits)) {
                throw new InvalidKeyException("Cipher requires key of size " + this.keySizeInBits + " bits");
            }
            if (BaseCipher.isAEADMode(alg)) {
                if (forEncryption) {
                    this.cipher = this.encryptor = (OutputEncryptor)Utils.addRandomIfNeeded(aeadOperatorFactory.createOutputAEADEncryptor(symmetricKey, parameters), random);
                    this.processingStream = this.encryptor.getEncryptingStream(this.resultStream);
                    this.aadStream = ((OutputAEADEncryptor)this.encryptor).getAADStream();
                } else {
                    this.cipher = this.decryptor = (OutputDecryptor)Utils.addRandomIfNeeded(aeadOperatorFactory.createOutputAEADDecryptor(symmetricKey, parameters), random);
                    this.processingStream = this.decryptor.getDecryptingStream(this.resultStream);
                    this.aadStream = ((OutputAEADDecryptor)this.decryptor).getAADStream();
                }
                if (!(params instanceof AEADParameterSpec)) return;
                this.associatedData = ((AEADParameterSpec)params).getAssociatedData();
                if (this.associatedData == null) return;
                this.aadStream.update(this.associatedData);
                return;
            } else if (forEncryption) {
                this.encryptor = Utils.addRandomIfNeeded(operatorFactory.createOutputEncryptor(symmetricKey, parameters), random);
                this.cipher = this.encryptor;
                this.processingStream = this.encryptor.getEncryptingStream(this.resultStream);
                this.aadStream = null;
                return;
            } else {
                this.decryptor = Utils.addRandomIfNeeded(operatorFactory.createOutputDecryptor(symmetricKey, parameters), random);
                this.cipher = this.decryptor;
                this.processingStream = this.decryptor.getDecryptingStream(this.resultStream);
                this.aadStream = null;
            }
            return;
        }
        catch (InvalidParameterException e) {
            throw e;
        }
        catch (InvalidKeyException e) {
            throw e;
        }
        catch (IllegalKeyException e) {
            throw new InvalidKeyException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAlgorithmParameterException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.getMessage(), e);
        }
    }

    private String getNonceAsHexString(AlgorithmParameterSpec params) {
        byte[] nonce = null;
        if (params instanceof IvParameterSpec) {
            nonce = ((IvParameterSpec)params).getIV();
        } else if (params instanceof GCMParameterSpec) {
            nonce = ((GCMParameterSpec)params).getIV();
        }
        return nonce != null ? ": " + Hex.toHexString(nonce) : "";
    }

    private Algorithm getAlgorithm() {
        Algorithm alg = this.activeAlgorithmSet.size() == 1 ? this.activeAlgorithmSet.iterator().next() : this.algorithms[0];
        return alg;
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec paramSpec = null;
        boolean originatesInModule = false;
        if (params != null) {
            Class[] availableSpecs = this.getAlgorithm() instanceof FipsAlgorithm ? this.fipsAvailableSpecs : this.generalAvailableSpecs;
            originatesInModule = params.getProvider() instanceof BouncyCastleFipsProvider;
            for (int i = 0; i != availableSpecs.length; ++i) {
                if (availableSpecs[i] == null) continue;
                try {
                    paramSpec = (AlgorithmParameterSpec)params.getParameterSpec(availableSpecs[i]);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (paramSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + params.toString());
            }
        }
        this.doEngineInit(opmode, key, paramSpec, random, originatesInModule);
        this.engineParams = params;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage(), e);
        }
    }

    @Override
    protected void engineUpdateAAD(byte[] input, int offset, int length) {
        this.aadStream.update(input, offset, length);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer src) {
        int remaining = src.remaining();
        if (remaining >= 1) {
            if (src.hasArray()) {
                this.engineUpdateAAD(src.array(), src.arrayOffset() + src.position(), remaining);
                src.position(src.limit());
            } else if (remaining <= 1024) {
                byte[] data = new byte[remaining];
                src.get(data);
                this.engineUpdateAAD(data, 0, data.length);
                Arrays.clear(data);
            } else {
                int length;
                byte[] data = new byte[1024];
                do {
                    length = Math.min(data.length, remaining);
                    src.get(data, 0, length);
                    this.engineUpdateAAD(data, 0, length);
                } while ((remaining -= length) > 0);
                Arrays.clear(data);
            }
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        byte[] out = new byte[this.cipher.getUpdateOutputSize(inputLen)];
        this.resultStream.setBuffer(out);
        this.processingStream.update(input, inputOffset, inputLen);
        if (this.resultStream.size() > 0) {
            byte[] result = this.resultStream.toTrimmedByteArray();
            if (this.cipher == this.decryptor) {
                this.resultStream.erase();
            }
            return result;
        }
        return null;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (outputOffset + this.cipher.getUpdateOutputSize(inputLen) > output.length) {
            throw new ShortBufferException("Output buffer too short for input.");
        }
        this.resultStream.setBuffer(output, outputOffset);
        if (inputLen != 0) {
            this.processingStream.update(input, inputOffset, inputLen);
        }
        return this.resultStream.size();
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        try {
            byte[] out = new byte[this.cipher.getMaxOutputSize(inputLen)];
            this.resultStream.setBuffer(out);
            if (inputLen != 0) {
                this.processingStream.update(input, inputOffset, inputLen);
            }
            this.processingStream.close();
        }
        catch (IOException e) {
            if (this.cipher.getParameters() instanceof AuthenticationParametersWithIV) {
                ClassUtil.throwBadTagException(e.getMessage());
            }
            throw new BadPaddingException(e.getMessage());
        }
        byte[] result = this.resultStream.toTrimmedByteArray();
        if (this.cipher == this.decryptor) {
            this.resultStream.erase();
        }
        if (this.associatedData != null) {
            this.aadStream.update(this.associatedData);
        }
        return result;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (outputOffset + this.engineGetOutputSize(inputLen) > output.length) {
            throw new ShortBufferException("Output buffer too short for input.");
        }
        try {
            this.resultStream.setBuffer(output, outputOffset);
            if (inputLen != 0) {
                this.processingStream.update(input, inputOffset, inputLen);
            }
            this.processingStream.close();
            int size = this.resultStream.size();
            if (this.associatedData != null) {
                this.aadStream.update(this.associatedData);
            }
            return size;
        }
        catch (IOException e) {
            if (this.cipher.getParameters() instanceof AuthenticationParametersWithIV) {
                ClassUtil.throwBadTagException(e.getMessage());
            }
            throw new BadPaddingException(e.getMessage());
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] encoded = key.getEncoded();
        if (encoded == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding.");
        }
        try {
            return this.engineDoFinal(encoded, 0, encoded.length);
        }
        catch (BadPaddingException e) {
            throw new IllegalBlockSizeException(e.getMessage());
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encoded;
        try {
            encoded = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidKeyException(e.getMessage());
        }
        return BaseWrapCipher.rebuildKey(wrappedKeyAlgorithm, wrappedKeyType, encoded, this.fipsProvider);
    }

    private static boolean isAEADMode(Algorithm algorithm) {
        String name = algorithm.getName();
        return name.contains("Poly1305") || name.contains("/CCM") || name.contains("/EAX") || name.contains("/GCM") || name.contains("/OCB");
    }

    static class Builder {
        private final BouncyCastleFipsProvider fipsProvider;
        private final int blockSize;
        private final Algorithm[] algorithms;
        private final Map<Algorithm, Parameters> baseParametersMap;
        private FipsSymmetricOperatorFactory fipsFactory;
        private SymmetricOperatorFactory generalFactory;
        private FipsAEADOperatorFactory fipsAeadFactory;
        private AEADOperatorFactory generalAeadFactory;
        private Class[] availableSpecs;
        private int keySizeInBits;
        private ParametersCreatorProvider fipsParametersProvider;
        private ParametersCreatorProvider generalParametersProvider;
        private DigestAlgorithm prf = FipsSHS.Algorithm.SHA1;
        private PBEScheme scheme;

        Builder(BouncyCastleFipsProvider fipsProvider, int blockSize, Parameters ... parameters) {
            this.fipsProvider = fipsProvider;
            this.blockSize = blockSize;
            this.baseParametersMap = new HashMap<Algorithm, Parameters>(parameters.length);
            this.algorithms = new Algorithm[parameters.length];
            for (int i = 0; i != parameters.length; ++i) {
                this.baseParametersMap.put(parameters[i].getAlgorithm(), parameters[i]);
                this.algorithms[i] = parameters[i].getAlgorithm();
            }
        }

        Builder withFixedKeySize(int keySizeInBits) {
            this.keySizeInBits = keySizeInBits;
            return this;
        }

        Builder withFipsOperators(ParametersCreatorProvider fipsParametersProvider, FipsSymmetricOperatorFactory fipsFactory) {
            this.fipsParametersProvider = fipsParametersProvider;
            this.fipsFactory = fipsFactory;
            return this;
        }

        Builder withFipsOperators(ParametersCreatorProvider fipsParametersProvider, FipsSymmetricOperatorFactory fipsFactory, FipsAEADOperatorFactory fipsAeadFactory) {
            this.fipsParametersProvider = fipsParametersProvider;
            this.fipsFactory = fipsFactory;
            this.fipsAeadFactory = fipsAeadFactory;
            return this;
        }

        Builder withGeneralOperators(ParametersCreatorProvider generalParametersProvider, SymmetricOperatorFactory generalFactory, AEADOperatorFactory generalAeadFactory) {
            this.generalParametersProvider = generalParametersProvider;
            this.generalFactory = generalFactory;
            this.generalAeadFactory = generalAeadFactory;
            return this;
        }

        Builder withScheme(PBEScheme scheme) {
            this.scheme = scheme;
            return this;
        }

        Builder withPrf(DigestAlgorithm prf) {
            this.prf = prf;
            return this;
        }

        Builder withParameters(Class[] availableSpecs) {
            this.availableSpecs = availableSpecs;
            return this;
        }

        BaseCipher build() {
            boolean isInApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
            if (!isInApprovedMode) {
                return new BaseCipher(this.fipsProvider, this.blockSize, this.keySizeInBits, this.prf, this.scheme, this.fipsFactory, this.generalFactory, this.fipsAeadFactory, this.generalAeadFactory, this.availableSpecs, this.fipsParametersProvider, this.generalParametersProvider, (Map)this.baseParametersMap, this.algorithms);
            }
            Set<Algorithm> activeSet = Utils.getActiveSet(this.algorithms);
            if (activeSet.isEmpty()) {
                return null;
            }
            return new BaseCipher(this.fipsProvider, this.blockSize, this.keySizeInBits, this.prf, this.scheme, this.fipsFactory, this.generalFactory, this.fipsAeadFactory, this.generalAeadFactory, this.availableSpecs, this.fipsParametersProvider, this.generalParametersProvider, (Map)this.baseParametersMap, activeSet.toArray(new Algorithm[activeSet.size()]));
        }
    }
}

