/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.crypto.util.DerUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public final class ByteMacData {
    private final byte[] macData;

    private ByteMacData(byte[] macData) {
        this.macData = macData;
    }

    public byte[] getMacData() {
        return Arrays.clone(this.macData);
    }

    public static final class Builder {
        private final Type type;
        private byte[] idU;
        private byte[] idV;
        private byte[] ephemDataU;
        private byte[] ephemDataV;
        private byte[] text;

        public Builder(Type type, byte[] idU, byte[] idV, byte[] ephemDataU, byte[] ephemDataV) {
            this.type = type;
            this.idU = Arrays.clone(idU);
            this.idV = Arrays.clone(idV);
            this.ephemDataU = Arrays.clone(ephemDataU);
            this.ephemDataV = Arrays.clone(ephemDataV);
        }

        public Builder withText(byte[] text) {
            this.text = DerUtil.toByteArray(new DERTaggedObject(false, 0, DerUtil.getOctetString(text)));
            return this;
        }

        public ByteMacData build() {
            switch (this.type) {
                case UNILATERALU: 
                case BILATERALU: {
                    return new ByteMacData(this.concatenate(this.type.getHeader(), this.idU, this.idV, this.ephemDataU, this.ephemDataV, this.text));
                }
                case UNILATERALV: 
                case BILATERALV: {
                    return new ByteMacData(this.concatenate(this.type.getHeader(), this.idV, this.idU, this.ephemDataV, this.ephemDataU, this.text));
                }
            }
            throw new IllegalStateException("Unknown type encountered in build");
        }

        private byte[] concatenate(byte[] header, byte[] id1, byte[] id2, byte[] ed1, byte[] ed2, byte[] text) {
            return Arrays.concatenate(Arrays.concatenate(header, id1, id2), Arrays.concatenate(ed1, ed2, text));
        }
    }

    public static enum Type {
        UNILATERALU("KC_1_U"),
        UNILATERALV("KC_1_V"),
        BILATERALU("KC_2_U"),
        BILATERALV("KC_2_V");

        private final String enc;

        private Type(String enc) {
            this.enc = enc;
        }

        public byte[] getHeader() {
            return Strings.toByteArray(this.enc);
        }
    }
}

