/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.pqc.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.pqc.lms.Composer;
import org.bouncycastle.crypto.internal.pqc.lms.LMOtsParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMOtsSignature;
import org.bouncycastle.crypto.internal.pqc.lms.LMSContext;
import org.bouncycastle.crypto.internal.pqc.lms.LMSSignature;
import org.bouncycastle.crypto.internal.pqc.lms.LmsDigestUtil;
import org.bouncycastle.crypto.internal.pqc.lms.LmsUtils;
import org.bouncycastle.util.Encodable;
import org.bouncycastle.util.io.Streams;

class LMOtsPublicKey
implements Encodable {
    private final LMOtsParameters parameter;
    private final byte[] I;
    private final int q;
    private final byte[] K;

    public LMOtsPublicKey(LMOtsParameters parameter, byte[] i, int q, byte[] k) {
        this.parameter = parameter;
        this.I = i;
        this.q = q;
        this.K = k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LMOtsPublicKey getInstance(Object src) throws Exception {
        if (src instanceof LMOtsPublicKey) {
            return (LMOtsPublicKey)src;
        }
        if (src instanceof DataInputStream) {
            LMOtsParameters parameter = LMOtsParameters.getParametersForType(((DataInputStream)src).readInt());
            byte[] I = new byte[16];
            ((DataInputStream)src).readFully(I);
            int q = ((DataInputStream)src).readInt();
            byte[] K = new byte[parameter.getN()];
            ((DataInputStream)src).readFully(K);
            return new LMOtsPublicKey(parameter, I, q, K);
        }
        if (src instanceof byte[]) {
            try (InputStream in = null;){
                in = new DataInputStream(new ByteArrayInputStream((byte[])src));
                LMOtsPublicKey lMOtsPublicKey = LMOtsPublicKey.getInstance(in);
                return lMOtsPublicKey;
            }
        }
        if (src instanceof InputStream) {
            return LMOtsPublicKey.getInstance(Streams.readAll((InputStream)src));
        }
        throw new IllegalArgumentException("cannot parse " + src);
    }

    public LMOtsParameters getParameter() {
        return this.parameter;
    }

    public byte[] getI() {
        return this.I;
    }

    public int getQ() {
        return this.q;
    }

    public byte[] getK() {
        return this.K;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LMOtsPublicKey that = (LMOtsPublicKey)o;
        if (this.q != that.q) {
            return false;
        }
        if (this.parameter != null ? !this.parameter.equals(that.parameter) : that.parameter != null) {
            return false;
        }
        if (!Arrays.equals(this.I, that.I)) {
            return false;
        }
        return Arrays.equals(this.K, that.K);
    }

    public int hashCode() {
        int result = this.parameter != null ? this.parameter.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.I);
        result = 31 * result + this.q;
        result = 31 * result + Arrays.hashCode(this.K);
        return result;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(this.parameter.getType()).bytes(this.I).u32str(this.q).bytes(this.K).build();
    }

    LMSContext createOtsContext(LMOtsSignature signature) {
        Digest ctx = LmsDigestUtil.getDigest(this.parameter);
        LmsUtils.byteArray(this.I, ctx);
        LmsUtils.u32str(this.q, ctx);
        LmsUtils.u16str((short)-32383, ctx);
        LmsUtils.byteArray(signature.getC(), ctx);
        return new LMSContext(this, signature, ctx);
    }

    LMSContext createOtsContext(LMSSignature signature) {
        Digest ctx = LmsDigestUtil.getDigest(this.parameter);
        LmsUtils.byteArray(this.I, ctx);
        LmsUtils.u32str(this.q, ctx);
        LmsUtils.u16str((short)-32383, ctx);
        LmsUtils.byteArray(signature.getOtsSignature().getC(), ctx);
        return new LMSContext(this, signature, ctx);
    }
}

