/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.general.CipherKeyGenerator;
import org.bouncycastle.crypto.general.CipherUtils;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralAuthParameters;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedAEADOperatorFactory;
import org.bouncycastle.crypto.general.GuardedKeyWrapOperatorFactory;
import org.bouncycastle.crypto.general.GuardedMACOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.GuardedSymmetricOperatorFactory;
import org.bouncycastle.crypto.general.Mode;
import org.bouncycastle.crypto.general.Padding;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.RC2Engine;
import org.bouncycastle.crypto.general.RC2Parameters;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.general.VariantKatTest;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public final class RC2 {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("RC2");
    private static final EngineProvider ENGINE_PROVIDER;
    public static final Parameters ECB;
    public static final Parameters ECBwithPKCS7;
    public static final Parameters ECBwithISO10126_2;
    public static final Parameters ECBwithX923;
    public static final Parameters ECBwithISO7816_4;
    public static final Parameters ECBwithTBC;
    public static final Parameters CBC;
    public static final Parameters CBCwithPKCS7;
    public static final Parameters CBCwithISO10126_2;
    public static final Parameters CBCwithX923;
    public static final Parameters CBCwithISO7816_4;
    public static final Parameters CBCwithTBC;
    public static final Parameters CBCwithCS1;
    public static final Parameters CBCwithCS2;
    public static final Parameters CBCwithCS3;
    public static final Parameters CFB8;
    public static final Parameters CFB64;
    public static final Parameters OFB;
    public static final Parameters CTR;
    public static final AuthParameters EAX;
    public static final AuthParameters CBC_MAC;
    public static final AuthParameters CFB8_MAC;
    public static final AuthParameters CMAC;
    public static final Parameters RFC3217_WRAP;

    private RC2() {
    }

    private static KeyParameter createRC2Parameters(SymmetricKey key, Algorithm algorithm, int effKeySizeInBits) {
        ValidatedSymmetricKey sKey = RC2.validateKey(key, algorithm);
        KeyParameterImpl keyParameter = effKeySizeInBits > 0 ? new RC2Parameters(sKey.getKeyBytes(), effKeySizeInBits) : new KeyParameterImpl(sKey.getKeyBytes());
        return keyParameter;
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey key, Algorithm paramAlgorithm) {
        ValidatedSymmetricKey vKey = PrivilegedUtils.getValidatedKey(key);
        int keyLength = vKey.getKeySizeInBits();
        if (RC2.invalidKeySize(keyLength)) {
            throw new IllegalKeyException("Key the wrong size for RC2");
        }
        Utils.checkKeyAlgorithm(vKey, ALGORITHM, paramAlgorithm);
        return vKey;
    }

    private static boolean invalidKeySize(int keyLength) {
        return keyLength < 8 || keyLength > 1024;
    }

    static {
        EngineProvider provider = new EngineProvider();
        provider.createEngine();
        ENGINE_PROVIDER = provider;
        ECB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB));
        ECBwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.PKCS7));
        ECBwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO10126_2));
        ECBwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.X923));
        ECBwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO7816_4));
        ECBwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.TBC));
        CBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC));
        CBCwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.PKCS7));
        CBCwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO10126_2));
        CBCwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.X923));
        CBCwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO7816_4));
        CBCwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.TBC));
        CBCwithCS1 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS1));
        CBCwithCS2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS2));
        CBCwithCS3 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS3));
        CFB8 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB8));
        CFB64 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB64));
        OFB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.OFB64));
        CTR = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CTR));
        EAX = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.EAX));
        CBC_MAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBCMAC));
        CFB8_MAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB8MAC));
        CMAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CMAC));
        RFC3217_WRAP = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.RFC3217_WRAP));
    }

    public static final class AEADOperatorFactory
    extends GuardedAEADOperatorFactory<AuthParameters> {
        protected AEADBlockCipher createAEADCipher(boolean forEncryption, SymmetricKey key, AuthParameters parameters) {
            KeyParameter keyParameter = RC2.createRC2Parameters(key, parameters.getAlgorithm(), parameters.getEffectiveKeySizeInBits());
            return CipherUtils.createStandardAEADCipher(forEncryption, keyParameter, (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (AuthenticationParametersWithIV)parameters);
        }
    }

    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private final int effectiveKeySizeInBits;

        private AuthParameters(GeneralAlgorithm algorithm, int effectiveKeySizeInBits, byte[] iv, int tagLenInBits) {
            super(algorithm, 8, iv, tagLenInBits);
            this.effectiveKeySizeInBits = effectiveKeySizeInBits;
        }

        AuthParameters(GeneralAlgorithm algorithm) {
            this(algorithm, -1, null, Utils.getDefaultMacSize(algorithm, 64));
        }

        public AuthParameters withEffectiveKeySizeInBits(int effectiveKeySizeInBits) {
            return new AuthParameters((GeneralAlgorithm)this.getAlgorithm(), effectiveKeySizeInBits, this.iv, this.macLenInBits);
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm algorithm, byte[] iv, int macSizeInBits) {
            return new AuthParameters(algorithm, this.effectiveKeySizeInBits, iv, macSizeInBits);
        }

        public int getEffectiveKeySizeInBits() {
            return this.effectiveKeySizeInBits;
        }
    }

    private static final class EngineProvider
    implements org.bouncycastle.crypto.internal.EngineProvider<BlockCipher> {
        private EngineProvider() {
        }

        @Override
        public BlockCipher createEngine() {
            return SelfTestExecutor.validate((Algorithm)ALGORITHM, new RC2Engine(), new VariantKatTest<RC2Engine>(){

                @Override
                public void evaluate(RC2Engine engine) {
                    byte[] input = Hex.decode("00112233445566778899aabbccddeeff");
                    byte[] output = Hex.decode("c9ac8a939b3868f6fcc81336913d515e");
                    byte[] tmp = new byte[input.length];
                    KeyParameterImpl key = new KeyParameterImpl(Hex.decode("101112131415161718191a1b1c1d1e1f"));
                    engine.init(true, key);
                    engine.processBlock(input, 0, tmp, 0);
                    engine.processBlock(input, 8, tmp, 8);
                    if (!Arrays.areEqual(output, tmp)) {
                        this.fail("Failed self test on encryption");
                    }
                    engine.init(false, key);
                    engine.processBlock(tmp, 0, tmp, 0);
                    engine.processBlock(tmp, 8, tmp, 8);
                    if (!Arrays.areEqual(input, tmp)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(int keySizeInBits, SecureRandom random) {
            this(ALGORITHM, keySizeInBits, random);
        }

        public KeyGenerator(GeneralParameters parameterSet, int keySizeInBits, SecureRandom random) {
            this((GeneralAlgorithm)parameterSet.getAlgorithm(), keySizeInBits, random);
        }

        private KeyGenerator(GeneralAlgorithm algorithm, int keySizeInBits, SecureRandom random) {
            this.algorithm = algorithm;
            if (RC2.invalidKeySize(keySizeInBits)) {
                throw new IllegalArgumentException("Attempt to create key with invalid key size [" + keySizeInBits + "]: " + algorithm.getName());
            }
            this.keySizeInBits = keySizeInBits;
            this.random = random;
        }

        @Override
        public SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    public static final class KeyWrapOperatorFactory
    extends GuardedKeyWrapOperatorFactory<Parameters, SymmetricKey> {
        @Override
        protected Wrapper createWrapper(boolean forWrapping, SymmetricKey key, Parameters parameters, SecureRandom random) {
            KeyParameter keyParameter = RC2.createRC2Parameters(key, parameters.getAlgorithm(), parameters.getEffectiveKeySizeInBits());
            return CipherUtils.createStandardWrapper(forWrapping, keyParameter, (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (ParametersWithIV)parameters, false, random);
        }
    }

    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey key, AuthParameters parameters) {
            KeyParameter keyParameter = RC2.createRC2Parameters(key, parameters.getAlgorithm(), parameters.getEffectiveKeySizeInBits());
            return CipherUtils.createStandardMac(keyParameter, (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (GeneralAuthParameters)parameters);
        }

        @Override
        protected int calculateMACSize(AuthParameters parameters) {
            return Utils.bitsToBytes(parameters.macLenInBits);
        }
    }

    public static final class OperatorFactory
    extends GuardedSymmetricOperatorFactory<Parameters> {
        @Override
        protected BufferedBlockCipher createCipher(boolean forEncryption, SymmetricKey key, Parameters parameters, SecureRandom random) {
            KeyParameter keyParameter = RC2.createRC2Parameters(key, parameters.getAlgorithm(), parameters.getEffectiveKeySizeInBits());
            return CipherUtils.createStandardCipher(forEncryption, keyParameter, (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (ParametersWithIV)parameters, random);
        }
    }

    public static final class Parameters
    extends GeneralParameters<GeneralAlgorithm>
    implements ParametersWithIV {
        private final byte[] iv;
        private final int effectiveKeySizeInBits;

        Parameters(GeneralAlgorithm algorithm) {
            this(algorithm, -1, null);
        }

        private Parameters(GeneralAlgorithm algorithm, int effectiveKeySizeInBits, byte[] iv) {
            super(algorithm);
            this.effectiveKeySizeInBits = effectiveKeySizeInBits;
            this.iv = iv;
        }

        public Parameters withEffectiveKeySizeInBits(int effectiveKeySizeInBits) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), effectiveKeySizeInBits, this.iv);
        }

        public Parameters withIV(byte[] iv) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), this.getEffectiveKeySizeInBits(), Arrays.clone(iv));
        }

        public Parameters withIV(SecureRandom random) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), this.getEffectiveKeySizeInBits(), ((GeneralAlgorithm)this.getAlgorithm()).createDefaultIvIfNecessary(8, random));
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }

        public int getEffectiveKeySizeInBits() {
            return this.effectiveKeySizeInBits;
        }
    }
}

