/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.params.DsaParameterGenerationParameters;
import org.bouncycastle.crypto.internal.params.DsaParameters;
import org.bouncycastle.crypto.internal.params.DsaValidationParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

class DsaParametersGenerator {
    private Digest digest;
    private int L;
    private int N;
    private int certainty;
    private SecureRandom random;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private boolean use186_3;
    private int usageIndex;

    public DsaParametersGenerator() {
        this(Register.createDigest(FipsSHS.Algorithm.SHA1));
    }

    public DsaParametersGenerator(Digest digest) {
        this.digest = digest;
    }

    public void init(int size, int certainty, SecureRandom random) {
        this.use186_3 = false;
        this.L = size;
        this.N = DsaParametersGenerator.getDefaultN(size);
        this.certainty = certainty;
        this.random = random;
    }

    public void init(DsaParameterGenerationParameters params) {
        this.use186_3 = true;
        this.L = params.getL();
        this.N = params.getN();
        this.certainty = params.getCertainty();
        this.random = params.getRandom();
        this.usageIndex = params.getUsageIndex();
        if (this.L < 1024 || this.L > 3072 || this.L % 1024 != 0) {
            throw new IllegalArgumentException("L values must be between 1024 and 3072 and a multiple of 1024");
        }
        if (this.L == 1024 && this.N != 160) {
            throw new IllegalArgumentException("N must be 160 for L = 1024");
        }
        if (this.L == 2048 && this.N != 224 && this.N != 256) {
            throw new IllegalArgumentException("N must be 224 or 256 for L = 2048");
        }
        if (this.L == 3072 && this.N != 256) {
            throw new IllegalArgumentException("N must be 256 for L = 3072");
        }
        if (this.digest.getDigestSize() * 8 < this.N) {
            throw new IllegalStateException("Digest output size too small for value of N");
        }
    }

    public DsaParameters generateParameters() {
        return this.use186_3 ? this.generateParameters_FIPS186_3() : this.generateParameters_FIPS186_2();
    }

    /*
     * Unable to fully structure code
     */
    private DsaParameters generateParameters_FIPS186_2() {
        seed = new byte[20];
        part1 = new byte[20];
        part2 = new byte[20];
        u = new byte[20];
        n = (this.L - 1) / 160;
        w = new byte[this.L / 8];
        block0: while (true) {
            this.random.nextBytes(seed);
            DsaParametersGenerator.hash(this.digest, seed, part1);
            System.arraycopy(seed, 0, part2, 0, seed.length);
            DsaParametersGenerator.inc(part2);
            DsaParametersGenerator.hash(this.digest, part2, part2);
            for (i = 0; i != u.length; ++i) {
                u[i] = (byte)(part1[i] ^ part2[i]);
            }
            u[0] = (byte)(u[0] | -128);
            u[19] = (byte)(u[19] | 1);
            q = new BigInteger(1, u);
            if (!q.isProbablePrime(this.certainty)) continue;
            offset = Arrays.clone(seed);
            DsaParametersGenerator.inc(offset);
            counter = 0;
            while (true) {
                if (counter < 4096) ** break;
                continue block0;
                for (k = 0; k < n; ++k) {
                    DsaParametersGenerator.inc(offset);
                    DsaParametersGenerator.hash(this.digest, offset, part1);
                    System.arraycopy(part1, 0, w, w.length - (k + 1) * part1.length, part1.length);
                }
                DsaParametersGenerator.inc(offset);
                DsaParametersGenerator.hash(this.digest, offset, part1);
                System.arraycopy(part1, part1.length - (w.length - n * part1.length), w, 0, w.length - n * part1.length);
                w[0] = (byte)(w[0] | -128);
                x = new BigInteger(1, w);
                c = x.mod(q.shiftLeft(1));
                p = x.subtract(c.subtract(DsaParametersGenerator.ONE));
                if (p.bitLength() == this.L && p.isProbablePrime(this.certainty)) {
                    g = DsaParametersGenerator.calculateGenerator_FIPS186_2(p, q, this.random);
                    return new DsaParameters(p, q, g, new DsaValidationParameters(seed, counter));
                }
                ++counter;
            }
            break;
        }
    }

    private static BigInteger calculateGenerator_FIPS186_2(BigInteger p, BigInteger q, SecureRandom r) {
        BigInteger h;
        BigInteger g;
        BigInteger e = p.subtract(ONE).divide(q);
        BigInteger pSub2 = p.subtract(TWO);
        while ((g = (h = BigIntegers.createRandomInRange(TWO, pSub2, r)).modPow(e, p)).bitLength() <= 1) {
        }
        return g;
    }

    /*
     * Unable to fully structure code
     */
    private DsaParameters generateParameters_FIPS186_3() {
        d = this.digest;
        outlen = d.getDigestSize() * 8;
        seedlen = this.N;
        seed = new byte[seedlen / 8];
        n = (this.L - 1) / outlen;
        b = (this.L - 1) % outlen;
        output = new byte[d.getDigestSize()];
        block0: while (true) {
            this.random.nextBytes(seed);
            DsaParametersGenerator.hash(d, seed, output);
            U = new BigInteger(1, output).mod(DsaParametersGenerator.ONE.shiftLeft(this.N - 1));
            q = DsaParametersGenerator.ONE.shiftLeft(this.N - 1).add(U).add(DsaParametersGenerator.ONE).subtract(U.mod(DsaParametersGenerator.TWO));
            if (!q.isProbablePrime(this.certainty)) continue;
            offset = Arrays.clone(seed);
            counterLimit = 4 * this.L;
            counter = 0;
            while (true) {
                if (counter < counterLimit) ** break;
                continue block0;
                W = DsaParametersGenerator.ZERO;
                j = 0;
                exp = 0;
                while (j <= n) {
                    DsaParametersGenerator.inc(offset);
                    DsaParametersGenerator.hash(d, offset, output);
                    Vj = new BigInteger(1, output);
                    if (j == n) {
                        Vj = Vj.mod(DsaParametersGenerator.ONE.shiftLeft(b));
                    }
                    W = W.add(Vj.shiftLeft(exp));
                    ++j;
                    exp += outlen;
                }
                X = W.add(DsaParametersGenerator.ONE.shiftLeft(this.L - 1));
                p = X.subtract((c = X.mod(q.shiftLeft(1))).subtract(DsaParametersGenerator.ONE));
                if (p.bitLength() == this.L && p.isProbablePrime(this.certainty)) {
                    if (this.usageIndex >= 0 && (g = DsaParametersGenerator.calculateGenerator_FIPS186_3_Verifiable(d, p, q, seed, this.usageIndex)) != null) {
                        return new DsaParameters(p, q, g, new DsaValidationParameters(seed, counter, this.usageIndex));
                    }
                    g = DsaParametersGenerator.calculateGenerator_FIPS186_3_Unverifiable(p, q, this.random);
                    return new DsaParameters(p, q, g, new DsaValidationParameters(seed, counter));
                }
                ++counter;
            }
            break;
        }
    }

    private static BigInteger calculateGenerator_FIPS186_3_Unverifiable(BigInteger p, BigInteger q, SecureRandom r) {
        return DsaParametersGenerator.calculateGenerator_FIPS186_2(p, q, r);
    }

    private static BigInteger calculateGenerator_FIPS186_3_Verifiable(Digest d, BigInteger p, BigInteger q, byte[] seed, int index) {
        BigInteger e = p.subtract(ONE).divide(q);
        byte[] ggen = Hex.decode("6767656E");
        byte[] U = new byte[seed.length + ggen.length + 1 + 2];
        System.arraycopy(seed, 0, U, 0, seed.length);
        System.arraycopy(ggen, 0, U, seed.length, ggen.length);
        U[U.length - 3] = (byte)index;
        byte[] w = new byte[d.getDigestSize()];
        for (int count = 1; count < 65536; ++count) {
            DsaParametersGenerator.inc(U);
            DsaParametersGenerator.hash(d, U, w);
            BigInteger W = new BigInteger(1, w);
            BigInteger g = W.modPow(e, p);
            if (g.compareTo(TWO) < 0) continue;
            return g;
        }
        return null;
    }

    private static void hash(Digest d, byte[] input, byte[] output) {
        d.update(input, 0, input.length);
        d.doFinal(output, 0);
    }

    private static int getDefaultN(int L) {
        return L > 1024 ? 256 : 160;
    }

    private static void inc(byte[] buf) {
        for (int i = buf.length - 1; i >= 0; --i) {
            byte b;
            buf[i] = b = (byte)(buf[i] + 1 & 0xFF);
            if (b != 0) break;
        }
    }
}

