/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.KMAC;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.DerivationFunction;
import org.bouncycastle.crypto.internal.DerivationParameters;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.params.KDFParameters;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;

class NoCounterKDFGenerator
implements DerivationFunction {
    private final Digest digest;
    private final Mac mac;
    private byte[] shared;
    private byte[] otherInfo;
    private int hLen;
    private int requiredLen;

    public NoCounterKDFGenerator(Digest digest) {
        this.digest = digest;
        this.mac = null;
        this.hLen = digest.getDigestSize();
    }

    public NoCounterKDFGenerator(Mac mac) {
        this.mac = mac;
        this.digest = null;
        this.hLen = mac.getMacSize();
    }

    @Override
    public void init(DerivationParameters param) {
        if (param instanceof KDFParameters) {
            KDFParameters p = (KDFParameters)param;
            this.shared = p.getSharedSecret();
            this.otherInfo = p.getIV();
            if (this.mac != null) {
                byte[] salt = p.getSalt();
                if (p.getSalt() == null) {
                    if (this.mac instanceof HMac) {
                        salt = new byte[((HMac)this.mac).getUnderlyingDigest().getByteLength()];
                    } else if (this.mac instanceof KMAC) {
                        salt = new byte[((KMAC)this.mac).getByteLength() - 4];
                    } else {
                        throw new IllegalArgumentException("cannot recognise MAC");
                    }
                }
                this.mac.init(new KeyParameterImpl(salt));
            }
        } else {
            throw new IllegalArgumentException("KDF parameters required for KDF generator");
        }
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (this.digest != null) {
            return this.digestGenerateBytes(out, outOff, len);
        }
        return this.macGenerateBytes(out, outOff, len);
    }

    private int macGenerateBytes(byte[] out, int outOff, int len) {
        this.mac.update(this.shared, 0, this.shared.length);
        if (this.otherInfo != null) {
            this.mac.update(this.otherInfo, 0, this.otherInfo.length);
        }
        if (this.mac instanceof KMAC) {
            ((KMAC)this.mac).doFinal(out, outOff, len);
        } else {
            if (len > this.hLen) {
                throw new IllegalArgumentException("requested length too large for KDF output");
            }
            byte[] hashBuf = new byte[this.hLen];
            this.mac.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, out, outOff, len);
            Arrays.fill(hashBuf, (byte)0);
        }
        return len;
    }

    private int digestGenerateBytes(byte[] out, int outOff, int len) {
        if (len > this.hLen) {
            throw new IllegalArgumentException("requested length too large for KDF output");
        }
        this.digest.update(this.shared, 0, this.shared.length);
        if (this.otherInfo != null) {
            this.digest.update(this.otherInfo, 0, this.otherInfo.length);
        }
        byte[] hashBuf = new byte[this.hLen];
        this.digest.doFinal(hashBuf, 0);
        System.arraycopy(hashBuf, 0, out, outOff, len);
        Arrays.fill(hashBuf, (byte)0);
        return len;
    }
}

