/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.internal.Xof;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.math.ec.rfc8032.Ed448;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

final class Ed448PublicKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 57;
    private final byte[] data = new byte[57];
    private final Ed448 ed448 = new Ed448(){

        @Override
        protected Xof createXof() {
            return (Xof)FipsSHS.createDigest(FipsSHS.Algorithm.SHAKE256);
        }
    };

    public Ed448PublicKeyParameters(byte[] buf) {
        this(Ed448PublicKeyParameters.validate(buf), 0);
    }

    public Ed448PublicKeyParameters(byte[] buf, int off) {
        super(false);
        System.arraycopy(buf, off, this.data, 0, 57);
    }

    public Ed448PublicKeyParameters(InputStream input) throws IOException {
        super(false);
        if (57 != Streams.readFully(input, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed448 public key");
        }
    }

    public void encode(byte[] buf, int off) {
        System.arraycopy(this.data, 0, buf, off, 57);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    public boolean verify(int algorithm, byte[] ctx, byte[] msg, int msgOff, int msgLen, byte[] sig, int sigOff) {
        switch (algorithm) {
            case 0: {
                return this.ed448.verify(sig, sigOff, this.data, 0, ctx, msg, msgOff, msgLen);
            }
            case 1: {
                if (64 != msgLen) {
                    throw new IllegalArgumentException("msgLen");
                }
                return this.ed448.verifyPrehash(sig, sigOff, this.data, 0, ctx, msg, msgOff);
            }
        }
        throw new IllegalArgumentException("algorithm");
    }

    private static byte[] validate(byte[] buf) {
        if (buf.length != 57) {
            throw new IllegalArgumentException("'buf' must have length 57");
        }
        return buf;
    }
}

