/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410Key;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.internal.Permissions;

public final class AsymmetricECGOST3410PrivateKey
extends AsymmetricGOST3410Key<ECDomainParameters>
implements AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private int hashCode;
    private BigInteger x;

    public AsymmetricECGOST3410PrivateKey(Algorithm algorithm, GOST3410Parameters<ECDomainParameters> params, BigInteger x) {
        super(algorithm, params);
        this.x = x;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricECGOST3410PrivateKey(Algorithm algorithm, byte[] enc) {
        this(algorithm, PrivateKeyInfo.getInstance(enc));
    }

    public AsymmetricECGOST3410PrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        super(algorithm, ecAcceptable, privateKeyInfo.getPrivateKeyAlgorithm());
        this.x = AsymmetricECGOST3410PrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo info) {
        try {
            ASN1Encodable keyData = info.parsePrivateKey();
            if (keyData instanceof ASN1Integer) {
                return ASN1Integer.getInstance(keyData).getPositiveValue();
            }
            byte[] encVal = ASN1OctetString.getInstance(keyData).getOctets();
            byte[] dVal = new byte[encVal.length];
            for (int i = 0; i != encVal.length; ++i) {
                dVal[i] = encVal[encVal.length - 1 - i];
            }
            return new BigInteger(1, dVal);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse ECGOST3410 private key: " + e.getMessage(), e);
        }
    }

    @Override
    public final byte[] getEncoded() {
        ASN1ObjectIdentifier id;
        byte[] encS = this.getS().toByteArray();
        byte[] encKey = encS.length > 33 ? new byte[64] : new byte[32];
        this.extractBytes(encKey, this.getS());
        if (this.getParameters().getPublicKeyParamSet() != null) {
            GOST3410PublicKeyAlgParameters pubParams = new GOST3410PublicKeyAlgParameters(this.getParameters().getPublicKeyParamSet(), this.getParameters().getDigestParamSet(), this.getParameters().getEncryptionParamSet());
            if (encKey.length == 64) {
                return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512, pubParams), new DEROctetString(encKey));
            }
            if (pubParams.getEncryptionParamSet().on(RosstandartObjectIdentifiers.id_tc26)) {
                return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256, pubParams), new DEROctetString(encKey));
            }
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, pubParams), new DEROctetString(encKey));
        }
        if (encKey.length == 64) {
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512), new DEROctetString(encKey));
        }
        if (this.getParameters().getDomainParameters() instanceof NamedECDomainParameters && (id = ((NamedECDomainParameters)this.getParameters().getDomainParameters()).getID()).on(RosstandartObjectIdentifiers.id_tc26)) {
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256), new DEROctetString(encKey));
        }
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001), new DEROctetString(encKey));
    }

    private void extractBytes(byte[] encKey, BigInteger bI) {
        byte[] val = bI.toByteArray();
        if (val.length < encKey.length) {
            byte[] tmp = new byte[encKey.length];
            System.arraycopy(val, 0, tmp, tmp.length - val.length, val.length);
            val = tmp;
        }
        for (int i = 0; i != encKey.length; ++i) {
            encKey[i] = val[val.length - 1 - i];
        }
    }

    @Override
    public final Algorithm getAlgorithm() {
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    @Override
    public final GOST3410Parameters<ECDomainParameters> getParameters() {
        KeyUtils.checkDestroyed(this);
        return super.getParameters();
    }

    public BigInteger getS() {
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        BigInteger xVal = this.x;
        KeyUtils.checkDestroyed(this);
        return xVal;
    }

    @Override
    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.x = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result = this.x.hashCode();
        result = 31 * result + this.getParameters().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricECGOST3410PrivateKey)) {
            return false;
        }
        AsymmetricECGOST3410PrivateKey other = (AsymmetricECGOST3410PrivateKey)o;
        if (this.isDestroyed() || other.isDestroyed()) {
            return false;
        }
        return this.x.equals(other.x) && this.getParameters().equals(other.getParameters());
    }
}

