/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.DrbgParameters;
import java.security.SecureRandom;
import java.security.SecureRandomParameters;
import java.security.SecureRandomSpi;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.SecureRandomProvider;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvRandom
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.random.";

    ProvRandom() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        provider.setProperty("SecureRandom.DEFAULT ThreadSafe", "true");
        provider.addAlgorithmImplementation("SecureRandom.DEFAULT", "org.bouncycastle.jcajce.provider.random.DefSecureRandom", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                PooledSecureRandomProvider pooledProv = new PooledSecureRandomProvider(provider, constructorParameter);
                return new MySecureRandomSpi(pooledProv);
            }
        });
        provider.setProperty("SecureRandom.NONCEANDIV ThreadSafe", "true");
        provider.addAlgorithmImplementation("SecureRandom.NONCEANDIV", "org.bouncycastle.jcajce.provider.random.NonceAndIVSecureRandom", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                PooledNonceSecureRandomProvider pooledProv = new PooledNonceSecureRandomProvider(provider, constructorParameter);
                return new MySecureRandomSpi(pooledProv);
            }
        });
    }

    private byte[] generatePersonalizationString() {
        return Arrays.concatenate(Strings.toByteArray("NonceAndIV"), Pack.longToLittleEndian(Thread.currentThread().getId()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }

    private class MySecureRandomSpi
    extends SecureRandomSpi {
        private final SecureRandomParameters params;
        private final SecureRandomProvider provider;

        protected MySecureRandomSpi(SecureRandomProvider provider) {
            this.provider = provider;
            SecureRandom baseRandom = provider.get();
            if (baseRandom instanceof FipsSecureRandom) {
                FipsSecureRandom fipsRandom = (FipsSecureRandom)baseRandom;
                this.params = DrbgParameters.instantiation(fipsRandom.getSecurityStrength(), fipsRandom.isPredictionResistant() ? DrbgParameters.Capability.PR_AND_RESEED : DrbgParameters.Capability.RESEED_ONLY, fipsRandom.getPersonalizationString());
            } else {
                this.params = null;
            }
        }

        @Override
        protected void engineSetSeed(byte[] bytes) {
            this.provider.get().setSeed(bytes);
        }

        @Override
        protected void engineNextBytes(byte[] bytes, SecureRandomParameters params) {
            DrbgParameters.NextBytes p;
            FipsSecureRandom baseRandom;
            if (params instanceof DrbgParameters.NextBytes) {
                baseRandom = (FipsSecureRandom)this.provider.get();
                p = (DrbgParameters.NextBytes)params;
                if (p.getStrength() > baseRandom.getSecurityStrength()) {
                    throw new IllegalArgumentException("maximum strength of DRBG is " + baseRandom.getSecurityStrength() + " bits");
                }
                if (p.getPredictionResistance() && !baseRandom.isPredictionResistant()) {
                    throw new IllegalArgumentException("prediction resistance not available");
                }
            } else {
                if (params == null) {
                    super.engineNextBytes(bytes, params);
                }
                throw new IllegalArgumentException("unrecognized DrbgParameters: " + params.getClass());
            }
            baseRandom.nextBytes(bytes, p.getAdditionalInput());
        }

        @Override
        protected void engineNextBytes(byte[] bytes) {
            this.provider.get().nextBytes(bytes);
        }

        @Override
        protected byte[] engineGenerateSeed(int numBytes) {
            return this.provider.get().generateSeed(numBytes);
        }

        @Override
        protected void engineReseed(SecureRandomParameters params) {
            if (params instanceof DrbgParameters.Reseed) {
                DrbgParameters.Reseed p = (DrbgParameters.Reseed)params;
                FipsSecureRandom baseRandom = (FipsSecureRandom)this.provider.get();
                if (p.getPredictionResistance() && !baseRandom.isPredictionResistant()) {
                    throw new IllegalArgumentException("prediction resistance not available");
                }
                baseRandom.reseed(p.getAdditionalInput());
            } else {
                if (params != null) {
                    throw new IllegalArgumentException("unrecognized DrbgParameters: " + params.getClass());
                }
                SecureRandom baseRandom = this.provider.get();
                if (baseRandom instanceof FipsSecureRandom) {
                    baseRandom.reseed();
                } else {
                    super.engineReseed(params);
                }
            }
        }

        @Override
        protected SecureRandomParameters engineGetParameters() {
            return this.params;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class PooledNonceSecureRandomProvider
    implements SecureRandomProvider {
        private final AtomicReference<SecureRandom>[] providerDefaultRandom = new AtomicReference[BouncyCastleFipsProvider.POOL_SIZE];
        private final BouncyCastleFipsProvider provider;
        private final Object constructorParameter;

        PooledNonceSecureRandomProvider(BouncyCastleFipsProvider provider, Object constructorParameter) {
            this.provider = provider;
            this.constructorParameter = constructorParameter;
            for (int i = 0; i != this.providerDefaultRandom.length; ++i) {
                this.providerDefaultRandom[i] = new AtomicReference();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public SecureRandom get() {
            int rngIndex = (Thread.currentThread().hashCode() & BouncyCastleFipsProvider.POOL_SIZE - 1) % this.providerDefaultRandom.length;
            if (this.providerDefaultRandom[rngIndex].get() != null) return this.providerDefaultRandom[rngIndex].get();
            AtomicReference<SecureRandom>[] atomicReferenceArray = this.providerDefaultRandom;
            synchronized (this.providerDefaultRandom) {
                FipsSecureRandom random;
                if (this.providerDefaultRandom[rngIndex].get() != null) return this.providerDefaultRandom[rngIndex].get();
                EntropySourceProvider entropySourceProvider = this.provider.getEntropySourceProvider();
                EntropySource seedSource = entropySourceProvider.get(this.provider.getProviderDefaultSecurityStrength() / 2 + 1);
                if (this.constructorParameter == null) {
                    random = this.provider.getProviderDefaultRandomBuilder().fromEntropySource(entropySourceProvider).setPersonalizationString(ProvRandom.this.generatePersonalizationString()).build(seedSource.getEntropy(), false, Strings.toByteArray("Bouncy Castle FIPS Provider Nonce/IV"));
                } else {
                    DrbgParameters.Instantiation params = (DrbgParameters.Instantiation)this.constructorParameter;
                    random = this.provider.getProviderDefaultRandomBuilder().fromEntropySource(entropySourceProvider).setSecurityStrength(params.getStrength()).setPersonalizationString(params.getPersonalizationString()).build(seedSource.getEntropy(), params.getCapability() == DrbgParameters.Capability.PR_AND_RESEED, Strings.toByteArray("Bouncy Castle FIPS Provider Custom Nonce/IV"));
                }
                this.providerDefaultRandom[rngIndex].compareAndSet(null, random);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.providerDefaultRandom[rngIndex].get();
            }
        }
    }

    private class PooledSecureRandomProvider
    implements SecureRandomProvider {
        private final AtomicReference<SecureRandom>[] providerDefaultRandom = new AtomicReference[BouncyCastleFipsProvider.POOL_SIZE];
        private final BouncyCastleFipsProvider provider;
        private final Object constructorParameter;

        PooledSecureRandomProvider(BouncyCastleFipsProvider provider, Object constructorParameter) {
            this.provider = provider;
            this.constructorParameter = constructorParameter;
            for (int i = 0; i != this.providerDefaultRandom.length; ++i) {
                this.providerDefaultRandom[i] = new AtomicReference();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public SecureRandom get() {
            int rngIndex = (Thread.currentThread().hashCode() & BouncyCastleFipsProvider.POOL_SIZE - 1) % this.providerDefaultRandom.length;
            if (this.providerDefaultRandom[rngIndex].get() != null) return this.providerDefaultRandom[rngIndex].get();
            AtomicReference<SecureRandom>[] atomicReferenceArray = this.providerDefaultRandom;
            synchronized (this.providerDefaultRandom) {
                SecureRandom random;
                if (this.providerDefaultRandom[rngIndex].get() != null) return this.providerDefaultRandom[rngIndex].get();
                if (this.constructorParameter == null) {
                    random = this.provider.getDefaultSecureRandom();
                } else {
                    DrbgParameters.Instantiation params = (DrbgParameters.Instantiation)this.constructorParameter;
                    EntropySourceProvider entropySourceProvider = this.provider.getEntropySourceProvider();
                    EntropySource seedSource = entropySourceProvider.get(params.getStrength() / 2 + 1);
                    random = this.provider.getProviderDefaultRandomBuilder().fromEntropySource(entropySourceProvider).setSecurityStrength(params.getStrength()).setPersonalizationString(params.getPersonalizationString()).build(seedSource.getEntropy(), params.getCapability() == DrbgParameters.Capability.PR_AND_RESEED, Strings.toByteArray("Bouncy Castle FIPS Custom Default"));
                }
                this.providerDefaultRandom[rngIndex].compareAndSet(null, random);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.providerDefaultRandom[rngIndex].get();
            }
        }
    }
}

