/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.jcajce.provider.ErasableByteArrayOutputStream;

class WrappedByteArrayOutputStream
extends OutputStream {
    private final ErasableByteArrayOutputStream ebOut = new ErasableByteArrayOutputStream();
    private byte[] buf;
    private int start;
    private int offset;

    public void setWrappedMode(byte[] output, int outputOffset) {
        this.buf = output;
        this.start = outputOffset;
        this.offset = outputOffset;
    }

    public void clearWrappedMode() {
        this.buf = null;
    }

    @Override
    public void write(byte[] in) throws IOException {
        if (this.buf != null) {
            System.arraycopy(in, 0, this.buf, this.offset, in.length);
            this.offset += in.length;
        } else {
            this.ebOut.write(in);
        }
    }

    @Override
    public void write(byte[] in, int inOff, int inLen) throws IOException {
        if (this.buf != null) {
            System.arraycopy(in, inOff, this.buf, this.offset, inLen);
            this.offset += inLen;
        } else {
            this.ebOut.write(in, inOff, inLen);
        }
    }

    @Override
    public void write(int in) throws IOException {
        if (this.buf != null) {
            this.buf[this.offset++] = 0;
        } else {
            this.ebOut.write(in);
        }
    }

    public void reset() {
        this.offset = this.start;
        this.ebOut.reset();
    }

    public int size() {
        if (this.buf != null) {
            return this.offset - this.start;
        }
        return this.ebOut.size();
    }

    public byte[] toByteArray() {
        if (this.buf != null) {
            throw new IllegalStateException("attempt to call toByteArray in wrap mode");
        }
        return this.ebOut.toByteArray();
    }

    public void erase() {
        this.ebOut.erase();
    }
}

