/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPublicKey;
import org.bouncycastle.jcajce.interfaces.XDHPublicKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.util.Arrays;

class ProvXDHPublicKey
implements XDHPublicKey {
    static final long serialVersionUID = 1L;
    private transient AsymmetricXDHPublicKey baseKey;

    ProvXDHPublicKey(AsymmetricXDHPublicKey pubKey) {
        this.baseKey = pubKey;
    }

    ProvXDHPublicKey(byte[] encoding) {
        this.baseKey = new AsymmetricXDHPublicKey(encoding);
    }

    @Override
    public String getAlgorithm() {
        return this.baseKey.getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getPublicData() {
        return this.baseKey.getPublicData();
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    public AsymmetricXDHPublicKey getBaseKey() {
        return this.baseKey;
    }

    public String toString() {
        return KeyUtil.keyToString("Public Key", this.getAlgorithm(), this.baseKey);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvXDHPublicKey)) {
            return false;
        }
        ProvXDHPublicKey other = (ProvXDHPublicKey)o;
        return Arrays.areEqual(other.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricXDHPublicKey(enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

