/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvRandom
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.random.";

    ProvRandom() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("SecureRandom.DEFAULT", "org.bouncycastle.jcajce.provider.random.DefSecureRandom", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                final SecureRandom random = provider.getDefaultSecureRandom();
                return new SecureRandomSpi(){

                    @Override
                    protected void engineSetSeed(byte[] bytes) {
                        random.setSeed(bytes);
                    }

                    @Override
                    protected void engineNextBytes(byte[] bytes) {
                        random.nextBytes(bytes);
                    }

                    @Override
                    protected byte[] engineGenerateSeed(int numBytes) {
                        return random.generateSeed(numBytes);
                    }
                };
            }
        });
        provider.addAlgorithmImplementation("SecureRandom.NONCEANDIV", "org.bouncycastle.jcajce.provider.random.NonceAndIVSecureRandom", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                SecureRandom entropySource = provider.getDefaultEntropySource();
                final FipsSecureRandom random = provider.getProviderDefaultRandomBuilder().fromEntropySource(entropySource, true).setPersonalizationString(ProvRandom.this.generatePersonalizationString()).build(entropySource.generateSeed(provider.getProviderDefaultSecurityStrength() / 16 + 1), false, Strings.toByteArray("Bouncy Castle FIPS Provider Nonce/IV"));
                return new SecureRandomSpi(){

                    @Override
                    protected void engineSetSeed(byte[] bytes) {
                        random.setSeed(bytes);
                    }

                    @Override
                    protected void engineNextBytes(byte[] bytes) {
                        random.nextBytes(bytes);
                    }

                    @Override
                    protected byte[] engineGenerateSeed(int numBytes) {
                        return random.generateSeed(numBytes);
                    }
                };
            }
        });
    }

    private byte[] generatePersonalizationString() {
        return Arrays.concatenate(Strings.toByteArray("NonceAndIV"), Pack.longToLittleEndian(Thread.currentThread().getId()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }
}

