/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.util.Arrays;

class PBKDFPBEKey
extends SecretKeySpec
implements Destroyable,
PBEKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final char[] password;
    private final byte[] salt;
    private final int iterationCount;

    public PBKDFPBEKey(byte[] bytes, String keyAlg, PBEKeySpec pbeSpec) {
        super(bytes, keyAlg);
        this.password = pbeSpec.getPassword();
        this.salt = pbeSpec.getSalt();
        this.iterationCount = pbeSpec.getIterationCount();
    }

    @Override
    public String getAlgorithm() {
        String rv = super.getAlgorithm();
        KeyUtil.checkDestroyed(this);
        return rv;
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        byte[] encoded = super.getEncoded();
        KeyUtil.checkDestroyed(this);
        return encoded;
    }

    @Override
    public char[] getPassword() {
        char[] rv = Arrays.clone(this.password);
        KeyUtil.checkDestroyed(this);
        return rv;
    }

    @Override
    public byte[] getSalt() {
        byte[] clone = Arrays.clone(this.salt);
        KeyUtil.checkDestroyed(this);
        return clone;
    }

    @Override
    public int getIterationCount() {
        int rv = this.iterationCount;
        KeyUtil.checkDestroyed(this);
        return rv;
    }

    @Override
    public void destroy() {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            if (this.password != null) {
                Arrays.fill(this.password, '\u0000');
            }
            if (this.salt != null) {
                Arrays.fill(this.salt, (byte)0);
            }
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }
}

