/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.StreamException;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.io.StreamIOException;
import org.bouncycastle.crypto.internal.io.Utils;
import org.bouncycastle.crypto.internal.modes.AEADCipher;

public class CipherOutputStreamImpl
extends CipherOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    private OutputStream out;
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private AEADCipher aeadBlockCipher;
    private final byte[] oneByte = new byte[1];
    private byte[] buf;
    private static final int INPUT_LEN = 4096;

    public CipherOutputStreamImpl(OutputStream out, BufferedBlockCipher cipher) {
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = cipher.getUnderlyingCipher().getAlgorithmName();
        this.out = out;
        this.bufferedBlockCipher = cipher;
    }

    public CipherOutputStreamImpl(OutputStream out, StreamCipher cipher) {
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = cipher.getAlgorithmName();
        this.out = out;
        this.streamCipher = cipher;
    }

    public CipherOutputStreamImpl(OutputStream out, AEADCipher cipher) {
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithmName = cipher.getAlgorithmName();
        this.out = out;
        this.aeadBlockCipher = cipher;
    }

    @Override
    public void write(int b) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.oneByte[0] = (byte)b;
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        if (this.bufferedBlockCipher != null) {
            while (len > 0) {
                this.ensureCapacity(4096, false);
                int outLen = this.bufferedBlockCipher.processBytes(b, off, len < 4096 ? len : 4096, this.buf, 0);
                if (outLen != 0) {
                    this.out.write(this.buf, 0, outLen);
                }
                off += 4096;
                len -= 4096;
            }
        } else if (this.aeadBlockCipher != null) {
            while (len > 0) {
                this.ensureCapacity(4096, false);
                int outLen = this.aeadBlockCipher.processBytes(b, off, len < 4096 ? len : 4096, this.buf, 0);
                if (outLen != 0) {
                    this.out.write(this.buf, 0, outLen);
                }
                off += 4096;
                len -= 4096;
            }
        } else {
            while (len > 0) {
                this.ensureCapacity(4096, false);
                int outLen = this.streamCipher.processBytes(b, off, len < 4096 ? len : 4096, this.buf, 0);
                if (outLen != 0) {
                    this.out.write(this.buf, 0, outLen);
                }
                off += 4096;
                len -= 4096;
            }
        }
    }

    private void ensureCapacity(int updateSize, boolean finalOutput) {
        int bufLen = updateSize;
        if (finalOutput) {
            if (this.bufferedBlockCipher != null) {
                bufLen = this.bufferedBlockCipher.getOutputSize(updateSize);
            } else if (this.aeadBlockCipher != null) {
                bufLen = this.aeadBlockCipher.getOutputSize(updateSize);
            }
        } else if (this.bufferedBlockCipher != null) {
            bufLen = this.bufferedBlockCipher.getUpdateOutputSize(updateSize);
        } else if (this.aeadBlockCipher != null) {
            bufLen = this.aeadBlockCipher.getUpdateOutputSize(updateSize);
        }
        if (this.buf == null || this.buf.length < bufLen) {
            this.buf = new byte[bufLen];
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        IOException error;
        block14: {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            this.ensureCapacity(0, true);
            error = null;
            try {
                int outLen;
                if (this.bufferedBlockCipher != null) {
                    outLen = this.bufferedBlockCipher.doFinal(this.buf, 0);
                    if (outLen != 0) {
                        this.out.write(this.buf, 0, outLen);
                    }
                } else if (this.aeadBlockCipher != null) {
                    outLen = this.aeadBlockCipher.doFinal(this.buf, 0);
                    if (outLen != 0) {
                        this.out.write(this.buf, 0, outLen);
                    }
                } else if (this.streamCipher != null) {
                    this.streamCipher.reset();
                }
            }
            catch (org.bouncycastle.crypto.internal.InvalidCipherTextException e) {
                error = new InvalidCipherTextException("Error finalising cipher data: " + e.getMessage(), e);
            }
            catch (IllegalStateException e) {
                error = new StreamException(e.getMessage(), e.getCause());
            }
            catch (Exception e) {
                error = new StreamIOException("Error closing stream: ", e);
            }
            try {
                this.flush();
            }
            catch (IOException e) {
                if (error != null) break block14;
                error = e;
            }
        }
        if (error != null) {
            throw error;
        }
    }
}

