/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.general.ARC4Engine;
import org.bouncycastle.crypto.general.CipherKeyGenerator;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.GuardedSymmetricStreamOperatorFactory;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.general.VariantKatTest;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public final class ARC4 {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("ARC4");
    public static final Parameters STREAM = new Parameters();
    private static final EngineProvider ENGINE_PROVIDER;

    private ARC4() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey key, Algorithm paramAlgorithm) {
        ValidatedSymmetricKey vKey = PrivilegedUtils.getValidatedKey(key);
        int keyLength = vKey.getKeySizeInBits();
        if (ARC4.invalidKeySize(keyLength)) {
            throw new IllegalKeyException("Key the wrong size for ARC4");
        }
        Utils.checkKeyAlgorithm(vKey, ALGORITHM, paramAlgorithm);
        return vKey;
    }

    private static boolean invalidKeySize(int keyLength) {
        return keyLength < 40 || keyLength > 2048;
    }

    static {
        EngineProvider provider = new EngineProvider();
        provider.createEngine();
        ENGINE_PROVIDER = provider;
    }

    private static final class EngineProvider
    implements org.bouncycastle.crypto.internal.EngineProvider<ARC4Engine> {
        private EngineProvider() {
        }

        @Override
        public ARC4Engine createEngine() {
            return SelfTestExecutor.validate((Algorithm)ALGORITHM, new ARC4Engine(), new VariantKatTest<ARC4Engine>(){

                @Override
                public void evaluate(ARC4Engine engine) {
                    byte[] input = Hex.decode("00112233445566778899aabbccddeeff");
                    byte[] output = Hex.decode("1035d3faeefacf4afea5343bc4e8876c");
                    byte[] tmp = new byte[input.length];
                    KeyParameterImpl key = new KeyParameterImpl(Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f"));
                    engine.init(true, key);
                    engine.processBytes(input, 0, input.length, tmp, 0);
                    if (!Arrays.areEqual(output, tmp)) {
                        this.fail("Failed self test on encryption");
                    }
                    engine.init(false, key);
                    engine.processBytes(tmp, 0, tmp.length, tmp, 0);
                    if (!Arrays.areEqual(input, tmp)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm = ALGORITHM;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(int keySizeInBits, SecureRandom random) {
            if (ARC4.invalidKeySize(keySizeInBits)) {
                throw new IllegalArgumentException("Attempt to create key with invalid key size [" + keySizeInBits + "]: RC4");
            }
            this.keySizeInBits = keySizeInBits;
            this.random = random;
        }

        @Override
        public SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    public static final class OperatorFactory
    extends GuardedSymmetricStreamOperatorFactory<Parameters> {
        @Override
        protected StreamCipher createCipher(boolean forEncryption, SymmetricKey key, Parameters parameters, SecureRandom random) {
            ARC4Engine cipher = ENGINE_PROVIDER.createEngine();
            KeyParameter params = Utils.getKeyParameter(ARC4.validateKey(key, parameters.getAlgorithm()));
            cipher.init(forEncryption, params);
            return cipher;
        }
    }

    public static final class Parameters
    extends GeneralParameters {
        Parameters() {
            super(ALGORITHM);
        }
    }
}

