/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.stream.Stream;
import org.bouncycastle.LICENSE;
import org.bouncycastle.crypto.fips.FipsOperationError;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.SHA256Digest;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;

public final class FipsStatus {
    public static final String READY = "READY";
    private static final Object statusLock = new Object();
    private static final String[] classes = new String[]{FipsSHS.class.getName()};
    private static final AtomicBoolean readyStatus = new AtomicBoolean(false);
    private static volatile Loader loader;
    private static volatile Throwable statusException;

    private FipsStatus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReady() {
        Object object = statusLock;
        synchronized (object) {
            if (loader == null && statusException == null) {
                try {
                    loader = new Loader();
                    loader.run();
                }
                catch (Exception e) {
                    statusException = e;
                    FipsStatus.moveToErrorStatus(new FipsOperationError("Module startup failed: " + e.getMessage(), e));
                }
                FipsStatus.checksumValidate();
                readyStatus.set(true);
            } else if (statusException != null) {
                throw new FipsOperationError("Module in error status: " + statusException.getMessage(), statusException);
            }
        }
        return readyStatus.get();
    }

    static boolean isBooting() {
        return !readyStatus.get();
    }

    private static void checksumValidate() {
        final String rscName = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return FipsStatus.getResourceName();
            }
        });
        if (rscName == null) {
            FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: unable to find"));
        }
        if (rscName.startsWith("jrt:/")) {
            byte[][] hmacs = null;
            try {
                FileSystem fs = FileSystems.newFileSystem(URI.create("jrt:/"), Collections.singletonMap("java.home", System.getProperty("java.home")));
                try (Stream<Path> stream = Files.list(fs.getPath("/modules", new String[0]));){
                    Iterator it = stream.iterator();
                    while (it.hasNext()) {
                        Path path = (Path)it.next();
                        if (!path.endsWith("/modules/org.bouncycastle.fips.core")) continue;
                        try {
                            hmacs = FipsStatus.calculateModuleHMAC(Files.walk(path, new FileVisitOption[0]));
                            break;
                        }
                        catch (Exception e) {
                            statusException = e;
                            FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: " + e.getMessage(), e));
                        }
                    }
                }
                if (!Arrays.constantTimeAreEqual(hmacs[0], hmacs[1])) {
                    FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: expected [" + Hex.toHexString(hmacs[1]) + "] got [" + Hex.toHexString(hmacs[0]) + "]"));
                }
            }
            catch (IOException e) {
                FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: unable to calculate: " + e.getMessage(), e));
            }
            if (hmacs == null) {
                FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: unable to calculate"));
            }
        } else if (FipsStatus.checkValidJarUrl(rscName)) {
            try {
                JarInputStream jIn = new JarInputStream(new URL(rscName).openStream());
                byte[][] hmacs = FipsStatus.calculateModuleHMAC(jIn);
                if (!Arrays.constantTimeAreEqual(hmacs[0], hmacs[1])) {
                    FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: expected [" + Hex.toHexString(hmacs[1]) + "] got [" + Hex.toHexString(hmacs[0]) + "]"));
                }
            }
            catch (Exception e) {
                statusException = e;
                FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: " + e.getMessage(), e));
            }
        } else {
            JarFile jarFile = AccessController.doPrivileged(new PrivilegedAction<JarFile>(){

                @Override
                public JarFile run() {
                    try {
                        return new JarFile(rscName);
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            });
            if (jarFile != null) {
                try {
                    int ch;
                    byte[] hmac = FipsStatus.calculateModuleHMAC(jarFile);
                    InputStream macIn = jarFile.getInputStream(jarFile.getEntry("META-INF/HMAC.SHA256"));
                    StringBuilder sb = new StringBuilder(hmac.length * 2);
                    while ((ch = macIn.read()) >= 0 && ch != 13 && ch != 10) {
                        sb.append((char)ch);
                    }
                    byte[] fileMac = Hex.decode(sb.toString().trim());
                    if (!Arrays.constantTimeAreEqual(hmac, fileMac)) {
                        FipsStatus.moveToErrorStatus((Object)((Object)new FipsOperationError("Module checksum failed: expected [" + sb.toString().trim() + "] got [" + Strings.fromByteArray(Hex.encode(hmac)))) + "]");
                    }
                }
                catch (Exception e) {
                    statusException = e;
                    FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: " + e.getMessage(), e));
                }
            }
        }
    }

    public static String getStatusMessage() {
        try {
            FipsStatus.isReady();
        }
        catch (FipsOperationError fipsOperationError) {
            // empty catch block
        }
        if (statusException != null) {
            return statusException.getMessage();
        }
        return READY;
    }

    private static void loadClass(String className) {
        try {
            Class.forName(className);
        }
        catch (ExceptionInInitializerError e) {
            statusException = e.getCause() != null ? e.getCause() : e;
            throw e;
        }
        catch (ClassNotFoundException e) {
            statusException = e;
            throw new IllegalStateException("Unable to initialize module: " + e.getMessage(), e);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] getModuleHMAC() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean skipName(String name) {
        if (name.indexOf("module-info.class") >= 0) {
            return true;
        }
        if (name.startsWith("META-INF/")) {
            if (name.contains("OSGI-INF/")) {
                return true;
            }
            if (name.indexOf("versions/") < 0) {
                return true;
            }
        }
        return name.contains("OSGI-INF/");
    }

    private static boolean skipEntry(JarEntry jarEntry) {
        return jarEntry.isDirectory() || FipsStatus.skipName(jarEntry.getName());
    }

    private static byte[][] calculateModuleHMAC(Stream<Path> jlinkStream) throws Exception {
        HMac hMac = new HMac(new SHA256Digest());
        hMac.init(new KeyParameterImpl(Strings.toByteArray("Legion of the Bouncy Castle Inc.")));
        TreeMap index = new TreeMap();
        jlinkStream.forEach(path -> index.put(path.toString(), path));
        byte[] checksum = null;
        byte[] buf = new byte[8192];
        for (Map.Entry entry : index.entrySet()) {
            int n;
            Path jlinkEntry = (Path)entry.getValue();
            if (Files.isDirectory(jlinkEntry, new LinkOption[0])) continue;
            String fileName = jlinkEntry.toAbsolutePath().toString().substring("/modules/org.bouncycastle.fips.core/".length());
            if (fileName.equals("BC-INF/HMAC.SHA256")) {
                InputStream inStr = Files.newInputStream(jlinkEntry.toAbsolutePath(), new OpenOption[0]);
                checksum = Hex.decode(Strings.fromByteArray(Streams.readAll(inStr)).trim());
                inStr.close();
                continue;
            }
            if (FipsStatus.skipName(fileName)) continue;
            Long length = (Long)Files.getAttribute(jlinkEntry, "size", new LinkOption[0]);
            InputStream is = Files.newInputStream(jlinkEntry.toAbsolutePath(), new OpenOption[0]);
            byte[] encName = Strings.toUTF8ByteArray(fileName);
            hMac.update((byte)91);
            hMac.update(encName, 0, encName.length);
            hMac.update(Pack.longToBigEndian(length), 0, 8);
            hMac.update((byte)93);
            while ((n = is.read(buf, 0, buf.length)) != -1) {
                hMac.update(buf, 0, n);
            }
            is.close();
        }
        hMac.update((byte)91);
        byte[] encName = Strings.toUTF8ByteArray("END");
        hMac.update(encName, 0, encName.length);
        hMac.update((byte)93);
        byte[] hmacResult = new byte[hMac.getMacSize()];
        hMac.doFinal(hmacResult, 0);
        return new byte[][]{hmacResult, checksum};
    }

    private static byte[] calculateModuleHMAC(JarFile jarFile) {
        try {
            HMac hMac = new HMac(new SHA256Digest());
            hMac.init(new KeyParameterImpl(Strings.toByteArray("Legion of the Bouncy Castle Inc.")));
            TreeMap<String, Object> index = new TreeMap<String, Object>();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                Object object;
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.getName().equals("META-INF/HMAC.SHA256") || FipsStatus.skipEntry(jarEntry) || (object = index.put(jarEntry.getName(), jarEntry)) == null) continue;
                IllegalStateException e = new IllegalStateException("Unable to initialize module: duplicate entry found in jar file");
                statusException = e;
                throw e;
            }
            byte[] buf = new byte[8192];
            for (Map.Entry entry : index.entrySet()) {
                int n;
                JarEntry jarEntry = (JarEntry)entry.getValue();
                InputStream is = jarFile.getInputStream(jarEntry);
                byte[] encName = Strings.toUTF8ByteArray(jarEntry.getName());
                hMac.update((byte)91);
                hMac.update(encName, 0, encName.length);
                hMac.update(Pack.longToBigEndian(jarEntry.getSize()), 0, 8);
                hMac.update((byte)93);
                while ((n = is.read(buf, 0, buf.length)) != -1) {
                    hMac.update(buf, 0, n);
                }
                is.close();
            }
            hMac.update((byte)91);
            byte[] encName = Strings.toUTF8ByteArray("END");
            hMac.update(encName, 0, encName.length);
            hMac.update((byte)93);
            byte[] byArray = new byte[hMac.getMacSize()];
            hMac.doFinal(byArray, 0);
            return byArray;
        }
        catch (Exception e) {
            return new byte[32];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[][] calculateModuleHMAC(JarInputStream jIn) throws Exception {
        try {
            Object encName;
            JarEntry jarEntry;
            HMac hMac = new HMac(new SHA256Digest());
            hMac.init(new KeyParameterImpl(Strings.toByteArray("Legion of the Bouncy Castle Inc.")));
            TreeMap<String, byte[]> index = new TreeMap<String, byte[]>();
            byte[] checksum = null;
            while ((jarEntry = jIn.getNextJarEntry()) != null) {
                if (jarEntry.getName().equals("META-INF/HMAC.SHA256")) {
                    checksum = Hex.decode(Strings.fromByteArray(Streams.readAll(jIn)).trim());
                    continue;
                }
                if (FipsStatus.skipEntry(jarEntry)) continue;
                encName = Strings.toUTF8ByteArray(jarEntry.getName());
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                bOut.write(91);
                bOut.write((byte[])encName, 0, ((Object)encName).length);
                byte[] classData = Streams.readAll(jIn);
                bOut.write(Pack.longToBigEndian(classData.length), 0, 8);
                bOut.write(93);
                bOut.write(classData, 0, classData.length);
                byte[] last = index.put(jarEntry.getName(), bOut.toByteArray());
                if (last == null) continue;
                IllegalStateException e = new IllegalStateException("Unable to initialize module: duplicate entry found in jar file");
                statusException = e;
                throw e;
            }
            for (Map.Entry entry : index.entrySet()) {
                byte[] data = (byte[])entry.getValue();
                hMac.update(data, 0, data.length);
            }
            hMac.update((byte)91);
            encName = Strings.toUTF8ByteArray("END");
            hMac.update((byte[])encName, 0, ((Object)encName).length);
            hMac.update((byte)93);
            byte[] hmacResult = new byte[hMac.getMacSize()];
            hMac.doFinal(hmacResult, 0);
            byte[][] byArrayArray = new byte[][]{hmacResult, checksum};
            return byArrayArray;
        }
        finally {
            jIn.close();
        }
    }

    private static String getResourceName() {
        String result = null;
        String markerName = LICENSE.class.getCanonicalName().replace(".", "/").replace("LICENSE", "MARKER");
        String marker = FipsStatus.getMarker(LICENSE.class, markerName);
        if (marker != null) {
            if (marker.startsWith("jar:") && marker.contains("!/")) {
                try {
                    String jarFilename;
                    int secondColon = marker.indexOf(58, 4);
                    if (secondColon == -1) {
                        return null;
                    }
                    result = jarFilename = URLDecoder.decode(marker.substring(secondColon + 1, marker.lastIndexOf("!/")), "UTF-8");
                }
                catch (IOException e) {
                    result = null;
                }
            } else if (marker.startsWith("file:") && marker.endsWith(".jar")) {
                try {
                    String jarFilename;
                    result = jarFilename = URLDecoder.decode(marker.substring("file:".length()), "UTF-8");
                }
                catch (IOException e) {
                    result = null;
                }
            } else {
                if (marker.startsWith("vfs:")) {
                    return marker;
                }
                if (marker.startsWith("jrt:")) {
                    return marker;
                }
                if (marker.startsWith("file:")) {
                    return marker;
                }
                if (FipsStatus.checkValidJarUrl(marker)) {
                    return marker;
                }
            }
        }
        return result;
    }

    static void moveToErrorStatus(String error) {
        FipsStatus.moveToErrorStatus(new FipsOperationError(error));
    }

    static void moveToErrorStatus(FipsOperationError error) {
        statusException = error;
        throw (FipsOperationError)((Object)statusException);
    }

    public static boolean isErrorStatus() {
        return statusException != null;
    }

    static String getMarker(final Class sourceClass, final String markerName) {
        ClassLoader loader = sourceClass.getClassLoader();
        if (loader != null) {
            Object resource = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        CodeSource cs = sourceClass.getProtectionDomain().getCodeSource();
                        return cs.getLocation();
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
            if (resource != null) {
                return resource.toString();
            }
            return loader.getResource(markerName).toString();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return ClassLoader.getSystemResource(markerName).toString();
            }
        });
    }

    private static boolean checkValidJarUrl(String url) {
        return (url.startsWith("http://") || url.startsWith("https://")) && url.endsWith(".jar");
    }

    static class Loader {
        Loader() {
        }

        void run() throws Exception {
            for (String cls : classes) {
                if (FipsStatus.isErrorStatus()) continue;
                FipsStatus.loadClass(cls);
            }
        }
    }
}

