/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.asymmetric.DHDomainParametersID;
import org.bouncycastle.crypto.asymmetric.DHDomainParametersIndex;
import org.bouncycastle.crypto.asymmetric.DHValidationParameters;
import org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import org.bouncycastle.crypto.asymmetric.DSAValidationParameters;
import org.bouncycastle.crypto.fips.DhBasicAgreement;
import org.bouncycastle.crypto.fips.DhKeyPairGenerator;
import org.bouncycastle.crypto.fips.DhParametersGenerator;
import org.bouncycastle.crypto.fips.DhuBasicAgreement;
import org.bouncycastle.crypto.fips.FipsAgreement;
import org.bouncycastle.crypto.fips.FipsAgreementFactory;
import org.bouncycastle.crypto.fips.FipsAgreementParameters;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.fips.FipsDSA;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.MqvBasicAgreement;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.PrimeCertaintyCalculator;
import org.bouncycastle.crypto.internal.params.DhKeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.DhParameters;
import org.bouncycastle.crypto.internal.params.DhPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DhPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.DhuPrivateParameters;
import org.bouncycastle.crypto.internal.params.DhuPublicParameters;
import org.bouncycastle.crypto.internal.params.MqvPrivateParameters;
import org.bouncycastle.crypto.internal.params.MqvPublicParameters;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public final class FipsDH {
    private static final int MIN_FIPS_KEY_STRENGTH = 2048;
    static final FipsEngineProvider<DhBasicAgreement> AGREEMENT_PROVIDER;
    static final FipsEngineProvider<MqvBasicAgreement> MQV_PROVIDER;
    static final FipsEngineProvider<DhuBasicAgreement> DHU_PROVIDER;
    public static final FipsAlgorithm ALGORITHM;
    private static final FipsAlgorithm ALGORITHM_DH;
    private static final FipsAlgorithm ALGORITHM_MQV;
    private static final FipsAlgorithm ALGORITHM_DHU;
    public static final AgreementParameters DH;
    public static final MQVAgreementParametersBuilder MQV;
    public static final DHUAgreementParametersBuilder DHU;

    private FipsDH() {
    }

    private static void validateKeyPair(FipsAlgorithm algorithm, AsymmetricCipherKeyPair keyPair) {
        Variations variation = algorithm == ALGORITHM ? Variations.DH : (Variations)algorithm.basicVariation();
        switch (variation) {
            case DH: {
                SelfTestExecutor.validate(algorithm, keyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair kp) throws Exception {
                        DhBasicAgreement agreement = new DhBasicAgreement();
                        agreement.init(kp.getPrivate());
                        BigInteger agree1 = agreement.calculateAgreement(kp.getPublic());
                        AsymmetricCipherKeyPair testKP = FipsDH.getTestKeyPair(kp);
                        agreement.init(testKP.getPrivate());
                        BigInteger agree2 = agreement.calculateAgreement(testKP.getPublic());
                        agreement.init(kp.getPrivate());
                        BigInteger agree3 = agreement.calculateAgreement(testKP.getPublic());
                        agreement.init(testKP.getPrivate());
                        BigInteger agree4 = agreement.calculateAgreement(kp.getPublic());
                        return !agree1.equals(agree2) && !agree1.equals(agree3) && agree3.equals(agree4);
                    }
                });
                break;
            }
            case MQV: {
                SelfTestExecutor.validate(algorithm, keyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair kp) throws Exception {
                        MqvBasicAgreement agreement = new MqvBasicAgreement();
                        agreement.init(new MqvPrivateParameters((DhPrivateKeyParameters)kp.getPrivate(), (DhPrivateKeyParameters)kp.getPrivate()));
                        BigInteger agree1 = agreement.calculateAgreement(new MqvPublicParameters((DhPublicKeyParameters)kp.getPublic(), (DhPublicKeyParameters)kp.getPublic()));
                        AsymmetricCipherKeyPair testSKP = FipsDH.getTestKeyPair(kp);
                        AsymmetricCipherKeyPair testEKP = FipsDH.getTestKeyPair(kp);
                        agreement.init(new MqvPrivateParameters((DhPrivateKeyParameters)kp.getPrivate(), (DhPrivateKeyParameters)kp.getPrivate()));
                        BigInteger agree2 = agreement.calculateAgreement(new MqvPublicParameters((DhPublicKeyParameters)testSKP.getPublic(), (DhPublicKeyParameters)testEKP.getPublic()));
                        agreement.init(new MqvPrivateParameters((DhPrivateKeyParameters)testSKP.getPrivate(), (DhPrivateKeyParameters)testEKP.getPrivate()));
                        BigInteger agree3 = agreement.calculateAgreement(new MqvPublicParameters((DhPublicKeyParameters)kp.getPublic(), (DhPublicKeyParameters)kp.getPublic()));
                        return !agree1.equals(agree2) && agree2.equals(agree3);
                    }
                });
                break;
            }
            case DHU: {
                SelfTestExecutor.validate(algorithm, keyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair kp) throws Exception {
                        DhuBasicAgreement agreement = new DhuBasicAgreement();
                        agreement.init(new DhuPrivateParameters((DhPrivateKeyParameters)kp.getPrivate(), (DhPrivateKeyParameters)kp.getPrivate()));
                        byte[] agree1 = agreement.calculateAgreement(new DhuPublicParameters((DhPublicKeyParameters)kp.getPublic(), (DhPublicKeyParameters)kp.getPublic()));
                        AsymmetricCipherKeyPair testSKP = FipsDH.getTestKeyPair(kp);
                        AsymmetricCipherKeyPair testEKP = FipsDH.getTestKeyPair(kp);
                        agreement.init(new DhuPrivateParameters((DhPrivateKeyParameters)kp.getPrivate(), (DhPrivateKeyParameters)kp.getPrivate()));
                        byte[] agree2 = agreement.calculateAgreement(new DhuPublicParameters((DhPublicKeyParameters)testSKP.getPublic(), (DhPublicKeyParameters)testEKP.getPublic()));
                        agreement.init(new DhuPrivateParameters((DhPrivateKeyParameters)testSKP.getPrivate(), (DhPrivateKeyParameters)testEKP.getPrivate()));
                        byte[] agree3 = agreement.calculateAgreement(new DhuPublicParameters((DhPublicKeyParameters)kp.getPublic(), (DhPublicKeyParameters)kp.getPublic()));
                        return !Arrays.areEqual(agree1, agree2) && Arrays.areEqual(agree2, agree3);
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled DH algorithm: " + algorithm.getName());
            }
        }
    }

    private static void ffPrimitiveZTest() {
        SelfTestExecutor.validate(ALGORITHM, new VariantInternalKatTest(ALGORITHM){

            @Override
            void evaluate() throws Exception {
                AsymmetricCipherKeyPair kp = FipsDH.getKATKeyPair();
                DhPrivateKeyParameters priv = (DhPrivateKeyParameters)kp.getPrivate();
                DhPublicKeyParameters pub = (DhPublicKeyParameters)kp.getPublic();
                if (!pub.getY().equals(priv.getParameters().getG().modPow(priv.getX(), priv.getParameters().getP()))) {
                    this.fail("FF primitive 'Z' computation failed");
                }
            }
        });
    }

    private static AsymmetricCipherKeyPair getKATKeyPair() {
        DHDomainParameters dhDp = DHDomainParametersIndex.lookupDomainParameters(DomainParameterID.ffdhe2048);
        DhParameters dhParameters = new DhParameters(dhDp.getP(), dhDp.getG(), dhDp.getQ());
        BigInteger x = new BigInteger("80d54802e42ce811d122ce2657c303013fc33c2f08f8ff1a9c4ebfd1", 16);
        BigInteger y = new BigInteger("f9a4d8edb52efa7ffd00bc2e632b79c69eba8949f7ba23a6feb2d27278e96cbd7fe158484286c07f91144a268539eeffb306844898c5efa845070489bcdc756c6858dcb242629f91b2714a33c0efebcb4b0832dba33b12db491dcded86f497094a52a3091a4bdf832d4f36cb0cd7ab05e24b2adea4d746806d9776cebe45b0938c8a7f323db0497f865e8d992839ce018d54b68c5808a97fb035c83c304690e6fff83dfd13be0186bdf0531cc416f9189fe87b1c92ce569578e9f55c874c0111a1e155f4dd876069424d38c94beb47f890d082eb9183a7ce3c6819c420ca91ba969549835314df899fc766ac2acc9d6b9de5b0a9570ca4cfb6187e049fbe6f10", 16);
        return new AsymmetricCipherKeyPair(new DhPublicKeyParameters(y, dhParameters), new DhPrivateKeyParameters(x, dhParameters));
    }

    private static AsymmetricCipherKeyPair getTestKeyPair(AsymmetricCipherKeyPair kp) {
        DhPrivateKeyParameters privKey = (DhPrivateKeyParameters)kp.getPrivate();
        DhParameters dhParams = privKey.getParameters();
        BigInteger testD = privKey.getX().multiply(BigInteger.valueOf(7L)).mod(privKey.getX());
        if (testD.compareTo(BigInteger.valueOf(2L)) < 0) {
            testD = new BigInteger("0102030405060708090a0b0c0d0e0f101112131415161718", 16);
        }
        DhPrivateKeyParameters testPriv = new DhPrivateKeyParameters(testD, dhParams);
        DhPublicKeyParameters testPub = new DhPublicKeyParameters(dhParams.getG().modPow(testD, dhParams.getP()), dhParams);
        return new AsymmetricCipherKeyPair(testPub, testPriv);
    }

    private static DhParameters getDomainParams(DHDomainParameters dhParameters) {
        return new DhParameters(dhParameters.getP(), dhParameters.getG(), dhParameters.getQ(), dhParameters.getM(), dhParameters.getL(), dhParameters.getJ());
    }

    private static DhPrivateKeyParameters getLwKey(final AsymmetricDHPrivateKey privKey) {
        return AccessController.doPrivileged(new PrivilegedAction<DhPrivateKeyParameters>(){

            @Override
            public DhPrivateKeyParameters run() {
                return new DhPrivateKeyParameters(privKey.getX(), FipsDH.getDomainParams(privKey.getDomainParameters()));
            }
        });
    }

    static {
        ALGORITHM = new FipsAlgorithm("DH");
        ALGORITHM_DH = new FipsAlgorithm("DH", (Enum)Variations.DH);
        ALGORITHM_MQV = new FipsAlgorithm("DH", (Enum)Variations.MQV);
        ALGORITHM_DHU = new FipsAlgorithm("DH", (Enum)Variations.DHU);
        DH = new AgreementParameters();
        MQV = new MQVAgreementParametersBuilder();
        DHU = new DHUAgreementParametersBuilder();
        FipsDH.ffPrimitiveZTest();
        AGREEMENT_PROVIDER = new AgreementProvider();
        MQV_PROVIDER = new MqvProvider();
        DHU_PROVIDER = new DhuProvider();
        AGREEMENT_PROVIDER.createEngine();
        MQV_PROVIDER.createEngine();
        DHU_PROVIDER.createEngine();
    }

    public static final class AgreementParameters
    extends FipsAgreementParameters {
        AgreementParameters() {
            this(null);
        }

        private AgreementParameters(FipsAlgorithm digestAlgorithm) {
            super(ALGORITHM, digestAlgorithm);
        }

        private AgreementParameters(FipsKDF.PRF prfAlgorithm, byte[] salt) {
            super(ALGORITHM, prfAlgorithm, salt);
        }

        private AgreementParameters(FipsAlgorithm agreementAlgorithm, FipsKDF.AgreementKDFParametersBuilder kdfType, byte[] iv, int outputSize) {
            super(agreementAlgorithm, kdfType, iv, outputSize);
        }

        public AgreementParameters withDigest(FipsAlgorithm digestAlgorithm) {
            return new AgreementParameters(digestAlgorithm);
        }

        public AgreementParameters withPRF(FipsKDF.PRF prfAlgorithm, byte[] salt) {
            return new AgreementParameters(prfAlgorithm, salt);
        }

        public AgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder kdfType, byte[] iv, int outputSize) {
            return new AgreementParameters(this.getAlgorithm(), kdfType, iv, outputSize);
        }
    }

    private static class AgreementProvider
    extends FipsEngineProvider<DhBasicAgreement> {
        static final BigInteger expected = new BigInteger("b9fab69d21269e002d6b9aed81176320e597a74894dc0827ac7bab12579425b8fd8f067be4d5a2b77cdd018d267f574df6ba4abf22fa354935acaf9edfac9e382b339b1cadd65e43dd7fa842a1c15116dd48d38015232e1bc3447cf52a39997510aaed5bf7e598f43c1d955c50566edb334af270fc904f38ab2d82024fd86718fbe3cd3d397a49c6be00eec903432855ce755ad5661a3730c281d2b182aaa99b7b77607f8394016a3481ba09109932ce2c964312094a260e9b905aed2a63edf308f95822c9876b61c45648263e4f230fa9f9b49c7916abe698d0a77af04032075b3978423822b919bd46a1e892e5404778133128825958059c9606dfa3b93c6e", 16);

        private AgreementProvider() {
        }

        @Override
        public DhBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM_DH, new DhBasicAgreement(), new VariantKatTest<DhBasicAgreement>(){

                @Override
                void evaluate(DhBasicAgreement engine) throws Exception {
                    AsymmetricCipherKeyPair kp = FipsDH.getKATKeyPair();
                    AsymmetricCipherKeyPair testOther = FipsDH.getTestKeyPair(kp);
                    engine.init(kp.getPrivate());
                    if (!expected.equals(engine.calculateAgreement(testOther.getPublic()))) {
                        this.fail("KAT DH agreement not verified");
                    }
                }
            });
        }
    }

    public static final class DHAgreementFactory
    extends FipsAgreementFactory<AgreementParameters> {
        @Override
        public FipsAgreement<AgreementParameters> createAgreement(AsymmetricPrivateKey key, final AgreementParameters parameters) {
            AsymmetricDHPrivateKey dhKey = (AsymmetricDHPrivateKey)key;
            DhPrivateKeyParameters lwDhKey = FipsDH.getLwKey(dhKey);
            final DhBasicAgreement dh = (DhBasicAgreement)AGREEMENT_PROVIDER.createEngine();
            dh.init(lwDhKey);
            return new FipsAgreement<AgreementParameters>(){

                @Override
                public AgreementParameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] calculate(AsymmetricPublicKey key) {
                    AsymmetricDHPublicKey dhKey = (AsymmetricDHPublicKey)key;
                    DhPublicKeyParameters lwDhKey = new DhPublicKeyParameters(dhKey.getY(), FipsDH.getDomainParams(dhKey.getDomainParameters()));
                    int length = dh.getFieldSize();
                    BigInteger z = dh.calculateAgreement(lwDhKey);
                    byte[] zBytes = BigIntegers.asUnsignedByteArray(length, z);
                    return FipsKDF.processZBytes(zBytes, parameters);
                }
            };
        }
    }

    public static final class DHUAgreementFactory
    extends FipsAgreementFactory<DHUAgreementParameters> {
        @Override
        public FipsAgreement<DHUAgreementParameters> createAgreement(AsymmetricPrivateKey key, final DHUAgreementParameters parameters) {
            AsymmetricDHPrivateKey dhKey = (AsymmetricDHPrivateKey)key;
            DhuPrivateParameters lwDhKey = new DhuPrivateParameters(FipsDH.getLwKey(dhKey), FipsDH.getLwKey(parameters.ephemeralPrivateKey));
            final DhuBasicAgreement dh = (DhuBasicAgreement)DHU_PROVIDER.createEngine();
            dh.init(lwDhKey);
            return new FipsAgreement<DHUAgreementParameters>(){

                @Override
                public DHUAgreementParameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] calculate(AsymmetricPublicKey key) {
                    AsymmetricDHPublicKey dhKey = (AsymmetricDHPublicKey)key;
                    DhPublicKeyParameters lwDhKey = new DhPublicKeyParameters(dhKey.getY(), FipsDH.getDomainParams(dhKey.getDomainParameters()));
                    DhuPublicParameters dhuParams = new DhuPublicParameters(lwDhKey, new DhPublicKeyParameters(parameters.otherPartyEphemeralKey.getY(), lwDhKey.getParameters()));
                    byte[] zBytes = dh.calculateAgreement(dhuParams);
                    return FipsKDF.processZBytes(zBytes, parameters);
                }
            };
        }
    }

    public static final class DHUAgreementParameters
    extends FipsAgreementParameters {
        private final AsymmetricDHPublicKey ephemeralPublicKey;
        private final AsymmetricDHPrivateKey ephemeralPrivateKey;
        private final AsymmetricDHPublicKey otherPartyEphemeralKey;

        private DHUAgreementParameters(AsymmetricDHPublicKey ephemeralPublicKey, AsymmetricDHPrivateKey ephemeralPrivateKey, AsymmetricDHPublicKey otherPartyEphemeralKey, FipsAlgorithm digestAlgorithm) {
            super(ALGORITHM_DHU, digestAlgorithm);
            this.ephemeralPublicKey = ephemeralPublicKey;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.otherPartyEphemeralKey = otherPartyEphemeralKey;
        }

        private DHUAgreementParameters(AsymmetricDHPublicKey ephemeralPublicKey, AsymmetricDHPrivateKey ephemeralPrivateKey, AsymmetricDHPublicKey otherPartyEphemeralKey, FipsKDF.PRF prfAlgorithm, byte[] salt) {
            super(ALGORITHM_DHU, prfAlgorithm, salt);
            this.ephemeralPublicKey = ephemeralPublicKey;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.otherPartyEphemeralKey = otherPartyEphemeralKey;
        }

        private DHUAgreementParameters(AsymmetricDHPublicKey ephemeralPublicKey, AsymmetricDHPrivateKey ephemeralPrivateKey, AsymmetricDHPublicKey otherPartyEphemeralKey, FipsKDF.AgreementKDFParametersBuilder kdfType, byte[] iv, int outputSize) {
            super(ALGORITHM_DHU, kdfType, iv, outputSize);
            this.ephemeralPublicKey = ephemeralPublicKey;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.otherPartyEphemeralKey = otherPartyEphemeralKey;
        }

        public AsymmetricDHPublicKey getEphemeralPublicKey() {
            return this.ephemeralPublicKey;
        }

        public AsymmetricDHPrivateKey getEphemeralPrivateKey() {
            return this.ephemeralPrivateKey;
        }

        public AsymmetricDHPublicKey getOtherPartyEphemeralKey() {
            return this.otherPartyEphemeralKey;
        }

        public DHUAgreementParameters withDigest(FipsAlgorithm digestAlgorithm) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, digestAlgorithm);
        }

        public DHUAgreementParameters withPRF(FipsKDF.PRF prfAlgorithm, byte[] salt) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, prfAlgorithm, salt);
        }

        public DHUAgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder kdfType, byte[] iv, int outputSize) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, kdfType, iv, outputSize);
        }
    }

    public static final class DHUAgreementParametersBuilder
    extends FipsParameters {
        DHUAgreementParametersBuilder() {
            super(ALGORITHM_DHU);
        }

        public DHUAgreementParameters using(AsymmetricKeyPair ephemeralKeyPair, AsymmetricDHPublicKey otherPartyEphemeralKey) {
            return new DHUAgreementParameters((AsymmetricDHPublicKey)ephemeralKeyPair.getPublicKey(), (AsymmetricDHPrivateKey)ephemeralKeyPair.getPrivateKey(), otherPartyEphemeralKey, null);
        }

        public DHUAgreementParameters using(AsymmetricDHPrivateKey ephemeralPrivateKey, AsymmetricDHPublicKey otherPartyEphemeralKey) {
            return new DHUAgreementParameters(null, ephemeralPrivateKey, otherPartyEphemeralKey, null);
        }

        public DHUAgreementParameters using(AsymmetricDHPublicKey ephemeralPublicKey, AsymmetricDHPrivateKey ephemeralPrivateKey, AsymmetricDHPublicKey otherPartyEphemeralKey) {
            return new DHUAgreementParameters(ephemeralPublicKey, ephemeralPrivateKey, otherPartyEphemeralKey, null);
        }
    }

    private static class DhuProvider
    extends FipsEngineProvider<DhuBasicAgreement> {
        static final byte[] expected = Hex.decode("b9fab69d21269e002d6b9aed81176320e597a74894dc0827ac7bab12579425b8fd8f067be4d5a2b77cdd018d267f574df6ba4abf22fa354935acaf9edfac9e382b339b1cadd65e43dd7fa842a1c15116dd48d38015232e1bc3447cf52a39997510aaed5bf7e598f43c1d955c50566edb334af270fc904f38ab2d82024fd86718fbe3cd3d397a49c6be00eec903432855ce755ad5661a3730c281d2b182aaa99b7b77607f8394016a3481ba09109932ce2c964312094a260e9b905aed2a63edf308f95822c9876b61c45648263e4f230fa9f9b49c7916abe698d0a77af04032075b3978423822b919bd46a1e892e5404778133128825958059c9606dfa3b93c6eb9fab69d21269e002d6b9aed81176320e597a74894dc0827ac7bab12579425b8fd8f067be4d5a2b77cdd018d267f574df6ba4abf22fa354935acaf9edfac9e382b339b1cadd65e43dd7fa842a1c15116dd48d38015232e1bc3447cf52a39997510aaed5bf7e598f43c1d955c50566edb334af270fc904f38ab2d82024fd86718fbe3cd3d397a49c6be00eec903432855ce755ad5661a3730c281d2b182aaa99b7b77607f8394016a3481ba09109932ce2c964312094a260e9b905aed2a63edf308f95822c9876b61c45648263e4f230fa9f9b49c7916abe698d0a77af04032075b3978423822b919bd46a1e892e5404778133128825958059c9606dfa3b93c6e");

        private DhuProvider() {
        }

        @Override
        public DhuBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM_DHU, new DhuBasicAgreement(), new VariantKatTest<DhuBasicAgreement>(){

                @Override
                void evaluate(DhuBasicAgreement engine) throws Exception {
                    AsymmetricCipherKeyPair kp = FipsDH.getKATKeyPair();
                    AsymmetricCipherKeyPair testSKP = FipsDH.getTestKeyPair(kp);
                    AsymmetricCipherKeyPair testEKP = FipsDH.getTestKeyPair(kp);
                    engine.init(new DhuPrivateParameters((DhPrivateKeyParameters)kp.getPrivate(), (DhPrivateKeyParameters)kp.getPrivate()));
                    byte[] calculated = engine.calculateAgreement(new DhuPublicParameters((DhPublicKeyParameters)testSKP.getPublic(), (DhPublicKeyParameters)testEKP.getPublic()));
                    if (!Arrays.areEqual(expected, calculated)) {
                        this.fail("KAT DH DHU agreement not verified");
                    }
                }
            });
        }
    }

    public static final class DomainGenParameters
    extends FipsParameters {
        private final int L;
        private final int N;
        private final int certainty;
        private final BigInteger p;
        private final BigInteger q;
        private final byte[] seed;
        private final int usageIndex;

        public DomainGenParameters(int strength) {
            this(strength, strength > 1024 ? 256 : 160, PrimeCertaintyCalculator.getDefaultCertainty(strength));
        }

        public DomainGenParameters(int strength, int certainty) {
            this(strength, strength > 1024 ? 256 : 160, certainty);
        }

        public DomainGenParameters(int L, int N, int certainty) {
            this(L, N, certainty, null, null, null, -1);
        }

        public DomainGenParameters(int L, int N, int certainty, int usageIndex) {
            this(L, N, certainty, null, null, null, usageIndex);
        }

        public DomainGenParameters(BigInteger p, BigInteger q) {
            this(p.bitLength(), q.bitLength(), 0, p, q, null, -1);
        }

        public DomainGenParameters(BigInteger p, BigInteger q, byte[] seed, int usageIndex) {
            this(p.bitLength(), q.bitLength(), 0, p, q, Arrays.clone(seed), usageIndex);
        }

        private DomainGenParameters(int L, int N, int certainty, BigInteger p, BigInteger q, byte[] seed, int usageIndex) {
            super(ALGORITHM);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && p == null && certainty < PrimeCertaintyCalculator.getDefaultCertainty(L)) {
                throw new FipsUnapprovedOperationError("Prime generation certainty " + certainty + " inadequate for parameters of " + L + " bits", this.getAlgorithm());
            }
            if (usageIndex > 255) {
                throw new IllegalArgumentException("Usage index must be in range 0 to 255 (or -1 to ignore)");
            }
            this.L = L;
            this.N = N;
            this.certainty = certainty;
            this.p = p;
            this.q = q;
            this.seed = seed;
            this.usageIndex = usageIndex;
        }
    }

    public static enum DomainParameterID implements DHDomainParametersID
    {
        ffdhe2048("ffdhe2048"),
        ffdhe3072("ffdhe3072"),
        ffdhe4096("ffdhe4096"),
        ffdhe6144("ffdhe6144"),
        ffdhe8192("ffdhe8192"),
        modp2048("modp2048"),
        modp3072("modp3072"),
        modp4096("modp4096"),
        modp6144("modp6144"),
        modp8192("modp8192");

        private final String name;

        private DomainParameterID(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static final class DomainParametersGenerator {
        private final SecureRandom random;
        private final DomainGenParameters parameters;
        private final FipsDigestAlgorithm digestAlgorithm;

        public DomainParametersGenerator(DomainGenParameters parameters, SecureRandom random) {
            this(FipsSHS.Algorithm.SHA256, parameters, random);
        }

        public DomainParametersGenerator(FipsDigestAlgorithm digestAlgorithm, DomainGenParameters parameters, SecureRandom random) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                int effSizeInBits = parameters.L;
                if (effSizeInBits < 2048) {
                    throw new FipsUnapprovedOperationError("Attempt to create parameters with unapproved key size [" + effSizeInBits + "]", ALGORITHM);
                }
                Utils.validateRandom(random, Utils.getAsymmetricSecurityStrength(effSizeInBits), ALGORITHM, "Attempt to create parameters with unapproved RNG");
            }
            this.digestAlgorithm = digestAlgorithm;
            this.parameters = parameters;
            this.random = random;
        }

        public DHDomainParameters generateDomainParameters() {
            if (this.parameters.L < 2048) {
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    throw new FipsUnapprovedOperationError("Requested DH parameter strength too small for approved mode: " + this.parameters.L);
                }
                DhParametersGenerator pGen = new DhParametersGenerator();
                pGen.init(this.parameters.L, this.parameters.certainty, this.random);
                DhParameters p = pGen.generateParameters();
                return new DHDomainParameters(p.getP(), p.getQ(), p.getG(), p.getJ(), null);
            }
            FipsDSA.DomainGenParameters params = new FipsDSA.DomainGenParameters(this.parameters.L, this.parameters.N, this.parameters.certainty, this.parameters.p, this.parameters.q, this.parameters.seed, this.parameters.usageIndex);
            FipsDSA.DomainParametersGenerator pGen = new FipsDSA.DomainParametersGenerator(this.digestAlgorithm, params, this.random);
            DSADomainParameters domainParameters = pGen.generateDomainParameters();
            DSAValidationParameters vParams = domainParameters.getValidationParameters();
            if (vParams != null) {
                return new DHDomainParameters(domainParameters.getP(), domainParameters.getQ(), domainParameters.getG(), null, new DHValidationParameters(vParams.getSeed(), vParams.getCounter(), vParams.getUsageIndex()));
            }
            return new DHDomainParameters(domainParameters.getP(), domainParameters.getQ(), domainParameters.getG());
        }
    }

    public static final class KeyGenParameters
    extends FipsParameters {
        private final DHDomainParameters domainParameters;

        public KeyGenParameters(DHDomainParameters domainParameters) {
            this(ALGORITHM, domainParameters);
        }

        public KeyGenParameters(AgreementParameters parameters, DHDomainParameters domainParameters) {
            this(parameters.getAlgorithm(), domainParameters);
        }

        public KeyGenParameters(MQVAgreementParametersBuilder builder, DHDomainParameters domainParameters) {
            this(builder.getAlgorithm(), domainParameters);
        }

        public KeyGenParameters(DHUAgreementParametersBuilder builder, DHDomainParameters domainParameters) {
            this(builder.getAlgorithm(), domainParameters);
        }

        private KeyGenParameters(FipsAlgorithm algorithm, DHDomainParameters domainParameters) {
            super(algorithm);
            this.domainParameters = domainParameters;
        }

        public DHDomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    public static final class KeyPairGenerator
    extends FipsAsymmetricKeyPairGenerator {
        private final DhKeyPairGenerator engine = new DhKeyPairGenerator();
        private final DHDomainParameters domainParameters;
        private final DhKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom random) {
            super(keyGenParameters);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                int sizeInBits = keyGenParameters.domainParameters.getP().bitLength();
                if (sizeInBits < 2048) {
                    throw new FipsUnapprovedOperationError("Attempt to create key of less than 2048 bits", keyGenParameters.getAlgorithm());
                }
                Utils.validateKeyPairGenRandom(random, Utils.getAsymmetricSecurityStrength(sizeInBits), ALGORITHM);
            }
            this.param = new DhKeyGenerationParameters(random, FipsDH.getDomainParams(keyGenParameters.getDomainParameters()));
            this.domainParameters = keyGenParameters.getDomainParameters();
            this.engine.init(this.param);
        }

        public AsymmetricKeyPair<AsymmetricDHPublicKey, AsymmetricDHPrivateKey> generateKeyPair() {
            AsymmetricCipherKeyPair kp = this.engine.generateKeyPair();
            DhPublicKeyParameters pubKey = (DhPublicKeyParameters)kp.getPublic();
            DhPrivateKeyParameters prvKey = (DhPrivateKeyParameters)kp.getPrivate();
            FipsAlgorithm algorithm = (FipsAlgorithm)this.getParameters().getAlgorithm();
            FipsDH.validateKeyPair(algorithm, kp);
            return new AsymmetricKeyPair<AsymmetricDHPublicKey, AsymmetricDHPrivateKey>(new AsymmetricDHPublicKey(algorithm, this.domainParameters, pubKey.getY()), new AsymmetricDHPrivateKey(algorithm, this.domainParameters, prvKey.getX()));
        }
    }

    public static final class MQVAgreementFactory
    extends FipsAgreementFactory<MQVAgreementParameters> {
        @Override
        public FipsAgreement<MQVAgreementParameters> createAgreement(AsymmetricPrivateKey key, final MQVAgreementParameters parameters) {
            AsymmetricDHPrivateKey dhKey = (AsymmetricDHPrivateKey)key;
            DhPrivateKeyParameters lwDHKey = FipsDH.getLwKey(dhKey);
            final MqvBasicAgreement mqv = (MqvBasicAgreement)MQV_PROVIDER.createEngine();
            mqv.init(new MqvPrivateParameters(lwDHKey, parameters.ephemeralPrivateKey == null ? lwDHKey : FipsDH.getLwKey(parameters.ephemeralPrivateKey)));
            return new FipsAgreement<MQVAgreementParameters>(){

                @Override
                public MQVAgreementParameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] calculate(AsymmetricPublicKey key) {
                    AsymmetricDHPublicKey dhKey = (AsymmetricDHPublicKey)key;
                    DhPublicKeyParameters lwDhKey = new DhPublicKeyParameters(dhKey.getY(), FipsDH.getDomainParams(dhKey.getDomainParameters()));
                    int length = mqv.getFieldSize();
                    AsymmetricDHPublicKey ephPublicKey = parameters.getOtherPartyEphemeralKey();
                    BigInteger z = mqv.calculateAgreement(new MqvPublicParameters(lwDhKey, new DhPublicKeyParameters(ephPublicKey.getY(), FipsDH.getDomainParams(ephPublicKey.getDomainParameters()))));
                    byte[] zBytes = BigIntegers.asUnsignedByteArray(length, z);
                    return FipsKDF.processZBytes(zBytes, parameters);
                }
            };
        }
    }

    public static final class MQVAgreementParameters
    extends FipsAgreementParameters {
        private final AsymmetricDHPublicKey ephemeralPublicKey;
        private final AsymmetricDHPrivateKey ephemeralPrivateKey;
        private final AsymmetricDHPublicKey otherPartyEphemeralKey;

        private MQVAgreementParameters(AsymmetricDHPublicKey ephemeralPublicKey, AsymmetricDHPrivateKey ephemeralPrivateKey, AsymmetricDHPublicKey otherPartyEphemeralKey, FipsAlgorithm digestAlgorithm) {
            super(ALGORITHM_MQV, digestAlgorithm);
            this.ephemeralPublicKey = ephemeralPublicKey;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.otherPartyEphemeralKey = otherPartyEphemeralKey;
        }

        private MQVAgreementParameters(AsymmetricDHPublicKey ephemeralPublicKey, AsymmetricDHPrivateKey ephemeralPrivateKey, AsymmetricDHPublicKey otherPartyEphemeralKey, FipsKDF.PRF prfAlgorithm, byte[] salt) {
            super(ALGORITHM_MQV, prfAlgorithm, salt);
            this.ephemeralPublicKey = ephemeralPublicKey;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.otherPartyEphemeralKey = otherPartyEphemeralKey;
        }

        private MQVAgreementParameters(AsymmetricDHPublicKey ephemeralPublicKey, AsymmetricDHPrivateKey ephemeralPrivateKey, AsymmetricDHPublicKey otherPartyEphemeralKey, FipsKDF.AgreementKDFParametersBuilder kdfType, byte[] iv, int outputSize) {
            super(ALGORITHM_MQV, kdfType, iv, outputSize);
            this.ephemeralPublicKey = ephemeralPublicKey;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.otherPartyEphemeralKey = otherPartyEphemeralKey;
        }

        public AsymmetricDHPublicKey getEphemeralPublicKey() {
            return this.ephemeralPublicKey;
        }

        public AsymmetricDHPrivateKey getEphemeralPrivateKey() {
            return this.ephemeralPrivateKey;
        }

        public AsymmetricDHPublicKey getOtherPartyEphemeralKey() {
            return this.otherPartyEphemeralKey;
        }

        public MQVAgreementParameters withDigest(FipsAlgorithm digestAlgorithm) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, digestAlgorithm);
        }

        public MQVAgreementParameters withPRF(FipsKDF.PRF prfAlgorithm, byte[] salt) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, prfAlgorithm, salt);
        }

        public MQVAgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder kdfType, byte[] iv, int outputSize) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, kdfType, iv, outputSize);
        }
    }

    public static final class MQVAgreementParametersBuilder
    extends FipsParameters {
        MQVAgreementParametersBuilder() {
            super(ALGORITHM_MQV);
        }

        public MQVAgreementParameters using(AsymmetricKeyPair ephemeralKeyPair, AsymmetricDHPublicKey otherPartyEphemeralKey) {
            return new MQVAgreementParameters((AsymmetricDHPublicKey)ephemeralKeyPair.getPublicKey(), (AsymmetricDHPrivateKey)ephemeralKeyPair.getPrivateKey(), otherPartyEphemeralKey, null);
        }

        public MQVAgreementParameters using(AsymmetricDHPrivateKey ephemeralPrivateKey, AsymmetricDHPublicKey otherPartyEphemeralKey) {
            return new MQVAgreementParameters(null, ephemeralPrivateKey, otherPartyEphemeralKey, null);
        }

        public MQVAgreementParameters using(AsymmetricDHPublicKey ephemeralPublicKey, AsymmetricDHPrivateKey ephemeralPrivateKey, AsymmetricDHPublicKey otherPartyEphemeralKey) {
            return new MQVAgreementParameters(ephemeralPublicKey, ephemeralPrivateKey, otherPartyEphemeralKey, null);
        }
    }

    private static class MqvProvider
    extends FipsEngineProvider<MqvBasicAgreement> {
        static final BigInteger expected = new BigInteger("fb6ad631bae112b5d2a24fa6e821cd3b1f5e70c352b66b83d348a1e4c825bb3b58048f8b1551ee01880d0e513b55e62b2f5389946716561bdb922b86841c311ebe34debb24f0f21a09fa5e383787b36d7c1998b4d6aa9a895859258217c303fedabceb7fe8f1021330a1780e93aca20088394d15b98dfbf5ef3820678feaca7b5c58ebf2b72f0ed4cddd4d8c70ef3a6d34c88f18d4f7bcdca07d5d8194f9db00f7f900c9bf7d7c25cccc94dd94c4a7dc03c3b6fa77dcf2725d3f850da278a5d1d16cf99e2abedbb5ba444bd0bdf7d6decef0d1d1f72f17e255ec9a4edb1c5db833fb65e8b604b00bd542043ed2562c1e1f5cce36fbfe4ba400e61c32622d6dd7", 16);

        private MqvProvider() {
        }

        @Override
        public MqvBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM_MQV, new MqvBasicAgreement(), new VariantKatTest<MqvBasicAgreement>(){

                @Override
                void evaluate(MqvBasicAgreement engine) throws Exception {
                    AsymmetricCipherKeyPair kp = FipsDH.getKATKeyPair();
                    AsymmetricCipherKeyPair testSKP = FipsDH.getTestKeyPair(kp);
                    AsymmetricCipherKeyPair testEKP = FipsDH.getTestKeyPair(kp);
                    engine.init(new MqvPrivateParameters((DhPrivateKeyParameters)kp.getPrivate(), (DhPrivateKeyParameters)kp.getPrivate()));
                    BigInteger calculated = engine.calculateAgreement(new MqvPublicParameters((DhPublicKeyParameters)testSKP.getPublic(), (DhPublicKeyParameters)testEKP.getPublic()));
                    if (!expected.equals(calculated)) {
                        this.fail("KAT DH MQV agreement not verified");
                    }
                }
            });
        }
    }

    private static enum Variations {
        DH,
        MQV,
        DHU;

    }
}

