/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.SHAKEDigest;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.XofUtils;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

class CSHAKEDigest
extends SHAKEDigest {
    private static final byte[] ZERO_BYTE = new byte[1];
    private static final byte[] padding = new byte[100];
    private final byte[] diff;

    CSHAKEDigest(CSHAKEDigest source) {
        super(source);
        this.diff = Arrays.clone(source.diff);
    }

    CSHAKEDigest(int bitLength, byte[] N, byte[] S) {
        super(bitLength);
        if (bitLength == 128) {
            SelfTestExecutor.validate((FipsAlgorithm)FipsSHS.Algorithm.cSHAKE128, this, new KatTest(Hex.decode("5881092dd818bf5cf8a3ddb793fbcba74097d5c526a6d35f97b83351940f2cc8")));
        } else {
            SelfTestExecutor.validate((FipsAlgorithm)FipsSHS.Algorithm.cSHAKE256, this, new KatTest(Hex.decode("483366601360a8771c6863080cc4114d8db44530f8f1e1ee4f94ea37e78b5739d5a15bef186a5386c75744c0527e1faa9f8726e462a12a4feb06bd8801e751e4")));
        }
        if (!(N != null && N.length != 0 || S != null && S.length != 0)) {
            this.diff = null;
        } else {
            this.diff = Arrays.concatenate(XofUtils.leftEncode(this.rate / 8), this.encodeString(N), this.encodeString(S));
            this.diffPadAndAbsorb();
        }
    }

    private void diffPadAndAbsorb() {
        int blockSize = this.rate / 8;
        this.absorb(this.diff, 0, this.diff.length * 8);
        int delta = this.diff.length % blockSize;
        if (delta != 0) {
            int required;
            for (required = blockSize - delta; required > padding.length; required -= padding.length) {
                this.absorb(padding, 0, padding.length * 8);
            }
            this.absorb(padding, 0, required * 8);
        }
    }

    private byte[] encodeString(byte[] str) {
        if (str == null || str.length == 0) {
            return XofUtils.leftEncode(0L);
        }
        return Arrays.concatenate(XofUtils.leftEncode((long)str.length * 8L), str);
    }

    @Override
    public String getAlgorithmName() {
        return "CSHAKE" + this.fixedOutputLength;
    }

    @Override
    public int doOutput(byte[] out, int outOff, int outLen) {
        if (this.diff != null) {
            if (!this.squeezing) {
                this.absorb(ZERO_BYTE, 0, 2L);
            }
            this.squeeze(out, outOff, (long)outLen * 8L);
            return outLen;
        }
        return super.doOutput(out, outOff, outLen);
    }

    @Override
    public void reset() {
        super.reset();
        if (this.diff != null) {
            this.diffPadAndAbsorb();
        }
    }

    private static class KatTest<T extends Digest>
    implements BasicKatTest<T> {
        private static final byte[] stdShaVector = Strings.toByteArray("abc");
        private final byte[] kat;

        KatTest(byte[] kat) {
            this.kat = kat;
        }

        @Override
        public boolean hasTestPassed(Digest digest) {
            digest.update(stdShaVector, 0, stdShaVector.length);
            byte[] result = new byte[digest.getDigestSize()];
            digest.doFinal(result, 0);
            digest.reset();
            return Arrays.areEqual(result, this.kat);
        }
    }
}

