/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAKey;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.util.BigIntegers;

public final class AsymmetricRSAPrivateKey
extends AsymmetricRSAKey
implements Destroyable,
AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger p;
    private BigInteger q;
    private BigInteger dp;
    private BigInteger dq;
    private BigInteger qInv;
    private int hashCode;

    public AsymmetricRSAPrivateKey(Algorithm algorithm, BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger p, BigInteger q, BigInteger dp, BigInteger dq, BigInteger qInv) {
        super(algorithm, modulus);
        this.publicExponent = publicExponent;
        this.privateExponent = privateExponent;
        this.p = p;
        this.q = q;
        this.dp = dp;
        this.dq = dq;
        this.qInv = qInv;
        this.hashCode = this.calculateHashCode();
        BigInteger pSub1 = p.subtract(BigIntegers.ONE);
        BigInteger qSub1 = q.subtract(BigIntegers.ONE);
        boolean valid = p.multiply(q).equals(modulus);
        valid &= dp.compareTo(BigIntegers.ONE) > 0 & dp.compareTo(pSub1) < 0 & dp.multiply(publicExponent).mod(pSub1).equals(BigIntegers.ONE);
        valid &= dq.compareTo(BigIntegers.ONE) > 0 & dq.compareTo(qSub1) < 0 & dq.multiply(publicExponent).mod(qSub1).equals(BigIntegers.ONE);
        if (!(valid &= qInv.compareTo(BigIntegers.ONE) > 0 & qInv.compareTo(p) < 0 & qInv.multiply(q).mod(p).equals(BigIntegers.ONE))) {
            throw new IllegalArgumentException("private values mismatch");
        }
    }

    public AsymmetricRSAPrivateKey(Algorithm algorithm, BigInteger modulus, BigInteger privateExponent) {
        super(algorithm, modulus);
        this.privateExponent = privateExponent;
        this.publicExponent = BigInteger.ZERO;
        this.p = BigInteger.ZERO;
        this.q = BigInteger.ZERO;
        this.dp = BigInteger.ZERO;
        this.dq = BigInteger.ZERO;
        this.qInv = BigInteger.ZERO;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricRSAPrivateKey(Algorithm algorithm, byte[] privateKeyInfoEncoding) {
        this(algorithm, AsymmetricRSAPrivateKey.getPrivateKeyInfo(privateKeyInfoEncoding));
    }

    public AsymmetricRSAPrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        this(algorithm, privateKeyInfo.getPrivateKeyAlgorithm(), AsymmetricRSAPrivateKey.parsePrivateKey(privateKeyInfo));
    }

    private static PrivateKeyInfo getPrivateKeyInfo(byte[] encoding) {
        try {
            return PrivateKeyInfo.getInstance(encoding);
        }
        catch (IllegalArgumentException e) {
            try {
                return new PrivateKeyInfo(DEF_ALG_ID, ASN1Sequence.getInstance(encoding));
            }
            catch (IOException e1) {
                throw new IllegalArgumentException("Unable to parse private key: " + e.getMessage(), e);
            }
        }
    }

    private static RSAPrivateKey parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            return RSAPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse private key: " + e.getMessage(), e);
        }
    }

    private AsymmetricRSAPrivateKey(Algorithm algorithm, AlgorithmIdentifier algId, RSAPrivateKey privKey) {
        super(algorithm, algId, KeyUtils.validatedModulus(privKey.getModulus()));
        this.publicExponent = privKey.getPublicExponent();
        this.privateExponent = privKey.getPrivateExponent();
        this.p = privKey.getPrime1();
        this.q = privKey.getPrime2();
        this.dp = privKey.getExponent1();
        this.dq = privKey.getExponent2();
        this.qInv = privKey.getCoefficient();
        this.hashCode = this.calculateHashCode();
    }

    @Override
    public Algorithm getAlgorithm() {
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    @Override
    public BigInteger getModulus() {
        BigInteger rv = super.getModulus();
        KeyUtils.checkDestroyed(this);
        return rv;
    }

    public BigInteger getPublicExponent() {
        BigInteger rv = this.publicExponent;
        KeyUtils.checkDestroyed(this);
        return rv;
    }

    public BigInteger getPrivateExponent() {
        return this.fieldValue(this.privateExponent);
    }

    public BigInteger getP() {
        return this.fieldValue(this.p);
    }

    public BigInteger getQ() {
        return this.fieldValue(this.q);
    }

    public BigInteger getDP() {
        return this.fieldValue(this.dp);
    }

    public BigInteger getDQ() {
        return this.fieldValue(this.dq);
    }

    public BigInteger getQInv() {
        return this.fieldValue(this.qInv);
    }

    @Override
    public final byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkDestroyed(this);
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        return KeyUtils.getEncodedPrivateKeyInfo(this.rsaAlgIdentifier, new RSAPrivateKey(this.getModulus(), this.publicExponent, this.getPrivateExponent(), this.getP(), this.getQ(), this.getDP(), this.getDQ(), this.getQInv()));
    }

    @Override
    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.publicExponent = null;
            this.privateExponent = null;
            this.qInv = null;
            this.dq = null;
            this.dp = null;
            this.q = null;
            this.p = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    @Override
    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    @Override
    public boolean equals(Object o) {
        this.checkApprovedOnlyModeStatus();
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricRSAPrivateKey)) {
            return false;
        }
        AsymmetricRSAPrivateKey other = (AsymmetricRSAPrivateKey)o;
        other.checkApprovedOnlyModeStatus();
        return KeyUtils.isFieldEqual(this.modulus, other.modulus) && KeyUtils.isFieldEqual(this.privateExponent, other.privateExponent) && KeyUtils.isFieldEqual(this.publicExponent, other.publicExponent) && KeyUtils.isFieldEqual(this.p, other.p) && KeyUtils.isFieldEqual(this.q, other.q) && KeyUtils.isFieldEqual(this.dp, other.dp) && KeyUtils.isFieldEqual(this.dq, other.dq) && KeyUtils.isFieldEqual(this.qInv, other.qInv);
    }

    @Override
    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result = this.getModulus().hashCode();
        result = 31 * result + this.publicExponent.hashCode();
        result = 31 * result + this.privateExponent.hashCode();
        result = 31 * result + this.p.hashCode();
        result = 31 * result + this.q.hashCode();
        result = 31 * result + this.dp.hashCode();
        result = 31 * result + this.dq.hashCode();
        result = 31 * result + this.qInv.hashCode();
        return result;
    }

    private void checkCanRead() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
    }

    private BigInteger fieldValue(BigInteger value) {
        this.checkCanRead();
        return value;
    }
}

