/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.iso.ISOIECObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.AsymmetricOperatorFactory;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.KeyWrapOperatorFactory;
import org.bouncycastle.crypto.OutputSigner;
import org.bouncycastle.crypto.OutputValidator;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.SignatureOperatorFactory;
import org.bouncycastle.crypto.SignatureWithMessageRecoveryOperatorFactory;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPublicKey;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsEncapsulatedSecretExtractor;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsRSA;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.RSA;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.internal.asn1.cms.GenericHybridParameters;
import org.bouncycastle.internal.asn1.cms.RsaKemParameters;
import org.bouncycastle.jcajce.AgreedKeyWithMacKey;
import org.bouncycastle.jcajce.KTSKeyWithEncapsulation;
import org.bouncycastle.jcajce.ZeroizableSecretKey;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BaseSignature;
import org.bouncycastle.jcajce.provider.BaseSingleBlockCipher;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.DigestUtil;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.KeyIvSizeProvider;
import org.bouncycastle.jcajce.provider.KtsCipherSpi;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvRSAPrivateCrtKey;
import org.bouncycastle.jcajce.provider.ProvRSAPrivateKey;
import org.bouncycastle.jcajce.provider.ProvRSAPublicKey;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.provider.X509AlgorithmParameters;
import org.bouncycastle.jcajce.spec.KTSExtractKeySpec;
import org.bouncycastle.jcajce.spec.KTSGenerateKeySpec;
import org.bouncycastle.jcajce.spec.KTSKeySpec;
import org.bouncycastle.jcajce.spec.KTSParameterSpec;
import org.bouncycastle.jcajce.spec.KTSWithKEMKWSKeySpec;
import org.bouncycastle.jcajce.util.MessageDigestUtils;
import org.bouncycastle.util.Arrays;

class ProvRSA
extends AsymmetricAlgorithmProvider {
    private static final KeyIvSizeProvider keySizeProvider = new KeyIvSizeProvider();
    private final SignatureOperatorFactory fipsRsaSigFactory = new FipsRSA.SignatureOperatorFactory();
    private SignatureOperatorFactory generalRsaSigFactory = this.getGeneralSigFactory();
    private SignatureWithMessageRecoveryOperatorFactory recoveryRsaSigFactory = this.getRecoverySigFactory();
    private AsymmetricOperatorFactory singleBlockFactory;
    private KeyWrapOperatorFactory generalKeyWrapFactory;
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.asymmetric.rsa.";
    private final FipsAlgorithm[] fipsAlgorithms = new FipsAlgorithm[]{FipsRSA.WRAP_PKCS1v1_5.getAlgorithm(), FipsRSA.WRAP_OAEP.getAlgorithm()};
    private final GeneralAlgorithm[] generalAlgorithms = new GeneralAlgorithm[]{RSA.ALGORITHM, (GeneralAlgorithm)RSA.WRAP_PKCS1v1_5.getAlgorithm(), (GeneralAlgorithm)RSA.WRAP_OAEP.getAlgorithm()};
    private static final PublicKeyConverter<AsymmetricRSAPublicKey> publicKeyConverter = new PublicKeyConverter<AsymmetricRSAPublicKey>(){

        @Override
        public AsymmetricRSAPublicKey convertKey(Algorithm algorithm, PublicKey key) throws InvalidKeyException {
            if (key instanceof RSAPublicKey) {
                if (key instanceof ProvRSAPublicKey) {
                    return ((ProvRSAPublicKey)key).getBaseKey();
                }
                return new ProvRSAPublicKey(algorithm, (RSAPublicKey)key).getBaseKey();
            }
            try {
                return new AsymmetricRSAPublicKey(algorithm, SubjectPublicKeyInfo.getInstance(Utils.getKeyEncoding(key)));
            }
            catch (Exception e) {
                throw new InvalidKeyException("Cannot identify RSA public key: " + e.getMessage(), e);
            }
        }
    };
    private static final PrivateKeyConverter<AsymmetricRSAPrivateKey> privateKeyConverter = new PrivateKeyConverter<AsymmetricRSAPrivateKey>(){

        @Override
        public AsymmetricRSAPrivateKey convertKey(Algorithm algorithm, PrivateKey key) throws InvalidKeyException {
            if (key instanceof RSAPrivateCrtKey) {
                if (key instanceof ProvRSAPrivateCrtKey) {
                    return ((ProvRSAPrivateCrtKey)key).getBaseKey();
                }
                return new ProvRSAPrivateCrtKey(algorithm, (RSAPrivateCrtKey)key).getBaseKey();
            }
            if (key instanceof RSAPrivateKey) {
                if (key instanceof ProvRSAPrivateKey) {
                    return ((ProvRSAPrivateKey)key).getBaseKey();
                }
                return new ProvRSAPrivateKey(algorithm, (RSAPrivateKey)key).getBaseKey();
            }
            try {
                return new AsymmetricRSAPrivateKey(algorithm, PrivateKeyInfo.getInstance(Utils.getKeyEncoding(key)));
            }
            catch (Exception e) {
                throw new InvalidKeyException("Cannot identify RSA private key: " + e.getMessage(), e);
            }
        }
    };
    private static final Map<ASN1ObjectIdentifier, FipsKDF.AgreementKDFPRF> kdfPRF = new HashMap<ASN1ObjectIdentifier, FipsKDF.AgreementKDFPRF>();
    private static final Map<ASN1ObjectIdentifier, String> wrapNames = new HashMap<ASN1ObjectIdentifier, String>();
    private static final Map<String, String> generalRsaAttributes = new HashMap<String, String>();

    ProvRSA() {
    }

    private AsymmetricOperatorFactory getGeneralEncryptionFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (this.singleBlockFactory == null) {
            this.singleBlockFactory = new RSA.OperatorFactory();
        }
        return this.singleBlockFactory;
    }

    private KeyWrapOperatorFactory getGeneralWrappingFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (this.generalKeyWrapFactory == null) {
            this.generalKeyWrapFactory = new RSA.KeyWrapOperatorFactory();
        }
        return this.generalKeyWrapFactory;
    }

    private SignatureOperatorFactory getGeneralSigFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (this.generalRsaSigFactory == null) {
            this.generalRsaSigFactory = new RSA.SignatureOperatorFactory();
        }
        return this.generalRsaSigFactory;
    }

    private SignatureWithMessageRecoveryOperatorFactory getRecoverySigFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (this.recoveryRsaSigFactory == null) {
            this.recoveryRsaSigFactory = new RSA.SignatureWithMessageRecoveryOperatorFactory();
        }
        return this.recoveryRsaSigFactory;
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("AlgorithmParameters.OAEP", "org.bouncycastle.jcajce.provider.asymmetric.rsa.AlgorithmParametersSpi$OAEP", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new OAEPAlgorithmParameters();
            }
        });
        provider.addAlias("AlgorithmParameters", "OAEP", PKCSObjectIdentifiers.id_RSAES_OAEP);
        provider.addAlgorithmImplementation("AlgorithmParameters.PSS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.AlgorithmParametersSpi$PSS", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new PSSAlgorithmParameters();
            }
        });
        provider.addAlias("AlgorithmParameters", "PSS", "RSAPSS", "RSA-PSS", "RSASSA-PSS");
        provider.addAlias("AlgorithmParameters", "PSS", PKCSObjectIdentifiers.id_RSASSA_PSS);
        EngineCreator rsaCreator = new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    return this.build(ProvRSA.this.fipsAlgorithms);
                }
                return this.build(ProvRSA.this.generalAlgorithms);
            }

            private BaseSingleBlockCipher build(Algorithm[] algorithms) {
                return new BaseSingleBlockCipher.Builder(provider, algorithms).setWrapModeOnly(CryptoServicesRegistrar.isInApprovedOnlyMode()).withFipsOperators(null, new FipsRSA.KeyWrapOperatorFactory()).withGeneralOperators(ProvRSA.this.getGeneralEncryptionFactory(), ProvRSA.this.getGeneralWrappingFactory()).withPublicKeyConverter(publicKeyConverter).withPrivateKeyConverter(privateKeyConverter).withParametersCreatorProvider(new ParametersCreatorProvider(){

                    public ParametersCreator get(final Parameters parameters) {
                        return new ParametersCreator(){

                            public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) {
                                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                                    if (parameters.getAlgorithm() == FipsRSA.WRAP_OAEP.getAlgorithm()) {
                                        return ProvRSA.createFipsOaepParameters((OAEPParameterSpec)spec);
                                    }
                                    return FipsRSA.WRAP_PKCS1v1_5;
                                }
                                if (parameters.getAlgorithm() == RSA.WRAP_OAEP.getAlgorithm()) {
                                    OAEPParameterSpec oaepSpec = (OAEPParameterSpec)spec;
                                    DigestAlgorithm digest = Utils.digestNameToAlgMap.get(oaepSpec.getDigestAlgorithm());
                                    MGF1ParameterSpec mgfParams = (MGF1ParameterSpec)oaepSpec.getMGFParameters();
                                    DigestAlgorithm mgfDigest = Utils.digestNameToAlgMap.get(mgfParams.getDigestAlgorithm());
                                    return RSA.WRAP_OAEP.withDigest(digest).withMGFDigest(mgfDigest).withEncodingParams(((PSource.PSpecified)oaepSpec.getPSource()).getValue());
                                }
                                if (parameters.getAlgorithm() == RSA.WRAP_PKCS1v1_5.getAlgorithm()) {
                                    return RSA.WRAP_PKCS1v1_5;
                                }
                                return RSA.RAW;
                            }
                        };
                    }
                }).build();
            }
        };
        GuardedEngineCreator pkcs1v15Creator = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSingleBlockCipher.Builder(provider, RSA.WRAP_PKCS1v1_5).withGeneralOperators(ProvRSA.this.getGeneralEncryptionFactory(), ProvRSA.this.getGeneralWrappingFactory()).withPublicKeyConverter(publicKeyConverter).withPrivateKeyConverter(privateKeyConverter).withParametersCreatorProvider(new ParametersCreatorProvider(){

                    public ParametersCreator get(Parameters algorithm) {
                        return new ParametersCreator(){

                            public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) {
                                return RSA.WRAP_PKCS1v1_5;
                            }
                        };
                    }
                }).build();
            }
        });
        GuardedEngineCreator pkcs1v15CreatorPrivate = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSingleBlockCipher.Builder(provider, RSA.WRAP_PKCS1v1_5).withGeneralOperators(ProvRSA.this.getGeneralEncryptionFactory(), ProvRSA.this.getGeneralWrappingFactory()).withPublicKeyConverter(publicKeyConverter).withPrivateKeyConverter(privateKeyConverter).setPrivateKeyOnly(true).withParametersCreatorProvider(new ParametersCreatorProvider(){

                    public ParametersCreator get(Parameters algorithm) {
                        return new ParametersCreator(){

                            public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) {
                                return RSA.WRAP_PKCS1v1_5;
                            }
                        };
                    }
                }).build();
            }
        });
        GuardedEngineCreator pkcs1v15CreatorPublic = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSingleBlockCipher.Builder(provider, RSA.WRAP_PKCS1v1_5).withGeneralOperators(ProvRSA.this.getGeneralEncryptionFactory(), ProvRSA.this.getGeneralWrappingFactory()).withPublicKeyConverter(publicKeyConverter).withPrivateKeyConverter(privateKeyConverter).setPublicKeyOnly(true).withParametersCreatorProvider(new ParametersCreatorProvider(){

                    public ParametersCreator get(Parameters algorithm) {
                        return new ParametersCreator(){

                            public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) {
                                return RSA.WRAP_PKCS1v1_5;
                            }
                        };
                    }
                }).build();
            }
        });
        provider.addAlgorithmImplementation("Cipher.RSA", "org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$NoPadding", rsaCreator);
        provider.addAttributes("Cipher.RSA", generalRsaAttributes);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            provider.addAlgorithmImplementation("Cipher", PKCSObjectIdentifiers.rsaEncryption, "org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$PKCS1v1_5Padding", (EngineCreator)pkcs1v15Creator);
            provider.addAttributes("Cipher", PKCSObjectIdentifiers.rsaEncryption, generalRsaAttributes);
            provider.addAlgorithmImplementation("Cipher", X509ObjectIdentifiers.id_ea_rsa, "org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$PKCS1v1_5Padding", (EngineCreator)pkcs1v15Creator);
            provider.addAttributes("Cipher", X509ObjectIdentifiers.id_ea_rsa, generalRsaAttributes);
            provider.addAlgorithmImplementation("Cipher.RSA/1/PKCS1PADDING", "org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$PKCS1v1_5Padding_PrivateOnly", pkcs1v15CreatorPrivate);
            provider.addAlgorithmImplementation("Cipher.RSA/2/PKCS1PADDING", "org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$PKCS1v1_5Padding_PublicOnly", pkcs1v15CreatorPublic);
        }
        provider.addAlgorithmImplementation("Cipher", PKCSObjectIdentifiers.id_RSAES_OAEP, "org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$OAEPPadding", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    return new BaseSingleBlockCipher.Builder(provider, FipsRSA.WRAP_OAEP).withPublicKeyConverter(publicKeyConverter).withPrivateKeyConverter(privateKeyConverter).setWrapModeOnly(true).withParameters(new Class[]{OAEPParameterSpec.class}).withFipsOperators(null, new FipsRSA.KeyWrapOperatorFactory()).withParametersCreatorProvider(new ParametersCreatorProvider(){

                        public ParametersCreator get(Parameters algorithm) {
                            return new ParametersCreator(){

                                public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) {
                                    if (spec == null) {
                                        return FipsRSA.WRAP_OAEP;
                                    }
                                    return ProvRSA.createFipsOaepParameters((OAEPParameterSpec)spec);
                                }
                            };
                        }
                    }).build();
                }
                return new BaseSingleBlockCipher.Builder(provider, RSA.WRAP_OAEP).withPublicKeyConverter(publicKeyConverter).withPrivateKeyConverter(privateKeyConverter).withParameters(new Class[]{OAEPParameterSpec.class}).withGeneralOperators(ProvRSA.this.getGeneralEncryptionFactory(), new RSA.KeyWrapOperatorFactory()).withParametersCreatorProvider(new ParametersCreatorProvider(){

                    public ParametersCreator get(Parameters algorithm) {
                        return new ParametersCreator(){

                            public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                                if (spec == null) {
                                    return RSA.WRAP_OAEP;
                                }
                                if (!(spec instanceof OAEPParameterSpec)) {
                                    throw new InvalidAlgorithmParameterException("OAEP can only accept OAEPParameterSpec");
                                }
                                OAEPParameterSpec oaepSpec = (OAEPParameterSpec)spec;
                                DigestAlgorithm digest = Utils.digestNameToAlgMap.get(oaepSpec.getDigestAlgorithm());
                                MGF1ParameterSpec mgfParams = (MGF1ParameterSpec)oaepSpec.getMGFParameters();
                                DigestAlgorithm mgfDigest = Utils.digestNameToAlgMap.get(mgfParams.getDigestAlgorithm());
                                return RSA.WRAP_OAEP.withDigest(digest).withMGFDigest(mgfDigest).withEncodingParams(((PSource.PSpecified)oaepSpec.getPSource()).getValue());
                            }
                        };
                    }
                }).build();
            }
        });
        provider.addAttributes("Cipher", PKCSObjectIdentifiers.id_RSAES_OAEP, generalRsaAttributes);
        provider.addAlgorithmImplementation("KeyFactory.RSA", "org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyFactorySpi", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new RSAKeyFactory(ProvRSA.getAlgorithmType());
            }
        });
        provider.addAlgorithmImplementation("KeyPairGenerator.RSA", "org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyPairGeneratorSpi", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyPairGenerator(provider);
            }
        });
        provider.addAlgorithmImplementation("KeyFactory.RSASSA-PSS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyFactoryPSSSpi", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new RSAKeyFactory(ProvRSA.getPssAlgorithmType());
            }
        });
        provider.addAlgorithmImplementation("KeyPairGenerator.RSASSA-PSS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyPairGeneratorPSSSpi", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyPairGenerator(provider, "RSASSA-PSS");
            }
        });
        RSAKeyFactory keyFact = new RSAKeyFactory(ProvRSA.getAlgorithmType());
        this.registerOid(provider, PKCSObjectIdentifiers.rsaEncryption, "RSA", keyFact);
        this.registerOid(provider, X509ObjectIdentifiers.id_ea_rsa, "RSA", keyFact);
        this.registerOid(provider, PKCSObjectIdentifiers.id_RSAES_OAEP, "RSA", keyFact);
        this.registerOid(provider, PKCSObjectIdentifiers.id_RSASSA_PSS, "RSA", keyFact);
        this.registerOid(provider, PKCSObjectIdentifiers.id_rsa_KEM, "RSA", keyFact);
        provider.addAlgorithmImplementation("SecretKeyFactory.RSA-KAS-KEM", "org.bouncycastle.jcajce.provider.asymmetric.rsa.RSAKTSKEM", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KTSSKeyFactory(new ParametersCreator(){

                    public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                        InternalKtsSpec ktsSpec = (InternalKtsSpec)spec;
                        if (ktsSpec.parameterSpec != null) {
                            throw new InvalidAlgorithmParameterException("RSA-KAS-KEM does not accept an AlgorithmParameterSpec");
                        }
                        return FipsRSA.KTS_SVE;
                    }
                }, provider, publicKeyConverter, privateKeyConverter);
            }
        });
        provider.addAlgorithmImplementation("SecretKeyFactory.RSA-KTS-KEM-KWS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.RSAKTSKEMKWS", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KEMKTSSKeyFactory(provider);
            }
        });
        provider.addAlgorithmImplementation("Cipher.RSA-KTS-KEM-KWS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherRSAKTSKEM", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) throws NoSuchAlgorithmException {
                return new KtsCipherSpi(provider, "RSA-KTS-KEM-KWS");
            }
        });
        provider.addAttributes("Cipher.RSA-KTS-KEM-KWS", generalRsaAttributes);
        provider.addAlias("Cipher", "RSA-KTS-KEM-KWS", PKCSObjectIdentifiers.id_rsa_KEM);
        provider.addAlgorithmImplementation("AlgorithmParameters.RSA-KTS-KEM-KWS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.AlgParamsRSAKTSKEM", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) throws NoSuchAlgorithmException {
                return new KtsAlgParams();
            }
        });
        provider.addAlias("AlgorithmParameters", "RSA-KTS-KEM-KWS", PKCSObjectIdentifiers.id_rsa_KEM);
        provider.addAlgorithmImplementation("SecretKeyFactory.RSA-KTS-OAEP", "org.bouncycastle.jcajce.provider.asymmetric.rsa.RSAKTSOEAP", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KTSSKeyFactory(new ParametersCreator(){

                    public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                        InternalKtsSpec ktsSpec = (InternalKtsSpec)spec;
                        if (ktsSpec.parameterSpec == null) {
                            return FipsRSA.KTS_OAEP.withKeySizeInBits(ktsSpec.keySize).withMacKeySizeInBits(ktsSpec.macKeySize);
                        }
                        if (!(ktsSpec.parameterSpec instanceof OAEPParameterSpec)) {
                            throw new InvalidAlgorithmParameterException("KTS-OAEP can only accept OAEPParameterSpec");
                        }
                        OAEPParameterSpec oaepSpec = (OAEPParameterSpec)ktsSpec.parameterSpec;
                        return FipsRSA.KTS_OAEP.withOAEPParameters(ProvRSA.createFipsOaepParameters(oaepSpec)).withKeySizeInBits(ktsSpec.keySize).withMacKeySizeInBits(ktsSpec.macKeySize);
                    }
                }, provider, publicKeyConverter, privateKeyConverter);
            }
        });
        provider.addAlgorithmImplementation("Signature.PSS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$PSSwithRSA", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, ProvRSA.this.fipsRsaSigFactory, publicKeyConverter, privateKeyConverter, FipsRSA.PSS, PSSParameterSpec.DEFAULT);
            }
        });
        provider.addAttributes("Signature.PSS", generalRsaAttributes);
        provider.addAlias("Signature", "PSS", PKCSObjectIdentifiers.id_RSASSA_PSS);
        provider.addAlias("Signature", "PSS", "RSAPSS", "RSA-PSS", "RSASSA-PSS");
        provider.addAlgorithmImplementation("Signature.NONEWITHRSA", "org.bouncycastle.jcajce.provider.asymmetric.rsa.SignatureSpi$NONEwithRSA", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, ProvRSA.this.fipsRsaSigFactory, publicKeyConverter, privateKeyConverter, FipsRSA.PKCS1v1_5.withDigestAlgorithm(null));
            }
        });
        provider.addAttributes("Signature.NONEWITHRSA", generalRsaAttributes);
        provider.addAlias("Alg.Alias.Signature.RAWRSA", "NONEWITHRSA");
        this.addPSSSignature(provider, "SHA1", FipsSHS.Algorithm.SHA1, new PSSParameterSpec("SHA-1", "MGF1", new MGF1ParameterSpec("SHA-1"), 20, 1));
        this.addPSSSignature(provider, "SHA224", FipsSHS.Algorithm.SHA224, new PSSParameterSpec("SHA-224", "MGF1", new MGF1ParameterSpec("SHA-224"), 28, 1));
        this.addPSSSignature(provider, "SHA256", FipsSHS.Algorithm.SHA256, new PSSParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), 32, 1));
        this.addPSSSignature(provider, "SHA384", FipsSHS.Algorithm.SHA384, new PSSParameterSpec("SHA-384", "MGF1", new MGF1ParameterSpec("SHA-384"), 48, 1));
        this.addPSSSignature(provider, "SHA512", FipsSHS.Algorithm.SHA512, new PSSParameterSpec("SHA-512", "MGF1", new MGF1ParameterSpec("SHA-512"), 64, 1));
        this.addPSSSignature(provider, "SHA512(224)", FipsSHS.Algorithm.SHA512_224, new PSSParameterSpec("SHA-512(224)", "MGF1", new MGF1ParameterSpec("SHA-512(224)"), 28, 1));
        this.addPSSSignature(provider, "SHA512(256)", FipsSHS.Algorithm.SHA512_256, new PSSParameterSpec("SHA-512(256)", "MGF1", new MGF1ParameterSpec("SHA-512(256)"), 32, 1));
        this.addPSSSignature(provider, "SHA3-224", FipsSHS.Algorithm.SHA3_224, new PSSParameterSpec("SHA3-224", "MGF1", new MGF1ParameterSpec("SHA3-224"), 28, 1));
        this.addPSSSignature(provider, "SHA3-256", FipsSHS.Algorithm.SHA3_256, new PSSParameterSpec("SHA3-256", "MGF1", new MGF1ParameterSpec("SHA3-256"), 32, 1));
        this.addPSSSignature(provider, "SHA3-384", FipsSHS.Algorithm.SHA3_384, new PSSParameterSpec("SHA3-384", "MGF1", new MGF1ParameterSpec("SHA3-384"), 48, 1));
        this.addPSSSignature(provider, "SHA3-512", FipsSHS.Algorithm.SHA3_512, new PSSParameterSpec("SHA3-512", "MGF1", new MGF1ParameterSpec("SHA3-512"), 64, 1));
        this.addX931Signature(provider, "SHA1", FipsSHS.Algorithm.SHA1);
        this.addX931Signature(provider, "SHA224", FipsSHS.Algorithm.SHA224);
        this.addX931Signature(provider, "SHA256", FipsSHS.Algorithm.SHA256);
        this.addX931Signature(provider, "SHA384", FipsSHS.Algorithm.SHA384);
        this.addX931Signature(provider, "SHA512", FipsSHS.Algorithm.SHA512);
        this.addX931Signature(provider, "SHA512(224)", FipsSHS.Algorithm.SHA512_224);
        this.addX931Signature(provider, "SHA512(256)", FipsSHS.Algorithm.SHA512_256);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.addX931Signature(provider, "RIPEMD128", SecureHash.Algorithm.RIPEMD128);
            this.addX931Signature(provider, "RIPEMD160", SecureHash.Algorithm.RIPEMD160);
            this.addX931Signature(provider, "WHIRLPOOL", SecureHash.Algorithm.WHIRLPOOL);
        }
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.addIso9796Signature(provider, "MD5", SecureHash.Algorithm.MD5);
            this.addIso9796Signature(provider, "SHA1", FipsSHS.Algorithm.SHA1);
            this.addIso9796Signature(provider, "SHA224", FipsSHS.Algorithm.SHA224);
            this.addIso9796Signature(provider, "SHA256", FipsSHS.Algorithm.SHA256);
            this.addIso9796Signature(provider, "SHA384", FipsSHS.Algorithm.SHA384);
            this.addIso9796Signature(provider, "SHA512", FipsSHS.Algorithm.SHA512);
            this.addIso9796Signature(provider, "SHA512(224)", FipsSHS.Algorithm.SHA512_224);
            this.addIso9796Signature(provider, "SHA512(256)", FipsSHS.Algorithm.SHA512_256);
            this.addIso9796Signature(provider, "RIPEMD128", SecureHash.Algorithm.RIPEMD128);
            this.addIso9796Signature(provider, "RIPEMD160", SecureHash.Algorithm.RIPEMD160);
            this.addIso9796PSSSignature(provider, "SHA1", FipsSHS.Algorithm.SHA1);
            this.addIso9796PSSSignature(provider, "SHA224", FipsSHS.Algorithm.SHA224);
            this.addIso9796PSSSignature(provider, "SHA256", FipsSHS.Algorithm.SHA256);
            this.addIso9796PSSSignature(provider, "SHA384", FipsSHS.Algorithm.SHA384);
            this.addIso9796PSSSignature(provider, "SHA512", FipsSHS.Algorithm.SHA512);
            this.addIso9796PSSSignature(provider, "SHA512(224)", FipsSHS.Algorithm.SHA512_224);
            this.addIso9796PSSSignature(provider, "SHA512(256)", FipsSHS.Algorithm.SHA512_256);
            this.addIso9796PSSSignature(provider, "RIPEMD128", SecureHash.Algorithm.RIPEMD128);
            this.addIso9796PSSSignature(provider, "RIPEMD160", SecureHash.Algorithm.RIPEMD160);
        }
        this.addDigestSignature(provider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA1), "SHA1", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA1", PKCSObjectIdentifiers.sha1WithRSAEncryption);
        provider.addAlias("Signature", "SHA1WITHRSA", OIWObjectIdentifiers.sha1WithRSA);
        this.addDigestSignature(provider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA224), "SHA224", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA224", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        this.addDigestSignature(provider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA256), "SHA256", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA256", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        this.addDigestSignature(provider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA384), "SHA384", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA384", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        this.addDigestSignature(provider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA512), "SHA512", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA512", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        this.addDigestSignature(provider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_224), "SHA512(224)", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA512_224", PKCSObjectIdentifiers.sha512_224WithRSAEncryption);
        this.addDigestSignature(provider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_256), "SHA512(256)", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA512_256", PKCSObjectIdentifiers.sha512_256WithRSAEncryption);
        this.addDigestSignature(provider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_224), "SHA3-224", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA3_224", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224);
        this.addDigestSignature(provider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_256), "SHA3-256", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA3_256", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256);
        this.addDigestSignature(provider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_384), "SHA3-384", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA3_384", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384);
        this.addDigestSignature(provider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_512), "SHA3-512", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA3_512", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.addDigestSignature(provider, RSA.PKCS1v1_5.withDigestAlgorithm(SecureHash.Algorithm.MD5), "MD5", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$MD5", PKCSObjectIdentifiers.md5WithRSAEncryption);
            provider.addAlias("Signature", "MD5WITHRSA", OIWObjectIdentifiers.md5WithRSA);
            this.addDigestSignature(provider, RSA.PKCS1v1_5.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD128), "RIPEMD128", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD128", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
            this.addDigestSignature(provider, RSA.PKCS1v1_5.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD128), "RMD128", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD128", null);
            this.addDigestSignature(provider, RSA.PKCS1v1_5.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD160), "RIPEMD160", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD160", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
            this.addDigestSignature(provider, RSA.PKCS1v1_5.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD160), "RMD160", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD160", null);
            this.addDigestSignature(provider, RSA.PKCS1v1_5.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD256), "RIPEMD256", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD256", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
            this.addDigestSignature(provider, RSA.PKCS1v1_5.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD256), "RMD256", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD256", null);
        }
    }

    private void addPSSSignature(final BouncyCastleFipsProvider provider, String digestName, final Algorithm digest, final PSSParameterSpec pssSPec) {
        provider.addAlgorithmImplementation("Signature." + digestName + "WITHRSA/PSS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$" + digestName, new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, ProvRSA.this.fipsRsaSigFactory, publicKeyConverter, privateKeyConverter, FipsRSA.PSS.withDigestAlgorithm((FipsDigestAlgorithm)digest), pssSPec);
            }
        });
        provider.addAttributes("Signature." + digestName + "WITHRSA/PSS", generalRsaAttributes);
        provider.addAlias("Signature", digestName + "WITHRSA/PSS", digestName + "WITHRSAANDMGF1", digestName + "WITHRSASSA-PSS");
        provider.addAlias("AlgorithmParameters", "PSS", digestName + "WITHRSA/PSS", digestName + "WITHRSAANDMGF1", digestName + "WITHRSASSA-PSS");
    }

    private void addX931Signature(final BouncyCastleFipsProvider provider, String digestName, final DigestAlgorithm digest) {
        if (digest instanceof FipsAlgorithm) {
            provider.addAlgorithmImplementation("Signature." + digestName + "WITHRSA/X9.31", "org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$" + digestName, new EngineCreator(){

                @Override
                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvRSA.this.fipsRsaSigFactory, publicKeyConverter, privateKeyConverter, FipsRSA.X931.withDigestAlgorithm((FipsDigestAlgorithm)digest));
                }
            });
        } else {
            provider.addAlgorithmImplementation("Signature." + digestName + "WITHRSA/X9.31", "org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$" + digestName, new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvRSA.this.generalRsaSigFactory, publicKeyConverter, privateKeyConverter, new RSA.X931SignatureParameters(digest));
                }
            }));
        }
        provider.addAttributes("Signature." + digestName + "WITHRSA/X9.31", generalRsaAttributes);
    }

    private void addIso9796Signature(final BouncyCastleFipsProvider provider, String digestName, final DigestAlgorithm digest) {
        provider.addAlgorithmImplementation("Signature." + digestName + "WITHRSA/ISO9796-2", "org.bouncycastle.jcajce.provider.asymmetric.rsa.ISO9796-2SignatureSpi$" + digestName, new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, ProvRSA.this.recoveryRsaSigFactory, publicKeyConverter, privateKeyConverter, RSA.ISO9796d2.withDigestAlgorithm(digest));
            }
        }));
        provider.addAttributes("Signature." + digestName + "WITHRSA/ISO9796-2", generalRsaAttributes);
    }

    private void addIso9796PSSSignature(final BouncyCastleFipsProvider provider, String digestName, final DigestAlgorithm digest) {
        provider.addAlgorithmImplementation("Signature." + digestName + "WITHRSA/ISO9796-2PSS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.ISO9796-2PSSSignatureSpi$" + digestName, new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, ProvRSA.this.recoveryRsaSigFactory, publicKeyConverter, privateKeyConverter, RSA.ISO9796d2PSS.withDigestAlgorithm(digest));
            }
        }));
        provider.addAttributes("Signature." + digestName + "WITHRSA/ISO9796-2PSS", generalRsaAttributes);
        provider.addAlias("Alg.Alias.Signature." + digestName + "WITHRSAANDMGF1/ISO9796-2", digestName + "WITHRSA/ISO9796-2PSS");
    }

    private void addDigestSignature(final BouncyCastleFipsProvider provider, final Parameters parameters, String digest, String className, ASN1ObjectIdentifier oid) {
        String mainName = digest + "WITHRSA";
        String alias = digest + "/RSA";
        String longName = digest + "WITHRSAENCRYPTION";
        if (parameters instanceof FipsParameters) {
            provider.addAlgorithmImplementation("Signature." + mainName, className, new EngineCreator(){

                @Override
                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, new AdaptiveSignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, parameters);
                }
            });
        } else {
            provider.addAlgorithmImplementation("Signature." + mainName, className, new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvRSA.this.getGeneralSigFactory(), publicKeyConverter, privateKeyConverter, parameters);
                }
            }));
        }
        provider.addAttributes("Signature." + mainName, generalRsaAttributes);
        provider.addAlias("Signature", mainName, alias, longName);
        if (oid != null) {
            provider.addAlias("Signature", mainName, oid);
        }
    }

    private static FipsRSA.OAEPParameters createFipsOaepParameters(OAEPParameterSpec spec) {
        OAEPParameterSpec oaepSpec = spec;
        FipsDigestAlgorithm digest = (FipsDigestAlgorithm)Utils.digestNameToAlgMap.get(oaepSpec.getDigestAlgorithm());
        MGF1ParameterSpec mgfParams = (MGF1ParameterSpec)oaepSpec.getMGFParameters();
        FipsDigestAlgorithm mgfDigest = (FipsDigestAlgorithm)Utils.digestNameToAlgMap.get(mgfParams.getDigestAlgorithm());
        return FipsRSA.WRAP_OAEP.withDigest(digest).withMGFDigest(mgfDigest).withEncodingParams(((PSource.PSpecified)oaepSpec.getPSource()).getValue());
    }

    private static Algorithm getAlgorithmType() {
        return CryptoServicesRegistrar.isInApprovedOnlyMode() ? FipsRSA.ALGORITHM : RSA.ALGORITHM;
    }

    private static Algorithm getPssAlgorithmType() {
        return CryptoServicesRegistrar.isInApprovedOnlyMode() ? FipsRSA.PSS.getAlgorithm() : RSA.PSS.getAlgorithm();
    }

    private static String getMGFName(ASN1ObjectIdentifier mgfOid) {
        if (PKCSObjectIdentifiers.id_mgf1.equals(mgfOid)) {
            return "MGF1";
        }
        return mgfOid.getId();
    }

    static {
        kdfPRF.put(OIWObjectIdentifiers.idSHA1, FipsKDF.AgreementKDFPRF.SHA1);
        kdfPRF.put(NISTObjectIdentifiers.id_sha224, FipsKDF.AgreementKDFPRF.SHA224);
        kdfPRF.put(NISTObjectIdentifiers.id_sha256, FipsKDF.AgreementKDFPRF.SHA256);
        kdfPRF.put(NISTObjectIdentifiers.id_sha384, FipsKDF.AgreementKDFPRF.SHA384);
        kdfPRF.put(NISTObjectIdentifiers.id_sha512, FipsKDF.AgreementKDFPRF.SHA512);
        kdfPRF.put(NISTObjectIdentifiers.id_sha512_224, FipsKDF.AgreementKDFPRF.SHA512_224);
        kdfPRF.put(NISTObjectIdentifiers.id_sha512_256, FipsKDF.AgreementKDFPRF.SHA512_256);
        kdfPRF.put(NISTObjectIdentifiers.id_sha3_224, FipsKDF.AgreementKDFPRF.SHA3_224);
        kdfPRF.put(NISTObjectIdentifiers.id_sha3_256, FipsKDF.AgreementKDFPRF.SHA3_256);
        kdfPRF.put(NISTObjectIdentifiers.id_sha3_384, FipsKDF.AgreementKDFPRF.SHA3_384);
        kdfPRF.put(NISTObjectIdentifiers.id_sha3_512, FipsKDF.AgreementKDFPRF.SHA3_512);
        kdfPRF.put(PKCSObjectIdentifiers.id_hmacWithSHA1, FipsKDF.AgreementKDFPRF.SHA1_HMAC);
        kdfPRF.put(PKCSObjectIdentifiers.id_hmacWithSHA224, FipsKDF.AgreementKDFPRF.SHA224_HMAC);
        kdfPRF.put(PKCSObjectIdentifiers.id_hmacWithSHA256, FipsKDF.AgreementKDFPRF.SHA256_HMAC);
        kdfPRF.put(PKCSObjectIdentifiers.id_hmacWithSHA384, FipsKDF.AgreementKDFPRF.SHA384_HMAC);
        kdfPRF.put(PKCSObjectIdentifiers.id_hmacWithSHA512, FipsKDF.AgreementKDFPRF.SHA512_HMAC);
        kdfPRF.put(PKCSObjectIdentifiers.id_hmacWithSHA512_224, FipsKDF.AgreementKDFPRF.SHA512_224_HMAC);
        kdfPRF.put(PKCSObjectIdentifiers.id_hmacWithSHA512_256, FipsKDF.AgreementKDFPRF.SHA512_256_HMAC);
        kdfPRF.put(NISTObjectIdentifiers.id_hmacWithSHA3_224, FipsKDF.AgreementKDFPRF.SHA3_224_HMAC);
        kdfPRF.put(NISTObjectIdentifiers.id_hmacWithSHA3_256, FipsKDF.AgreementKDFPRF.SHA3_256_HMAC);
        kdfPRF.put(NISTObjectIdentifiers.id_hmacWithSHA3_384, FipsKDF.AgreementKDFPRF.SHA3_384_HMAC);
        kdfPRF.put(NISTObjectIdentifiers.id_hmacWithSHA3_512, FipsKDF.AgreementKDFPRF.SHA3_512_HMAC);
        kdfPRF.put(NISTObjectIdentifiers.id_KmacWithSHAKE128, FipsKDF.AgreementKDFPRF.KMAC_128);
        kdfPRF.put(NISTObjectIdentifiers.id_KmacWithSHAKE256, FipsKDF.AgreementKDFPRF.KMAC_256);
        wrapNames.put(NISTObjectIdentifiers.id_aes128_wrap, "AES");
        wrapNames.put(NISTObjectIdentifiers.id_aes192_wrap, "AES");
        wrapNames.put(NISTObjectIdentifiers.id_aes256_wrap, "AES");
        wrapNames.put(NTTObjectIdentifiers.id_camellia128_wrap, "Camellia");
        wrapNames.put(NTTObjectIdentifiers.id_camellia192_wrap, "Camellia");
        wrapNames.put(NTTObjectIdentifiers.id_camellia256_wrap, "Camellia");
        generalRsaAttributes.put("SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
        generalRsaAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    private class AdaptiveSignatureOperatorFactory<T extends Parameters>
    implements SignatureOperatorFactory<FipsRSA.PKCS1v15SignatureParameters> {
        private AdaptiveSignatureOperatorFactory() {
        }

        @Override
        public final OutputSigner createSigner(AsymmetricPrivateKey key, FipsRSA.PKCS1v15SignatureParameters parameters) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                return ProvRSA.this.fipsRsaSigFactory.createSigner(key, parameters);
            }
            AsymmetricRSAPrivateKey k = (AsymmetricRSAPrivateKey)key;
            if (k.getModulus().bitLength() < 2048) {
                RSA.PKCS1v15SignatureParameters params = RSA.PKCS1v1_5.withDigestAlgorithm(parameters.getDigestAlgorithm());
                return ProvRSA.this.getGeneralSigFactory().createSigner(key, params);
            }
            return ProvRSA.this.fipsRsaSigFactory.createSigner(key, parameters);
        }

        @Override
        public final OutputVerifier createVerifier(AsymmetricPublicKey key, FipsRSA.PKCS1v15SignatureParameters parameters) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                return ProvRSA.this.fipsRsaSigFactory.createVerifier(key, parameters);
            }
            AsymmetricRSAPublicKey k = (AsymmetricRSAPublicKey)key;
            if (k.getModulus().bitLength() < 1024) {
                RSA.PKCS1v15SignatureParameters params = RSA.PKCS1v1_5.withDigestAlgorithm(parameters.getDigestAlgorithm());
                return ProvRSA.this.getGeneralSigFactory().createVerifier(key, params);
            }
            return ProvRSA.this.fipsRsaSigFactory.createVerifier(key, parameters);
        }

        @Override
        public final OutputValidator createValidator(AsymmetricPublicKey key, FipsRSA.PKCS1v15SignatureParameters parameters, byte[] signature) {
            throw new IllegalStateException("not implemented");
        }
    }

    static class InternalKtsSpec
    implements AlgorithmParameterSpec {
        private final int keySize;
        private final int macKeySize;
        private final AlgorithmParameterSpec parameterSpec;

        public InternalKtsSpec(int keySize, int macKeySize, AlgorithmParameterSpec parameterSpec) {
            this.keySize = keySize;
            this.macKeySize = macKeySize;
            this.parameterSpec = parameterSpec;
        }
    }

    static class KEMKTSSKeyFactory
    extends SecretKeyFactorySpi {
        private final BouncyCastleFipsProvider fipsProvider;

        public KEMKTSSKeyFactory(BouncyCastleFipsProvider fipsProvider) {
            this.fipsProvider = fipsProvider;
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            try {
                if (keySpec instanceof KTSWithKEMKWSKeySpec) {
                    KTSWithKEMKWSKeySpec kemSpec = (KTSWithKEMKWSKeySpec)keySpec;
                    KTSKeySpec ktsSpec = kemSpec.getKTSKeySpec();
                    SecretKeyFactory keyFact = SecretKeyFactory.getInstance("RSA-KAS-KEM", this.fipsProvider);
                    if (ktsSpec instanceof KTSGenerateKeySpec) {
                        KTSKeyWithEncapsulation ktsKey = (KTSKeyWithEncapsulation)keyFact.generateSecret(ktsSpec);
                        KeyGenerator keyGenerator = KeyGenerator.getInstance(kemSpec.getTransportedKeyAlgorithm(), this.fipsProvider);
                        keyGenerator.init(kemSpec.getTransportedKeySize(), ((KTSGenerateKeySpec)ktsSpec).getSecureRandom());
                        Cipher wrapCipher = Cipher.getInstance(ktsSpec.getKeyAlgorithmName(), this.fipsProvider);
                        wrapCipher.init(3, (Key)ktsKey, ((KTSGenerateKeySpec)ktsSpec).getSecureRandom());
                        SecretKey genKey = keyGenerator.generateKey();
                        ZeroizableSecretKey macKey = ktsKey.getMacKey();
                        byte[] encapsulation = Arrays.concatenate(ktsKey.getEncapsulation(), wrapCipher.wrap(genKey));
                        if (macKey != null) {
                            return new KTSKeyWithEncapsulation(new AgreedKeyWithMacKey(genKey, macKey.getAlgorithm(), macKey.getEncoded()), encapsulation);
                        }
                        return new KTSKeyWithEncapsulation(genKey, encapsulation);
                    }
                    KTSExtractKeySpec extractKeySpec = (KTSExtractKeySpec)ktsSpec;
                    byte[] encapsulationPlusKey = extractKeySpec.getEncapsulation();
                    byte[] encapsulation = new byte[(((RSAPrivateKey)extractKeySpec.getPrivateKey()).getModulus().bitLength() + 7) / 8];
                    System.arraycopy(encapsulationPlusKey, 0, encapsulation, 0, encapsulation.length);
                    KTSExtractKeySpec internalSpec = new KTSExtractKeySpec.Builder(extractKeySpec.getPrivateKey(), encapsulation, extractKeySpec.getKeyAlgorithmName(), extractKeySpec.getKeySize(), extractKeySpec.getOtherInfo()).withKdfAlgorithm(extractKeySpec.getKdfAlgorithmId()).withMac(extractKeySpec.getMacAlgorithmName(), extractKeySpec.getMacKeySize()).build();
                    KTSKeyWithEncapsulation ktsKey = (KTSKeyWithEncapsulation)keyFact.generateSecret(internalSpec);
                    Cipher wrapCipher = Cipher.getInstance(extractKeySpec.getKeyAlgorithmName(), this.fipsProvider);
                    wrapCipher.init(4, (Key)ktsKey, (SecureRandom)null);
                    byte[] encodedKey = new byte[encapsulationPlusKey.length - encapsulation.length];
                    System.arraycopy(encapsulationPlusKey, encapsulation.length, encodedKey, 0, encodedKey.length);
                    SecretKey transportedKey = (SecretKey)wrapCipher.unwrap(encodedKey, kemSpec.getTransportedKeyAlgorithm(), 3);
                    ZeroizableSecretKey macKey = ktsKey.getMacKey();
                    int transportedKeyLength = transportedKey.getEncoded().length;
                    if (transportedKeyLength != (kemSpec.getTransportedKeySize() + 7) / 8) {
                        throw new InvalidKeySpecException("KEM transported key the incorrect size: found " + transportedKeyLength + " bytes");
                    }
                    if (macKey != null) {
                        return new KTSKeyWithEncapsulation(new AgreedKeyWithMacKey(transportedKey, macKey.getAlgorithm(), macKey.getEncoded()), encapsulation);
                    }
                    return new KTSKeyWithEncapsulation(transportedKey, encapsulation);
                }
            }
            catch (InvalidKeySpecException e) {
                throw e;
            }
            catch (GeneralSecurityException e) {
                throw new InvalidKeySpecException("Unable to process RSA key: " + e.getMessage(), e);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidKeySpecException("Unable to process KDF AlgorithmIdentifier: " + e.getMessage(), e);
            }
            throw new InvalidKeySpecException("Unknown KeySpec passed");
        }

        protected KeySpec engineGetKeySpec(SecretKey secretKey, Class aClass) throws InvalidKeySpecException {
            throw new InvalidKeySpecException("Operation not supported");
        }

        @Override
        protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
            throw new InvalidKeyException("Operation not supported");
        }
    }

    static class KTSSKeyFactory
    extends SecretKeyFactorySpi {
        private final BouncyCastleFipsProvider fipsProvider;
        private final PublicKeyConverter publicKeyConverter;
        private final PrivateKeyConverter privateKeyConverter;
        private final ParametersCreator parametersCreator;

        public KTSSKeyFactory(ParametersCreator parametersCreator, BouncyCastleFipsProvider fipsProvider, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter) {
            this.parametersCreator = parametersCreator;
            this.fipsProvider = fipsProvider;
            this.publicKeyConverter = publicKeyConverter;
            this.privateKeyConverter = privateKeyConverter;
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            FipsRSA.KTSOperatorFactory KTSOperatorFactory2 = new FipsRSA.KTSOperatorFactory(this.fipsProvider.getDefaultSecureRandom());
            try {
                if (keySpec instanceof KTSGenerateKeySpec) {
                    KTSGenerateKeySpec generateKeySpec = (KTSGenerateKeySpec)keySpec;
                    FipsRSA.KTSParameters parameters = (FipsRSA.KTSParameters)this.parametersCreator.createParameters(true, new InternalKtsSpec(generateKeySpec.getKeySize(), generateKeySpec.getMacKeySize(), generateKeySpec.getParameterSpec()), generateKeySpec.getSecureRandom());
                    Object secGen = KTSOperatorFactory2.createGenerator((org.bouncycastle.crypto.Key)this.publicKeyConverter.convertKey(parameters.getAlgorithm(), generateKeySpec.getPublicKey()), parameters);
                    if (generateKeySpec.getSecureRandom() != null) {
                        secGen = secGen.withSecureRandom(generateKeySpec.getSecureRandom());
                    }
                    try {
                        SecretWithEncapsulation encSec = secGen.generate();
                        byte[] secret = encSec.getSecret();
                        if (generateKeySpec.getMacAlgorithmName() != null) {
                            byte[] macKey = new byte[(generateKeySpec.getMacKeySize() + 7) / 8];
                            if (macKey.length > secret.length) {
                                throw new InvalidKeySpecException("MAC key length larger than available key material");
                            }
                            byte[] dkm = this.makeKeyBytes(parameters, generateKeySpec.getKdfAlgorithmId(), secret, generateKeySpec.getKeySize() + generateKeySpec.getMacKeySize(), generateKeySpec.getOtherInfo(), generateKeySpec.getKdfSalt());
                            byte[] tmp = new byte[dkm.length - macKey.length];
                            System.arraycopy(dkm, 0, macKey, 0, macKey.length);
                            System.arraycopy(dkm, macKey.length, tmp, 0, tmp.length);
                            Arrays.fill(secret, (byte)0);
                            Arrays.fill(dkm, (byte)0);
                            return new KTSKeyWithEncapsulation(new AgreedKeyWithMacKey(new SecretKeySpec(tmp, generateKeySpec.getKeyAlgorithmName()), generateKeySpec.getMacAlgorithmName(), macKey), encSec.getEncapsulation());
                        }
                        return new KTSKeyWithEncapsulation(new SecretKeySpec(this.makeKeyBytes(parameters, generateKeySpec.getKdfAlgorithmId(), secret, generateKeySpec.getKeySize(), generateKeySpec.getOtherInfo(), generateKeySpec.getKdfSalt()), generateKeySpec.getKeyAlgorithmName()), encSec.getEncapsulation());
                    }
                    catch (PlainInputProcessingException e) {
                        throw new InvalidKeySpecException("Unable to create secret: " + e.getMessage(), e);
                    }
                }
                if (keySpec instanceof KTSExtractKeySpec) {
                    KTSExtractKeySpec extractKeySpec = (KTSExtractKeySpec)keySpec;
                    FipsRSA.KTSParameters parameters = (FipsRSA.KTSParameters)this.parametersCreator.createParameters(true, new InternalKtsSpec(extractKeySpec.getKeySize(), extractKeySpec.getMacKeySize(), extractKeySpec.getParameterSpec()), null);
                    FipsEncapsulatedSecretExtractor<FipsRSA.KTSParameters> secExtract = KTSOperatorFactory2.createExtractor((org.bouncycastle.crypto.Key)this.privateKeyConverter.convertKey(parameters.getAlgorithm(), extractKeySpec.getPrivateKey()), parameters);
                    byte[] encapsulation = extractKeySpec.getEncapsulation();
                    try {
                        byte[] secret = secExtract.extractSecret(encapsulation, 0, encapsulation.length).getSecret();
                        if (extractKeySpec.getMacAlgorithmName() != null) {
                            byte[] macKey = new byte[(extractKeySpec.getMacKeySize() + 7) / 8];
                            if (macKey.length > secret.length) {
                                throw new InvalidKeySpecException("MAC key length larger than available key material");
                            }
                            byte[] dkm = this.makeKeyBytes(parameters, extractKeySpec.getKdfAlgorithmId(), secret, extractKeySpec.getKeySize() + extractKeySpec.getMacKeySize(), extractKeySpec.getOtherInfo(), extractKeySpec.getKdfSalt());
                            byte[] tmp = new byte[dkm.length - macKey.length];
                            System.arraycopy(dkm, 0, macKey, 0, macKey.length);
                            System.arraycopy(dkm, macKey.length, tmp, 0, tmp.length);
                            Arrays.fill(secret, (byte)0);
                            Arrays.fill(dkm, (byte)0);
                            return new KTSKeyWithEncapsulation(new AgreedKeyWithMacKey(new SecretKeySpec(tmp, extractKeySpec.getKeyAlgorithmName()), extractKeySpec.getMacAlgorithmName(), macKey), encapsulation);
                        }
                        return new KTSKeyWithEncapsulation(new SecretKeySpec(this.makeKeyBytes(parameters, extractKeySpec.getKdfAlgorithmId(), secret, extractKeySpec.getKeySize(), extractKeySpec.getOtherInfo(), extractKeySpec.getKdfSalt()), extractKeySpec.getKeyAlgorithmName()), encapsulation);
                    }
                    catch (InvalidCipherTextException e) {
                        throw new InvalidKeySpecException("Unable to extract secret: " + e.getMessage(), e);
                    }
                }
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new InvalidKeySpecException("Unable to process RSA key: " + e.getMessage(), e);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException("Unable to process RSA key: " + e.getMessage(), e);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidKeySpecException("Unable to process KDF AlgorithmIdentifier: " + e.getMessage(), e);
            }
            throw new InvalidKeySpecException("Unknown KeySpec passed");
        }

        private byte[] makeKeyBytes(FipsRSA.KTSParameters parameters, AlgorithmIdentifier kdfAlgorithm, byte[] secret, int keyLength, byte[] otherInfo, byte[] salt) throws InvalidKeySpecException {
            KDFCalculator<FipsKDF.AgreementKDFParameters> kdfCalculator;
            if (parameters instanceof FipsRSA.OAEPKTSParameters) {
                return secret;
            }
            AlgorithmIdentifier digAlg = AlgorithmIdentifier.getInstance(kdfAlgorithm.getParameters());
            if (Utils.isNotNull(digAlg.getParameters())) {
                throw new InvalidKeySpecException("Digest algorithm identifier cannot have parameters");
            }
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && (otherInfo == null || otherInfo.length == 0)) {
                throw new FipsUnapprovedOperationError("OtherInfo/IV for KDF must be present in approved mode");
            }
            if (X9ObjectIdentifiers.id_kdf_kdf2.equals(kdfAlgorithm.getAlgorithm())) {
                kdfCalculator = new FipsKDF.AgreementOperatorFactory().createKDFCalculator(FipsKDF.X963.withPRF(KTSSKeyFactory.getPrfAlgorithm(digAlg.getAlgorithm())).using(secret).withIV(otherInfo));
            } else if (X9ObjectIdentifiers.id_kdf_kdf3.equals(kdfAlgorithm.getAlgorithm())) {
                kdfCalculator = new FipsKDF.AgreementOperatorFactory().createKDFCalculator(FipsKDF.CONCATENATION.withPRF(KTSSKeyFactory.getPrfAlgorithm(digAlg.getAlgorithm())).using(secret).withIV(otherInfo).withSalt(salt));
            } else {
                throw new InvalidKeySpecException("Unrecognized KDF: " + kdfAlgorithm.getAlgorithm());
            }
            byte[] keyBytes = new byte[(keyLength + 7) / 8];
            kdfCalculator.generateBytes(keyBytes);
            Arrays.fill(secret, (byte)0);
            return keyBytes;
        }

        private static FipsKDF.AgreementKDFPRF getPrfAlgorithm(ASN1ObjectIdentifier algorithm) throws InvalidKeySpecException {
            FipsKDF.AgreementKDFPRF prfAlg = (FipsKDF.AgreementKDFPRF)((Object)kdfPRF.get(algorithm));
            if (prfAlg == null) {
                throw new InvalidKeySpecException("Unrecognized digest in KDF: " + algorithm);
            }
            return prfAlg;
        }

        protected KeySpec engineGetKeySpec(SecretKey secretKey, Class aClass) throws InvalidKeySpecException {
            throw new InvalidKeySpecException("Operation not supported");
        }

        @Override
        protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
            throw new InvalidKeyException("Operation not supported");
        }
    }

    static class KeyPairGenerator
    extends java.security.KeyPairGenerator {
        private final BouncyCastleFipsProvider fipsProvider;
        static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
        AsymmetricKeyPairGenerator engine;

        public KeyPairGenerator(BouncyCastleFipsProvider fipsProvider, String algorithmName) {
            super(algorithmName);
            this.fipsProvider = fipsProvider;
        }

        public KeyPairGenerator(BouncyCastleFipsProvider fipsProvider) {
            this(fipsProvider, "RSA");
        }

        @Override
        public void initialize(int strength) {
            this.initialize(strength, this.fipsProvider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.engine = strength < 2048 ? (this.getAlgorithm().equals("RSASSA-PSS") ? new RSA.KeyPairGenerator(new RSA.KeyGenParameters(RSA.PSS, defaultPublicExponent, strength), random) : new RSA.KeyPairGenerator(new RSA.KeyGenParameters(defaultPublicExponent, strength), random)) : (this.getAlgorithm().equals("RSASSA-PSS") ? new FipsRSA.KeyPairGenerator(new FipsRSA.KeyGenParameters(FipsRSA.PSS, defaultPublicExponent, strength), random) : new FipsRSA.KeyPairGenerator(new FipsRSA.KeyGenParameters(defaultPublicExponent, strength), random));
        }

        @Override
        public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.initialize(params, this.fipsProvider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + params.getClass().getName());
            }
            RSAKeyGenParameterSpec rsaParams = (RSAKeyGenParameterSpec)params;
            if (rsaParams.getKeysize() < 2048) {
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    throw new InvalidAlgorithmParameterException("RSA key size too small for FIPS mode operation");
                }
                this.engine = this.getAlgorithm().equals("RSASSA-PSS") ? new RSA.KeyPairGenerator(new RSA.KeyGenParameters(RSA.PSS, rsaParams.getPublicExponent(), rsaParams.getKeysize()), random) : new RSA.KeyPairGenerator(new RSA.KeyGenParameters(rsaParams.getPublicExponent(), rsaParams.getKeysize()), random);
            } else {
                this.engine = this.getAlgorithm().equals("RSASSA-PSS") ? new FipsRSA.KeyPairGenerator(new FipsRSA.KeyGenParameters(FipsRSA.PSS, rsaParams.getPublicExponent(), rsaParams.getKeysize()), random) : new FipsRSA.KeyPairGenerator(new FipsRSA.KeyGenParameters(rsaParams.getPublicExponent(), rsaParams.getKeysize()), random);
            }
        }

        @Override
        public KeyPair generateKeyPair() {
            if (this.engine == null) {
                this.engine = this.getAlgorithm().equals("RSASSA-PSS") ? new FipsRSA.KeyPairGenerator(new FipsRSA.KeyGenParameters(FipsRSA.PSS, defaultPublicExponent, 2048), this.fipsProvider.getDefaultSecureRandom()) : new FipsRSA.KeyPairGenerator(new FipsRSA.KeyGenParameters(defaultPublicExponent, 2048), this.fipsProvider.getDefaultSecureRandom());
            }
            AsymmetricKeyPair pair = this.engine.generateKeyPair();
            AsymmetricRSAPublicKey pub = (AsymmetricRSAPublicKey)pair.getPublicKey();
            AsymmetricRSAPrivateKey priv = (AsymmetricRSAPrivateKey)pair.getPrivateKey();
            return new KeyPair(new ProvRSAPublicKey(pub), new ProvRSAPrivateCrtKey(priv));
        }
    }

    public static class KtsAlgParams
    extends X509AlgorithmParameters {
        private GenericHybridParameters params;

        @Override
        protected byte[] localGetEncoded() throws IOException {
            return this.params.getEncoded();
        }

        @Override
        protected void localInit(byte[] encoded) throws IOException {
            this.params = GenericHybridParameters.getInstance(encoded);
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == KTSParameterSpec.class || paramSpec == AlgorithmParameterSpec.class) {
                RsaKemParameters rsaKemParameters = RsaKemParameters.getInstance(this.params.getKem().getParameters());
                String keyAlg = (String)wrapNames.get(this.params.getDem().getAlgorithm());
                if (keyAlg == null) {
                    keyAlg = this.params.getDem().getAlgorithm().getId();
                }
                return new KTSParameterSpec.Builder(keyAlg, rsaKemParameters.getKeyLength().intValue() * 8).withKdfAlgorithm(rsaKemParameters.getKeyDerivationFunction()).build();
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + paramSpec.getName());
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            ASN1ObjectIdentifier wrapOid;
            int keyLength;
            int keySize;
            KTSParameterSpec ktsParameterSpec;
            block16: {
                block17: {
                    block15: {
                        if (!(paramSpec instanceof KTSParameterSpec)) {
                            throw new InvalidParameterSpecException("KTSParameterSpec required to initialise a KTS AlgorithmParameters object");
                        }
                        ktsParameterSpec = (KTSParameterSpec)paramSpec;
                        keySize = ktsParameterSpec.getKeySize();
                        keyLength = -1;
                        wrapOid = null;
                        if (!ktsParameterSpec.getKeyAlgorithmName().equalsIgnoreCase("AES")) break block15;
                        switch (keySize) {
                            case 128: {
                                wrapOid = NISTObjectIdentifiers.id_aes128_wrap;
                                keyLength = 16;
                                break block16;
                            }
                            case 192: {
                                wrapOid = NISTObjectIdentifiers.id_aes192_wrap;
                                keyLength = 24;
                                break block16;
                            }
                            case 256: {
                                wrapOid = NISTObjectIdentifiers.id_aes256_wrap;
                                keyLength = 32;
                                break block16;
                            }
                            default: {
                                throw new InvalidParameterSpecException("Unknown key size for AES: " + keySize);
                            }
                        }
                    }
                    if (!ktsParameterSpec.getKeyAlgorithmName().equalsIgnoreCase("Camellia")) break block17;
                    switch (keySize) {
                        case 128: {
                            wrapOid = NTTObjectIdentifiers.id_camellia128_wrap;
                            keyLength = 16;
                            break block16;
                        }
                        case 192: {
                            wrapOid = NTTObjectIdentifiers.id_camellia192_wrap;
                            keyLength = 24;
                            break block16;
                        }
                        case 256: {
                            wrapOid = NTTObjectIdentifiers.id_camellia256_wrap;
                            keyLength = 32;
                            break block16;
                        }
                        default: {
                            throw new InvalidParameterSpecException("Unknown key size for Camellia: " + keySize);
                        }
                    }
                }
                keyLength = keySizeProvider.getKeySize(ktsParameterSpec.getKeyAlgorithmName());
                try {
                    wrapOid = new ASN1ObjectIdentifier(ktsParameterSpec.getKeyAlgorithmName());
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidParameterSpecException("Cannot recognise key algorithm: " + ktsParameterSpec.getKeyAlgorithmName());
                }
            }
            if (keyLength < 0) {
                throw new InvalidParameterSpecException("Unavailable key length for algorithm: " + ktsParameterSpec.getKeyAlgorithmName());
            }
            if (keyLength * 8 != keySize) {
                throw new InvalidParameterSpecException("Expected key size and key length do not match: " + keySize + " != (8 * " + keyLength + ")");
            }
            this.params = new GenericHybridParameters(new AlgorithmIdentifier(ISOIECObjectIdentifiers.id_kem_rsa, new RsaKemParameters(ktsParameterSpec.getKdfAlgorithm(), keyLength)), new AlgorithmIdentifier(wrapOid));
        }

        @Override
        protected String engineToString() {
            return "KTS AlgParams";
        }
    }

    public static class OAEPAlgorithmParameters
    extends X509AlgorithmParameters {
        OAEPParameterSpec currentSpec;

        @Override
        protected byte[] localGetEncoded() throws IOException {
            AlgorithmIdentifier hashAlgorithm = new AlgorithmIdentifier(DigestUtil.getOID(this.currentSpec.getDigestAlgorithm()), DERNull.INSTANCE);
            MGF1ParameterSpec mgfSpec = (MGF1ParameterSpec)this.currentSpec.getMGFParameters();
            AlgorithmIdentifier maskGenAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, new AlgorithmIdentifier(DigestUtil.getOID(mgfSpec.getDigestAlgorithm()), DERNull.INSTANCE));
            PSource.PSpecified pSource = (PSource.PSpecified)this.currentSpec.getPSource();
            AlgorithmIdentifier pSourceAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_pSpecified, new DEROctetString(pSource.getValue()));
            RSAESOAEPparams oaepP = new RSAESOAEPparams(hashAlgorithm, maskGenAlgorithm, pSourceAlgorithm);
            return oaepP.getEncoded("DER");
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == OAEPParameterSpec.class || paramSpec == AlgorithmParameterSpec.class) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + paramSpec.getName());
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof OAEPParameterSpec)) {
                throw new InvalidParameterSpecException("OAEPParameterSpec required to initialise an OAEP AlgorithmParameters object");
            }
            this.currentSpec = (OAEPParameterSpec)paramSpec;
        }

        @Override
        protected void localInit(byte[] params) throws IOException {
            RSAESOAEPparams oaepP = RSAESOAEPparams.getInstance(params);
            this.currentSpec = new OAEPParameterSpec(MessageDigestUtils.getDigestName(oaepP.getHashAlgorithm().getAlgorithm()), ProvRSA.getMGFName(oaepP.getMaskGenAlgorithm().getAlgorithm()), new MGF1ParameterSpec(MessageDigestUtils.getDigestName(AlgorithmIdentifier.getInstance(oaepP.getMaskGenAlgorithm().getParameters()).getAlgorithm())), new PSource.PSpecified(ASN1OctetString.getInstance(oaepP.getPSourceAlgorithm().getParameters()).getOctets()));
        }

        @Override
        protected String engineToString() {
            return "OAEP Parameters";
        }
    }

    public static class PSSAlgorithmParameters
    extends X509AlgorithmParameters {
        PSSParameterSpec currentSpec;

        @Override
        protected byte[] localGetEncoded() throws IOException {
            PSSParameterSpec pssSpec = this.currentSpec;
            AlgorithmIdentifier hashAlgorithm = new AlgorithmIdentifier(DigestUtil.getOID(pssSpec.getDigestAlgorithm()), DERNull.INSTANCE);
            MGF1ParameterSpec mgfSpec = (MGF1ParameterSpec)pssSpec.getMGFParameters();
            AlgorithmIdentifier maskGenAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, new AlgorithmIdentifier(DigestUtil.getOID(mgfSpec.getDigestAlgorithm()), DERNull.INSTANCE));
            RSASSAPSSparams pssP = new RSASSAPSSparams(hashAlgorithm, maskGenAlgorithm, new ASN1Integer(pssSpec.getSaltLength()), new ASN1Integer(pssSpec.getTrailerField()));
            return pssP.getEncoded("DER");
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == PSSParameterSpec.class || paramSpec == AlgorithmParameterSpec.class) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + paramSpec.getName());
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof PSSParameterSpec)) {
                throw new InvalidParameterSpecException("PSSParameterSpec required to initialise an PSS AlgorithmParameters object");
            }
            this.currentSpec = (PSSParameterSpec)paramSpec;
        }

        @Override
        protected void localInit(byte[] params) throws IOException {
            RSASSAPSSparams pssP = RSASSAPSSparams.getInstance(params);
            this.currentSpec = new PSSParameterSpec(MessageDigestUtils.getDigestName(pssP.getHashAlgorithm().getAlgorithm()), ProvRSA.getMGFName(pssP.getMaskGenAlgorithm().getAlgorithm()), new MGF1ParameterSpec(MessageDigestUtils.getDigestName(AlgorithmIdentifier.getInstance(pssP.getMaskGenAlgorithm().getParameters()).getAlgorithm())), pssP.getSaltLength().intValue(), pssP.getTrailerField().intValue());
        }

        @Override
        protected String engineToString() {
            return "PSS Parameters";
        }
    }

    static class RSAKeyFactory
    extends BaseKeyFactory {
        private final Algorithm algorithm;

        public RSAKeyFactory(Algorithm algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
            if (spec == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            if ((spec.isAssignableFrom(KeySpec.class) || spec.isAssignableFrom(RSAPublicKeySpec.class)) && key instanceof RSAPublicKey) {
                RSAPublicKey k = (RSAPublicKey)key;
                return new RSAPublicKeySpec(k.getModulus(), k.getPublicExponent());
            }
            if ((spec.isAssignableFrom(KeySpec.class) || spec.isAssignableFrom(RSAPrivateCrtKeySpec.class)) && key instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey k = (RSAPrivateCrtKey)key;
                return new RSAPrivateCrtKeySpec(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
            }
            if ((spec.isAssignableFrom(KeySpec.class) || spec.isAssignableFrom(RSAPrivateKeySpec.class)) && key instanceof RSAPrivateKey) {
                RSAPrivateKey k = (RSAPrivateKey)key;
                return new RSAPrivateKeySpec(k.getModulus(), k.getPrivateExponent());
            }
            return super.engineGetKeySpec(key, spec);
        }

        @Override
        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                return new ProvRSAPublicKey((AsymmetricRSAPublicKey)publicKeyConverter.convertKey(this.algorithm, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return this.toProviderKey((AsymmetricRSAPrivateKey)privateKeyConverter.convertKey(this.algorithm, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        @Override
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                PKCS8EncodedKeySpec pkcs8Spec = (PKCS8EncodedKeySpec)keySpec;
                try {
                    return this.generatePrivate(pkcs8Spec.getEncoded());
                }
                catch (Exception e) {
                    throw new InvalidKeySpecException(e.getMessage(), e);
                }
            }
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                return new ProvRSAPrivateCrtKey(this.algorithm, (RSAPrivateCrtKeySpec)keySpec);
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                return new ProvRSAPrivateKey(this.algorithm, (RSAPrivateKeySpec)keySpec);
            }
            if (keySpec != null) {
                throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
            }
            throw new InvalidKeySpecException("null keySpec passed for PrivateKey");
        }

        @Override
        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof RSAPublicKeySpec) {
                return new ProvRSAPublicKey(this.algorithm, (RSAPublicKeySpec)keySpec);
            }
            return super.engineGeneratePublic(keySpec);
        }

        public PrivateKey generatePrivate(byte[] keyInfo) throws IOException {
            return this.generatePrivate(PrivateKeyInfo.getInstance(keyInfo));
        }

        @Override
        public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
            return this.toProviderKey(new AsymmetricRSAPrivateKey(this.algorithm, keyInfo));
        }

        @Override
        public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
            return new ProvRSAPublicKey(new AsymmetricRSAPublicKey(this.algorithm, keyInfo));
        }

        private RSAPrivateKey toProviderKey(AsymmetricRSAPrivateKey rsaPrivateKey) {
            if (rsaPrivateKey.getP().equals(BigInteger.ZERO)) {
                return new ProvRSAPrivateKey(rsaPrivateKey);
            }
            return new ProvRSAPrivateCrtKey(rsaPrivateKey);
        }
    }
}

