/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.BaseMac;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.KMACParametersCreator;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;

final class ProvKMAC
extends AlgorithmProvider {
    private static final Map<String, String> generalAttributes = new HashMap<String, String>();
    private static final String PREFIX;

    ProvKMAC() {
    }

    @Override
    void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("KeyGenerator.KMACWITHSHAKE128", PREFIX + "$KeyGenerator128", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseKeyGenerator(provider, "KMACWITHSHAKE128", 256, false, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int keySize, SecureRandom random) {
                        return new FipsSHS.KeyGenerator(FipsSHS.KMAC128.getAlgorithm(), keySize, random);
                    }
                });
            }
        });
        provider.addAlias("KeyGenerator", "KMACWITHSHAKE128", NISTObjectIdentifiers.id_KmacWithSHAKE128);
        provider.addAlias("KeyGenerator", "KMACWITHSHAKE128", "KMAC128");
        provider.addAlgorithmImplementation("Mac.KMACWITHSHAKE128", PREFIX + "KMACwithSHAKE128", generalAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseMac(FipsSHS.KMAC128, (MACOperatorFactory)new FipsSHS.MACOperatorFactory(), new KMACParametersCreator(FipsSHS.KMAC128));
            }
        });
        provider.addAlias("Mac", "KMACWITHSHAKE128", NISTObjectIdentifiers.id_KmacWithSHAKE128);
        provider.addAlias("Mac", "KMACWITHSHAKE128", "KMAC128");
        provider.addAlgorithmImplementation("KeyGenerator.KMACWITHSHAKE256", PREFIX + "$KeyGenerator256", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseKeyGenerator(provider, "KMACWITHSHAKE256", 512, false, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int keySize, SecureRandom random) {
                        return new FipsSHS.KeyGenerator(FipsSHS.KMAC256.getAlgorithm(), keySize, random);
                    }
                });
            }
        });
        provider.addAlias("KeyGenerator", "KMACWITHSHAKE256", NISTObjectIdentifiers.id_KmacWithSHAKE256);
        provider.addAlias("KeyGenerator", "KMACWITHSHAKE256", "KMAC256");
        provider.addAlgorithmImplementation("Mac.KMACWITHSHAKE256", PREFIX + "KMACwithSHAKE256", generalAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseMac(FipsSHS.KMAC256, (MACOperatorFactory)new FipsSHS.MACOperatorFactory(), new KMACParametersCreator(FipsSHS.KMAC256));
            }
        });
        provider.addAlias("Mac", "KMACWITHSHAKE256", NISTObjectIdentifiers.id_KmacWithSHAKE256);
        provider.addAlias("Mac", "KMACWITHSHAKE256", "KMAC256");
    }

    static {
        generalAttributes.put("SupportedKeyClasses", "javax.crypto.SecretKey");
        generalAttributes.put("SupportedKeyFormats", "RAW");
        PREFIX = ProvKMAC.class.getName();
    }
}

