/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.OutputSigner;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SignatureOperatorFactory;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsRSA;
import org.bouncycastle.crypto.general.EdEC;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.RSA;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.DigestUtil;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.EdDSASigParameterSpec;

class BaseSignature
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private static final byte TRAILER_IMPLICIT = -68;
    private final SignatureOperatorFactory operatorFactory;
    private final PublicKeyConverter publicKeyConverter;
    private final PrivateKeyConverter privateKeyConverter;
    private final BouncyCastleFipsProvider fipsProvider;
    private final AlgorithmParameterSpec originalSpec;
    protected Parameters parameters;
    protected OutputVerifier verifier;
    protected OutputSigner signer;
    protected UpdateOutputStream dataStream;
    protected AlgorithmParameters engineParams;
    protected AlgorithmParameterSpec paramSpec;
    protected AsymmetricKey key;
    protected boolean isInitState = true;

    protected BaseSignature(BouncyCastleFipsProvider fipsProvider, SignatureOperatorFactory operatorFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, Parameters parameters) {
        this.fipsProvider = fipsProvider;
        this.operatorFactory = operatorFactory;
        this.publicKeyConverter = publicKeyConverter;
        this.privateKeyConverter = privateKeyConverter;
        this.parameters = parameters;
        this.originalSpec = null;
    }

    protected BaseSignature(BouncyCastleFipsProvider fipsProvider, SignatureOperatorFactory operatorFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, Parameters parameters, AlgorithmParameterSpec paramSpec) {
        this.fipsProvider = fipsProvider;
        this.operatorFactory = operatorFactory;
        this.publicKeyConverter = publicKeyConverter;
        this.privateKeyConverter = privateKeyConverter;
        this.parameters = parameters;
        this.paramSpec = paramSpec;
        this.originalSpec = paramSpec;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.key = this.publicKeyConverter.convertKey(this.parameters.getAlgorithm(), publicKey);
        this.initVerify();
        this.isInitState = true;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.key = this.privateKeyConverter.convertKey(this.parameters.getAlgorithm(), privateKey);
        this.initSign(this.fipsProvider.getDefaultSecureRandom());
        this.isInitState = true;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.key = this.privateKeyConverter.convertKey(this.parameters.getAlgorithm(), privateKey);
        this.initSign(random != null ? random : this.fipsProvider.getDefaultSecureRandom());
        this.isInitState = true;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.isInitState = false;
        this.dataStream.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.isInitState = false;
        this.dataStream.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            this.isInitState = true;
            return this.signer.getSignature();
        }
        catch (Exception e) {
            throw new SignatureException(e.toString(), e);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        try {
            this.isInitState = true;
            return this.verifier.isVerified(sigBytes);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            if (this.originalSpec == null) return;
            params = this.originalSpec;
        }
        if (!this.isInitState) {
            throw new ProviderException("cannot call setParameter in the middle of update");
        }
        if (params instanceof PSSParameterSpec) {
            PSSParameterSpec newParamSpec = (PSSParameterSpec)params;
            if (this.originalSpec instanceof PSSParameterSpec) {
                PSSParameterSpec origPssSpec = (PSSParameterSpec)this.originalSpec;
                if (this.originalSpec != PSSParameterSpec.DEFAULT && !DigestUtil.isSameDigest(origPssSpec.getDigestAlgorithm(), newParamSpec.getDigestAlgorithm())) {
                    throw new InvalidAlgorithmParameterException("Parameter must be using " + origPssSpec.getDigestAlgorithm());
                }
            }
            if (!newParamSpec.getMGFAlgorithm().equalsIgnoreCase("MGF1") && !newParamSpec.getMGFAlgorithm().equals(PKCSObjectIdentifiers.id_mgf1.getId())) {
                throw new InvalidAlgorithmParameterException("Unknown mask generation function specified");
            }
            if (!(newParamSpec.getMGFParameters() instanceof MGF1ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unknown MGF parameters");
            }
            MGF1ParameterSpec mgfParams = (MGF1ParameterSpec)newParamSpec.getMGFParameters();
            if (!DigestUtil.isSameDigest(mgfParams.getDigestAlgorithm(), newParamSpec.getDigestAlgorithm())) {
                throw new InvalidAlgorithmParameterException("Digest algorithm for MGF should be the same as for PSS parameters.");
            }
            DigestAlgorithm newDigest = DigestUtil.getDigestID(mgfParams.getDigestAlgorithm());
            if (newDigest == null) {
                throw new InvalidAlgorithmParameterException("No match on MGF digest algorithm: " + mgfParams.getDigestAlgorithm());
            }
            if (!(newDigest instanceof FipsAlgorithm)) {
                throw new InvalidAlgorithmParameterException("Digest algorithm not supported: " + mgfParams.getDigestAlgorithm());
            }
            this.parameters = FipsRSA.PSS.withDigestAlgorithm((FipsDigestAlgorithm)newDigest).withMGFDigest((FipsDigestAlgorithm)newDigest).withSaltLength(newParamSpec.getSaltLength()).withTrailer(this.getPssTrailer(newParamSpec.getTrailerField()));
            this.paramSpec = newParamSpec;
            this.reInit();
            return;
        } else if (params instanceof EdDSASigParameterSpec) {
            Algorithm algorithm = this.parameters.getAlgorithm();
            if (algorithm == null && this.key != null) {
                algorithm = this.key.getAlgorithm();
            }
            if (algorithm == null) throw new InvalidAlgorithmParameterException("cannot identify algorithm, call initSign/initVerify first");
            if (((EdDSASigParameterSpec)params).getContext() == null) return;
            this.paramSpec = params;
            this.parameters = new EdEC.ParametersWithContext((GeneralAlgorithm)algorithm, ((EdDSASigParameterSpec)params).getContext());
            this.reInit();
            return;
        } else {
            if (!(this.parameters instanceof RSA.PSSSignatureParameters) && !(this.parameters instanceof FipsRSA.PSSSignatureParameters)) throw new InvalidAlgorithmParameterException("unknown AlgorithmParameterSpec in signature");
            throw new InvalidAlgorithmParameterException("only PSSParameterSpec supported");
        }
    }

    private void reInit() throws InvalidAlgorithmParameterException {
        if (this.key instanceof AsymmetricPublicKey) {
            this.initVerify();
        } else if (this.key instanceof AsymmetricPrivateKey) {
            try {
                this.initSign(this.appRandom);
            }
            catch (InvalidKeyException e) {
                throw new InvalidAlgorithmParameterException("parameter inappropriate for key:" + e.getMessage());
            }
        }
    }

    private void initVerify() {
        this.verifier = this.operatorFactory.createVerifier((AsymmetricPublicKey)this.key, this.parameters);
        this.dataStream = this.verifier.getVerifyingStream();
    }

    private void initSign(SecureRandom random) throws InvalidKeyException {
        this.appRandom = random;
        try {
            this.signer = Utils.addRandomIfNeeded(this.operatorFactory.createSigner((AsymmetricPrivateKey)this.key, this.parameters), random);
            this.dataStream = this.signer.getSigningStream();
        }
        catch (Exception e) {
            throw new InvalidKeyException("cannot initialize for signing: " + e.getMessage(), e);
        }
    }

    private byte getPssTrailer(int trailerField) {
        if (trailerField == 1) {
            return -68;
        }
        throw new IllegalArgumentException("unknown trailer field");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance("PSS", this.fipsProvider);
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.toString(), e);
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("SetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("GetParameter unsupported");
    }
}

