/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.internal.asn1.cms.GCMParameters;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameters;
import org.bouncycastle.jcajce.provider.GcmSpecUtil;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;

class ASN1AlgorithmParameters
extends BaseAlgorithmParameters {
    private final String algorithm;
    private ASN1Primitive spec;

    ASN1AlgorithmParameters(String algName) {
        this.algorithm = algName;
    }

    @Override
    protected byte[] localGetEncoded() throws IOException {
        return this.spec.getEncoded();
    }

    @Override
    protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == IvParameterSpec.class) {
            if (this.spec instanceof ASN1OctetString) {
                return new IvParameterSpec(ASN1OctetString.getInstance(this.spec).getOctets());
            }
            if (this.spec instanceof ASN1Sequence) {
                return new IvParameterSpec(GCMParameters.getInstance(this.spec).getNonce());
            }
            throw new InvalidParameterSpecException("Cannot convert AlgorithmParameters to IvParameterSpec");
        }
        if (paramSpec == AlgorithmParameterSpec.class) {
            if (this.spec instanceof ASN1OctetString) {
                return new IvParameterSpec(ASN1OctetString.getInstance(this.spec).getOctets());
            }
            if (this.spec instanceof ASN1Sequence) {
                if (GcmSpecUtil.gcmSpecExists()) {
                    return GcmSpecUtil.extractGcmSpec(this.spec);
                }
                GCMParameters gcmParams = GCMParameters.getInstance(this.spec);
                return new AEADParameterSpec(gcmParams.getNonce(), gcmParams.getIcvLen() * 8);
            }
            throw new InvalidParameterSpecException("Cannot convert AlgorithmParameters to IvParameterSpec");
        }
        if (GcmSpecUtil.isGcmSpec(paramSpec)) {
            return GcmSpecUtil.extractGcmSpec(this.spec);
        }
        if (paramSpec == AEADParameterSpec.class && this.spec instanceof ASN1Sequence) {
            try {
                GCMParameters gcmParams = GCMParameters.getInstance(this.spec);
                return new AEADParameterSpec(gcmParams.getNonce(), gcmParams.getIcvLen() * 8);
            }
            catch (Exception e) {
                throw new InvalidParameterSpecException("ASN.1 encoding not recognized: " + e.getMessage());
            }
        }
        throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + paramSpec.getName());
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (paramSpec instanceof IvParameterSpec) {
            this.spec = paramSpec instanceof AEADParameterSpec ? new GCMParameters(((AEADParameterSpec)paramSpec).getNonce(), (((AEADParameterSpec)paramSpec).getMacSizeInBits() + 7) / 8).toASN1Primitive() : new DEROctetString(((IvParameterSpec)paramSpec).getIV());
        } else if (GcmSpecUtil.isGcmSpec(paramSpec)) {
            this.spec = GcmSpecUtil.extractGcmParameters(paramSpec).toASN1Primitive();
        } else {
            throw new InvalidParameterSpecException("AlgorithmParameterSpec class not recognized: " + paramSpec.getClass().getName());
        }
    }

    @Override
    protected void localInit(byte[] params) throws IOException {
        this.spec = ASN1Primitive.fromByteArray(params);
    }

    @Override
    protected String engineToString() {
        return "ASN.1 Parameters";
    }
}

