/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.signers;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.CryptoException;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.Signer;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.util.Arrays;

public class BaseRsaDigestSigner
implements Signer {
    private final AsymmetricBlockCipher rsaEngine;
    private final AlgorithmIdentifier algId;
    private final Digest digest;
    private boolean forSigning;

    public BaseRsaDigestSigner(AsymmetricBlockCipher rsaEngine, Digest digest, ASN1ObjectIdentifier digestOid) {
        this.rsaEngine = rsaEngine;
        this.digest = digest;
        this.algId = new AlgorithmIdentifier(digestOid, DERNull.INSTANCE);
    }

    @Override
    public void init(boolean forSigning, CipherParameters parameters) {
        this.forSigning = forSigning;
        AsymmetricKeyParameter k = parameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)parameters).getParameters() : (AsymmetricKeyParameter)parameters;
        if (forSigning && !k.isPrivate()) {
            throw new IllegalArgumentException("signing requires private key");
        }
        if (!forSigning && k.isPrivate()) {
            throw new IllegalArgumentException("verification requires public key");
        }
        this.reset();
        this.rsaEngine.init(forSigning, parameters);
    }

    @Override
    public void update(byte input) {
        this.digest.update(input);
    }

    @Override
    public void update(byte[] input, int inOff, int length) {
        this.digest.update(input, inOff, length);
    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        if (!this.forSigning) {
            throw new IllegalStateException("RsaDigestSigner not initialised for signature generation.");
        }
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            byte[] data = this.derEncode(hash);
            return this.rsaEngine.processBlock(data, 0, data.length);
        }
        catch (IOException e) {
            throw new CryptoException("unable to encode signature: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean verifySignature(byte[] signature) throws InvalidSignatureException {
        byte[] expected;
        byte[] sig;
        if (this.forSigning) {
            throw new IllegalStateException("RsaDigestSigner not initialised for verification");
        }
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            sig = this.rsaEngine.processBlock(signature, 0, signature.length);
            expected = this.derEncode(hash);
        }
        catch (Exception e) {
            throw new InvalidSignatureException("Unable to process signature: " + e.getMessage(), e);
        }
        return BaseRsaDigestSigner.checkPKCS1Sig(expected, sig);
    }

    @Override
    public void reset() {
        this.digest.reset();
    }

    private byte[] derEncode(byte[] hash) throws IOException {
        DigestInfo dInfo = new DigestInfo(this.algId, hash);
        return dInfo.getEncoded("DER");
    }

    public static boolean checkPKCS1Sig(byte[] expected, byte[] sig) {
        if (sig.length == expected.length) {
            return Arrays.constantTimeAreEqual(expected, sig);
        }
        if (sig.length == expected.length - 2) {
            int i;
            expected[1] = (byte)(expected[1] - 2);
            expected[3] = (byte)(expected[3] - 2);
            int sigOffset = 4 + expected[3];
            int expectedOffset = sigOffset + 2;
            int nonEqual = 0;
            for (i = 0; i < expected.length - expectedOffset; ++i) {
                nonEqual |= sig[sigOffset + i] ^ expected[expectedOffset + i];
            }
            for (i = 0; i < sigOffset; ++i) {
                nonEqual |= sig[i] ^ expected[i];
            }
            return nonEqual == 0;
        }
        Arrays.constantTimeAreEqual(expected, expected);
        return false;
    }
}

