/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.pqc.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.bouncycastle.crypto.internal.pqc.lms.Composer;
import org.bouncycastle.crypto.internal.pqc.lms.LMOtsSignature;
import org.bouncycastle.crypto.internal.pqc.lms.LMSigParameters;
import org.bouncycastle.util.Encodable;
import org.bouncycastle.util.io.Streams;

class LMSSignature
implements Encodable {
    private final int q;
    private final LMOtsSignature otsSignature;
    private final LMSigParameters parameter;
    private final byte[][] y;

    public LMSSignature(int q, LMOtsSignature otsSignature, LMSigParameters parameter, byte[][] y) {
        this.q = q;
        this.otsSignature = otsSignature;
        this.parameter = parameter;
        this.y = y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LMSSignature getInstance(Object src) throws IOException {
        if (src instanceof LMSSignature) {
            return (LMSSignature)src;
        }
        if (src instanceof DataInputStream) {
            int q = ((DataInputStream)src).readInt();
            LMOtsSignature otsSignature = LMOtsSignature.getInstance(src);
            LMSigParameters type = LMSigParameters.getParametersForType(((DataInputStream)src).readInt());
            byte[][] path = new byte[type.getH()][];
            for (int h = 0; h < path.length; ++h) {
                path[h] = new byte[type.getM()];
                ((DataInputStream)src).readFully(path[h]);
            }
            return new LMSSignature(q, otsSignature, type, path);
        }
        if (src instanceof byte[]) {
            try (InputStream in = null;){
                in = new DataInputStream(new ByteArrayInputStream((byte[])src));
                LMSSignature lMSSignature = LMSSignature.getInstance(in);
                return lMSSignature;
            }
        }
        if (src instanceof InputStream) {
            return LMSSignature.getInstance(Streams.readAll((InputStream)src));
        }
        throw new IllegalArgumentException("cannot parse " + src);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LMSSignature that = (LMSSignature)o;
        if (this.q != that.q) {
            return false;
        }
        if (this.otsSignature != null ? !this.otsSignature.equals(that.otsSignature) : that.otsSignature != null) {
            return false;
        }
        if (this.parameter != null ? !this.parameter.equals(that.parameter) : that.parameter != null) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.y, (Object[])that.y);
    }

    public int hashCode() {
        int result = this.q;
        result = 31 * result + (this.otsSignature != null ? this.otsSignature.hashCode() : 0);
        result = 31 * result + (this.parameter != null ? this.parameter.hashCode() : 0);
        result = 31 * result + Arrays.deepHashCode((Object[])this.y);
        return result;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(this.q).bytes(this.otsSignature.getEncoded()).u32str(this.parameter.getType()).bytes(this.y).build();
    }

    public int getQ() {
        return this.q;
    }

    public LMOtsSignature getOtsSignature() {
        return this.otsSignature;
    }

    public LMSigParameters getParameter() {
        return this.parameter;
    }

    public byte[][] getY() {
        return this.y;
    }
}

