/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.modes;

import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.SkippingStreamCipher;
import org.bouncycastle.crypto.internal.StreamBlockCipher;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class SICBlockCipher
extends StreamBlockCipher
implements SkippingStreamCipher {
    private final BlockCipher cipher;
    private final int blockSize;
    private byte[] IV;
    private byte[] counter;
    private byte[] counterOut;
    private int byteCount;

    public SICBlockCipher(BlockCipher c) {
        super(c);
        this.cipher = c;
        this.blockSize = this.cipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.counterOut = new byte[this.blockSize];
        this.byteCount = 0;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof ParametersWithIV) {
            int maxCounterSize;
            ParametersWithIV ivParam = (ParametersWithIV)params;
            this.IV = Arrays.clone(ivParam.getIV());
            int n = maxCounterSize = 8 > this.blockSize / 2 ? this.blockSize / 2 : 8;
            if (this.blockSize - this.IV.length > maxCounterSize) {
                throw new IllegalArgumentException("CTR mode requires IV of at least: " + (this.blockSize - maxCounterSize) + " bytes.");
            }
            if (ivParam.getParameters() != null) {
                this.cipher.init(true, ivParam.getParameters());
            }
        } else {
            throw new IllegalArgumentException("CTR mode requires ParametersWithIV");
        }
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.processBytes(in, inOff, this.blockSize, out, outOff);
        return this.blockSize;
    }

    @Override
    protected byte calculateByte(byte in) throws DataLengthException, IllegalStateException {
        if (this.byteCount == 0) {
            this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
            return (byte)(this.counterOut[this.byteCount++] ^ in);
        }
        byte rv = (byte)(this.counterOut[this.byteCount++] ^ in);
        if (this.byteCount == this.counter.length) {
            this.byteCount = 0;
            this.incrementCounter();
            this.checkCounter();
        }
        return rv;
    }

    private void checkCounter() {
        if (this.IV.length != this.blockSize) {
            for (int i = 0; i != this.IV.length; ++i) {
                if (this.counter[i] == this.IV[i]) continue;
                throw new IllegalStateException("Counter in CTR mode out of range.");
            }
        }
    }

    private void incrementCounterPow2(int pow2Div8) {
        int i = this.counter.length - (1 + pow2Div8);
        while (i >= 0) {
            int n = i--;
            this.counter[n] = (byte)(this.counter[n] + 1);
            if (this.counter[n] == 0) continue;
        }
    }

    private void incrementCounter(int offSet) {
        byte old = this.counter[this.counter.length - 1];
        int n = this.counter.length - 1;
        this.counter[n] = (byte)(this.counter[n] + offSet);
        if (old != 0 && this.counter[this.counter.length - 1] < old) {
            this.incrementCounterPow2(1);
        }
    }

    private void incrementCounter() {
        int i = this.counter.length - 1;
        while (i >= 0) {
            int n = i--;
            this.counter[n] = (byte)(this.counter[n] + 1);
            if (this.counter[n] == 0) continue;
        }
    }

    private void decrementCounterPow2(int pow2Div8) {
        if (this.counter[pow2Div8] == 0) {
            boolean nonZero = false;
            for (int i = this.counter.length - (1 + pow2Div8); i > 0; --i) {
                if (this.counter[i] == 0) continue;
                nonZero = true;
            }
            if (!nonZero) {
                throw new IllegalStateException("attempt to reduce counter past zero.");
            }
        }
        int i = this.counter.length - (1 + pow2Div8);
        while (i >= 0) {
            int n = i--;
            this.counter[n] = (byte)(this.counter[n] - 1);
            if (this.counter[n] == -1) continue;
        }
    }

    private void decrementCounter() {
        int i = this.counter.length - 1;
        while (i >= 0) {
            int n = i--;
            this.counter[n] = (byte)(this.counter[n] - 1);
            if (this.counter[n] == -1) continue;
        }
    }

    private void adjustCounter(long n) {
        if (n >= 0L) {
            long numBlocks = (n + (long)this.byteCount) / (long)this.blockSize;
            if (numBlocks > 255L) {
                long gap = numBlocks;
                for (int i = 5; i >= 1; --i) {
                    long diff = 1L << 8 * i;
                    while (gap >= diff) {
                        this.incrementCounterPow2(i);
                        gap -= diff;
                    }
                }
                this.incrementCounter((int)gap);
            } else {
                this.incrementCounter((int)numBlocks);
            }
            this.byteCount = (int)(n + (long)this.byteCount - (long)this.blockSize * numBlocks);
        } else {
            int gap;
            long numBlocks = (-n - (long)this.byteCount) / (long)this.blockSize;
            if (numBlocks > 255L) {
                long gap2 = numBlocks;
                for (int i = 5; i >= 1; --i) {
                    long diff = 1L << 8 * i;
                    while (gap2 > diff) {
                        this.decrementCounterPow2(i);
                        gap2 -= diff;
                    }
                }
                for (long i = 0L; i != gap2; ++i) {
                    this.decrementCounter();
                }
            } else {
                for (long i = 0L; i != numBlocks; ++i) {
                    this.decrementCounter();
                }
            }
            if ((gap = (int)((long)this.byteCount + n + (long)this.blockSize * numBlocks)) >= 0) {
                this.byteCount = 0;
            } else {
                this.decrementCounter();
                this.byteCount = this.blockSize + gap;
            }
        }
    }

    @Override
    public void reset() {
        Arrays.fill(this.counter, (byte)0);
        System.arraycopy(this.IV, 0, this.counter, 0, this.IV.length);
        this.cipher.reset();
        this.byteCount = 0;
    }

    @Override
    public long skip(long numberOfBytes) {
        this.adjustCounter(numberOfBytes);
        this.checkCounter();
        this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
        return numberOfBytes;
    }

    @Override
    public long seekTo(long position) {
        this.reset();
        return this.skip(position);
    }

    @Override
    public long getPosition() {
        byte[] res = new byte[this.counter.length];
        System.arraycopy(this.counter, 0, res, 0, res.length);
        for (int i = res.length - 1; i >= 1; --i) {
            int v = i < this.IV.length ? (res[i] & 0xFF) - (this.IV[i] & 0xFF) : res[i] & 0xFF;
            if (v < 0) {
                int n = i - 1;
                res[n] = (byte)(res[n] - 1);
                v += 256;
            }
            res[i] = (byte)v;
        }
        return Pack.bigEndianToLong(res, res.length - 8) * (long)this.blockSize + (long)this.byteCount;
    }
}

