/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.macs;

import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.Mac;

public class TruncatingMac
implements Mac {
    private final Mac mac;
    private final int macSizeInBits;

    public TruncatingMac(Mac mac, int macSizeInBits) {
        this.mac = mac;
        this.macSizeInBits = macSizeInBits;
    }

    @Override
    public void init(CipherParameters params) throws IllegalArgumentException {
        this.mac.init(params);
    }

    @Override
    public String getAlgorithmName() {
        return this.mac.getAlgorithmName();
    }

    @Override
    public int getMacSize() {
        return this.macSizeInBits / 8;
    }

    @Override
    public void update(byte in) throws IllegalStateException {
        this.mac.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        this.mac.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        byte[] res = new byte[this.mac.getMacSize()];
        this.mac.doFinal(res, 0);
        System.arraycopy(res, 0, out, outOff, this.macSizeInBits / 8);
        return this.macSizeInBits / 8;
    }

    @Override
    public void reset() {
    }
}

