/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.general.Gost3410KeyGenerationParameters;
import org.bouncycastle.crypto.general.Gost3410Parameters;
import org.bouncycastle.crypto.general.Gost3410PrivateKeyParameters;
import org.bouncycastle.crypto.general.Gost3410PublicKeyParameters;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;

class Gost3410KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private Gost3410KeyGenerationParameters param;

    Gost3410KeyPairGenerator() {
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (Gost3410KeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger x;
        Gost3410Parameters GOST3410Params = this.param.getParameters();
        SecureRandom random = this.param.getRandom();
        BigInteger q = GOST3410Params.getQ();
        BigInteger p = GOST3410Params.getP();
        BigInteger a = GOST3410Params.getA();
        while ((x = new BigInteger(256, random)).equals(ZERO) || x.compareTo(q) >= 0) {
        }
        BigInteger y = a.modPow(x, p);
        return new AsymmetricCipherKeyPair(new Gost3410PublicKeyParameters(y, GOST3410Params), new Gost3410PrivateKeyParameters(x, GOST3410Params));
    }
}

