/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.general.Mode;
import org.bouncycastle.crypto.general.Padding;

public class GeneralAlgorithm
implements Algorithm {
    private final Enum basicVariation;
    private final Enum additionalVariation;
    private final String name;

    GeneralAlgorithm(String name) {
        this(name, null, null);
    }

    GeneralAlgorithm(String name, Enum basicVariation) {
        this(name, basicVariation, null);
    }

    GeneralAlgorithm(GeneralAlgorithm baseAlgorithm, Enum basicVariation) {
        this(baseAlgorithm.getName(), basicVariation, null);
    }

    GeneralAlgorithm(GeneralAlgorithm baseAlgorithm, Enum basicVariation, Padding additionalVariation) {
        this(baseAlgorithm.getName(), basicVariation, additionalVariation);
    }

    GeneralAlgorithm(String name, Enum basicVariation, Padding additionalVariation) {
        this.basicVariation = basicVariation;
        this.additionalVariation = additionalVariation;
        this.name = basicVariation instanceof Mode ? name + "/" + ((Mode)basicVariation).getBaseMode().getCode() + (additionalVariation != null ? "/" + additionalVariation.getBasePadding().getCode() : "") : name;
    }

    Enum basicVariation() {
        return this.basicVariation;
    }

    Enum additionalVariation() {
        return this.additionalVariation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final boolean requiresAlgorithmParameters() {
        return this.basicVariation instanceof Mode && ((Mode)this.basicVariation).getBaseMode().expectsIV() || this.name.indexOf("ChaCha20") >= 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeneralAlgorithm)) {
            return false;
        }
        GeneralAlgorithm other = (GeneralAlgorithm)o;
        if (!this.isEqual(this.additionalVariation, other.additionalVariation)) {
            return false;
        }
        if (!this.isEqual(this.basicVariation, other.basicVariation)) {
            return false;
        }
        return this.name.equals(other.name);
    }

    private boolean isEqual(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    @Override
    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.basicVariation != null ? this.basicVariation.hashCode() : 0);
        result = 31 * result + (this.additionalVariation != null ? this.additionalVariation.hashCode() : 0);
        return result;
    }

    byte[] checkIv(byte[] iv, int blockSize) {
        return ((Mode)this.basicVariation()).checkIv(iv, blockSize);
    }

    byte[] createDefaultIvIfNecessary(int blockSize, SecureRandom random) {
        return ((Mode)this.basicVariation()).createDefaultIvIfNecessary(blockSize, random);
    }

    byte[] createIvIfNecessary(int ivLen, SecureRandom random) {
        return ((Mode)this.basicVariation()).createIvIfNecessary(ivLen, random);
    }
}

