/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.OutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.OutputValidator;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410PrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410PublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.GOST3410DomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import org.bouncycastle.crypto.general.DSAOutputSigner;
import org.bouncycastle.crypto.general.DSAOutputValidator;
import org.bouncycastle.crypto.general.DSAOutputVerifier;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.Gost3410KeyGenerationParameters;
import org.bouncycastle.crypto.general.Gost3410KeyPairGenerator;
import org.bouncycastle.crypto.general.Gost3410Parameters;
import org.bouncycastle.crypto.general.Gost3410PrivateKeyParameters;
import org.bouncycastle.crypto.general.Gost3410PublicKeyParameters;
import org.bouncycastle.crypto.general.Gost3410Signer;
import org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.general.GuardedSignatureOperatorFactory;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.util.encoders.Hex;

public final class GOST3410 {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("GOST3410", (Enum)Variations.GOST3410);
    public static final SignatureParameters GOST3410 = new SignatureParameters();

    private GOST3410() {
    }

    private static Gost3410Parameters getDomainParams(GOST3410Parameters<GOST3410DomainParameters> gostParameters) {
        GOST3410DomainParameters domainParameters = gostParameters.getDomainParameters();
        return new Gost3410Parameters(domainParameters.getP(), domainParameters.getQ(), domainParameters.getA());
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair kp) {
        SelfTestExecutor.validate((Algorithm)ALGORITHM, kp, new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair kp) {
                byte[] data = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                Gost3410Signer signer = new Gost3410Signer();
                signer.init(true, new ParametersWithRandom(kp.getPrivate(), Utils.testRandom));
                BigInteger[] rv = signer.generateSignature(data);
                signer.init(false, kp.getPublic());
                signer.verifySignature(data, rv[0], rv[1]);
                return signer.verifySignature(data, rv[0], rv[1]);
            }
        });
    }

    private static Gost3410PrivateKeyParameters getLwKey(final AsymmetricGOST3410PrivateKey privKey) {
        return AccessController.doPrivileged(new PrivilegedAction<Gost3410PrivateKeyParameters>(){

            @Override
            public Gost3410PrivateKeyParameters run() {
                return new Gost3410PrivateKeyParameters(privKey.getX(), org.bouncycastle.crypto.general.GOST3410.getDomainParams(privKey.getParameters()));
            }
        });
    }

    public static final class KeyGenParameters
    extends GeneralParameters {
        private final GOST3410Parameters<GOST3410DomainParameters> domainParameters;

        public KeyGenParameters(GOST3410Parameters<GOST3410DomainParameters> domainParameters) {
            super(ALGORITHM);
            this.domainParameters = domainParameters;
        }

        public GOST3410Parameters<GOST3410DomainParameters> getDomainParameters() {
            return this.domainParameters;
        }
    }

    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricGOST3410PublicKey, AsymmetricGOST3410PrivateKey> {
        private final Gost3410KeyPairGenerator engine = new Gost3410KeyPairGenerator();
        private final GOST3410Parameters<GOST3410DomainParameters> parameters;
        private final Gost3410KeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom random) {
            super(keyGenParameters);
            this.parameters = keyGenParameters.getDomainParameters();
            this.param = new Gost3410KeyGenerationParameters(random, org.bouncycastle.crypto.general.GOST3410.getDomainParams(this.parameters));
            this.engine.init(this.param);
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricGOST3410PublicKey, AsymmetricGOST3410PrivateKey> doGenerateKeyPair() {
            AsymmetricCipherKeyPair kp = this.engine.generateKeyPair();
            org.bouncycastle.crypto.general.GOST3410.validateKeyPair(kp);
            Gost3410PublicKeyParameters pubKey = (Gost3410PublicKeyParameters)kp.getPublic();
            Gost3410PrivateKeyParameters prvKey = (Gost3410PrivateKeyParameters)kp.getPrivate();
            Object algorithm = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            return new AsymmetricKeyPair<AsymmetricGOST3410PublicKey, AsymmetricGOST3410PrivateKey>(new AsymmetricGOST3410PublicKey((Algorithm)algorithm, this.parameters, pubKey.getY()), new AsymmetricGOST3410PrivateKey((Algorithm)algorithm, this.parameters, prvKey.getX()));
        }
    }

    public static final class SignatureOperatorFactory
    extends GuardedSignatureOperatorFactory<SignatureParameters> {
        @Override
        public OutputSignerUsingSecureRandom<SignatureParameters> doCreateSigner(AsymmetricPrivateKey key, SignatureParameters parameters) {
            Gost3410Signer gost3410Signer = new Gost3410Signer();
            Digest digest = Register.createDigest(parameters.getDigestAlgorithm());
            AsymmetricGOST3410PrivateKey k = (AsymmetricGOST3410PrivateKey)key;
            final Gost3410PrivateKeyParameters privateKeyParameters = org.bouncycastle.crypto.general.GOST3410.getLwKey(k);
            return new DSAOutputSigner<SignatureParameters>(gost3410Signer, digest, parameters, new DSAOutputSigner.Initializer(){

                @Override
                public void initialize(DSA signer, SecureRandom random) {
                    signer.init(true, new ParametersWithRandom(privateKeyParameters, random));
                }
            });
        }

        @Override
        public OutputVerifier<SignatureParameters> doCreateVerifier(AsymmetricPublicKey key, SignatureParameters parameters) {
            Gost3410Signer gost3410Signer = new Gost3410Signer();
            Digest digest = Register.createDigest(parameters.getDigestAlgorithm());
            AsymmetricGOST3410PublicKey k = (AsymmetricGOST3410PublicKey)key;
            Gost3410PublicKeyParameters publicKeyParameters = new Gost3410PublicKeyParameters(k.getY(), org.bouncycastle.crypto.general.GOST3410.getDomainParams(k.getParameters()));
            gost3410Signer.init(false, publicKeyParameters);
            return new DSAOutputVerifier<SignatureParameters>(gost3410Signer, digest, parameters);
        }

        @Override
        public OutputValidator<SignatureParameters> doCreateValidator(AsymmetricPublicKey key, SignatureParameters parameters, byte[] signature) throws InvalidSignatureException {
            Gost3410Signer gost3410Signer = new Gost3410Signer();
            Digest digest = Register.createDigest(parameters.getDigestAlgorithm());
            AsymmetricGOST3410PublicKey k = (AsymmetricGOST3410PublicKey)key;
            Gost3410PublicKeyParameters publicKeyParameters = new Gost3410PublicKeyParameters(k.getY(), org.bouncycastle.crypto.general.GOST3410.getDomainParams(k.getParameters()));
            gost3410Signer.init(false, publicKeyParameters);
            return new DSAOutputValidator<SignatureParameters>(gost3410Signer, digest, parameters, signature);
        }
    }

    public static final class SignatureParameters
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        SignatureParameters() {
            this(SecureHash.Algorithm.GOST3411);
        }

        private SignatureParameters(DigestAlgorithm digestAlgorithm) {
            super(ALGORITHM);
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public SignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new SignatureParameters(digestAlgorithm);
        }
    }

    private static enum Variations {
        GOST3410;

    }
}

