/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.fips.CTRSP800DRBG;
import org.bouncycastle.crypto.fips.ContinuousTestingPseudoRNG;
import org.bouncycastle.crypto.fips.DRBG;
import org.bouncycastle.crypto.fips.DRBGProvider;
import org.bouncycastle.crypto.fips.DRBGPseudoRandom;
import org.bouncycastle.crypto.fips.DesEdeEngine;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsTripleDES;
import org.bouncycastle.crypto.fips.FixedEntropySourceProvider;
import org.bouncycastle.crypto.fips.HMacSP800DRBG;
import org.bouncycastle.crypto.fips.HashSP800DRBG;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.util.BasicEntropySourceProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public final class FipsDRBG {
    public static final Base SHA1 = new Base(new FipsAlgorithm("SHA-1", (Enum)FipsSHS.Variations.SHA1));
    public static final Base SHA224 = new Base(new FipsAlgorithm("SHA-224", (Enum)FipsSHS.Variations.SHA224));
    public static final Base SHA256 = new Base(new FipsAlgorithm("SHA-256", (Enum)FipsSHS.Variations.SHA256));
    public static final Base SHA384 = new Base(new FipsAlgorithm("SHA-384", (Enum)FipsSHS.Variations.SHA384));
    public static final Base SHA512 = new Base(new FipsAlgorithm("SHA-512", (Enum)FipsSHS.Variations.SHA512));
    public static final Base SHA512_224 = new Base(new FipsAlgorithm("SHA-512(224)", (Enum)FipsSHS.Variations.SHA512_224));
    public static final Base SHA512_256 = new Base(new FipsAlgorithm("SHA-512(256)", (Enum)FipsSHS.Variations.SHA512_256));
    public static final Base SHA1_HMAC = new Base(new FipsAlgorithm("SHA-1/HMAC", (Enum)FipsSHS.Variations.SHA1_HMAC));
    public static final Base SHA224_HMAC = new Base(new FipsAlgorithm("SHA-224/HMAC", (Enum)FipsSHS.Variations.SHA224_HMAC));
    public static final Base SHA256_HMAC = new Base(new FipsAlgorithm("SHA-256/HMAC", (Enum)FipsSHS.Variations.SHA256_HMAC));
    public static final Base SHA384_HMAC = new Base(new FipsAlgorithm("SHA-384/HMAC", (Enum)FipsSHS.Variations.SHA384_HMAC));
    public static final Base SHA512_HMAC = new Base(new FipsAlgorithm("SHA-512/HMAC", (Enum)FipsSHS.Variations.SHA512_HMAC));
    public static final Base SHA512_224_HMAC = new Base(new FipsAlgorithm("SHA-512(224)/HMAC", (Enum)FipsSHS.Variations.SHA512_224_HMAC));
    public static final Base SHA512_256_HMAC = new Base(new FipsAlgorithm("SHA-512(256)/HMAC", (Enum)FipsSHS.Variations.SHA512_256_HMAC));
    public static final Base CTR_Triple_DES_168 = new Base(new FipsAlgorithm("TRIPLEDES", (Enum)Variations.CTR_Triple_DES_168));
    public static final Base CTR_AES_128 = new Base(new FipsAlgorithm("AES-128", (Enum)Variations.CTR_AES_128));
    public static final Base CTR_AES_192 = new Base(new FipsAlgorithm("AES-192", (Enum)Variations.CTR_AES_192));
    public static final Base CTR_AES_256 = new Base(new FipsAlgorithm("AES-256", (Enum)Variations.CTR_AES_256));
    private static Map<DRBGKey, FipsSecureRandom> drbgMap;
    private static AtomicLong nonce;

    private FipsDRBG() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FipsSecureRandom fetchBasicDRBG(Algorithm usage, Base drbgBase, byte[] personalizationString) {
        if (usage == null || drbgBase == null || personalizationString == null) {
            throw new NullPointerException("null parameter passed to fetchBasicDRBG()");
        }
        if (!FipsStatus.isReady()) {
            return drbgBase.fromEntropySource(new KATEntropyProvider()).build(null, false, personalizationString);
        }
        DRBGKey key = new DRBGKey(usage, drbgBase.getAlgorithm(), personalizationString);
        FipsSecureRandom drbg = drbgMap.get(key);
        if (drbg == null) {
            Algorithm algorithm = usage;
            synchronized (algorithm) {
                drbg = drbgMap.get(key);
                if (drbg == null) {
                    drbg = drbgBase.fromEntropySource(new SecureRandom(), true).build(Pack.longToBigEndian(nonce.getAndIncrement()), false, personalizationString);
                    drbgMap.put(key, drbg);
                }
            }
        }
        return drbg;
    }

    private static String getSimplifiedName(Digest digest) {
        String name = digest.getAlgorithmName();
        int dIndex = name.indexOf(45);
        if (dIndex > 0 && !name.startsWith("SHA3")) {
            return name.substring(0, dIndex) + name.substring(dIndex + 1);
        }
        return name;
    }

    private static void drbgStartupTest() {
        SelfTestExecutor.validate(SHA256.getAlgorithm(), new DRBGHashSelfTest(SHA256.getAlgorithm(), new DRBGTestVector(FipsSHS.createDigest(FipsSHS.Algorithm.SHA256), new KATEntropyProvider().get(440), true, "2021222324", 256, new String[]{"de1c6b0fe66e9106e5203fa821ead509dda22d703434d56a974eb94a47c90ca1e16479c239ab6097", "05bfd156e55000ff68d9c71c6e9d240b385d3f0f52c8f2ba98f35a76104060cc7ee87083501eb159"}).setPersonalizationString("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576")));
        SelfTestExecutor.validate(SHA256_HMAC.getAlgorithm(), new DRBGHMACSelfTest(SHA256_HMAC.getAlgorithm(), new DRBGTestVector(FipsSHS.createDigest(FipsSHS.Algorithm.SHA256), new KATEntropyProvider().get(440), true, "2021222324", 256, new String[]{"2c332d2c6e24fb45d508614d5af3b1cc604b26c5674865557735b6a2900e39227cd467f0cb7ae0d8", "1a3d5fce46b6b3aebe17b8f6421dfd7fa8dcd0429a749d6d3309f07ff31a742a68eb34bf4104f756"}).setPersonalizationString("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576")));
        SelfTestExecutor.validate(CTR_AES_128.getAlgorithm(), new DRBGCTRSelfTest(CTR_AES_128.getAlgorithm(), new DRBGTestVector((BlockCipher)FipsAES.ENGINE_PROVIDER.createEngine(), 128, new KATEntropyProvider().get(440), true, "2021222324", 128, new String[]{"8339142c7329b506b61514bdb8fd5ad225d72a564b1025000c33c43281ebbe1cddf0eace9493342e", "b6a51deea6c2b019ab9d03ac730388c3af39d41f45c9263008dcf6e1d63dc8e9ad06624a4b5866ef"}).setPersonalizationString("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576")));
    }

    static {
        FipsDRBG.drbgStartupTest();
        drbgMap = new ConcurrentHashMap<DRBGKey, FipsSecureRandom>();
        nonce = new AtomicLong(System.currentTimeMillis());
    }

    public static class Base
    extends FipsParameters {
        Base(FipsAlgorithm algorithm) {
            super(algorithm);
        }

        public Builder fromDefaultEntropy() {
            SecureRandom entropySource = new SecureRandom();
            return new Builder(this.getAlgorithm(), entropySource, new BasicEntropySourceProvider(entropySource, false));
        }

        public Builder fromEntropySource(SecureRandom entropySource, boolean predictionResistant) {
            return new Builder(this.getAlgorithm(), entropySource, new BasicEntropySourceProvider(entropySource, predictionResistant));
        }

        public Builder fromEntropySource(EntropySourceProvider entropySourceProvider) {
            return new Builder(this.getAlgorithm(), null, entropySourceProvider);
        }
    }

    public static class Builder {
        private final FipsAlgorithm algorithm;
        private final SecureRandom random;
        private final EntropySourceProvider entropySourceProvider;
        private byte[] personalizationString;
        private int securityStrength = 256;
        private int entropyBitsRequired = 256;

        Builder(FipsAlgorithm algorithm, SecureRandom random, EntropySourceProvider entropySourceProvider) {
            FipsStatus.isReady();
            this.algorithm = algorithm;
            this.random = random;
            this.entropySourceProvider = entropySourceProvider;
        }

        public Builder setPersonalizationString(byte[] personalizationString) {
            this.personalizationString = Arrays.clone(personalizationString);
            return this;
        }

        public Builder setSecurityStrength(int securityStrength) {
            this.securityStrength = securityStrength;
            return this;
        }

        public Builder setEntropyBitsRequired(int entropyBitsRequired) {
            this.entropyBitsRequired = entropyBitsRequired;
            return this;
        }

        public FipsSecureRandom build(byte[] nonce, boolean predictionResistant) {
            return this.build(nonce, predictionResistant, null);
        }

        public FipsSecureRandom build(byte[] nonce, boolean predictionResistant, byte[] additionalInput) {
            return this.build(this.algorithm, nonce, predictionResistant, additionalInput);
        }

        private FipsSecureRandom build(FipsAlgorithm algorithm, byte[] nonce, boolean predictionResistant, byte[] additionalInput) {
            int keySizeInBits;
            BlockCipher cipher;
            EntropySource entropySource = this.entropySourceProvider.get(this.entropyBitsRequired);
            if (algorithm.basicVariation() instanceof FipsSHS.Variations) {
                switch ((FipsSHS.Variations)algorithm.basicVariation()) {
                    case SHA1: 
                    case SHA224: 
                    case SHA256: 
                    case SHA384: 
                    case SHA512: 
                    case SHA512_224: 
                    case SHA512_256: {
                        HashDRBGProvider hashDRBGProvider = new HashDRBGProvider(algorithm, Arrays.clone(nonce), this.personalizationString, this.securityStrength, additionalInput);
                        return new FipsSecureRandom(this.random, hashDRBGProvider.getAlgorithmName(), new DRBGPseudoRandom(algorithm, entropySource, hashDRBGProvider), entropySource, predictionResistant);
                    }
                    case SHA1_HMAC: 
                    case SHA224_HMAC: 
                    case SHA256_HMAC: 
                    case SHA384_HMAC: 
                    case SHA512_HMAC: 
                    case SHA512_224_HMAC: 
                    case SHA512_256_HMAC: {
                        HMacDRBGProvider hMacDRBGProvider = new HMacDRBGProvider(algorithm, Arrays.clone(nonce), this.personalizationString, this.securityStrength, additionalInput);
                        return new FipsSecureRandom(this.random, hMacDRBGProvider.getAlgorithmName(), new DRBGPseudoRandom(algorithm, entropySource, hMacDRBGProvider), entropySource, predictionResistant);
                    }
                }
                throw new IllegalArgumentException("Unknown algorithm passed to build(): " + algorithm.getName());
            }
            switch ((Variations)algorithm.basicVariation()) {
                case CTR_AES_128: {
                    cipher = (BlockCipher)FipsAES.ENGINE_PROVIDER.createEngine();
                    keySizeInBits = 128;
                    break;
                }
                case CTR_AES_192: {
                    cipher = (BlockCipher)FipsAES.ENGINE_PROVIDER.createEngine();
                    keySizeInBits = 192;
                    break;
                }
                case CTR_AES_256: {
                    cipher = (BlockCipher)FipsAES.ENGINE_PROVIDER.createEngine();
                    keySizeInBits = 256;
                    break;
                }
                case CTR_Triple_DES_168: {
                    cipher = (BlockCipher)FipsTripleDES.ENGINE_PROVIDER.createEngine();
                    keySizeInBits = 168;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown algorithm passed to build(): " + algorithm.getName());
                }
            }
            CTRDRBGProvider ctrDRBGProvider = new CTRDRBGProvider(cipher, keySizeInBits, Arrays.clone(nonce), this.personalizationString, this.securityStrength, additionalInput);
            return new FipsSecureRandom(this.random, ctrDRBGProvider.getAlgorithmName(), new DRBGPseudoRandom(algorithm, entropySource, ctrDRBGProvider), entropySource, predictionResistant);
        }
    }

    private static class CTRDRBGProvider
    implements DRBGProvider {
        private final BlockCipher blockCipher;
        private final int keySizeInBits;
        private final byte[] nonce;
        private final byte[] personalizationString;
        private final int securityStrength;
        private final byte[] primaryAdditionalInput;

        public CTRDRBGProvider(BlockCipher blockCipher, int keySizeInBits, byte[] nonce, byte[] personalizationString, int securityStrength, byte[] primaryAdditionalInput) {
            FipsStatus.isReady();
            this.blockCipher = blockCipher;
            this.keySizeInBits = keySizeInBits;
            this.nonce = nonce;
            this.personalizationString = personalizationString;
            this.securityStrength = securityStrength;
            this.primaryAdditionalInput = primaryAdditionalInput;
        }

        @Override
        public DRBG get(EntropySource entropySource) {
            CTRSP800DRBG drbg = new CTRSP800DRBG(this.blockCipher, this.keySizeInBits, this.securityStrength, entropySource, this.personalizationString, this.nonce);
            return new ContinuousTestingPseudoRNG(drbg, this.primaryAdditionalInput);
        }

        @Override
        public String getAlgorithmName() {
            if (this.blockCipher instanceof DesEdeEngine) {
                return "CTR-DRBG-3KEY-TDES";
            }
            return "CTR-DRBG-" + this.blockCipher.getAlgorithmName() + this.keySizeInBits;
        }
    }

    private static class DRBGCTRSelfTest
    extends DRBGSelfTest {
        private final DRBGTestVector tv;

        DRBGCTRSelfTest(FipsAlgorithm algorithm, DRBGTestVector tv) {
            super(algorithm);
            this.tv = tv;
        }

        @Override
        void evaluate() throws Exception {
            byte[] nonce = this.tv.nonce();
            byte[] personalisationString = this.tv.personalizationString();
            CTRSP800DRBG d = new CTRSP800DRBG(this.tv.getCipher(), this.tv.keySizeInBits(), this.tv.securityStrength(), this.tv.entropySource(), personalisationString, nonce);
            byte[] output = new byte[this.tv.expectedValue(0).length];
            d.generate(output, this.tv.additionalInput(0), this.tv.predictionResistance());
            byte[] expected = this.tv.expectedValue(0);
            if (!Arrays.areEqual(expected, output)) {
                this.fail("Self test " + this.algorithm.getName() + ".1 failed, expected " + Strings.fromByteArray(Hex.encode(this.tv.expectedValue(0))) + " got " + Strings.fromByteArray(Hex.encode(output)));
            }
            output = new byte[this.tv.expectedValue(0).length];
            d.generate(output, this.tv.additionalInput(1), this.tv.predictionResistance());
            expected = this.tv.expectedValue(1);
            if (!Arrays.areEqual(expected, output)) {
                this.fail("Self test " + this.algorithm.getName() + ".2 failed, expected " + Strings.fromByteArray(Hex.encode(this.tv.expectedValue(1))) + " got " + Strings.fromByteArray(Hex.encode(output)));
            }
        }
    }

    private static class DRBGHMACSelfTest
    extends DRBGSelfTest {
        private final DRBGTestVector tv;

        DRBGHMACSelfTest(FipsAlgorithm algorithm, DRBGTestVector tv) {
            super(algorithm);
            this.tv = tv;
        }

        @Override
        void evaluate() throws Exception {
            byte[] nonce = this.tv.nonce();
            byte[] personalisationString = this.tv.personalizationString();
            HMacSP800DRBG d = new HMacSP800DRBG(new HMac(this.tv.getDigest()), this.tv.securityStrength(), this.tv.entropySource(), personalisationString, nonce);
            byte[] output = new byte[this.tv.expectedValue(0).length];
            d.generate(output, this.tv.additionalInput(0), this.tv.predictionResistance());
            byte[] expected = this.tv.expectedValue(0);
            if (!Arrays.areEqual(expected, output)) {
                this.fail("Self test " + this.algorithm.getName() + ".1 failed, expected " + Strings.fromByteArray(Hex.encode(this.tv.expectedValue(0))) + " got " + Strings.fromByteArray(Hex.encode(output)));
            }
            output = new byte[this.tv.expectedValue(0).length];
            d.generate(output, this.tv.additionalInput(1), this.tv.predictionResistance());
            expected = this.tv.expectedValue(1);
            if (!Arrays.areEqual(expected, output)) {
                this.fail("Self test " + this.algorithm.getName() + ".2 failed, expected " + Strings.fromByteArray(Hex.encode(this.tv.expectedValue(1))) + " got " + Strings.fromByteArray(Hex.encode(output)));
            }
        }
    }

    private static class DRBGHashSelfTest
    extends DRBGSelfTest {
        private final DRBGTestVector tv;

        DRBGHashSelfTest(FipsAlgorithm algorithm, DRBGTestVector tv) {
            super(algorithm);
            this.tv = tv;
        }

        @Override
        void evaluate() throws Exception {
            byte[] nonce = this.tv.nonce();
            byte[] personalisationString = this.tv.personalizationString();
            HashSP800DRBG d = new HashSP800DRBG(this.tv.getDigest(), this.tv.securityStrength(), this.tv.entropySource(), personalisationString, nonce);
            byte[] output = new byte[this.tv.expectedValue(0).length];
            d.generate(output, this.tv.additionalInput(0), this.tv.predictionResistance());
            byte[] expected = this.tv.expectedValue(0);
            if (!Arrays.areEqual(expected, output)) {
                this.fail("Self test " + this.algorithm.getName() + ".1 failed, expected " + Strings.fromByteArray(Hex.encode(this.tv.expectedValue(0))) + " got " + Strings.fromByteArray(Hex.encode(output)));
            }
            output = new byte[this.tv.expectedValue(0).length];
            d.generate(output, this.tv.additionalInput(1), this.tv.predictionResistance());
            expected = this.tv.expectedValue(1);
            if (!Arrays.areEqual(expected, output)) {
                this.fail("Self test " + this.algorithm.getName() + ".2 failed, expected " + Strings.fromByteArray(Hex.encode(this.tv.expectedValue(1))) + " got " + Strings.fromByteArray(Hex.encode(output)));
            }
        }
    }

    private static class DRBGKey {
        private final Algorithm algorithm;
        private final Algorithm baseAlg;
        private final byte[] personalizationString;

        public DRBGKey(Algorithm algorithm, Algorithm baseAlg, byte[] personalizationString) {
            this.algorithm = algorithm;
            this.baseAlg = baseAlg;
            this.personalizationString = personalizationString;
        }

        public int hashCode() {
            return 7 * (this.algorithm.hashCode() + 7 * this.baseAlg.hashCode()) + Arrays.hashCode(this.personalizationString);
        }

        public boolean equals(Object o) {
            DRBGKey other = (DRBGKey)o;
            return this.algorithm.equals(other.algorithm) && this.baseAlg.equals(this.baseAlg) && Arrays.areEqual(this.personalizationString, other.personalizationString);
        }
    }

    private static abstract class DRBGSelfTest
    extends VariantInternalKatTest {
        DRBGSelfTest(FipsAlgorithm algorithm) {
            super(algorithm);
        }
    }

    private static class DRBGTestVector {
        private Digest _digest;
        private BlockCipher _cipher;
        private int _keySizeInBits;
        private EntropySource _eSource;
        private boolean _pr;
        private String _nonce;
        private String _personalisation;
        private int _ss;
        private String[] _ev;
        private List _ai = new ArrayList();

        public DRBGTestVector(Digest digest, EntropySource eSource, boolean predictionResistance, String nonce, int securityStrength, String[] expected) {
            this._digest = digest;
            this._eSource = eSource;
            this._pr = predictionResistance;
            this._nonce = nonce;
            this._ss = securityStrength;
            this._ev = expected;
            this._personalisation = null;
        }

        public DRBGTestVector(BlockCipher cipher, int keySizeInBits, EntropySource eSource, boolean predictionResistance, String nonce, int securityStrength, String[] expected) {
            this._cipher = cipher;
            this._keySizeInBits = keySizeInBits;
            this._eSource = eSource;
            this._pr = predictionResistance;
            this._nonce = nonce;
            this._ss = securityStrength;
            this._ev = expected;
            this._personalisation = null;
        }

        public Digest getDigest() {
            return this._digest;
        }

        public BlockCipher getCipher() {
            return this._cipher;
        }

        public int keySizeInBits() {
            return this._keySizeInBits;
        }

        public DRBGTestVector addAdditionalInput(String input) {
            this._ai.add(input);
            return this;
        }

        public DRBGTestVector setPersonalizationString(String p) {
            this._personalisation = p;
            return this;
        }

        public EntropySource entropySource() {
            return this._eSource;
        }

        public boolean predictionResistance() {
            return this._pr;
        }

        public byte[] nonce() {
            if (this._nonce == null) {
                return null;
            }
            return Hex.decode(this._nonce);
        }

        public byte[] personalizationString() {
            if (this._personalisation == null) {
                return null;
            }
            return Hex.decode(this._personalisation);
        }

        public int securityStrength() {
            return this._ss;
        }

        public byte[] expectedValue(int index) {
            return Hex.decode(this._ev[index]);
        }

        public byte[] additionalInput(int position) {
            int len = this._ai.size();
            byte[] rv = position >= len ? null : Hex.decode((String)this._ai.get(position));
            return rv;
        }
    }

    private static class HMacDRBGProvider
    implements DRBGProvider {
        private final Mac hMac;
        private final byte[] nonce;
        private final byte[] personalizationString;
        private final int securityStrength;
        private final byte[] primaryAdditionalInput;

        public HMacDRBGProvider(FipsAlgorithm algorithm, byte[] nonce, byte[] personalizationString, int securityStrength, byte[] primaryAdditionalInput) {
            FipsStatus.isReady();
            this.hMac = FipsSHS.createHMac(algorithm);
            this.nonce = nonce;
            this.personalizationString = personalizationString;
            this.securityStrength = securityStrength;
            this.primaryAdditionalInput = primaryAdditionalInput;
        }

        @Override
        public DRBG get(EntropySource entropySource) {
            HMacSP800DRBG drbg = new HMacSP800DRBG(this.hMac, this.securityStrength, entropySource, this.personalizationString, this.nonce);
            return new ContinuousTestingPseudoRNG(drbg, this.primaryAdditionalInput);
        }

        @Override
        public String getAlgorithmName() {
            if (this.hMac instanceof HMac) {
                return "HMAC-DRBG-" + FipsDRBG.getSimplifiedName(((HMac)this.hMac).getUnderlyingDigest());
            }
            return "HMAC-DRBG-" + this.hMac.getAlgorithmName();
        }
    }

    private static class HashDRBGProvider
    implements DRBGProvider {
        private final Digest digest;
        private final byte[] nonce;
        private final byte[] personalizationString;
        private final int securityStrength;
        private final byte[] primaryAdditionalInput;

        public HashDRBGProvider(FipsAlgorithm algorithm, byte[] nonce, byte[] personalizationString, int securityStrength, byte[] primaryAdditionalInput) {
            FipsStatus.isReady();
            this.digest = FipsSHS.createDigest(algorithm);
            this.nonce = nonce;
            this.personalizationString = personalizationString;
            this.securityStrength = securityStrength;
            this.primaryAdditionalInput = primaryAdditionalInput;
        }

        @Override
        public DRBG get(EntropySource entropySource) {
            HashSP800DRBG drbg = new HashSP800DRBG(this.digest, this.securityStrength, entropySource, this.personalizationString, this.nonce);
            return new ContinuousTestingPseudoRNG(drbg, this.primaryAdditionalInput);
        }

        @Override
        public String getAlgorithmName() {
            return "HASH-DRBG-" + FipsDRBG.getSimplifiedName(this.digest);
        }
    }

    private static class KATEntropyProvider
    extends FixedEntropySourceProvider {
        KATEntropyProvider() {
            super(Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F30313233343536808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6C0C1C2C3C4C5C6C7C8C9CACBCCCDCECFD0D1D2D3D4D5D6D7D8D9DADBDCDDDEDFE0E1E2E3E4E5E6E7E8E9EAEBECEDEEEFF0F1F2F3F4F5F6"), true);
        }
    }

    private static enum Variations {
        CTR_Triple_DES_168,
        CTR_AES_128,
        CTR_AES_192,
        CTR_AES_256;

    }
}

