/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.DsaKCalculator;
import org.bouncycastle.crypto.fips.RandomDsaKCalculator;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.params.DsaKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaParameters;
import org.bouncycastle.crypto.internal.params.DsaPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.util.BigIntegers;

class DsaSigner
implements DSA {
    private final DsaKCalculator kCalculator;
    private DsaKeyParameters key;
    private SecureRandom random;

    public DsaSigner() {
        this.kCalculator = new RandomDsaKCalculator();
    }

    public DsaSigner(DsaKCalculator kCalculator) {
        this.kCalculator = kCalculator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (!(param instanceof ParametersWithRandom)) throw new IllegalArgumentException("No random provided where one required.");
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.random = rParam.getRandom();
            this.key = (DsaPrivateKeyParameters)rParam.getParameters();
            return;
        } else {
            this.key = (DsaPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        DsaParameters params = this.key.getParameters();
        BigInteger q = params.getQ();
        BigInteger m = this.calculateE(q, message);
        BigInteger x = ((DsaPrivateKeyParameters)this.key).getX();
        if (this.kCalculator.isDeterministic()) {
            this.kCalculator.init(q, x, message);
        } else {
            this.kCalculator.init(q, this.random);
        }
        BigInteger k = this.kCalculator.nextK();
        BigInteger r = params.getG().modPow(k.add(this.getRandomizer(q, this.random)), params.getP()).mod(q);
        k = BigIntegers.modOddInverse(q, k).multiply(m.add(x.multiply(r)));
        BigInteger s = k.mod(q);
        return new BigInteger[]{r, s};
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        DsaParameters params = this.key.getParameters();
        BigInteger q = params.getQ();
        BigInteger m = this.calculateE(q, message);
        BigInteger zero = BigInteger.valueOf(0L);
        if (zero.compareTo(r) >= 0 || q.compareTo(r) <= 0) {
            return false;
        }
        if (zero.compareTo(s) >= 0 || q.compareTo(s) <= 0) {
            return false;
        }
        BigInteger w = BigIntegers.modOddInverseVar(q, s);
        BigInteger u1 = m.multiply(w).mod(q);
        BigInteger u2 = r.multiply(w).mod(q);
        u1 = params.getG().modPow(u1, params.getP());
        u2 = ((DsaPublicKeyParameters)this.key).getY().modPow(u2, params.getP());
        BigInteger v = u1.multiply(u2).mod(params.getP()).mod(q);
        return v.equals(r);
    }

    private BigInteger calculateE(BigInteger n, byte[] message) {
        if (n.bitLength() >= message.length * 8) {
            return new BigInteger(1, message);
        }
        byte[] trunc = new byte[n.bitLength() / 8];
        System.arraycopy(message, 0, trunc, 0, trunc.length);
        return new BigInteger(1, trunc);
    }

    private BigInteger getRandomizer(BigInteger q, SecureRandom provided) {
        int randomBits = 7;
        return new BigInteger(randomBits, provided).add(BigInteger.valueOf(128L)).multiply(q);
    }
}

