/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.internal.params.DhParameters;
import org.bouncycastle.math.ec.WNafUtil;
import org.bouncycastle.util.BigIntegers;

class DhKeyGeneratorHelper {
    static final DhKeyGeneratorHelper INSTANCE = new DhKeyGeneratorHelper();

    private DhKeyGeneratorHelper() {
    }

    BigInteger calculatePrivate(DhParameters dhParams, SecureRandom random) {
        BigInteger x;
        BigInteger q;
        int limit = dhParams.getL();
        if (limit != 0) {
            BigInteger x2;
            int minWeight = limit >>> 2;
            while (WNafUtil.getNafWeight(x2 = BigIntegers.createRandomBigInteger(limit, random).setBit(limit - 1)) < minWeight) {
            }
            return x2;
        }
        BigInteger min = BigIntegers.TWO;
        int m = dhParams.getM();
        if (m != 0) {
            min = BigIntegers.ONE.shiftLeft(m - 1);
        }
        if ((q = dhParams.getQ()) == null) {
            q = dhParams.getP();
        }
        BigInteger max = q.subtract(BigIntegers.TWO);
        int minWeight = max.bitLength() >>> 2;
        while (WNafUtil.getNafWeight(x = BigIntegers.createRandomInRange(min, max, random)) < minWeight) {
        }
        return x;
    }

    BigInteger calculatePublic(DhParameters dhParams, BigInteger x) {
        return dhParams.getG().modPow(x, dhParams.getP());
    }
}

