/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHKey;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.general.EdEC;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;

public final class AsymmetricXDHPrivateKey
extends AsymmetricXDHKey
implements Destroyable,
AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final byte[] keyData;
    private byte[] publicData;
    private boolean hasPublicKey;
    private ASN1Set attributes;
    private int hashCode;

    public AsymmetricXDHPrivateKey(Algorithm algorithm, byte[] keyData, byte[] publicData) {
        super(algorithm);
        this.keyData = Arrays.clone(keyData);
        this.hashCode = this.calculateHashCode();
        this.attributes = null;
        if (publicData == null) {
            this.hasPublicKey = false;
            this.publicData = EdEC.computePublicData(algorithm, keyData);
        } else {
            this.hasPublicKey = true;
            this.publicData = Arrays.clone(publicData);
        }
    }

    public AsymmetricXDHPrivateKey(byte[] encoding) throws IOException {
        this(PrivateKeyInfo.getInstance(encoding));
    }

    public AsymmetricXDHPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        super(EdECObjectIdentifiers.id_X448.equals(keyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? EdEC.Algorithm.X448 : EdEC.Algorithm.X25519);
        byte[] infoOcts = keyInfo.getPrivateKey().getOctets();
        if (infoOcts.length == 32 || infoOcts.length == 56) {
            this.keyData = Arrays.clone(infoOcts);
        } else {
            ASN1Encodable keyOcts = keyInfo.parsePrivateKey();
            this.keyData = Arrays.clone(ASN1OctetString.getInstance(keyOcts).getOctets());
        }
        if (keyInfo.hasPublicKey()) {
            this.hasPublicKey = true;
            this.publicData = Arrays.clone(keyInfo.getPublicKeyData().getOctets());
        } else {
            this.publicData = null;
        }
        if (EdECObjectIdentifiers.id_X448.equals(keyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? this.keyData.length != 56 : this.keyData.length != 32) {
            throw new IllegalArgumentException("raw key data incorrect size");
        }
        this.attributes = keyInfo.getAttributes();
        this.hashCode = this.calculateHashCode();
    }

    public byte[] getSecret() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        byte[] clone = Arrays.clone(this.keyData);
        KeyUtils.checkDestroyed(this);
        return clone;
    }

    public byte[] getPublicData() {
        byte[] clone = Arrays.clone(this.publicData);
        KeyUtils.checkDestroyed(this);
        return clone;
    }

    @Override
    public byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        byte[] pubData = this.hasPublicKey && !Properties.isOverrideSet("org.bouncycastle.pkcs8.v1_info_only") ? this.publicData : null;
        ASN1Set attributes = this.attributes;
        if (this.getAlgorithm().equals(EdEC.Algorithm.X448)) {
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X448), new DEROctetString(this.getSecret()), attributes, pubData);
        }
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), new DEROctetString(this.getSecret()), attributes, pubData);
    }

    @Override
    protected void zeroize() {
        super.zeroize();
        Arrays.clear(this.keyData);
    }

    @Override
    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            Arrays.clear(this.keyData);
            if (this.publicData != null) {
                Arrays.clear(this.publicData);
            }
            this.publicData = null;
            this.hasPublicKey = false;
            this.attributes = null;
            this.hashCode = -1;
        }
    }

    @Override
    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    @Override
    public boolean equals(Object o) {
        this.checkApprovedOnlyModeStatus();
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricXDHPrivateKey)) {
            return false;
        }
        AsymmetricXDHPrivateKey other = (AsymmetricXDHPrivateKey)o;
        other.checkApprovedOnlyModeStatus();
        return this.hashCode == other.hashCode && KeyUtils.isFieldEqual(this.getAlgorithm(), other.getAlgorithm()) && Arrays.constantTimeAreEqual(this.keyData, other.keyData);
    }

    @Override
    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result = this.getAlgorithm().hashCode();
        result = 31 * result + Arrays.hashCode(this.keyData);
        return result;
    }
}

