/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAKey;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.general.EdEC;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public final class AsymmetricEdDSAPublicKey
extends AsymmetricEdDSAKey
implements AsymmetricPublicKey {
    static final byte[] Ed448Prefix = Hex.decode("3043300506032b6571033a00");
    static final byte[] Ed25519Prefix = Hex.decode("302a300506032b6570032100");
    private static final byte Ed448_type = 113;
    private static final byte Ed25519_type = 112;
    private final byte[] keyData;
    private final int hashCode;

    public AsymmetricEdDSAPublicKey(Algorithm algorithm, byte[] keyData) {
        super(algorithm);
        this.keyData = KeyUtils.isValidEdDSAPublicKey(Arrays.clone(keyData));
        this.hashCode = this.calculateHashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AsymmetricEdDSAPublicKey(byte[] encoding) {
        super(encoding[8] == 113 ? EdEC.Algorithm.Ed448 : EdEC.Algorithm.Ed25519);
        if (encoding[8] == 113) {
            if (!KeyUtils.isValidPrefix(Ed448Prefix, encoding) || encoding.length - Ed448Prefix.length != 57) throw new IllegalArgumentException("raw key data not recognised");
            this.keyData = KeyUtils.isValidEdDSAPublicKey(Arrays.copyOfRange(encoding, Ed448Prefix.length, encoding.length));
        } else {
            if (!KeyUtils.isValidPrefix(Ed25519Prefix, encoding) || encoding.length - Ed25519Prefix.length != 32) throw new IllegalArgumentException("raw key data not recognised");
            this.keyData = KeyUtils.isValidEdDSAPublicKey(Arrays.copyOfRange(encoding, Ed25519Prefix.length, encoding.length));
        }
        this.hashCode = this.calculateHashCode();
    }

    public byte[] getPublicData() {
        return Arrays.clone(this.keyData);
    }

    @Override
    public byte[] getEncoded() {
        if (this.getAlgorithm().equals(EdEC.Algorithm.Ed448)) {
            byte[] encoding = new byte[Ed448Prefix.length + this.keyData.length];
            System.arraycopy(Ed448Prefix, 0, encoding, 0, Ed448Prefix.length);
            System.arraycopy(this.keyData, 0, encoding, Ed448Prefix.length, this.keyData.length);
            return encoding;
        }
        byte[] encoding = new byte[Ed25519Prefix.length + this.keyData.length];
        System.arraycopy(Ed25519Prefix, 0, encoding, 0, Ed25519Prefix.length);
        System.arraycopy(this.keyData, 0, encoding, Ed25519Prefix.length, this.keyData.length);
        return encoding;
    }

    @Override
    public boolean equals(Object o) {
        this.checkApprovedOnlyModeStatus();
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricEdDSAPublicKey)) {
            return false;
        }
        AsymmetricEdDSAPublicKey other = (AsymmetricEdDSAPublicKey)o;
        if (!Arrays.areEqual(this.keyData, other.keyData)) {
            return false;
        }
        return this.getAlgorithm().equals(other.getAlgorithm());
    }

    @Override
    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result = this.getAlgorithm().hashCode();
        result = 31 * result + Arrays.hashCode(this.keyData);
        return result;
    }
}

