/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.util.Arrays;
import sun.security.internal.spec.TlsKeyMaterialParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialSpec;
import sun.security.internal.spec.TlsMasterSecretParameterSpec;
import sun.security.internal.spec.TlsPrfParameterSpec;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;

class ProvSunTLSKDF
extends AsymmetricAlgorithmProvider {
    private static final boolean hasPrfMethods = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                Class<?> def = BouncyCastleFipsProvider.class.getClassLoader().loadClass("sun.security.internal.spec.TlsPrfParameterSpec");
                return def.getMethod("getPRFHashAlg", new Class[0]) != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    });
    private static final Constructor tlsPrfParameterSpecConstructor;
    private static final boolean hasGetEncodeSecretMethod;
    private static final String PROVIDER_PACKAGE = "org.bouncycastle.jcajce.provider.";
    private static final String SYMMETRIC_PACKAGE = "org.bouncycastle.jcajce.provider.symmetric.";
    private static final String KDF_PACKAGE = "org.bouncycastle.jcajce.provider.symmetric.kdf.";

    ProvSunTLSKDF() {
    }

    public void configure(BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("KeyGenerator.SUNTLSRSAPREMASTERSECRET", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLSKeyGeneratorPremaster", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new TLSRsaPreMasterSecretGenerator();
            }
        });
        provider.addAlgorithmImplementation("KeyGenerator.SUNTLS12RSAPREMASTERSECRET", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLS12KeyGeneratorPremaster", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new TLSRsaPreMasterSecretGenerator();
            }
        });
        provider.addAlgorithmImplementation("KeyGenerator.SUNTLSMASTERSECRET", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLSKeyGeneratorMaster", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new TLSMasterSecretGenerator();
            }
        });
        provider.addAlgorithmImplementation("KeyGenerator.SUNTLSEXTENDEDMASTERSECRET", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLSExtendedKeyGeneratorMaster", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new TLSExtendedMasterSecretGenerator();
            }
        });
        provider.addAlgorithmImplementation("KeyGenerator.SUNTLS12MASTERSECRET", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLS12KeyGeneratorMaster", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new TLSMasterSecretGenerator();
            }
        });
        provider.addAlgorithmImplementation("KeyGenerator.SUNTLSKEYMATERIAL", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLSKeyGeneratorKeyMaterial", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new TLSKeyMaterialGenerator();
            }
        });
        provider.addAlgorithmImplementation("KeyGenerator.SUNTLS12KEYMATERIAL", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLS12KeyGeneratorKeyMaterial", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new TLSKeyMaterialGenerator();
            }
        });
        provider.addAlgorithmImplementation("KeyGenerator.SUNTLSPRF", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLSKeyGeneratorPRF", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new TLSPRFKeyGenerator();
            }
        });
        provider.addAlgorithmImplementation("KeyGenerator.SUNTLS12PRF", "org.bouncycastle.jcajce.provider.symmetric.kdf.SunTLS12KeyGeneratorPRF", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new TLSPRFKeyGenerator();
            }
        });
    }

    private static FipsKDF.TLSPRF getPRF(String alg) {
        if (alg.equals("NONE")) {
            return null;
        }
        if (alg.equals("SHA-256")) {
            return FipsKDF.TLSPRF.SHA256_HMAC;
        }
        if (alg.equals("SHA-384")) {
            return FipsKDF.TLSPRF.SHA384_HMAC;
        }
        if (alg.equals("SHA-512")) {
            return FipsKDF.TLSPRF.SHA512_HMAC;
        }
        throw new IllegalStateException("Unknown PRF: " + alg);
    }

    private static TlsPrfParameterSpec createPrfParameterSpec(SecretKey secret, String label, byte[] seed, int outputLength, String prfHashAlg, int prfHashLength, int prfBlockSize) {
        Object[] args = hasPrfMethods ? new Object[]{secret, label, seed, outputLength, prfHashAlg, prfHashLength, prfBlockSize} : new Object[]{secret, label, seed, outputLength};
        try {
            return (TlsPrfParameterSpec)tlsPrfParameterSpecConstructor.newInstance(args);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to construct TlsPrfParameterSpec: " + e.getMessage(), e);
        }
    }

    static {
        hasGetEncodeSecretMethod = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Class<?> def = BouncyCastleFipsProvider.class.getClassLoader().loadClass("sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec");
                    return def.getMethod("getEncodedSecret", new Class[0]) != null;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
        tlsPrfParameterSpecConstructor = AccessController.doPrivileged(new PrivilegedAction<Constructor>(){

            @Override
            public Constructor run() {
                try {
                    Class<?> def = BouncyCastleFipsProvider.class.getClassLoader().loadClass("sun.security.internal.spec.TlsPrfParameterSpec");
                    return def.getConstructors()[0];
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    static abstract class BaseTLSKeyGeneratorSpi
    extends KeyGeneratorSpi {
        protected SecureRandom secureRandom = null;

        BaseTLSKeyGeneratorSpi() {
        }

        protected void engineInit(SecureRandom secureRandom) {
            throw new UnsupportedOperationException();
        }

        protected void engineInit(int keySize, SecureRandom secureRandom) {
            throw new UnsupportedOperationException();
        }

        protected SecretKey calculatePRF(TlsPrfParameterSpec spec, String keyAlg) {
            FipsKDF.TLSPRF prf;
            FipsKDF.TLSParametersBuilder pBld = hasPrfMethods ? ((prf = ProvSunTLSKDF.getPRF(spec.getPRFHashAlg())) == null ? FipsKDF.TLS1_1 : FipsKDF.TLS1_2.withPRF(prf)) : FipsKDF.TLS1_1;
            FipsKDF.TLSParameters tlsParams = pBld.using(spec.getSecret().getEncoded(), spec.getLabel(), new byte[][]{spec.getSeed()});
            KDFCalculator<FipsKDF.TLSParameters> kdfCalculator = new FipsKDF.TLSOperatorFactory().createKDFCalculator(tlsParams);
            byte[] prfOutput = new byte[spec.getOutputLength()];
            kdfCalculator.generateBytes(prfOutput);
            return new SecretKeySpec(prfOutput, keyAlg);
        }
    }

    static final class TLSExtendedMasterSecretGenerator
    extends BaseTLSKeyGeneratorSpi {
        private TlsMasterSecretParameterSpec spec;

        TLSExtendedMasterSecretGenerator() {
        }

        protected void engineInit(SecureRandom secureRandom) {
            throw new InvalidParameterException("only initialise with TlsMasterSecretParameterSpec");
        }

        protected void engineInit(int keySize, SecureRandom secureRandom) {
            throw new InvalidParameterException("only initialise with TlsMasterSecretParameterSpec");
        }

        protected void engineInit(final AlgorithmParameterSpec algorithmParameterSpec, final SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    TLSExtendedMasterSecretGenerator.this.spec = (TlsMasterSecretParameterSpec)algorithmParameterSpec;
                    TLSExtendedMasterSecretGenerator.this.secureRandom = secureRandom;
                    return null;
                }
            });
        }

        protected SecretKey engineGenerateKey() {
            return AccessController.doPrivileged(new PrivilegedAction<SecretKey>(){

                @Override
                public SecretKey run() {
                    String label = "extended master secret";
                    byte[] seed = TLSExtendedMasterSecretGenerator.this.spec.getExtendedMasterSecretSessionHash();
                    int version = TLSExtendedMasterSecretGenerator.this.spec.getMajorVersion() << 8 | TLSExtendedMasterSecretGenerator.this.spec.getMinorVersion();
                    TlsPrfParameterSpec prfSpec = version >= 771 ? ProvSunTLSKDF.createPrfParameterSpec(TLSExtendedMasterSecretGenerator.this.spec.getPremasterSecret(), label, seed, 48, TLSExtendedMasterSecretGenerator.this.spec.getPRFHashAlg(), TLSExtendedMasterSecretGenerator.this.spec.getPRFHashLength(), TLSExtendedMasterSecretGenerator.this.spec.getPRFBlockSize()) : ProvSunTLSKDF.createPrfParameterSpec(TLSExtendedMasterSecretGenerator.this.spec.getPremasterSecret(), label, seed, 48, "NONE", 0, 0);
                    return TLSExtendedMasterSecretGenerator.this.calculatePRF(prfSpec, "TlsMasterSecret");
                }
            });
        }
    }

    static final class TLSKeyMaterialGenerator
    extends BaseTLSKeyGeneratorSpi {
        private TlsKeyMaterialParameterSpec spec;

        TLSKeyMaterialGenerator() {
        }

        protected void engineInit(final AlgorithmParameterSpec algorithmParameterSpec, final SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    TLSKeyMaterialGenerator.this.spec = (TlsKeyMaterialParameterSpec)algorithmParameterSpec;
                    TLSKeyMaterialGenerator.this.secureRandom = secureRandom;
                    return null;
                }
            });
        }

        protected SecretKey engineGenerateKey() {
            return AccessController.doPrivileged(new PrivilegedAction<SecretKey>(){

                @Override
                public SecretKey run() {
                    if (TLSKeyMaterialGenerator.this.spec.getExpandedCipherKeyLength() > 0) {
                        throw new UnsupportedOperationException();
                    }
                    int cipherKeyLength = TLSKeyMaterialGenerator.this.spec.getCipherKeyLength();
                    int ivLength = TLSKeyMaterialGenerator.this.spec.getIvLength();
                    int macKeyLength = TLSKeyMaterialGenerator.this.spec.getMacKeyLength();
                    int total = (cipherKeyLength + ivLength + macKeyLength) * 2;
                    byte[] seed = Arrays.concatenate(TLSKeyMaterialGenerator.this.spec.getServerRandom(), TLSKeyMaterialGenerator.this.spec.getClientRandom());
                    TlsPrfParameterSpec prfSpec = hasPrfMethods ? ProvSunTLSKDF.createPrfParameterSpec(TLSKeyMaterialGenerator.this.spec.getMasterSecret(), "key expansion", seed, total, TLSKeyMaterialGenerator.this.spec.getPRFHashAlg(), TLSKeyMaterialGenerator.this.spec.getPRFHashLength(), TLSKeyMaterialGenerator.this.spec.getPRFBlockSize()) : ProvSunTLSKDF.createPrfParameterSpec(TLSKeyMaterialGenerator.this.spec.getMasterSecret(), "key expansion", seed, total, null, 0, 0);
                    byte[] keyMaterial = TLSKeyMaterialGenerator.this.calculatePRF(prfSpec, "DUMMY").getEncoded();
                    SecretKeySpec clientMacKey = null;
                    SecretKeySpec serverMacKey = null;
                    SecretKeySpec clientCipherKey = null;
                    SecretKeySpec serverCipherKey = null;
                    IvParameterSpec clientIv = null;
                    IvParameterSpec serverIv = null;
                    int offset = 0;
                    if (macKeyLength > 0) {
                        String macAlgorithm = "DUMMY";
                        clientMacKey = new SecretKeySpec(keyMaterial, offset, macKeyLength, macAlgorithm);
                        serverMacKey = new SecretKeySpec(keyMaterial, offset += macKeyLength, macKeyLength, macAlgorithm);
                        offset += macKeyLength;
                    }
                    if (cipherKeyLength > 0) {
                        String cipherAlgorithm = TLSKeyMaterialGenerator.this.spec.getCipherAlgorithm();
                        clientCipherKey = new SecretKeySpec(keyMaterial, offset, cipherKeyLength, cipherAlgorithm);
                        serverCipherKey = new SecretKeySpec(keyMaterial, offset += cipherKeyLength, cipherKeyLength, cipherAlgorithm);
                        offset += cipherKeyLength;
                    }
                    if (ivLength > 0) {
                        clientIv = new IvParameterSpec(keyMaterial, offset, ivLength);
                        serverIv = new IvParameterSpec(keyMaterial, offset += ivLength, ivLength);
                        offset += ivLength;
                    }
                    if (offset != total) {
                        throw new IllegalStateException();
                    }
                    return new TlsKeyMaterialSpec(clientMacKey, serverMacKey, clientCipherKey, clientIv, serverCipherKey, serverIv);
                }
            });
        }
    }

    static final class TLSMasterSecretGenerator
    extends BaseTLSKeyGeneratorSpi {
        private TlsMasterSecretParameterSpec spec;

        TLSMasterSecretGenerator() {
        }

        protected void engineInit(final AlgorithmParameterSpec algorithmParameterSpec, final SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    TLSMasterSecretGenerator.this.spec = (TlsMasterSecretParameterSpec)algorithmParameterSpec;
                    TLSMasterSecretGenerator.this.secureRandom = secureRandom;
                    return null;
                }
            });
        }

        protected SecretKey engineGenerateKey() {
            return AccessController.doPrivileged(new PrivilegedAction<SecretKey>(){

                @Override
                public SecretKey run() {
                    byte[] seed = Arrays.concatenate(TLSMasterSecretGenerator.this.spec.getClientRandom(), TLSMasterSecretGenerator.this.spec.getServerRandom());
                    TlsPrfParameterSpec prfSpec = hasPrfMethods ? ProvSunTLSKDF.createPrfParameterSpec(TLSMasterSecretGenerator.this.spec.getPremasterSecret(), "master secret", seed, 48, TLSMasterSecretGenerator.this.spec.getPRFHashAlg(), TLSMasterSecretGenerator.this.spec.getPRFHashLength(), TLSMasterSecretGenerator.this.spec.getPRFBlockSize()) : ProvSunTLSKDF.createPrfParameterSpec(TLSMasterSecretGenerator.this.spec.getPremasterSecret(), "master secret", seed, 48, null, 0, 0);
                    return TLSMasterSecretGenerator.this.calculatePRF(prfSpec, "TlsMasterSecret");
                }
            });
        }
    }

    static final class TLSPRFKeyGenerator
    extends BaseTLSKeyGeneratorSpi {
        private TlsPrfParameterSpec spec;

        TLSPRFKeyGenerator() {
        }

        protected void engineInit(final AlgorithmParameterSpec algorithmParameterSpec, final SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    TLSPRFKeyGenerator.this.spec = (TlsPrfParameterSpec)algorithmParameterSpec;
                    TLSPRFKeyGenerator.this.secureRandom = secureRandom;
                    return null;
                }
            });
        }

        protected SecretKey engineGenerateKey() {
            return AccessController.doPrivileged(new PrivilegedAction<SecretKey>(){

                @Override
                public SecretKey run() {
                    return TLSPRFKeyGenerator.this.calculatePRF(TLSPRFKeyGenerator.this.spec, "DUMMY");
                }
            });
        }
    }

    static final class TLSRsaPreMasterSecretGenerator
    extends BaseTLSKeyGeneratorSpi {
        private TlsRsaPremasterSecretParameterSpec spec;

        TLSRsaPreMasterSecretGenerator() {
        }

        protected void engineInit(final AlgorithmParameterSpec algorithmParameterSpec, final SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    TLSRsaPreMasterSecretGenerator.this.spec = (TlsRsaPremasterSecretParameterSpec)algorithmParameterSpec;
                    TLSRsaPreMasterSecretGenerator.this.secureRandom = secureRandom;
                    return null;
                }
            });
        }

        protected SecretKey engineGenerateKey() {
            return AccessController.doPrivileged(new PrivilegedAction<SecretKey>(){

                @Override
                public SecretKey run() {
                    if (hasGetEncodeSecretMethod) {
                        try {
                            Class<?> def = BouncyCastleFipsProvider.class.getClassLoader().loadClass("sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec");
                            byte[] premasterSecret = (byte[])def.getMethod("getEncodedSecret", new Class[0]).invoke((Object)TLSRsaPreMasterSecretGenerator.this.spec, new Object[0]);
                            if (premasterSecret == null) {
                                premasterSecret = new byte[48];
                                TLSRsaPreMasterSecretGenerator.this.secureRandom.nextBytes(premasterSecret);
                                premasterSecret[0] = (byte)TLSRsaPreMasterSecretGenerator.this.spec.getMajorVersion();
                                premasterSecret[1] = (byte)TLSRsaPreMasterSecretGenerator.this.spec.getMinorVersion();
                            }
                            return new SecretKeySpec(premasterSecret, "TlsPreMasterSecret");
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("internal error, profile of TlsRSAPremasterSecretParameterSpec has changed: " + e.getMessage(), e);
                        }
                    }
                    byte[] premasterSecret = new byte[48];
                    TLSRsaPreMasterSecretGenerator.this.secureRandom.nextBytes(premasterSecret);
                    premasterSecret[0] = (byte)TLSRsaPreMasterSecretGenerator.this.spec.getMajorVersion();
                    premasterSecret[1] = (byte)TLSRsaPreMasterSecretGenerator.this.spec.getMinorVersion();
                    return new SecretKeySpec(premasterSecret, "TlsPreMasterSecret");
                }
            });
        }
    }
}

