/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPublicKey;
import org.bouncycastle.jcajce.provider.DHUtils;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.util.Arrays;

class ProvDHPublicKey
implements DHPublicKey {
    static final long serialVersionUID = -216691575254424324L;
    private transient AsymmetricDHPublicKey baseKey;

    ProvDHPublicKey(Algorithm algorithm, DHPublicKey baseKey) {
        this.baseKey = new AsymmetricDHPublicKey(algorithm, DHUtils.extractParams(baseKey.getParams()), baseKey.getY());
    }

    ProvDHPublicKey(Algorithm algorithm, DHPublicKeySpec keySpec) {
        this.baseKey = new AsymmetricDHPublicKey(algorithm, DHUtils.extractParams(keySpec), keySpec.getY());
    }

    ProvDHPublicKey(AsymmetricDHPublicKey baseKey) {
        this.baseKey = baseKey;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "X.509";
    }

    public DHParameterSpec getParams() {
        return DHUtils.convertParams(this.baseKey.getDomainParameters());
    }

    public BigInteger getY() {
        return this.baseKey.getY();
    }

    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    AsymmetricDHPublicKey getBaseKey() {
        return this.baseKey;
    }

    public String toString() {
        return KeyUtil.publicKeyToString("DH", this.baseKey.getY(), this.baseKey.getDomainParameters());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DHPublicKey)) {
            return false;
        }
        if (o instanceof ProvDHPublicKey) {
            ProvDHPublicKey other = (ProvDHPublicKey)o;
            return this.baseKey.equals(other.baseKey);
        }
        DHPublicKey other = (DHPublicKey)o;
        return Arrays.areEqual(this.getEncoded(), other.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Algorithm alg = (Algorithm)in.readObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricDHPublicKey(alg, enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.baseKey.getAlgorithm());
        out.writeObject(this.getEncoded());
    }
}

